/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.actions.ComposerAbstractAction;
import com.jetbrains.php.composer.actions.ComposerActionCommandExecutor;
import com.jetbrains.php.composer.actions.ComposerCommandExecutor;
import com.jetbrains.php.composer.actions.ComposerOptionsManager;
import com.jetbrains.php.composer.actions.ComposerValidateDialog;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.execution.ComposerExecution;
import com.jetbrains.php.composer.statistics.ComposerActionStatistics;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerValidateAction
extends ComposerAbstractAction {
    @NonNls
    public static final String ID = "ComposerValidateAction";
    public static final String COMMAND_NAME = "validate";

    @Override
    protected void doPerformAction(@NotNull Project project, @NotNull VirtualFile configFile, @NotNull String placeForStatistics) {
        if (project == null) {
            ComposerValidateAction.$$$reportNull$$$0(0);
        }
        if (configFile == null) {
            ComposerValidateAction.$$$reportNull$$$0(1);
        }
        if (placeForStatistics == null) {
            ComposerValidateAction.$$$reportNull$$$0(2);
        }
        String options = ComposerOptionsManager.getCommandLineOptions(project, ComposerOptionsManager.Command.VALIDATE, configFile);
        ComposerValidateDialog dialog = new ComposerValidateDialog(project);
        dialog.setCommandLineOptions(options);
        boolean ok = dialog.showAndGet();
        if (!ok) {
            return;
        }
        options = dialog.getCommandLineOptions();
        ComposerOptionsManager.setCommandLineOptions(project, ComposerOptionsManager.Command.VALIDATE, configFile, options);
        ComposerCommandExecutor commandExecutor = ComposerValidateAction.createExecutor(project, ComposerDataService.getInstance(project).getComposerExecution(), configFile, options, placeForStatistics);
        commandExecutor.execute();
    }

    @Override
    public String getCommand() {
        return COMMAND_NAME;
    }

    @NotNull
    protected static ComposerCommandExecutor createExecutor(@NotNull Project project, final @NotNull ComposerExecution execution, final @NotNull VirtualFile configFile, final @Nullable String commandLineOptions, @NotNull String placeForStatistics) {
        if (project == null) {
            ComposerValidateAction.$$$reportNull$$$0(3);
        }
        if (execution == null) {
            ComposerValidateAction.$$$reportNull$$$0(4);
        }
        if (configFile == null) {
            ComposerValidateAction.$$$reportNull$$$0(5);
        }
        if (placeForStatistics == null) {
            ComposerValidateAction.$$$reportNull$$$0(6);
        }
        ComposerActionStatistics actionStatistics = ComposerActionStatistics.create(ComposerActionStatistics.Action.VALIDATE, placeForStatistics);
        return new ComposerActionCommandExecutor.WithConfig(project, execution, configFile, commandLineOptions, actionStatistics, false, true){

            @Override
            @NotNull
            protected List<String> getBasicCommand() {
                List<String> list = Collections.singletonList(ComposerValidateAction.COMMAND_NAME);
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            @Override
            protected ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> getExecutorGenerator() {
                String configFilePath = configFile.getPath();
                return ComposerValidateAction.createExecutorGenerator(execution, configFilePath, commandLineOptions);
            }

            @Override
            protected ComposerLogMessageBuilder.SummaryMessage createSuccessfulSummary() {
                return new ComposerLogMessageBuilder.SummaryMessage("Composer found no errors in ").appendFileLink(this.myComposerJson, this.myProject).appendText(".");
            }

            @Override
            protected ComposerLogMessageBuilder.SummaryMessage createFailureSummary() {
                return new ComposerLogMessageBuilder.SummaryMessage("Composer found errors in ").appendFileLink(this.myComposerJson, this.myProject).appendText(".");
            }

            @Override
            @Nls
            protected String getProgressTitle() {
                return PhpBundle.message("validating", new Object[0]);
            }

            @Override
            @NlsSafe
            protected String getActionName() {
                return ComposerValidateAction.COMMAND_NAME;
            }

            @Override
            @Nls(capitalization=Nls.Capitalization.Title)
            @NotNull
            protected String getTaskTitle() {
                String string = PhpBundle.message("composer.validating.task.title", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/php/composer/actions/ComposerValidateAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBasicCommand";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTaskTitle";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    private static ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> createExecutorGenerator(@NotNull ComposerExecution execution, @NotNull String configFilePath, @Nullable String commandLineOptions) {
        if (execution == null) {
            ComposerValidateAction.$$$reportNull$$$0(7);
        }
        if (configFilePath == null) {
            ComposerValidateAction.$$$reportNull$$$0(8);
        }
        ThrowableNotNullFunction throwableNotNullFunction = generatorProject -> {
            VirtualFile generatorConfigFile = LocalFileSystem.getInstance().findFileByPath(configFilePath);
            ComposerCommandExecutor.checkFileExists(configFilePath, generatorConfigFile);
            return ComposerValidateAction.createExecutor(generatorProject, execution, generatorConfigFile, commandLineOptions, "ComposerLogRerun");
        };
        if (throwableNotNullFunction == null) {
            ComposerValidateAction.$$$reportNull$$$0(9);
        }
        return throwableNotNullFunction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeForStatistics";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execution";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFilePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/actions/ComposerValidateAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerValidateAction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutorGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doPerformAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createExecutor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createExecutorGenerator";
                break;
            }
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }
}

