/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions.log;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerConfigurable;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.actions.ComposerCommandExecutor;
import com.jetbrains.php.composer.actions.log.ComposerLogConsoleViewInterface;
import com.jetbrains.php.composer.actions.log.ComposerLogService;
import com.jetbrains.php.composer.actions.log.lang.highlighter.ComposerLogHighlighter;
import com.jetbrains.php.config.PhpProjectConfigurable;
import com.jetbrains.php.testFramework.PhpTestFrameworksConfigurable;
import com.jetbrains.php.ui.PhpUiUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerLogMessageBuilder {
    private static final Logger LOG = Logger.getInstance(ComposerLogMessageBuilder.class);
    private final ComposerLogService.MessageId myId;
    private ComposerLogConsoleViewInterface myConsole;
    @Nullable
    private final ModalityState myModalityState;

    ComposerLogMessageBuilder(@NotNull ComposerLogService.MessageId id, @Nullable Settings settings, @NotNull ComposerLogConsoleViewInterface console, @Nullable ModalityState modalityState) {
        if (id == null) {
            ComposerLogMessageBuilder.$$$reportNull$$$0(0);
        }
        if (console == null) {
            ComposerLogMessageBuilder.$$$reportNull$$$0(1);
        }
        this.myId = id;
        this.myConsole = console;
        this.myModalityState = modalityState;
        this.myConsole.print(ComposerLogConsoleViewInterface.MessagePart.ID, this.myId.getTextPart(), ComposerLogHighlighter.DEFAULT_CONTENT_TYPE, this.myModalityState);
        if (settings != null) {
            this.myConsole.print(ComposerLogConsoleViewInterface.MessagePart.ID, " \u2006", ComposerLogHighlighter.DEFAULT_CONTENT_TYPE, this.myModalityState);
            this.myConsole.print(ComposerLogConsoleViewInterface.MessagePart.ID, settings.myId, ComposerLogHighlighter.DEFAULT_CONTENT_TYPE, this.myModalityState);
        }
    }

    public ComposerLogMessageBuilder printCommand(@NotNull String command, @Nullable ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> executorGenerator, @Nullable Project project) {
        if (command == null) {
            ComposerLogMessageBuilder.$$$reportNull$$$0(2);
        }
        this.myConsole.print(ComposerLogConsoleViewInterface.MessagePart.COMMAND, command, ComposerLogHighlighter.SUCCESSFUL_COMMAND_CONTENT_TYPE, this.myModalityState);
        if (executorGenerator != null && project != null) {
            ComposerLogService.getInstance(project).putRerunData(this.myId, executorGenerator);
        }
        return this;
    }

    public void printOutputPart(String text, Key outputType) {
        ConsoleViewContentType consoleViewType = ConsoleViewContentType.getConsoleViewType((Key)outputType);
        this.myConsole.print(ComposerLogConsoleViewInterface.MessagePart.OUTPUT, text, consoleViewType, this.myModalityState);
    }

    public void printSummary(String text) {
        this.printSummary(text, true, false, null, null);
    }

    public void printSummary(String text, boolean success, boolean showInEventLog, NotificationType notificationType, Project project) {
        this.printSummary(new SummaryMessage(text), success, showInEventLog, notificationType, project, new AnAction[0]);
    }

    public void printSummary(SummaryMessage text, boolean success, boolean showInEventLog, NotificationType notificationType, final Project project, AnAction ... actions) {
        text.printToConsole(this.myConsole, success, this.myModalityState);
        if (showInEventLog && (notificationType == NotificationType.ERROR || !this.myConsole.isShown())) {
            LOG.assertTrue(project != null);
            if (notificationType == null) {
                notificationType = NotificationType.INFORMATION;
            }
            DumbAwareAction logAction = new DumbAwareAction(PhpBundle.message("action.show.in.log.text", new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ComposerLogService.getInstance(project).getConsoleView().show(ComposerLogMessageBuilder.this.myId);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/composer/actions/log/ComposerLogMessageBuilder$1", "actionPerformed"));
                }
            };
            Notification notification = new Notification(ComposerUtils.getComposerGroupDisplayId(), PhpBundle.message("framework.composer", new Object[0]), text.forNotification(), notificationType);
            notification.addAction((AnAction)logAction);
            notification.addActions(List.of(actions));
            Notifications.Bus.notify((Notification)notification, (Project)project);
        }
        this.myConsole.scrollToEnd();
        this.detach();
    }

    public void detach() {
        this.myConsole.detach();
        this.myConsole = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/composer/actions/log/ComposerLogMessageBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "printCommand";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class Settings {
        static ExtensionPointName<Settings> EP_NAME = ExtensionPointName.create((String)"com.jetbrains.php.openSettingsProvider");
        public static final Settings COMPOSER = new Settings("\u2000"){

            @Override
            public void show(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                PhpUiUtil.editConfigurable(project, (Configurable)new ComposerConfigurable(project, false, true));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/composer/actions/log/ComposerLogMessageBuilder$Settings$1", "show"));
            }
        };
        public static final Settings PHP = new Settings("\u2001"){

            @Override
            public void show(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                ShowSettingsUtil.getInstance().showSettingsDialog(project, PhpProjectConfigurable.class);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/composer/actions/log/ComposerLogMessageBuilder$Settings$2", "show"));
            }
        };
        public static final Settings DIRECTORIES = new Settings("\u2002"){

            @Override
            public void show(@NotNull Project project) {
                if (project == null) {
                    3.$$$reportNull$$$0(0);
                }
                ShowSettingsUtil.getInstance().showSettingsDialog(project, PhpBundle.message("directories", new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/composer/actions/log/ComposerLogMessageBuilder$Settings$3", "show"));
            }
        };
        public static final Settings TEST_FRAMEWORKS = new Settings("\u2003"){

            @Override
            public void show(@NotNull Project project) {
                if (project == null) {
                    4.$$$reportNull$$$0(0);
                }
                PhpUiUtil.editConfigurable(project, (Configurable)new PhpTestFrameworksConfigurable(project));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/composer/actions/log/ComposerLogMessageBuilder$Settings$4", "show"));
            }
        };
        public static final Settings CODE_SNIFFER = new Settings("\u2004"){

            @Override
            public void show(@NotNull Project project) {
                if (project == null) {
                    5.$$$reportNull$$$0(0);
                }
                ShowSettingsUtil.getInstance().showSettingsDialog(project, PhpBundle.message("configurable.quality.tool.php.code.sniffer", new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/composer/actions/log/ComposerLogMessageBuilder$Settings$5", "show"));
            }
        };
        public static final Settings MESS_DETECTOR = new Settings("\u2005"){

            @Override
            public void show(@NotNull Project project) {
                if (project == null) {
                    6.$$$reportNull$$$0(0);
                }
                ShowSettingsUtil.getInstance().showSettingsDialog(project, PhpBundle.message("configurable.quality.tool.mess.detector", new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/composer/actions/log/ComposerLogMessageBuilder$Settings$6", "show"));
            }
        };
        public static final Settings CS_FIXER = new Settings("\u2008"){

            @Override
            public void show(@NotNull Project project) {
                if (project == null) {
                    7.$$$reportNull$$$0(0);
                }
                ShowSettingsUtil.getInstance().showSettingsDialog(project, PhpBundle.message("configurable.quality.tool.php.cs.fixer", new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/composer/actions/log/ComposerLogMessageBuilder$Settings$7", "show"));
            }
        };
        public static final Settings LARAVEL_PINT = new Settings("\u2010"){

            @Override
            public void show(@NotNull Project project) {
                if (project == null) {
                    8.$$$reportNull$$$0(0);
                }
                ShowSettingsUtil.getInstance().showSettingsDialog(project, PhpBundle.message("configurable.quality.tool.laravel.pint", new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/composer/actions/log/ComposerLogMessageBuilder$Settings$8", "show"));
            }
        };
        @NlsSafe
        private static final String PHING_NAME = "Phing";
        public static final Settings PHING = new Settings("\u200a"){

            @Override
            public void show(@NotNull Project project) {
                if (project == null) {
                    9.$$$reportNull$$$0(0);
                }
                ShowSettingsUtil.getInstance().showSettingsDialog(project, Settings.PHING_NAME);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/composer/actions/log/ComposerLogMessageBuilder$Settings$9", "show"));
            }
        };
        static List<Settings> mySettings = new SmartList((Object[])new Settings[]{COMPOSER, CODE_SNIFFER, PHP, DIRECTORIES, TEST_FRAMEWORKS, MESS_DETECTOR, CS_FIXER, PHING, LARAVEL_PINT});
        private final String myId;

        public Settings(String id) {
            this.myId = id;
        }

        public String getId() {
            return this.myId;
        }

        public abstract void show(@NotNull Project var1);

        @Nullable
        public static Settings findById(String id) {
            if (id == null) {
                return null;
            }
            for (Settings settings : mySettings) {
                if (!settings.getId().equals(id)) continue;
                return settings;
            }
            return EP_NAME.getExtensionList().stream().filter(i -> i.getId().equals(id)).findFirst().orElse(null);
        }
    }

    public static class SummaryMessage {
        private final List<Pair<String, ? extends HyperlinkInfo>> myElements = new ArrayList<Pair<String, ? extends HyperlinkInfo>>();

        public SummaryMessage() {
        }

        public SummaryMessage(String text) {
            this.appendText(text);
        }

        public SummaryMessage appendText(String text) {
            this.myElements.add((Pair<String, ? extends HyperlinkInfo>)Pair.create((Object)text, null));
            return this;
        }

        public SummaryMessage appendFileLink(@NotNull VirtualFile file, @NotNull Project project) {
            String presentablePath;
            if (file == null) {
                SummaryMessage.$$$reportNull$$$0(0);
            }
            if (project == null) {
                SummaryMessage.$$$reportNull$$$0(1);
            }
            if ((presentablePath = ComposerUtils.getPresentablePath(file, project)) == null) {
                return this;
            }
            return this.appendLink(presentablePath, (HyperlinkInfo)new OpenFileHyperlinkInfo(new OpenFileDescriptor(project, file)));
        }

        public SummaryMessage appendLink(@NotNull String text, @NotNull HyperlinkInfo info) {
            if (text == null) {
                SummaryMessage.$$$reportNull$$$0(2);
            }
            if (info == null) {
                SummaryMessage.$$$reportNull$$$0(3);
            }
            this.myElements.add((Pair<String, ? extends HyperlinkInfo>)Pair.create((Object)text, (Object)info));
            return this;
        }

        public void printToConsole(ComposerLogConsoleViewInterface console, boolean success, ModalityState modalityState) {
            ComposerLogConsoleViewInterface.MessagePart messagePart = success ? ComposerLogConsoleViewInterface.MessagePart.SUCCESS_SUMMARY : ComposerLogConsoleViewInterface.MessagePart.FAILURE_SUMMARY;
            ConsoleViewContentType consoleViewType = success ? ComposerLogHighlighter.SUCCESSFUL_SUMMARY_TEXT_CONTENT_TYPE : ComposerLogHighlighter.FAILED_SUMMARY_TEXT_CONTENT_TYPE;
            for (Pair<String, ? extends HyperlinkInfo> pair : this.myElements) {
                if (pair.second == null) {
                    console.print(messagePart, (String)pair.first, consoleViewType, modalityState);
                    continue;
                }
                console.printHyperlink(messagePart, (String)pair.first, (HyperlinkInfo)pair.second, modalityState);
            }
        }

        @NlsSafe
        public String forNotification() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Pair<String, ? extends HyperlinkInfo> pair : this.myElements) {
                stringBuilder.append((String)pair.first);
            }
            return stringBuilder.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/composer/actions/log/ComposerLogMessageBuilder$SummaryMessage";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendFileLink";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendLink";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

