/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions.update;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.composer.ComposerConfigListener;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.configData.ComposerConfigManager;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\u000e\u001a\u0004\u0018\u00018\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0010H&\u00a2\u0006\u0002\u0010\u0011J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/php/composer/actions/update/ComposerConfigServiceFactory;", "T", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "instances", "Ljava/util/concurrent/ConcurrentHashMap;", "", "removeListeners", "Lcom/jetbrains/php/composer/ComposerConfigListener;", "getOrCreateInstance", "context", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/Object;", "createNewInstance", "config", "getAllInstances", "", "dispose", "", "intellij.php.impl"})
@SourceDebugExtension(value={"SMAP\nComposerConfigServiceFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposerConfigServiceFactory.kt\ncom/jetbrains/php/composer/actions/update/ComposerConfigServiceFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n1863#2,2:41\n*S KotlinDebug\n*F\n+ 1 ComposerConfigServiceFactory.kt\ncom/jetbrains/php/composer/actions/update/ComposerConfigServiceFactory\n*L\n38#1:41,2\n*E\n"})
public abstract class ComposerConfigServiceFactory<T>
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<String, T> instances;
    @NotNull
    private final ConcurrentHashMap<String, ComposerConfigListener> removeListeners;

    public ComposerConfigServiceFactory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.instances = new ConcurrentHashMap();
        this.removeListeners = new ConcurrentHashMap();
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @Nullable
    public final T getOrCreateInstance(@Nullable VirtualFile context) {
        VirtualFile virtualFile = ComposerConfigManager.Companion.getInstance(this.project).getConfig(context);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile config = virtualFile;
        T newInstance = this.createNewInstance(config);
        T t = this.instances.putIfAbsent(config.getPath(), newInstance);
        if (t == null) {
            t = newInstance;
        }
        T instance = t;
        ComposerConfigListener removeConfigListener2 = new ComposerConfigListener(this){
            final /* synthetic */ ComposerConfigServiceFactory<T> this$0;
            {
                this.this$0 = $receiver;
            }

            public void configPathChanged(String oldPath, String newPath, boolean isWellConfigured) {
                if (oldPath == null) {
                    return;
                }
                if (newPath != null && isWellConfigured) {
                    V v = ComposerConfigServiceFactory.access$getInstances$p(this.this$0).get(oldPath);
                    if (v != null) {
                        V v2 = v;
                        ComposerConfigServiceFactory<T> composerConfigServiceFactory = this.this$0;
                        V it = v2;
                        boolean bl = false;
                        ((Map)ComposerConfigServiceFactory.access$getInstances$p(composerConfigServiceFactory)).put(newPath, it);
                    }
                }
                ComposerConfigServiceFactory.access$getInstances$p(this.this$0).remove(oldPath);
            }
        };
        this.removeListeners.putIfAbsent(config.getPath(), removeConfigListener2);
        ComposerDataService.getInstance(this.project).addConfigListener(removeConfigListener2);
        return instance;
    }

    public abstract T createNewInstance(@NotNull VirtualFile var1);

    @NotNull
    public final Collection<T> getAllInstances() {
        Collection<T> collection = this.instances.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    public void dispose() {
        Collection<ComposerConfigListener> collection = this.removeListeners.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ComposerConfigListener it = (ComposerConfigListener)element$iv;
            boolean bl = false;
            ComposerDataService.getInstance(this.project).removeConfigListener(it);
        }
    }

    public static final /* synthetic */ ConcurrentHashMap access$getInstances$p(ComposerConfigServiceFactory $this) {
        return $this.instances;
    }
}

