/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions.update;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.messages.Topic;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.InstalledPackageData;
import com.jetbrains.php.composer.actions.update.ComposerConfigFileListener;
import com.jetbrains.php.composer.actions.update.ComposerInstalledPackagesServiceFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerInstalledPackagesService
implements ComposerConfigFileListener {
    @Topic.ProjectLevel
    public static final Topic<ComposerUpdateListener> PACKAGE_MANAGER_TOPIC = new Topic(ComposerUpdateListener.class);
    private final Map<String, String> myPackageToCurrentVersion;
    private final Object myLock;
    private final Project myProject;
    private final VirtualFile myConfig;

    ComposerInstalledPackagesService(@NotNull Project project, @NotNull VirtualFile config) {
        if (project == null) {
            ComposerInstalledPackagesService.$$$reportNull$$$0(0);
        }
        if (config == null) {
            ComposerInstalledPackagesService.$$$reportNull$$$0(1);
        }
        this.myPackageToCurrentVersion = CollectionFactory.createCaseInsensitiveStringMap();
        this.myLock = new Object();
        this.myProject = project;
        this.myConfig = config;
    }

    @Override
    public void composerConfigInitialized() {
        this.updateInstalledPackagesVersions();
    }

    @Override
    public void composerJsonChanged() {
    }

    @Override
    public void composerLockChanged(boolean mayBeInDumbMode) {
        this.updateInstalledPackagesVersions();
        ((ComposerUpdateListener)this.myProject.getMessageBus().syncPublisher(PACKAGE_MANAGER_TOPIC)).packageRefreshed(this.myProject);
    }

    private void updateInstalledPackagesVersions() {
        List<InstalledPackageData> installedPackages = ComposerConfigUtils.getInstalledPackagesFromConfig(this.myConfig);
        this.updateCurrentPackageVersions(installedPackages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCurrentPackageVersions(@NotNull List<InstalledPackageData> installedPackages) {
        if (installedPackages == null) {
            ComposerInstalledPackagesService.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myPackageToCurrentVersion.clear();
            for (InstalledPackageData installedPackage : installedPackages) {
                this.myPackageToCurrentVersion.put(installedPackage.getName(), installedPackage.getVersion());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getCurrentPackageVersion(@NotNull String packageName) {
        if (packageName == null) {
            ComposerInstalledPackagesService.$$$reportNull$$$0(3);
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myPackageToCurrentVersion.get(packageName);
        }
    }

    @Nullable
    public VirtualFile getConfig() {
        return this.myConfig;
    }

    @Nullable
    public static ComposerInstalledPackagesService getInstance(@NotNull Project project, @Nullable VirtualFile context) {
        if (project == null) {
            ComposerInstalledPackagesService.$$$reportNull$$$0(4);
        }
        return (ComposerInstalledPackagesService)((ComposerInstalledPackagesServiceFactory)project.getService(ComposerInstalledPackagesServiceFactory.class)).getOrCreateInstance(context);
    }

    @Nullable
    public static ComposerInstalledPackagesService getInstance(@NotNull Project project, @Nullable PsiElement context) {
        if (project == null) {
            ComposerInstalledPackagesService.$$$reportNull$$$0(5);
        }
        VirtualFile virtualFile = context != null ? context.getContainingFile().getVirtualFile() : null;
        return ComposerInstalledPackagesService.getInstance(project, virtualFile);
    }

    public static Collection<InstalledPackage> getAllInstalledPackages(@NotNull Project project) {
        if (project == null) {
            ComposerInstalledPackagesService.$$$reportNull$$$0(6);
        }
        return ComposerInstalledPackagesService.getAllInstances(project).stream().flatMap(it -> it.getPackageToCurrentVersion().entrySet().stream()).map(packageVersion -> new InstalledPackage((String)packageVersion.getKey(), (String)packageVersion.getValue())).collect(Collectors.toSet());
    }

    public static Collection<ComposerInstalledPackagesService> getAllInstances(@NotNull Project project) {
        if (project == null) {
            ComposerInstalledPackagesService.$$$reportNull$$$0(7);
        }
        return ((ComposerInstalledPackagesServiceFactory)project.getService(ComposerInstalledPackagesServiceFactory.class)).getAllInstances();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getPackageToCurrentVersion() {
        Object object = this.myLock;
        synchronized (object) {
            return new HashMap<String, String>(this.myPackageToCurrentVersion);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installedPackages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/composer/actions/update/ComposerInstalledPackagesService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateCurrentPackageVersions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCurrentPackageVersion";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllInstalledPackages";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllInstances";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface ComposerUpdateListener {
        public void packageRefreshed(@NotNull Project var1);
    }

    public record InstalledPackage(String name, String version) {
    }
}

