/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions.update;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.SingleAlarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerConfigListener;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.actions.ComposerCommandRunner;
import com.jetbrains.php.composer.actions.ComposerOptionsManager;
import com.jetbrains.php.composer.actions.update.ComposerAvailablePackageVersionsService;
import com.jetbrains.php.composer.actions.update.ComposerUpdateOutputParser;
import com.jetbrains.php.composer.configData.ComposerConfigManager;
import com.jetbrains.php.composer.execution.ComposerExecution;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComposerUpdateAvailabilityService
implements Disposable {
    private final Project myProject;
    private final AtomicReference<ProgressIndicator> myProgressIndicator;
    private final SingleAlarm myAlarm;
    @Nullable
    private Disposable myFileOpenListenerDisposable;
    private final Collection<VirtualFile> myConfigsToUpdate;
    private static final ExecutorService EXECUTOR = ComposerUtils.createExecutorService("Composer Available Packages Versions", "php.composer.available.package.versions.max.threads");

    ComposerUpdateAvailabilityService(final @NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        if (project == null) {
            ComposerUpdateAvailabilityService.$$$reportNull$$$0(0);
        }
        if (coroutineScope == null) {
            ComposerUpdateAvailabilityService.$$$reportNull$$$0(1);
        }
        this.myProgressIndicator = new AtomicReference();
        this.myConfigsToUpdate = new ConcurrentLinkedQueue<VirtualFile>();
        this.myProject = project;
        this.myAlarm = SingleAlarm.singleEdtAlarm((int)1000, (CoroutineScope)coroutineScope, this::updateAvailablePackageVersions);
        this.createOrUpdateFileOpenedListener();
        ComposerDataService.getInstance(project).addConfigListener(new ComposerConfigListener(){

            @Override
            public void loadUpdateAvailabilityStatusChanged() {
                ComposerUpdateAvailabilityService.this.createOrUpdateFileOpenedListener();
                ComposerUpdateAvailabilityService.this.updateAvailablePackageVersions(ComposerConfigManager.getInstance(project).getAllConfigs().toArray(VirtualFile.EMPTY_ARRAY));
            }
        });
    }

    private void createOrUpdateFileOpenedListener() {
        if (this.myFileOpenListenerDisposable != null) {
            Disposer.dispose((Disposable)this.myFileOpenListenerDisposable);
        }
        if (this.isLoadUpdateAvailability()) {
            this.myFileOpenListenerDisposable = Disposer.newDisposable();
            Disposer.register((Disposable)this, (Disposable)this.myFileOpenListenerDisposable);
            this.myProject.getMessageBus().connect(this.myFileOpenListenerDisposable).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

                public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                    ComposerConfigManager composerConfigManager;
                    if (source == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (file == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (Objects.equals((composerConfigManager = ComposerConfigManager.getInstance(ComposerUpdateAvailabilityService.this.myProject)).getConfigPath(file), file.getPath())) {
                        ComposerUpdateAvailabilityService.this.updateAvailablePackageVersions(file);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "source";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "file";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/php/composer/actions/update/ComposerUpdateAvailabilityService$2";
                    objectArray[2] = "fileOpened";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    void scheduleUpdateAvailablePackageVersions(VirtualFile config) {
        this.myConfigsToUpdate.add(config);
        this.myAlarm.cancelAndRequest(true);
    }

    void updateAvailablePackageVersions(VirtualFile ... configs) {
        ContainerUtil.addAll(this.myConfigsToUpdate, (Object[])configs);
        this.myAlarm.cancelAndRequest(true);
    }

    private void updateAvailablePackageVersions() {
        if (!this.isLoadUpdateAvailability()) {
            return;
        }
        if (!TrustedProjects.isTrusted((Project)this.myProject)) {
            return;
        }
        ComposerDataService dataService = ComposerDataService.getInstance(this.myProject);
        ComposerExecution execution = dataService.getComposerExecution();
        if (!execution.isWellConfigured(this.myProject, true)) {
            return;
        }
        Task.Backgroundable task = new Task.Backgroundable(this.myProject, PhpBundle.message("framework.composer.loading.update.availability", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                HashSet<VirtualFile> uniqConfigs;
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((uniqConfigs = new HashSet<VirtualFile>(ComposerUpdateAvailabilityService.this.myConfigsToUpdate)).size() > 1) {
                    indicator.setIndeterminate(false);
                }
                double step = 1.0 / (double)uniqConfigs.size();
                List futures = ContainerUtil.map(uniqConfigs, c -> CompletableFuture.runAsync(() -> ComposerUpdateAvailabilityService.this.updateAvailablePackageVersions(indicator, (VirtualFile)c, step), EXECUTOR));
                for (CompletableFuture future : futures) {
                    future.join();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/php/composer/actions/update/ComposerUpdateAvailabilityService$3", "run"));
            }
        };
        ProgressIndicator oldIndicator = this.myProgressIndicator.getAndSet((ProgressIndicator)new BackgroundableProcessIndicator(task));
        if (oldIndicator != null) {
            HashSet<VirtualFile> unprocessedFiles = new HashSet<VirtualFile>(this.myConfigsToUpdate);
            oldIndicator.cancel();
            this.myConfigsToUpdate.addAll(unprocessedFiles);
        }
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, this.myProgressIndicator.get());
    }

    private void updateAvailablePackageVersions(@NotNull ProgressIndicator indicator, VirtualFile file, double step) {
        if (indicator == null) {
            ComposerUpdateAvailabilityService.$$$reportNull$$$0(2);
        }
        indicator.checkCanceled();
        int numberFilesToRemove = ContainerUtil.count(this.myConfigsToUpdate, c -> c.equals(file));
        ComposerExecution execution = ComposerDataService.getInstance(this.myProject).getComposerExecution();
        CheckForUpdateResult checkForUpdateResult = ComposerUpdateAvailabilityService.executeCommand(indicator, execution, this.myProject, file);
        indicator.checkCanceled();
        ComposerAvailablePackageVersionsService packageVersionsService = ComposerAvailablePackageVersionsService.getInstance(this.myProject, file);
        if (packageVersionsService != null) {
            packageVersionsService.updateAvailableVersions(checkForUpdateResult.myReadyToUpdatePackages);
        }
        ReadAction.run(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
            if (psiFile != null) {
                DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(psiFile);
            }
        });
        for (int i = 0; i < numberFilesToRemove; ++i) {
            this.myConfigsToUpdate.remove(file);
        }
        if (!indicator.isIndeterminate()) {
            indicator.setFraction(Math.min(0.99, indicator.getFraction() + step));
        }
    }

    private boolean isLoadUpdateAvailability() {
        return ComposerDataService.getInstance(this.myProject).isLoadUpdateAvailability();
    }

    @NotNull
    public static CheckForUpdateResult executeCommand(@NotNull ProgressIndicator indicator, @NotNull ComposerExecution execution, @NotNull Project project, @NotNull VirtualFile configFile) {
        if (indicator == null) {
            ComposerUpdateAvailabilityService.$$$reportNull$$$0(3);
        }
        if (execution == null) {
            ComposerUpdateAvailabilityService.$$$reportNull$$$0(4);
        }
        if (project == null) {
            ComposerUpdateAvailabilityService.$$$reportNull$$$0(5);
        }
        if (configFile == null) {
            ComposerUpdateAvailabilityService.$$$reportNull$$$0(6);
        }
        ComposerCommandRunner executor = new ComposerCommandRunner(execution, project, configFile.getParent().getPath(), indicator);
        List<String> basicCommand = ComposerUtils.getUpdateSimulationCommand();
        List options = ParametersListUtil.parse((String)ComposerOptionsManager.getInstallCommandLineOptions(project));
        OutputCapturingAdapter outputCapturingAdapter = new OutputCapturingAdapter();
        ComposerCommandRunner.ExecutionResult executionResult = executor.runCommand(ContainerUtil.concat(basicCommand, (List)options), (ProcessListener)outputCapturingAdapter);
        String output = outputCapturingAdapter.getOutput();
        return new CheckForUpdateResult(executionResult, ComposerUpdateOutputParser.parseReadyToUpdatePackages(output));
    }

    public void dispose() {
        ProgressIndicator progressIndicator = this.myProgressIndicator.get();
        if (progressIndicator != null) {
            progressIndicator.cancel();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execution";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/composer/actions/update/ComposerUpdateAvailabilityService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateAvailablePackageVersions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "executeCommand";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class CheckForUpdateResult {
        @NotNull
        public final ComposerCommandRunner.ExecutionResult myExecutionResult;
        public final @NotNull Map<@NlsSafe String, @NlsSafe String> myReadyToUpdatePackages;

        private CheckForUpdateResult(@NotNull ComposerCommandRunner.ExecutionResult executionResult, @NotNull Map<@NlsSafe String, @NlsSafe String> readyToUpdatePackages) {
            if (executionResult == null) {
                CheckForUpdateResult.$$$reportNull$$$0(0);
            }
            if (readyToUpdatePackages == null) {
                CheckForUpdateResult.$$$reportNull$$$0(1);
            }
            this.myExecutionResult = executionResult;
            this.myReadyToUpdatePackages = readyToUpdatePackages;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "executionResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "readyToUpdatePackages";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/composer/actions/update/ComposerUpdateAvailabilityService$CheckForUpdateResult";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class OutputCapturingAdapter
    extends ProcessAdapter {
        private final StringBuffer myOutputBuilder = new StringBuffer();

        private OutputCapturingAdapter() {
        }

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
            if (event == null) {
                OutputCapturingAdapter.$$$reportNull$$$0(0);
            }
            if (outputType == null) {
                OutputCapturingAdapter.$$$reportNull$$$0(1);
            }
            this.myOutputBuilder.append(event.getText());
        }

        public String getOutput() {
            return this.myOutputBuilder.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outputType";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/composer/actions/update/ComposerUpdateAvailabilityService$OutputCapturingAdapter";
            objectArray[2] = "onTextAvailable";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

