/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions.update;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.actions.ComposerUpdatePackageAction;
import com.jetbrains.php.composer.actions.update.ComposerAvailablePackageVersionsService;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import icons.PhpIcons;
import org.jetbrains.annotations.NotNull;

public final class ComposerUpdateLineMarkerProvider
implements LineMarkerProvider {
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            ComposerUpdateLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (!(element instanceof LeafPsiElement)) {
            return null;
        }
        if (!ComposerConfigUtils.belongsToCurrentComposerJson(element)) {
            return null;
        }
        JsonProperty property = PhpPsiUtil.getParentOfClass(element, false, JsonProperty.class);
        if (!ComposerConfigUtils.isPropertyKey(element, property)) {
            return null;
        }
        String packageName = ComposerConfigUtils.getPackageName(property);
        if (packageName == null) {
            return null;
        }
        ComposerAvailablePackageVersionsService availablePackageVersions = ComposerAvailablePackageVersionsService.getInstance(element.getProject(), element);
        if (availablePackageVersions == null || availablePackageVersions.getUpdateAvailableVersion(packageName) == null) {
            return null;
        }
        return new ComposerUpdateLineMarkerInfo(element, packageName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/composer/actions/update/ComposerUpdateLineMarkerProvider", "getLineMarkerInfo"));
    }

    private static final class ComposerUpdateLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        @NotNull
        private final String myPackageName;

        private ComposerUpdateLineMarkerInfo(@NotNull PsiElement element, @NotNull String packageName) {
            if (element == null) {
                ComposerUpdateLineMarkerInfo.$$$reportNull$$$0(0);
            }
            if (packageName == null) {
                ComposerUpdateLineMarkerInfo.$$$reportNull$$$0(1);
            }
            super(element, element.getTextRange(), PhpIcons.UpLevel, s -> PhpBundle.message("tooltip.update", packageName), null, GutterIconRenderer.Alignment.CENTER);
            this.myPackageName = packageName;
        }

        public GutterIconRenderer createGutterRenderer() {
            return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

                public AnAction getClickAction() {
                    return new ComposerUpdatePackageAction(myPackageName);
                }

                public boolean isNavigateAction() {
                    return true;
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "packageName";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/composer/actions/update/ComposerUpdateLineMarkerProvider$ComposerUpdateLineMarkerInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

