/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.addDependency;

import com.intellij.DynamicBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerPackagedVersionedCommandExecutor;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.InstalledPackageData;
import com.jetbrains.php.composer.actions.ComposerCommandExecutor;
import com.jetbrains.php.composer.actions.ComposerOptionsManager;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.actions.update.ComposerAvailablePackageVersionsService;
import com.jetbrains.php.composer.addDependency.AddDependencyForm;
import com.jetbrains.php.composer.execution.ComposerExecution;
import com.jetbrains.php.composer.statistics.ComposerActionStatistics;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddDependencyDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(AddDependencyDialog.class);
    private static final String PLACE = "AddDependencyDialog";
    public static final char I = 'I';
    public static final char U = 'U';
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myComposerJson;
    private JPanel myMainPanel;
    private AddDependencyForm myForm;
    private HoverHyperlinkLabel myInstallationFeedbackLinkLabel;
    private JBLabel myInstallationFeedbackLabel;
    private RawCommandLineEditor myCommandLineParametersEditor;
    private HyperlinkListener myHyperlinkListener;
    private JButton myCloseButton;
    private Runnable myChangesListener;
    private RemoveAction myRemoveAction;

    public AddDependencyDialog(@NotNull Project project, @NotNull VirtualFile composerJson, @NotNull List<InstalledPackageData> installedPackages) {
        if (project == null) {
            AddDependencyDialog.$$$reportNull$$$0(0);
        }
        if (composerJson == null) {
            AddDependencyDialog.$$$reportNull$$$0(1);
        }
        if (installedPackages == null) {
            AddDependencyDialog.$$$reportNull$$$0(2);
        }
        super(project);
        this.myProject = project;
        this.myComposerJson = composerJson;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(PhpBundle.message("framework.composer.add.composer.dependency.title", objectArray));
        this.myInstallationFeedbackLabel.setVisible(false);
        this.myInstallationFeedbackLinkLabel.setVisible(false);
        for (InstalledPackageData installedPackage : installedPackages) {
            this.myForm.addInstalledPackage(installedPackage.getName(), installedPackage.getVersion());
        }
        String commandLineOptions = ComposerOptionsManager.getCommandLineOptions(project, ComposerOptionsManager.Command.ADD_DEPENDENCY, this.myComposerJson.getParent());
        this.myCommandLineParametersEditor.setText(commandLineOptions);
        this.init();
        this.pack();
        this.initValidation();
    }

    protected boolean postponeValidation() {
        return false;
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myRemoveAction = new RemoveAction();
        this.myRemoveAction.setEnabled(false);
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.myRemoveAction, this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            AddDependencyDialog.$$$reportNull$$$0(3);
        }
        return actionArray;
    }

    private void createUIComponents() {
        this.myInstallationFeedbackLinkLabel = new HoverHyperlinkLabel("");
        this.setOKActionEnabled(false);
        this.setOKButtonText(PhpBundle.message("framework.composer.add.dependency.install.button", new Object[0]));
        this.setOKButtonMnemonic(73);
        this.setCancelButtonText(PhpBundle.message("framework.composer.add.dependency.close.button", new Object[0]));
        this.myChangesListener = () -> {
            this.setOKActionEnabled(this.myForm.validate() == null);
            boolean packageInstalled = this.myForm.isSelectedPackageInstalled();
            if (packageInstalled) {
                this.setOKButtonText(PhpBundle.message("framework.composer.add.dependency.update.button", new Object[0]));
                this.setOKButtonMnemonic(85);
                if (!this.myForm.isSelectedPackageUpdateAvailable()) {
                    this.myOKAction.setEnabled(false);
                }
                this.myRemoveAction.setEnabled(true);
            } else {
                this.setOKButtonText(PhpBundle.message("framework.composer.add.dependency.install.button", new Object[0]));
                this.setOKButtonMnemonic(73);
                this.myRemoveAction.setEnabled(false);
            }
        };
        this.myForm = new AddDependencyForm(false, false, this.myChangesListener, false, this.myProject, this.myComposerJson);
    }

    @Nullable
    protected ValidationInfo doValidate() {
        ValidationInfo validate = this.myForm.validate();
        if (validate != null) {
            return new ValidationInfo(validate.message, null);
        }
        return null;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "PHPComposerAddDependencyDialogDimensionKey";
    }

    protected void doOKAction() {
        String packageName = this.myForm.getSelectedPackageName();
        LOG.assertTrue(packageName != null);
        String commandLineOptions = this.myCommandLineParametersEditor.getText();
        if (this.myForm.isSelectedPackageInstalled()) {
            String version = this.myForm.getSelectedPackageAvailableVersion();
            AddDependencyDialog.createUpdatingExecutor(packageName, commandLineOptions, ComposerDataService.getInstance(this.myProject).getComposerExecution(), this, this.myProject, this.myComposerJson, PLACE, version).execute();
        } else {
            Object selectedValue = this.myForm.getVersionComboBox().getSelectedItem();
            String version = selectedValue instanceof String ? (String)selectedValue : StringUtil.notNullize((String)((String)this.myForm.getVersionComboBox().getItemAt(0)));
            if (commandLineOptions != null) {
                commandLineOptions = commandLineOptions.trim();
            }
            ComposerOptionsManager.setCommandLineOptions(this.myProject, ComposerOptionsManager.Command.ADD_DEPENDENCY, this.myComposerJson.getParent(), commandLineOptions);
            AddDependencyDialog.createInstallingExecutor(packageName, version, commandLineOptions, ComposerDataService.getInstance(this.myProject).getComposerExecution(), this, this.myProject, this.myComposerJson, PLACE).execute();
        }
    }

    @NotNull
    static ComposerCommandExecutor createInstallingExecutor(@NotNull String packageName, final String version, @Nullable String commandLineOptions, @NotNull ComposerExecution execution, @Nullable AddDependencyDialog dialog, @NotNull Project project, @NotNull VirtualFile composerJson, @NotNull String placeForStatistics) {
        if (packageName == null) {
            AddDependencyDialog.$$$reportNull$$$0(4);
        }
        if (execution == null) {
            AddDependencyDialog.$$$reportNull$$$0(5);
        }
        if (project == null) {
            AddDependencyDialog.$$$reportNull$$$0(6);
        }
        if (composerJson == null) {
            AddDependencyDialog.$$$reportNull$$$0(7);
        }
        if (placeForStatistics == null) {
            AddDependencyDialog.$$$reportNull$$$0(8);
        }
        ComposerActionStatistics statistics = ComposerActionStatistics.create(ComposerActionStatistics.Action.REQUIRE, placeForStatistics);
        return new AddDependencyCommandExecutor(dialog, project, composerJson, packageName, version, commandLineOptions, execution, statistics){

            @Override
            protected void reportFeedback(@NotNull ComposerLogMessageBuilder builder2, @NotNull List<String> command, boolean success, List<Pair<String, Key>> output, ExecutionException exception, boolean cancelledByUser) {
                if (builder2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (command == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.reportFeedback(builder2, command, success, output, exception, cancelledByUser);
                if (this.myDialog != null) {
                    this.myDialog.provideInstallationFeedback(success, ComposerCommandExecutor.createText(output), this.myPackageName, this.myVersion);
                    this.myDialog.getRootPane().setDefaultButton(this.myDialog.getCloseButton());
                    this.myDialog.myChangesListener.run();
                }
            }

            @Override
            @NotNull
            protected List<String> getBasicCommand() {
                List<String> list = ComposerUtils.getInstallationCommand(this.myPackageName, this.myVersion);
                if (list == null) {
                    1.$$$reportNull$$$0(2);
                }
                return list;
            }

            @Override
            @Nls
            protected String getProgressTitle() {
                return PhpBundle.message("framework.composer.add.dependency.task.title", new Object[0]);
            }

            @Override
            @NlsSafe
            protected String getActionName() {
                return PhpBundle.message("framework.composer.install.action.name", new Object[0]);
            }

            @Override
            @NotNull
            protected String getCommandDescriptionInPast() {
                return "installed";
            }

            @Override
            protected boolean handleAfterCommandExecution(boolean success) {
                if (success && this.myDialog != null) {
                    this.myDialog.myForm.addInstalledPackage(this.myPackageName, version);
                    this.myDialog.myForm.refreshPackagesList(true);
                }
                return success;
            }

            @Override
            protected ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> getExecutorGenerator() {
                String composerJsonPath = this.myComposerJson.getPath();
                return AddDependencyDialog.createInstallingGenerator(this.myExecution, composerJsonPath, this.myCommandLineOptions, this.myPackageName, this.myVersion);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "builder";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "command";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/composer/addDependency/AddDependencyDialog$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/composer/addDependency/AddDependencyDialog$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBasicCommand";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "reportFeedback";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    private static ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> createInstallingGenerator(@NotNull ComposerExecution execution, String composerJsonPath, String commandLineOptions, String packageName, String version) {
        if (execution == null) {
            AddDependencyDialog.$$$reportNull$$$0(9);
        }
        ThrowableNotNullFunction throwableNotNullFunction = generationProject -> {
            VirtualFile composerJson = LocalFileSystem.getInstance().findFileByPath(composerJsonPath);
            ComposerCommandExecutor.checkFileExists(composerJsonPath, composerJson);
            return AddDependencyDialog.createInstallingExecutor(packageName, version, commandLineOptions, execution, null, generationProject, composerJson, "ComposerLogRerun");
        };
        if (throwableNotNullFunction == null) {
            AddDependencyDialog.$$$reportNull$$$0(10);
        }
        return throwableNotNullFunction;
    }

    @NotNull
    static ComposerCommandExecutor createUpdatingExecutor(@NotNull String packageName, @Nullable String commandLineOptions, @NotNull ComposerExecution execution, @Nullable AddDependencyDialog dialog, final @NotNull Project project, @NotNull VirtualFile composerJson, @NotNull String placeForStatistics, final @Nullable String version) {
        if (packageName == null) {
            AddDependencyDialog.$$$reportNull$$$0(11);
        }
        if (execution == null) {
            AddDependencyDialog.$$$reportNull$$$0(12);
        }
        if (project == null) {
            AddDependencyDialog.$$$reportNull$$$0(13);
        }
        if (composerJson == null) {
            AddDependencyDialog.$$$reportNull$$$0(14);
        }
        if (placeForStatistics == null) {
            AddDependencyDialog.$$$reportNull$$$0(15);
        }
        ComposerActionStatistics statistics = ComposerActionStatistics.create(ComposerActionStatistics.Action.UPDATE_PACKAGE, placeForStatistics);
        return new AddDependencyCommandExecutor(dialog, project, composerJson, packageName, version, commandLineOptions, execution, statistics){

            @Override
            protected void reportFeedback(@NotNull ComposerLogMessageBuilder builder2, @NotNull List<String> command, boolean success, List<Pair<String, Key>> output, ExecutionException exception, boolean cancelledByUser) {
                if (builder2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (command == null) {
                    2.$$$reportNull$$$0(1);
                }
                super.reportFeedback(builder2, command, success, output, exception, cancelledByUser);
                if (this.myDialog != null) {
                    this.myDialog.provideUpdateFeedback(success, ComposerCommandExecutor.createText(output), this.myPackageName, PhpBundle.message("framework.composer.add.dependency.successfully.updated.0", this.myPackageName), this.getActionName());
                    this.myDialog.getRootPane().setDefaultButton(this.myDialog.getCloseButton());
                }
            }

            @Override
            protected boolean handleAfterCommandExecution(boolean success) {
                if (success && this.myDialog != null) {
                    ComposerAvailablePackageVersionsService packageVersionsService = ComposerAvailablePackageVersionsService.getInstance(project, this.myComposerJson);
                    if (packageVersionsService != null) {
                        packageVersionsService.removeUpdateAvailableVersion(this.myPackageName);
                    }
                    this.myDialog.myForm.removeUpdateAvailableVersion(this.myPackageName);
                    if (version != null) {
                        this.myDialog.myForm.addInstalledPackage(this.myPackageName, version);
                    }
                    this.myDialog.myForm.refreshPackagesList(true);
                }
                return success;
            }

            @Override
            @NotNull
            protected List<String> getBasicCommand() {
                List<String> list = ComposerUtils.getUpdatePackageCommand(this.myPackageName);
                if (list == null) {
                    2.$$$reportNull$$$0(2);
                }
                return list;
            }

            @Override
            protected ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> getExecutorGenerator() {
                String composerJsonPath = this.myComposerJson.getPath();
                return AddDependencyDialog.createUpdatingGenerator(this.myExecution, composerJsonPath, this.myPackageName, this.myCommandLineOptions, this.myVersion);
            }

            @Override
            @Nls
            protected String getProgressTitle() {
                return PhpBundle.message("framework.composer.updating.package.task.title", new Object[0]);
            }

            @Override
            @NotNull
            @NlsSafe
            protected String getActionName() {
                String string = PhpBundle.message("framework.composer.update.action.name", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(3);
                }
                return string;
            }

            @Override
            @NotNull
            protected String getCommandDescriptionInPast() {
                return "updated";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "builder";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "command";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/composer/addDependency/AddDependencyDialog$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/composer/addDependency/AddDependencyDialog$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBasicCommand";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "reportFeedback";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    private static ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> createUpdatingGenerator(@NotNull ComposerExecution execution, String composerJsonPath, String packageName, String commandLineOptions, String version) {
        if (execution == null) {
            AddDependencyDialog.$$$reportNull$$$0(16);
        }
        ThrowableNotNullFunction throwableNotNullFunction = generatorProject -> {
            VirtualFile composerJson = LocalFileSystem.getInstance().findFileByPath(composerJsonPath);
            ComposerCommandExecutor.checkFileExists(composerJsonPath, composerJson);
            return AddDependencyDialog.createUpdatingExecutor(packageName, commandLineOptions, execution, null, generatorProject, composerJson, "ComposerLogRerun", version);
        };
        if (throwableNotNullFunction == null) {
            AddDependencyDialog.$$$reportNull$$$0(17);
        }
        return throwableNotNullFunction;
    }

    @NotNull
    static ComposerCommandExecutor createRemovingExecutor(@NotNull String packageName, @Nullable String commandLineOptions, @NotNull ComposerExecution execution, @Nullable AddDependencyDialog dialog, @NotNull Project project, @NotNull VirtualFile composerJson, @NotNull String placeForStatistics) {
        if (packageName == null) {
            AddDependencyDialog.$$$reportNull$$$0(18);
        }
        if (execution == null) {
            AddDependencyDialog.$$$reportNull$$$0(19);
        }
        if (project == null) {
            AddDependencyDialog.$$$reportNull$$$0(20);
        }
        if (composerJson == null) {
            AddDependencyDialog.$$$reportNull$$$0(21);
        }
        if (placeForStatistics == null) {
            AddDependencyDialog.$$$reportNull$$$0(22);
        }
        ComposerActionStatistics statistics = ComposerActionStatistics.create(ComposerActionStatistics.Action.REMOVE, placeForStatistics);
        return new AddDependencyCommandExecutor(dialog, project, composerJson, packageName, null, commandLineOptions, execution, statistics){

            @Override
            protected void reportFeedback(@NotNull ComposerLogMessageBuilder builder2, @NotNull List<String> command, boolean success, List<Pair<String, Key>> output, ExecutionException exception, boolean cancelledByUser) {
                if (builder2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (command == null) {
                    3.$$$reportNull$$$0(1);
                }
                super.reportFeedback(builder2, command, success, output, exception, cancelledByUser);
                if (this.myDialog != null) {
                    this.myDialog.provideRemoveFeedback(success, ComposerCommandExecutor.createText(output), this.myPackageName);
                    this.myDialog.getRootPane().setDefaultButton(this.myDialog.getCloseButton());
                }
            }

            @Override
            @NotNull
            protected List<String> getBasicCommand() {
                List<String> list = ComposerUtils.getRemovePackageCommand(this.myPackageName);
                if (list == null) {
                    3.$$$reportNull$$$0(2);
                }
                return list;
            }

            @Override
            @Nls
            protected String getProgressTitle() {
                return PhpBundle.message("framework.composer.removing.package.task.title", new Object[0]);
            }

            @Override
            @NlsSafe
            protected String getActionName() {
                return PhpBundle.message("framework.composer.remove.action.name", new Object[0]);
            }

            @Override
            @NotNull
            protected String getCommandDescriptionInPast() {
                return "removed";
            }

            @Override
            protected boolean handleAfterCommandExecution(boolean success) {
                if (success && this.myDialog != null) {
                    this.myDialog.myForm.removeInstalledPackage(this.myPackageName);
                    this.myDialog.myForm.refreshPackagesList(false);
                }
                return success;
            }

            @Override
            protected ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> getExecutorGenerator() {
                String composerJsonPath = this.myComposerJson.getPath();
                return AddDependencyDialog.createRemovingGenerator(this.myExecution, composerJsonPath, this.myPackageName, this.myCommandLineOptions);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "builder";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "command";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/composer/addDependency/AddDependencyDialog$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/composer/addDependency/AddDependencyDialog$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBasicCommand";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "reportFeedback";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    private static ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> createRemovingGenerator(@NotNull ComposerExecution execution, String composerJsonPath, String packageName, String commandLineOptions) {
        if (execution == null) {
            AddDependencyDialog.$$$reportNull$$$0(23);
        }
        ThrowableNotNullFunction throwableNotNullFunction = generatorProject -> {
            VirtualFile composerJson = LocalFileSystem.getInstance().findFileByPath(composerJsonPath);
            ComposerCommandExecutor.checkFileExists(composerJsonPath, composerJson);
            return AddDependencyDialog.createRemovingExecutor(packageName, commandLineOptions, execution, null, generatorProject, composerJson, "ComposerLogRerun");
        };
        if (throwableNotNullFunction == null) {
            AddDependencyDialog.$$$reportNull$$$0(24);
        }
        return throwableNotNullFunction;
    }

    private JButton getCloseButton() {
        return this.myCloseButton;
    }

    protected JButton createJButtonForAction(Action action) {
        JButton button = super.createJButtonForAction(action);
        if (action.equals(this.getCancelAction())) {
            this.myCloseButton = button;
        }
        return button;
    }

    private void provideInstallationFeedback(boolean successful, String output, @NotNull String packageName, String version) {
        String message;
        if (packageName == null) {
            AddDependencyDialog.$$$reportNull$$$0(25);
        }
        if (successful) {
            message = PhpBundle.message("framework.composer.add.dependency.successfully.installed.0.version.1", packageName, version);
        } else {
            String presentableCommand = PhpBundle.message("framework.composer.0.1.version.2", PhpBundle.message("framework.composer.install.action.name", new Object[0]), packageName, version);
            message = PhpBundle.message("framework.composer.failed.to.0", presentableCommand);
        }
        this.provideFeedback(message, output, AddDependencyDialog.getLabelIcon(successful));
    }

    private static Icon getLabelIcon(boolean successful) {
        return successful ? AllIcons.General.BalloonInformation : AllIcons.General.BalloonError;
    }

    private void provideUpdateFeedback(boolean successful, String output, @NotNull String packageName, @NotNull @NlsContexts.Label String successMessage, @NotNull String commandName) {
        if (packageName == null) {
            AddDependencyDialog.$$$reportNull$$$0(26);
        }
        if (successMessage == null) {
            AddDependencyDialog.$$$reportNull$$$0(27);
        }
        if (commandName == null) {
            AddDependencyDialog.$$$reportNull$$$0(28);
        }
        String message = successful ? (output != null && output.contains("Nothing to install or update") ? PhpBundle.message("framework.composer.add.dependency.no.new.version.found.for.0", packageName) : successMessage) : PhpBundle.message("framework.composer.failed.to.0.1.script.was.cancelled", commandName, packageName);
        this.provideFeedback(message, output, AddDependencyDialog.getLabelIcon(successful));
    }

    private void provideRemoveFeedback(boolean successful, String output, @NotNull String packageName) {
        if (packageName == null) {
            AddDependencyDialog.$$$reportNull$$$0(29);
        }
        this.provideFeedback(AddDependencyDialog.getMessage(successful, packageName), output, AddDependencyDialog.getLabelIcon(successful));
    }

    @NotNull
    @Nls
    private static String getMessage(boolean successful, @NotNull String packageName) {
        if (packageName == null) {
            AddDependencyDialog.$$$reportNull$$$0(30);
        }
        if (successful) {
            String string = PhpBundle.message("framework.composer.add.dependency.successfully.removed.0", packageName);
            if (string == null) {
                AddDependencyDialog.$$$reportNull$$$0(31);
            }
            return string;
        }
        String string = PhpBundle.message("framework.composer.failed.to.0.1.script.was.cancelled", PhpBundle.message("framework.composer.remove.action.name", new Object[0]), packageName);
        if (string == null) {
            AddDependencyDialog.$$$reportNull$$$0(32);
        }
        return string;
    }

    private void provideFeedback(final @NlsContexts.Label String message, final String output, Icon icon) {
        this.myInstallationFeedbackLabel.setIcon(icon);
        this.myInstallationFeedbackLabel.setText(message);
        this.myInstallationFeedbackLinkLabel.setText(PhpBundle.message("framework.composer.add.dependency.show.output", new Object[0]));
        if (this.myHyperlinkListener != null) {
            this.myInstallationFeedbackLinkLabel.removeHyperlinkListener(this.myHyperlinkListener);
        }
        this.myHyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                AddDependencyDialog.this.myForm.showOutput(output, message, AddDependencyDialog.this.myProject);
            }
        };
        this.myInstallationFeedbackLinkLabel.addHyperlinkListener(this.myHyperlinkListener);
        this.myInstallationFeedbackLabel.setVisible(true);
        this.myInstallationFeedbackLinkLabel.setVisible(true);
    }

    @NonNls
    @Nullable
    protected String getHelpId() {
        return "composer.add.dependency";
    }

    protected void dispose() {
        super.dispose();
        this.myForm.dispose();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        RawCommandLineEditor rawCommandLineEditor;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        AddDependencyForm addDependencyForm = this.myForm;
        JComponent jComponent = addDependencyForm.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent, new GridConstraints(0, 0, 1, 3, 0, 3, 7, 7, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myCommandLineParametersEditor = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel2.add((Component)rawCommandLineEditor, new GridConstraints(1, 1, 1, 2, 0, 1, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/PhpBundle", AddDependencyDialog.class).getString("framework.composer.add.dependency.settings.cl.label"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        HoverHyperlinkLabel hoverHyperlinkLabel = this.myInstallationFeedbackLinkLabel;
        jPanel3.add((Component)hoverHyperlinkLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInstallationFeedbackLabel = jBLabel = new JBLabel();
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        jBLabel2.setLabelFor((Component)rawCommandLineEditor);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 10, 17, 24, 31, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composerJson";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installedPackages";
                break;
            }
            case 3: 
            case 10: 
            case 17: 
            case 24: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/addDependency/AddDependencyDialog";
                break;
            }
            case 4: 
            case 11: 
            case 18: 
            case 25: 
            case 26: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execution";
                break;
            }
            case 8: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeForStatistics";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "successMessage";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/addDependency/AddDependencyDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstallingGenerator";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createUpdatingGenerator";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemovingGenerator";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 10: 
            case 17: 
            case 24: 
            case 31: 
            case 32: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createInstallingExecutor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createInstallingGenerator";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createUpdatingExecutor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createUpdatingGenerator";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createRemovingExecutor";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createRemovingGenerator";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "provideInstallationFeedback";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "provideUpdateFeedback";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "provideRemoveFeedback";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 10, 17, 24, 31, 32 -> new IllegalStateException(string);
        };
    }

    protected final class RemoveAction
    extends DialogWrapper.DialogWrapperAction {
        private RemoveAction() {
            super((DialogWrapper)AddDependencyDialog.this, PhpBundle.message("composer.remove.action.name", new Object[0]));
        }

        protected void doAction(ActionEvent e) {
            String packageName = AddDependencyDialog.this.myForm.getSelectedPackageName();
            LOG.assertTrue(packageName != null);
            String commandLineOptions = AddDependencyDialog.this.myCommandLineParametersEditor.getText();
            LOG.assertTrue(AddDependencyDialog.this.myForm.isSelectedPackageInstalled());
            AddDependencyDialog.createRemovingExecutor(packageName, commandLineOptions, ComposerDataService.getInstance(AddDependencyDialog.this.myProject).getComposerExecution(), AddDependencyDialog.this, AddDependencyDialog.this.myProject, AddDependencyDialog.this.myComposerJson, AddDependencyDialog.PLACE).execute();
        }
    }

    private static abstract class AddDependencyCommandExecutor
    extends ComposerPackagedVersionedCommandExecutor {
        @NotNull
        protected final VirtualFile myComposerJson;
        @Nullable
        protected final AddDependencyDialog myDialog;

        protected AddDependencyCommandExecutor(@Nullable AddDependencyDialog dialog, @NotNull Project project, @NotNull VirtualFile composerJson, @NotNull String packageName, String version, @Nullable String commandLineOptions, @NotNull ComposerExecution execution, @NotNull ComposerActionStatistics actionStatistics) {
            if (project == null) {
                AddDependencyCommandExecutor.$$$reportNull$$$0(0);
            }
            if (composerJson == null) {
                AddDependencyCommandExecutor.$$$reportNull$$$0(1);
            }
            if (packageName == null) {
                AddDependencyCommandExecutor.$$$reportNull$$$0(2);
            }
            if (execution == null) {
                AddDependencyCommandExecutor.$$$reportNull$$$0(3);
            }
            if (actionStatistics == null) {
                AddDependencyCommandExecutor.$$$reportNull$$$0(4);
            }
            super(project, packageName, version, composerJson.getParent().getPath(), commandLineOptions, execution, actionStatistics, false);
            this.myDialog = dialog;
            this.myComposerJson = composerJson;
        }

        @Override
        protected ComposerLogMessageBuilder.SummaryMessage createSuccessfulSummary() {
            return new ComposerLogMessageBuilder.SummaryMessage().appendText("Successfully " + this.getCommandDescriptionInPast() + " dependency " + this.myPackageName + " for ").appendFileLink(this.myComposerJson, this.myProject);
        }

        @NotNull
        protected abstract String getCommandDescriptionInPast();

        @Override
        protected ComposerLogMessageBuilder.SummaryMessage createFailureSummary() {
            return new ComposerLogMessageBuilder.SummaryMessage().appendText("Failed to " + this.getPresentableCommandDescription() + " for ").appendFileLink(this.myComposerJson, this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "composerJson";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "packageName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "execution";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "actionStatistics";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/composer/addDependency/AddDependencyDialog$AddDependencyCommandExecutor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

