/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.configData;

import com.google.common.collect.Sets;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.xmlb.annotations.XCollection;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="ComposerConfigs", storages={@Storage(value="$WORKSPACE_FILE$")})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\b\u0007\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002$%B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u0014\u0010\u0013\u001a\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0015J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\tJ\u0012\u0010\u0018\u001a\u0004\u0018\u00010\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0017J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00122\b\u0010\u000f\u001a\u0004\u0018\u00010\tJ\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001aJ\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001eH\u0007J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0012H\u0007J\n\u0010 \u001a\u0004\u0018\u00010\tH\u0007J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\u0015H\u0007J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u0007\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\u000b0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006&"}, d2={"Lcom/jetbrains/php/composer/configData/ComposerConfigManager;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lcom/jetbrains/php/composer/configData/ComposerConfigManager$ComposerConfigState;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "configs", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "", "Ljava/util/Set;", "addConfig", "", "context", "removeConfig", "path", "", "setSubProjectConfigs", "newConfigs", "", "getConfigPath", "Lcom/intellij/psi/PsiElement;", "getConfig", "isConfigured", "", "setNotifyAboutSettingsSync", "value", "getAllConfigs", "", "getMainConfigPath", "getMainConfig", "getSubProjectConfigs", "loadState", "state", "Companion", "ComposerConfigState", "intellij.php.impl"})
@SourceDebugExtension(value={"SMAP\nComposerConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposerConfigManager.kt\ncom/jetbrains/php/composer/configData/ComposerConfigManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1863#2,2:107\n1863#2,2:109\n1557#2:112\n1628#2,3:113\n774#2:116\n865#2,2:117\n1971#2,14:119\n1611#2,9:133\n1863#2:142\n1864#2:144\n1620#2:145\n1863#2,2:146\n1#3:111\n1#3:143\n*S KotlinDebug\n*F\n+ 1 ComposerConfigManager.kt\ncom/jetbrains/php/composer/configData/ComposerConfigManager\n*L\n37#1:107,2\n38#1:109,2\n58#1:112\n58#1:113,3\n60#1:116\n60#1:117,2\n61#1:119,14\n98#1:133,9\n98#1:142\n98#1:144\n98#1:145\n98#1:146,2\n98#1:143\n*E\n"})
public final class ComposerConfigManager
extends SimplePersistentStateComponent<ComposerConfigState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final Set<VirtualFile> configs;

    public ComposerConfigManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super((BaseState)new ComposerConfigState());
        this.project = project;
        this.configs = Sets.newConcurrentHashSet();
    }

    public final void addConfig(@NotNull VirtualFile context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.configs.add(context)) {
            ((Collection)((ComposerConfigState)this.getState()).getConfigs()).add(context.getPath());
            ComposerDataService.getInstance(this.project).configPathChanged(null, context.getPath());
        }
    }

    public final void removeConfig(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (this.configs.removeIf(arg_0 -> ComposerConfigManager.removeConfig$lambda$1(arg_0 -> ComposerConfigManager.removeConfig$lambda$0(path, arg_0), arg_0))) {
            ((Collection)((ComposerConfigState)this.getState()).getConfigs()).remove(path);
            ComposerDataService.getInstance(this.project).configPathChanged(path, null);
        }
    }

    public final void setSubProjectConfigs(@NotNull Collection<? extends VirtualFile> newConfigs) {
        VirtualFile it;
        Intrinsics.checkNotNullParameter(newConfigs, (String)"newConfigs");
        Iterable iterable = newConfigs;
        Set<VirtualFile> set = this.configs;
        Intrinsics.checkNotNullExpressionValue(set, (String)"configs");
        List toAdd = CollectionsKt.minus((Iterable)iterable, (Iterable)set);
        Set<VirtualFile> set2 = this.configs;
        Intrinsics.checkNotNullExpressionValue(set2, (String)"configs");
        Set toRemove = SetsKt.minus(set2, (Iterable)CollectionsKt.toSet((Iterable)newConfigs));
        Iterable $this$forEach$iv = toAdd;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (VirtualFile)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.addConfig(it);
        }
        $this$forEach$iv = toRemove;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (VirtualFile)element$iv;
            boolean bl = false;
            String string = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            this.removeConfig(string);
        }
    }

    @Nullable
    public final String getConfigPath(@Nullable PsiElement context) {
        PsiElement psiElement = context;
        return this.getConfigPath(psiElement != null && (psiElement = psiElement.getContainingFile()) != null ? psiElement.getVirtualFile() : null);
    }

    @Nullable
    public final VirtualFile getConfig(@Nullable VirtualFile context) {
        VirtualFile virtualFile;
        String string = this.getConfigPath(context);
        if (string != null) {
            String it = string;
            boolean bl = false;
            virtualFile = ComposerUtils.refreshAndFindFileByPath(it);
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    @Nullable
    public final VirtualFile getConfig(@Nullable PsiElement context) {
        PsiElement psiElement = context;
        return this.getConfig(psiElement != null && (psiElement = psiElement.getContainingFile()) != null ? psiElement.getVirtualFile() : null);
    }

    @Nullable
    public final String getConfigPath(@Nullable VirtualFile context) {
        VirtualFile virtualFile = context;
        return this.getConfigPath(virtualFile != null ? virtualFile.getPath() : null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getConfigPath(@Nullable String path) {
        String string;
        Object v2;
        void $this$filterTo$iv$iv;
        if (path == null) {
            String string2 = this.getMainConfigPath();
            if (string2 == null) {
                void $this$mapTo$iv$iv;
                Set<VirtualFile> set = this.configs;
                Intrinsics.checkNotNullExpressionValue(set, (String)"configs");
                Iterable $this$map$iv = set;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getPath());
                }
                string2 = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            }
            return string2;
        }
        Iterable $this$filter$iv = this.getAllConfigs();
        boolean $i$f$filter = false;
        Iterable $this$mapTo$iv$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(StringsKt.startsWith$default((String)path, (String)(it.getParent().getPath() + "/"), (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)path, (Object)it.getParent().getPath()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$maxByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = maxElem$iv;
            } else {
                VirtualFile it = (VirtualFile)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getPath().length();
                do {
                    Object e$iv = iterator$iv.next();
                    VirtualFile it2 = (VirtualFile)e$iv;
                    $i$a$-maxByOrNull-ComposerConfigManager$getConfigPath$3 = false;
                    int v$iv = it2.getPath().length();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = maxElem$iv;
            }
        }
        VirtualFile virtualFile = v2;
        return virtualFile != null && (string = virtualFile.getPath()) != null ? string : this.getMainConfigPath();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isConfigured() {
        if (!((ComposerConfigState)this.getState()).getNotifyAboutSettingsSync()) return true;
        Set<VirtualFile> set = this.configs;
        Intrinsics.checkNotNullExpressionValue(set, (String)"configs");
        if (((Collection)set).isEmpty()) return false;
        return true;
    }

    public final void setNotifyAboutSettingsSync(boolean value) {
        ((ComposerConfigState)this.getState()).setNotifyAboutSettingsSync(value);
    }

    @ApiStatus.Internal
    @NotNull
    public final List<VirtualFile> getAllConfigs() {
        Set<VirtualFile> set = this.configs;
        Intrinsics.checkNotNullExpressionValue(set, (String)"configs");
        return CollectionsKt.filterNotNull((Iterable)SetsKt.plus(set, (Object)this.getMainConfig()));
    }

    @ApiStatus.Internal
    @Nullable
    public final String getMainConfigPath() {
        return ComposerDataService.getInstance(this.project).getConfigPath();
    }

    @ApiStatus.Internal
    @Nullable
    public final VirtualFile getMainConfig() {
        VirtualFile virtualFile;
        String string = this.getMainConfigPath();
        if (string != null) {
            String it = string;
            boolean bl = false;
            virtualFile = ComposerUtils.refreshAndFindFileByPath(it);
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    @ApiStatus.Internal
    @NotNull
    public final Collection<VirtualFile> getSubProjectConfigs() {
        Set<VirtualFile> set = this.configs;
        Intrinsics.checkNotNullExpressionValue(set, (String)"configs");
        return set;
    }

    /*
     * WARNING - void declaration
     */
    public void loadState(@NotNull ComposerConfigState state) {
        void $this$forEach$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        super.loadState((BaseState)state);
        Iterable $this$mapNotNull$iv = state.getConfigs();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (ComposerUtils.refreshAndFindFileByPath(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        Set<VirtualFile> set = this.configs;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile p0 = (VirtualFile)element$iv;
            boolean bl = false;
            set.add(p0);
        }
    }

    private static final boolean removeConfig$lambda$0(String $path, VirtualFile it) {
        return Intrinsics.areEqual((Object)$path, (Object)it.getPath());
    }

    private static final boolean removeConfig$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final ComposerConfigManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/php/composer/configData/ComposerConfigManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/php/composer/configData/ComposerConfigManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.php.impl"})
    @SourceDebugExtension(value={"SMAP\nComposerConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposerConfigManager.kt\ncom/jetbrains/php/composer/configData/ComposerConfigManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,106:1\n31#2,2:107\n*S KotlinDebug\n*F\n+ 1 ComposerConfigManager.kt\ncom/jetbrains/php/composer/configData/ComposerConfigManager$Companion\n*L\n93#1:107,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ComposerConfigManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ComposerConfigManager> serviceClass$iv = ComposerConfigManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ComposerConfigManager)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR+\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\n\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/php/composer/configData/ComposerConfigManager$ComposerConfigState;", "Lcom/intellij/openapi/components/BaseState;", "<init>", "()V", "configs", "", "", "getConfigs", "()Ljava/util/List;", "configs$delegate", "Lkotlin/properties/ReadWriteProperty;", "<set-?>", "", "notifyAboutSettingsSync", "getNotifyAboutSettingsSync", "()Z", "setNotifyAboutSettingsSync", "(Z)V", "notifyAboutSettingsSync$delegate", "intellij.php.impl"})
    public static final class ComposerConfigState
    extends BaseState {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty configs$delegate = this.list().provideDelegate((Object)this, $$delegatedProperties[0]);
        @NotNull
        private final ReadWriteProperty notifyAboutSettingsSync$delegate = this.property(true).provideDelegate((Object)this, $$delegatedProperties[1]);

        @XCollection
        @NotNull
        public final List<String> getConfigs() {
            return (List)this.configs$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final boolean getNotifyAboutSettingsSync() {
            return (Boolean)this.notifyAboutSettingsSync$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        public final void setNotifyAboutSettingsSync(boolean bl) {
            this.notifyAboutSettingsSync$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)bl);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ComposerConfigState.class, "configs", "getConfigs()Ljava/util/List;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ComposerConfigState.class, "notifyAboutSettingsSync", "getNotifyAboutSettingsSync()Z", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

