/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.configData;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerSettingSyncConfigClient;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.configData.ComposerConfigClient;
import com.jetbrains.php.composer.configData.ComposerConfigListener;
import com.jetbrains.php.composer.configData.ComposerConfigManager;
import com.jetbrains.php.composer.lib.ComposerLibraryService;
import com.jetbrains.php.composer.lib.ComposerLibraryServiceFactory;
import com.jetbrains.php.roots.PhpPsrComposerConfig;
import com.jetbrains.php.testFramework.PhpTestFrameworkComposerConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComposerJsonConfigService
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ComposerJsonConfigService.class);
    private final ComposerDataService myService;
    @NotNull
    private final Project myProject;
    private final AtomicReference<Boolean> myIsListenToFileChanges;
    private final List<ComposerConfigListener<?>> myClients;
    private final VirtualFileListener myVirtualFileListener;

    public static ComposerJsonConfigService getInstance(Project project) {
        return (ComposerJsonConfigService)project.getService(ComposerJsonConfigService.class);
    }

    public ComposerJsonConfigService(final @NotNull Project project) {
        if (project == null) {
            ComposerJsonConfigService.$$$reportNull$$$0(0);
        }
        this.myIsListenToFileChanges = new AtomicReference<Boolean>(false);
        this.myClients = Collections.synchronizedList(new ArrayList());
        this.myService = ComposerDataService.getInstance(project);
        this.myProject = project;
        for (ComposerConfigClient client : (ComposerConfigClient[])ComposerConfigClient.EP_NAME.getExtensions()) {
            this.addClient(client);
        }
        this.myVirtualFileListener = new VirtualFileListener(){

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ComposerJsonConfigService.this.isConfiguredConfig(event.getFile())) {
                    VirtualFile file = event.getFile();
                    ComposerJsonConfigService.this.cleanRootsAndRun(project, file.getPath(), ComposerJsonConfigService.this.myService, () -> ComposerJsonConfigService.this.handleChange(file, file, false));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/composer/configData/ComposerJsonConfigService$1", "contentsChanged"));
            }
        };
        this.myService.addSynchronizationInitListener(newSyncState -> {
            if (newSyncState == ComposerDataService.SynchronizationState.SYNCHRONIZE) {
                this.cleanAllRootsAndRun(project, this.myService, () -> {
                    for (VirtualFile config : ComposerConfigManager.getInstance(this.myProject).getAllConfigs()) {
                        this.doInform(config, config, true);
                    }
                });
            }
        });
        this.myService.addConfigListener(new com.jetbrains.php.composer.ComposerConfigListener(){

            @Override
            public void configPathChanged(@Nullable String oldPath, @Nullable String newPath, boolean isWellConfigured) {
                VirtualFile oldFile;
                VirtualFile newFile = StringUtil.isEmpty((String)newPath) ? null : LocalFileSystem.getInstance().findFileByPath(newPath);
                VirtualFile virtualFile = oldFile = StringUtil.isEmpty((String)oldPath) ? null : LocalFileSystem.getInstance().findFileByPath(oldPath);
                if (oldPath != null) {
                    ComposerJsonConfigService.this.cleanRootsAndRun(project, oldPath, ComposerJsonConfigService.this.myService, () -> ComposerJsonConfigService.this.handleChange(newFile, oldFile, false));
                } else {
                    ComposerJsonConfigService.this.handleChange(newFile, oldFile, false);
                }
            }
        });
        ComposerConfigClient.EP_NAME.addExtensionPointListener(new ExtensionPointListener<ComposerConfigClient<?>>(){

            public void extensionAdded(@NotNull ComposerConfigClient<?> extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(1);
                }
                ComposerJsonConfigService.this.addClient(extension);
            }

            public void extensionRemoved(@NotNull ComposerConfigClient<?> extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(3);
                }
                ComposerJsonConfigService.this.myClients.removeIf(client -> client.usesConfigClient(extension));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/composer/configData/ComposerJsonConfigService$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> {
            if (this.myService.isConfigWellConfigured() && this.myService.getSynchronizationState() == ComposerDataService.SynchronizationState.NOT_INITIALIZED) {
                ComposerSettingSyncConfigClient.initOrSuggestSync(this.myProject);
            }
            for (VirtualFile config : ComposerConfigManager.getInstance(this.myProject).getAllConfigs()) {
                this.handleChange(config, config, ApplicationManager.getApplication().isHeadlessEnvironment());
            }
        });
    }

    private void cleanRootsAndRun(@NotNull Project project, @Nullable String configPath, @NotNull Disposable parentDisposable, @NotNull Runnable runAfter) {
        if (project == null) {
            ComposerJsonConfigService.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            ComposerJsonConfigService.$$$reportNull$$$0(2);
        }
        if (runAfter == null) {
            ComposerJsonConfigService.$$$reportNull$$$0(3);
        }
        ReadAction.nonBlocking(() -> {
            Module module = ComposerJsonConfigService.getModule(project, configPath);
            if (module != null && ModuleRootManager.getInstance((Module)module).getContentEntries().length > 0) {
                return ModuleRootManager.getInstance((Module)module).getModifiableModel();
            }
            return null;
        }).inSmartMode(project).expireWith(parentDisposable).coalesceBy(new Object[]{configPath != null ? configPath : ComposerConfigManager.getInstance(project).getMainConfigPath(), parentDisposable}).finishOnUiThread(ModalityState.nonModal(), modifiableModel -> this.cleanRootsAndRun((ModifiableRootModel)modifiableModel, configPath, runAfter)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @RequiresEdt
    private void cleanRootsAndRun(@Nullable ModifiableRootModel modifiableModel, @Nullable String configPath, @NotNull Runnable runAfter) {
        if (runAfter == null) {
            ComposerJsonConfigService.$$$reportNull$$$0(4);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (modifiableModel != null) {
            for (ContentEntry entry : modifiableModel.getContentEntries()) {
                if (configPath == null) {
                    entry.clearSourceFolders();
                    continue;
                }
                for (SourceFolder folder : entry.getSourceFolders()) {
                    if (!VirtualFileManager.extractPath((String)folder.getUrl()).startsWith(PathUtil.getParentPath((String)configPath) + "/")) continue;
                    entry.removeSourceFolder(folder);
                }
            }
            WriteAction.run(() -> modifiableModel.commit());
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.resetClientsAndRun(configPath, runAfter);
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.resetClientsAndRun(configPath, runAfter));
        }
    }

    private void resetClientsAndRun(@Nullable String configPath, @NotNull Runnable runAfter) {
        if (runAfter == null) {
            ComposerJsonConfigService.$$$reportNull$$$0(5);
        }
        for (ComposerConfigListener<?> client : this.myClients) {
            if (!client.isClientInstanceOf(PhpPsrComposerConfig.class, PhpTestFrameworkComposerConfig.class)) continue;
            client.reset(configPath);
        }
        runAfter.run();
    }

    @Nullable
    private static Module getModule(@NotNull Project project, @Nullable String configPath) {
        if (project == null) {
            ComposerJsonConfigService.$$$reportNull$$$0(6);
        }
        if (configPath == null) {
            VirtualFile mainConfig = ComposerConfigManager.getInstance(project).getMainConfig();
            if (mainConfig != null) {
                return ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(mainConfig);
            }
            Module[] modules = ModuleManager.getInstance((Project)project).getModules();
            return modules.length == 1 ? modules[0] : null;
        }
        return PhpPsrComposerConfig.getModule(project, configPath);
    }

    private void cleanAllRootsAndRun(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull Runnable runAfter) {
        if (project == null) {
            ComposerJsonConfigService.$$$reportNull$$$0(7);
        }
        if (parentDisposable == null) {
            ComposerJsonConfigService.$$$reportNull$$$0(8);
        }
        if (runAfter == null) {
            ComposerJsonConfigService.$$$reportNull$$$0(9);
        }
        this.cleanRootsAndRun(project, null, parentDisposable, runAfter);
    }

    private boolean isConfiguredConfig(VirtualFile newConfig) {
        return newConfig != null && ComposerConfigManager.getInstance(this.myProject).getAllConfigs().contains(newConfig);
    }

    private <T> void addClient(ComposerConfigClient<T> client) {
        ComposerConfigListener<T> listener = new ComposerConfigListener<T>(client);
        this.myClients.add(listener);
    }

    private void handleChange(@Nullable VirtualFile newConfig, @Nullable VirtualFile oldConfig, boolean initialized) {
        VirtualFile configToInform;
        List<VirtualFile> allConfigs = ComposerConfigManager.getInstance(this.myProject).getAllConfigs();
        if (allConfigs.isEmpty() && this.myIsListenToFileChanges.compareAndSet(true, false)) {
            LocalFileSystem.getInstance().removeVirtualFileListener(this.myVirtualFileListener);
        } else if (this.myIsListenToFileChanges.compareAndSet(false, true)) {
            LocalFileSystem.getInstance().addVirtualFileListener(this.myVirtualFileListener);
        }
        VirtualFile virtualFile = configToInform = oldConfig != null ? oldConfig : newConfig;
        if (configToInform == null) {
            return;
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.doInform(newConfig, configToInform, initialized);
        } else {
            this.doInform(newConfig, configToInform, initialized);
        }
    }

    private void doInform(@Nullable VirtualFile newConfig, @NotNull VirtualFile config, boolean initialized) {
        if (config == null) {
            ComposerJsonConfigService.$$$reportNull$$$0(10);
        }
        Runnable inform = () -> {
            JsonElement fileElement = ComposerJsonConfigService.getElement(newConfig);
            if (LOG.isTraceEnabled()) {
                LOG.trace("inform() with initialized " + initialized + "\nfileElement " + (fileElement == null ? "<null>" : fileElement.toString()));
            }
            this.ensureComposerLibraryServiceUpdated(config);
            for (ComposerConfigListener<?> client : this.myClients) {
                client.inform(fileElement, config, this.myProject, initialized);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            inform.run();
        } else {
            ComposerUtils.COMPOSER_CONFIG_EXECUTOR.execute(inform);
        }
    }

    private void ensureComposerLibraryServiceUpdated(@NotNull VirtualFile config) {
        if (config == null) {
            ComposerJsonConfigService.$$$reportNull$$$0(11);
        }
        ReadAction.nonBlocking(() -> {
            LOG.trace("Force update of the composer library service for project: " + this.myProject.getName());
            ComposerLibraryService composerLibraryService = ComposerLibraryServiceFactory.getInstance(this.myProject, config);
            if (!config.equals(composerLibraryService.getConfig())) {
                composerLibraryService.reloadLibraries(false, Collections.emptySet(), composerLibraryService.isUpdatingLibrary(), composerLibraryService.isUpdatingLibrary());
            }
            return null;
        }).expireWith((Disposable)this).executeSynchronously();
    }

    @Nullable
    private static JsonElement getElement(VirtualFile newConfig) {
        JsonElement fileElement = null;
        if (newConfig != null) {
            try {
                fileElement = ComposerConfigUtils.parseJson(newConfig);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
        }
        return fileElement;
    }

    public void dispose() {
        LocalFileSystem.getInstance().removeVirtualFileListener(this.myVirtualFileListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runAfter";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/composer/configData/ComposerJsonConfigService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "cleanRootsAndRun";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "resetClientsAndRun";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getModule";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "cleanAllRootsAndRun";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "doInform";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureComposerLibraryServiceUpdated";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

