/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.execution.phar;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.AbstractPathMapper;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.actions.ComposerExecutionException;
import com.jetbrains.php.composer.execution.ComposerExecution;
import com.jetbrains.php.composer.statistics.ComposerExecutorStatProvider;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PharComposerExecution
implements ComposerExecution,
ComposerExecutorStatProvider {
    private static final String ROOT_TAG_NAME = "phar";
    private static final String PHAR_PATH_ATTRIBUTE = "pharPath";
    private static final String INTERPRETER_ID_ATTRIBUTE = "interpreterId";
    @NotNull
    private String pharPath;
    @Nullable
    private final String interpreterId;
    private boolean shouldDownload;

    public PharComposerExecution() {
        this(null, "", false);
    }

    public PharComposerExecution(@Nullable String interpreterId, @Nullable String pharPath, boolean shouldDownload) {
        this.interpreterId = interpreterId;
        this.pharPath = StringUtil.notNullize((String)pharPath);
        this.shouldDownload = shouldDownload;
    }

    @Override
    @NotNull
    public ProcessHandler createProcessHandler(@NotNull Project project, String workingDir, @NotNull List<String> command, @NotNull String commandText) throws ExecutionException {
        String[] stringArray;
        PhpInterpreter interpreter;
        if (project == null) {
            PharComposerExecution.$$$reportNull$$$0(0);
        }
        if (command == null) {
            PharComposerExecution.$$$reportNull$$$0(1);
        }
        if (commandText == null) {
            PharComposerExecution.$$$reportNull$$$0(2);
        }
        if ((interpreter = this.getInterpreter(project)) == null) {
            throw new ExecutionException(PhpBundle.message("failed.to.find.interpreter", new Object[0]));
        }
        if (interpreter.isRemote()) {
            ProcessHandler processHandler;
            PhpRemoteInterpreterManager instance = PhpRemoteInterpreterManager.getInstance();
            if (instance == null) {
                throw new ExecutionException(PhpRemoteInterpreterManager.getRemoteInterpreterPluginIsDisabledErrorMessage());
            }
            PhpSdkAdditionalData data = interpreter.getPhpSdkAdditionalData();
            PathMappingSettings mappings = instance.createPathMappings(project, data);
            List pathMappings = mappings.getPathMappings();
            String remotePharPath = AbstractPathMapper.convertToRemote((String)this.pharPath, (Collection)pathMappings);
            if (remotePharPath == null) {
                ArrayList<Pair<String, ? extends HyperlinkInfo>> message = ComposerUtils.createUnmappedMessage(this.pharPath, "Phar path");
                throw new ComposerExecutionException(message);
            }
            String remoteWorkingDir = AbstractPathMapper.convertToRemote((String)workingDir, (Collection)pathMappings);
            if (remoteWorkingDir == null) {
                ArrayList<Pair<String, ? extends HyperlinkInfo>> message = ComposerUtils.createUnmappedMessage(workingDir, "Working directory");
                throw new ComposerExecutionException(message);
            }
            PhpCommandSettings phpCommand = new PhpCommandSettingsBuilder(project, interpreter).build();
            phpCommand.setWorkingDir(workingDir);
            phpCommand.addArgument(remotePharPath);
            for (String params : command) {
                phpCommand.addArgument(params);
            }
            phpCommand.addArgument("-d");
            phpCommand.addArgument(remoteWorkingDir);
            try {
                processHandler = instance.getRemoteProcessHandler(project, data, phpCommand.createGeneralCommandLine(PtyCommandLine.isEnabled()), true, new PathMappingSettings.PathMapping[0]);
            }
            catch (InterruptedException e) {
                throw new ExecutionException(PhpBundle.message("failed.to.run.interpreter", new Object[0]), (Throwable)e);
            }
            if (processHandler == null) {
                PharComposerExecution.$$$reportNull$$$0(3);
            }
            return processHandler;
        }
        String[] parameters = new String[command.size() + 1];
        parameters[0] = this.pharPath;
        for (int i = 0; i < command.size(); ++i) {
            parameters[i + 1] = command.get(i);
        }
        if (interpreter.getCustomIni() != null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "-c";
            stringArray = stringArray2;
            stringArray2[1] = interpreter.getCustomIni();
        } else {
            stringArray = null;
        }
        String[] customIni = stringArray;
        String phpPath = StringUtil.notNullize((String)interpreter.getPathToPhpExecutable());
        OSProcessHandler oSProcessHandler = ScriptRunnerUtil.execute((String)phpPath, (String)workingDir, null, (String[])parameters, null, commandLine -> {
            KillableColoredProcessHandler handler = new KillableColoredProcessHandler(commandLine);
            handler.setShouldKillProcessSoftly(false);
            return handler;
        }, (String[])customIni, (boolean)true);
        if (oSProcessHandler == null) {
            PharComposerExecution.$$$reportNull$$$0(4);
        }
        return oSProcessHandler;
    }

    @Nullable
    private PhpInterpreter getInterpreter(@NotNull Project project) {
        if (project == null) {
            PharComposerExecution.$$$reportNull$$$0(5);
        }
        if (this.interpreterId == null) {
            return PhpProjectConfigurationFacade.getInstance(project).getInterpreter();
        }
        return PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(this.interpreterId);
    }

    @Override
    public void cancelProcess(@NotNull ProcessHandler handler) {
        if (handler == null) {
            PharComposerExecution.$$$reportNull$$$0(6);
        }
        handler.destroyProcess();
    }

    @Override
    public ComposerExecution addPharDownloadPath(@Nullable String pharDownloadPath) {
        return new PharComposerExecution(this.interpreterId, pharDownloadPath, false);
    }

    @Override
    @Nullable
    public String getInterpreterId() {
        return this.interpreterId;
    }

    @Override
    public boolean isWellConfigured(@NotNull Project project, boolean quick) {
        if (project == null) {
            PharComposerExecution.$$$reportNull$$$0(7);
        }
        if (!ComposerDataService.isWellConfigured(this.pharPath)) {
            return false;
        }
        if (quick) {
            return true;
        }
        return this.getInterpreter(project) != null;
    }

    @NotNull
    public String getPharPath() {
        String string = this.pharPath;
        if (string == null) {
            PharComposerExecution.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void setPharPath(@NotNull String pharPath) {
        if (pharPath == null) {
            PharComposerExecution.$$$reportNull$$$0(9);
        }
        this.pharPath = pharPath;
    }

    public boolean isShouldDownload() {
        return this.shouldDownload;
    }

    public void setShouldDownload(boolean shouldDownload) {
        this.shouldDownload = shouldDownload;
    }

    @Override
    public boolean isConfigured() {
        return !StringUtil.isEmptyOrSpaces((String)this.getPharPath());
    }

    @Override
    public boolean isDefault() {
        return !StringUtil.isEmptyOrSpaces((String)this.getPharPath()) && this.getInterpreterId() == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PharComposerExecution execution = (PharComposerExecution)o;
        return this.isShouldDownload() == execution.isShouldDownload() && this.getPharPath().equals(execution.getPharPath()) && Objects.equals(this.getInterpreterId(), execution.getInterpreterId());
    }

    public int hashCode() {
        return Objects.hash(this.getPharPath(), this.getInterpreterId(), this.isShouldDownload());
    }

    @Override
    @NotNull
    public Element save() {
        Element element = new Element(ROOT_TAG_NAME);
        ComposerUtils.writeAttribute(element, PHAR_PATH_ATTRIBUTE, this.pharPath);
        ComposerUtils.writeAttribute(element, INTERPRETER_ID_ATTRIBUTE, this.interpreterId);
        Element element2 = element;
        if (element2 == null) {
            PharComposerExecution.$$$reportNull$$$0(10);
        }
        return element2;
    }

    @Nullable
    public static PharComposerExecution load(@NotNull Element element) {
        if (element == null) {
            PharComposerExecution.$$$reportNull$$$0(11);
        }
        if (!ROOT_TAG_NAME.equals(element.getName())) {
            return null;
        }
        String pharPath = element.getAttributeValue(PHAR_PATH_ATTRIBUTE);
        String interpreterId = element.getAttributeValue(INTERPRETER_ID_ATTRIBUTE);
        return new PharComposerExecution(interpreterId, pharPath, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandText";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/execution/phar/PharComposerExecution";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = PHAR_PATH_ATTRIBUTE;
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/execution/phar/PharComposerExecution";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessHandler";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPharPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "save";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandler";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInterpreter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "cancelProcess";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isWellConfigured";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setPharPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 8, 10 -> new IllegalStateException(string);
        };
    }
}

