/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.json;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonUtil;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.json.PhpComposerJsonUtils;
import com.jetbrains.php.lang.inspections.PhpInspection;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PhpComposerDuplicatedRequirementInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiFile file;
        if (holder == null) {
            PhpComposerDuplicatedRequirementInspection.$$$reportNull$$$0(0);
        }
        if (!PhpComposerJsonUtils.insideComposerJson((PsiElement)(file = holder.getFile()))) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpComposerDuplicatedRequirementInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JsonFile composerJson = (JsonFile)ObjectUtils.tryCast((Object)file, JsonFile.class);
        final JsonObject topLevelObject = JsonUtil.getTopLevelObject((JsonFile)composerJson);
        if (topLevelObject == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpComposerDuplicatedRequirementInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        return new JsonElementVisitor(){

            public void visitObject(@NotNull JsonObject o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!o.equals(topLevelObject)) {
                    return;
                }
                JsonObject requireSection = (JsonObject)JsonUtil.getPropertyValueOfType((JsonObject)o, (String)"require", JsonObject.class);
                JsonObject requireDevSection = (JsonObject)JsonUtil.getPropertyValueOfType((JsonObject)o, (String)"require-dev", JsonObject.class);
                if (requireDevSection == null || requireSection == null) {
                    return;
                }
                List requireProperties = requireSection.getPropertyList();
                List requireDevProperties = requireDevSection.getPropertyList();
                Collection intersection = ContainerUtil.intersection((Collection)ContainerUtil.map((Collection)requireProperties, JsonProperty::getName), (Collection)ContainerUtil.map((Collection)requireDevProperties, JsonProperty::getName));
                if (intersection.isEmpty()) {
                    return;
                }
                ContainerUtil.filter((Collection)ContainerUtil.union((Collection)requireDevProperties, (Collection)requireProperties), i -> intersection.contains(i.getName())).forEach(this::markProblem);
            }

            private void markProblem(@NotNull JsonProperty property) {
                if (property == null) {
                    1.$$$reportNull$$$0(1);
                }
                holder.registerProblem((PsiElement)property.getNameElement(), PhpBundle.message("inspection.json.duplicated.packages.0", property.getName()), new LocalQuickFix[]{RemoveRequireDevDuplicateQuickFix.INSTANCE});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "property";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/composer/json/PhpComposerDuplicatedRequirementInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitObject";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "markProblem";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/json/PhpComposerDuplicatedRequirementInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/json/PhpComposerDuplicatedRequirementInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static class RemoveRequireDevDuplicateQuickFix
    extends PsiUpdateModCommandQuickFix {
        static RemoveRequireDevDuplicateQuickFix INSTANCE = new RemoveRequireDevDuplicateQuickFix();

        private RemoveRequireDevDuplicateQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("inspection.json.duplicated.packages.fix", new Object[0]);
            if (string == null) {
                RemoveRequireDevDuplicateQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement psiElement, @NotNull ModPsiUpdater updater) {
            JsonProperty duplicate;
            JsonObject requireDevSection;
            JsonProperty element;
            JsonObject topLevelObject;
            if (project == null) {
                RemoveRequireDevDuplicateQuickFix.$$$reportNull$$$0(1);
            }
            if (psiElement == null) {
                RemoveRequireDevDuplicateQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                RemoveRequireDevDuplicateQuickFix.$$$reportNull$$$0(3);
            }
            if ((topLevelObject = JsonUtil.getTopLevelObject((JsonFile)((JsonFile)(element = (JsonProperty)psiElement.getParent()).getContainingFile()))) != null && (requireDevSection = (JsonObject)JsonUtil.getPropertyValueOfType((JsonObject)topLevelObject, (String)"require-dev", JsonObject.class)) != null && (duplicate = requireDevSection.findProperty(element.getName())) != null) {
                PsiElement forward = PsiTreeUtil.skipWhitespacesForward((PsiElement)duplicate);
                PsiElement backward = PsiTreeUtil.skipWhitespacesBackward((PsiElement)duplicate);
                duplicate.delete();
                if (RemoveRequireDevDuplicateQuickFix.isComma(forward)) {
                    forward.delete();
                } else if (RemoveRequireDevDuplicateQuickFix.isComma(backward)) {
                    backward.delete();
                }
            }
        }

        private static boolean isComma(PsiElement forward) {
            return forward instanceof LeafPsiElement && ((LeafPsiElement)forward).getElementType() == JsonElementTypes.COMMA;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/composer/json/PhpComposerDuplicatedRequirementInspection$RemoveRequireDevDuplicateQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/composer/json/PhpComposerDuplicatedRequirementInspection$RemoveRequireDevDuplicateQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

