/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.json;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.LiveTemplateWeigher;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.json.codeinsight.JsonStringPropertyInsertHandler;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonReferenceExpression;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.completion.PhpCompletionContributor;
import com.jetbrains.php.completion.PhpCompletionUtil;
import com.jetbrains.php.completion.PhpLookupElement;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.addDependency.ComposerPackage;
import com.jetbrains.php.composer.addDependency.ComposerPackagesUtil;
import com.jetbrains.php.composer.json.PhpComposerJsonUtils;
import com.jetbrains.php.composer.json.cache.ComposerPackagesCache;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurableForm;
import com.jetbrains.php.config.library.PhpRuntimeLibraryRootsProvider;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.util.PhpStringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpComposerJsonCompletionContributor
extends CompletionContributor
implements DumbAware {
    @NonNls
    private static final String PHP = "php";
    @NonNls
    private static final String EXT = "ext-";
    private static final PatternCondition<PsiElement> INSIDE_COMPOSER_JSON = new PatternCondition<PsiElement>("inside composer.json"){

        public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            return PhpComposerJsonUtils.insideComposerJson(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/composer/json/PhpComposerJsonCompletionContributor$1", "accepts"));
        }
    };
    private static final Logger LOG = Logger.getInstance(PhpComposerJsonCompletionContributor.class);
    private static final PatternCondition<JsonStringLiteral> PROPERTY_KEY_INSIDE_REPOSITORIES_SECTION = new PatternCondition<JsonStringLiteral>("Property key inside repositories section"){

        public boolean accepts(@NotNull JsonStringLiteral element, ProcessingContext context) {
            PsiElement parent;
            if (element == null) {
                2.$$$reportNull$$$0(0);
            }
            if ((parent = element.getParent()) instanceof JsonProperty && !JsonPsiUtil.isPropertyKey((PsiElement)element)) {
                return false;
            }
            JsonObject propertyObject = (JsonObject)ObjectUtils.tryCast((Object)parent.getParent(), JsonObject.class);
            if (propertyObject == null) {
                return false;
            }
            PsiElement objectParent = propertyObject.getParent();
            return PhpComposerJsonCompletionContributor.isRepositoriesSection(objectParent) || objectParent instanceof JsonArray && PhpComposerJsonCompletionContributor.isRepositoriesSection(objectParent.getParent());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/composer/json/PhpComposerJsonCompletionContributor$2", "accepts"));
        }
    };

    private static boolean isRepositoriesSection(PsiElement object) {
        return object instanceof JsonProperty && "repositories".equals(((JsonProperty)object).getName());
    }

    public PhpComposerJsonCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(JsonStringLiteral.class)).with(INSIDE_COMPOSER_JSON), new PhpStringLiteralClassesCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(JsonStringLiteral.class).with(PROPERTY_KEY_INSIDE_REPOSITORIES_SECTION))).with(INSIDE_COMPOSER_JSON), new PhpPackagistOrgDisabledRepositoryCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(JsonStringLiteral.class)).with(INSIDE_COMPOSER_JSON), new PhpComposerPackagesProvider(true));
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(JsonReferenceExpression.class)).with(INSIDE_COMPOSER_JSON), new PhpComposerPackagesProvider(false));
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(JsonStringLiteral.class)).with(INSIDE_COMPOSER_JSON), new PhpComposerPackageVersionsProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(JsonStringLiteral.class)).with((PatternCondition)new PatternCondition<PsiElement>("inside composer.json"){

            public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                PsiElement parent = element.getParent();
                return PhpComposerJsonUtils.insideLicenseSection(element) && (JsonPsiUtil.isPropertyValue((PsiElement)parent) || JsonPsiUtil.isPropertyValue((PsiElement)parent.getParent()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/composer/json/PhpComposerJsonCompletionContributor$3", "accepts"));
            }
        }), new PhpLicenseProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(JsonStringLiteral.class)).with((PatternCondition)new PatternCondition<PsiElement>("inside composer.json"){

            public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
                if (element == null) {
                    4.$$$reportNull$$$0(0);
                }
                PsiElement parent = element.getParent();
                return PhpComposerJsonUtils.insideStabilitySection(element) && (JsonPsiUtil.isPropertyValue((PsiElement)parent) || JsonPsiUtil.isPropertyValue((PsiElement)parent.getParent()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/composer/json/PhpComposerJsonCompletionContributor$4", "accepts"));
            }
        }), new PhpStabilityProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(JsonStringLiteral.class)).with((PatternCondition)new PatternCondition<PsiElement>("inside composer.json"){

            public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
                if (element == null) {
                    5.$$$reportNull$$$0(0);
                }
                return PhpComposerJsonUtils.insideScriptsSection(element) && PhpComposerJsonUtils.insidePropertyKey(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/composer/json/PhpComposerJsonCompletionContributor$5", "accepts"));
            }
        }), new PhpComposerEventNamesCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(JsonStringLiteral.class)).with((PatternCondition)new PatternCondition<PsiElement>("inside composer.json"){

            public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
                if (element == null) {
                    6.$$$reportNull$$$0(0);
                }
                return PhpComposerJsonUtils.insideScriptsSection(element) && !PhpComposerJsonUtils.insidePropertyKey(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/composer/json/PhpComposerJsonCompletionContributor$6", "accepts"));
            }
        }), new PhpScriptsReferencesCompletionProvider());
    }

    private static class PhpStringLiteralClassesCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private static final String SEPARATOR = "::";
        private static final String SCRIPTS_SECTION = "scripts";
        @NonNls
        private static final Set<String> AUTOLOAD_SECTIONS = ContainerUtil.newHashSet((Object[])new String[]{"autoload", "autoload-dev"});
        private static final InsertHandler<LookupElement> NAMESPACE_HANDLER = (context, item) -> {
            String resultString = PhpStringUtil.escapeText(item.getLookupString().replace("\\\\", "\\"), false);
            PsiElement elementAtOffset = PsiUtilCore.getElementAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset());
            context.getDocument().replaceString(elementAtOffset.getTextOffset() + 1, context.getTailOffset(), (CharSequence)resultString);
            context.getEditor().getCaretModel().moveToOffset(context.getTailOffset());
        };

        private PhpStringLiteralClassesCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(2);
            }
            PsiElement position = parameters.getPosition().getOriginalElement();
            JsonProperty scripts = PhpPsiUtil.getParentOfClass(PsiTreeUtil.getParentOfType((PsiElement)position, JsonProperty.class), JsonProperty.class);
            JsonProperty autoload = PhpPsiUtil.getParentOfClass((PsiElement)scripts, JsonProperty.class);
            if (scripts != null && scripts.getName().equals(SCRIPTS_SECTION) || autoload != null && AUTOLOAD_SECTIONS.contains(autoload.getName()) && PhpComposerJsonUtils.insidePropertyKey(position)) {
                boolean showClass = !result.getPrefixMatcher().getPrefix().endsWith(SEPARATOR);
                result = PhpCompletionContributor.PhpStringLiteralClassesCompletionProvider.patchPrefixMatcher(result, position);
                String prefixWithoutEscaping = PhpStringUtil.unescapeText(result.getPrefixMatcher().getPrefix(), false);
                String namespace = PhpCompletionContributor.PhpStringLiteralClassesCompletionProvider.getNamespace(prefixWithoutEscaping);
                PhpIndex phpIndex = PhpIndex.getInstance(position.getProject());
                if (autoload != null && AUTOLOAD_SECTIONS.contains(autoload.getName())) {
                    CompletionSorter sorter = CompletionSorter.emptySorter().weigh((LookupElementWeigher)new LiveTemplateWeigher()).weigh(new LookupElementWeigher("prefer top-level namespaces"){

                        @NotNull
                        public Integer weigh(@NotNull LookupElement element) {
                            if (element == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            Integer n = StringUtil.countChars((CharSequence)element.getLookupString(), (char)'\\');
                            if (n == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return n;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[switch (n) {
                                default -> 3;
                                case 1 -> 2;
                            }];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "element";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/jetbrains/php/composer/json/PhpComposerJsonCompletionContributor$PhpStringLiteralClassesCompletionProvider$1";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/jetbrains/php/composer/json/PhpComposerJsonCompletionContributor$PhpStringLiteralClassesCompletionProvider$1";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "weigh";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "weigh";
                                    break;
                                }
                                case 1: {
                                    break;
                                }
                            }
                            String string = String.format(v0, objectArray);
                            throw switch (n) {
                                default -> new IllegalArgumentException(string);
                                case 1 -> new IllegalStateException(string);
                            };
                        }
                    });
                    result = result.withRelevanceSorter(sorter);
                }
                if (!PhpComposerJsonUtils.insideScriptsSection(position) || !PhpComposerJsonUtils.insidePropertyKey(position)) {
                    PhpStringLiteralClassesCompletionProvider.addMatchedSubNamespaces(result.getPrefixMatcher(), namespace, result, phpIndex, autoload != null && AUTOLOAD_SECTIONS.contains(autoload.getName()));
                }
                if (scripts.getName().equals(SCRIPTS_SECTION) && !PhpComposerJsonUtils.insidePropertyKey(position)) {
                    PhpStringLiteralClassesCompletionProvider.addMatchedPhpClasses(result.getPrefixMatcher(), namespace, result, phpIndex, PhpLangUtil.toShortName(prefixWithoutEscaping), showClass);
                }
            }
        }

        public static void addMatchedSubNamespaces(@NotNull PrefixMatcher prefixMatcher, @NotNull String namespace, @NotNull CompletionResultSet result, @NotNull PhpIndex phpIndex, boolean showPartial) {
            if (prefixMatcher == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(3);
            }
            if (namespace == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(4);
            }
            if (result == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(5);
            }
            if (phpIndex == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(6);
            }
            for (String i : PhpCompletionUtil.getAllChildNamespaceNames(phpIndex, namespace)) {
                String fqn = PhpLangUtil.toFQN(i);
                if (fqn.startsWith("\\___PHPSTORM_HELPERS")) continue;
                for (PhpNamespace phpNamespace : phpIndex.getNamespacesByName(fqn)) {
                    if (ContainerUtil.exists(PhpRuntimeLibraryRootsProvider.getLibraryRoots(phpNamespace.getProject()), ns -> VfsUtilCore.isAncestor((VirtualFile)ns, (VirtualFile)phpNamespace.getContainingFile().getVirtualFile(), (boolean)false))) continue;
                    PhpLookupElement element = new PhpLookupElement(phpNamespace);
                    element.lookupString = PhpCompletionContributor.PhpStringLiteralClassesCompletionProvider.adjustNamespaceToPrefix(phpNamespace.getFQN(), prefixMatcher.getPrefix());
                    element.handler = NAMESPACE_HANDLER;
                    result.addElement((LookupElement)element);
                    if (!showPartial) continue;
                    String parentNamespaceName = phpNamespace.getParentNamespaceName();
                    while (!PhpLangUtil.isGlobalNamespaceFQN(parentNamespaceName)) {
                        String toFQN = PhpLangUtil.toFQN(StringUtil.trimTrailing((String)parentNamespaceName, (char)'\\'));
                        if (phpIndex.getNamespacesByName(toFQN).isEmpty()) {
                            String adjustNamespaceToPrefix = PhpCompletionContributor.PhpStringLiteralClassesCompletionProvider.adjustNamespaceToPrefix(toFQN, prefixMatcher.getPrefix());
                            result.addElement(LookupElementBuilder.create((String)adjustNamespaceToPrefix).withLookupString(adjustNamespaceToPrefix).withIcon(PhpIcons.NAMESPACE).withInsertHandler(NAMESPACE_HANDLER).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE));
                        }
                        parentNamespaceName = PhpLangUtil.getParentNamespaceFQN(toFQN);
                    }
                }
            }
        }

        private static void addMatchedPhpClasses(@NotNull PrefixMatcher prefixMatcher, @NotNull String namespace, @NotNull CompletionResultSet result, @NotNull PhpIndex phpIndex, @NotNull String classPrefix, boolean showClass) {
            if (prefixMatcher == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(7);
            }
            if (namespace == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(8);
            }
            if (result == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(9);
            }
            if (phpIndex == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(10);
            }
            if (classPrefix == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(11);
            }
            PhpCompletionUtil.addClasses(phpIndex, prefixMatcher.cloneWithPrefix(classPrefix.contains(SEPARATOR) ? StringUtil.notNullize((String)StringUtil.substringBefore((String)classPrefix, (String)SEPARATOR)) : classPrefix), aClass1 -> (PhpCompletionUtil.hasNamespace(namespace, true, aClass1) || !prefixMatcher.getPrefix().contains("\\")) && !aClass1.getFQN().startsWith("\\___PHPSTORM_HELPERS"), aClass -> PhpStringLiteralClassesCompletionProvider.addElement(prefixMatcher, namespace, result, aClass, showClass));
        }

        public static void addElement(@NotNull PrefixMatcher prefixMatcher, @NotNull String namespace, @NotNull CompletionResultSet result, final PhpNamedElement namedElement, boolean showClass) {
            List staticMethods;
            if (prefixMatcher == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(12);
            }
            if (namespace == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(13);
            }
            if (result == null) {
                PhpStringLiteralClassesCompletionProvider.$$$reportNull$$$0(14);
            }
            if ((staticMethods = ContainerUtil.filter(((PhpClass)namedElement.getOriginalElement()).getMethods(), i -> i.isStatic() && !PhpLangUtil.isMagicMethod(i.getNameCS()))).size() > 0) {
                if (ContainerUtil.exists(PhpRuntimeLibraryRootsProvider.getLibraryRoots(namedElement.getProject()), i -> VfsUtilCore.isAncestor((VirtualFile)i, (VirtualFile)namedElement.getOriginalElement().getContainingFile().getVirtualFile(), (boolean)false))) {
                    return;
                }
                final PhpLookupElement element = new PhpLookupElement(namedElement);
                element.lookupString = PhpCompletionContributor.PhpStringLiteralClassesCompletionProvider.adjustNamespaceToPrefix(namedElement.getNamespaceName(), prefixMatcher.getPrefix()) + namedElement.getName();
                element.handler = ComposerJsonClassInsertHandler.INSTANCE;
                if (showClass) {
                    result.addElement((LookupElement)element);
                }
                for (final Method method : staticMethods) {
                    PhpLookupElement lookupElement = new PhpLookupElement(method){

                        @Override
                        public void renderElement(@NotNull LookupElementPresentation presentation) {
                            if (presentation == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            super.renderElement(presentation);
                            this.tailText = element.tailText;
                            presentation.setItemText(namedElement.getName() + PhpStringLiteralClassesCompletionProvider.SEPARATOR + method.getName());
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/jetbrains/php/composer/json/PhpComposerJsonCompletionContributor$PhpStringLiteralClassesCompletionProvider$2", "renderElement"));
                        }
                    };
                    lookupElement.lookupString = element.lookupString + SEPARATOR + method.getName();
                    lookupElement.handler = ComposerJsonClassInsertHandler.INSTANCE;
                    result.addElement((LookupElement)lookupElement);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 5: 
                case 9: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: 
                case 7: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefixMatcher";
                    break;
                }
                case 4: 
                case 8: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phpIndex";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classPrefix";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/composer/json/PhpComposerJsonCompletionContributor$PhpStringLiteralClassesCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletions";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addMatchedSubNamespaces";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addMatchedPhpClasses";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static final class ComposerJsonClassInsertHandler
        implements InsertHandler<PhpLookupElement> {
            private static final ComposerJsonClassInsertHandler INSTANCE = new ComposerJsonClassInsertHandler();

            private ComposerJsonClassInsertHandler() {
            }

            public void handleInsert(@NotNull InsertionContext context, @NotNull PhpLookupElement item) {
                PhpNamedElement element;
                if (context == null) {
                    ComposerJsonClassInsertHandler.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    ComposerJsonClassInsertHandler.$$$reportNull$$$0(1);
                }
                if ((element = item.getNamedElement()) != null) {
                    String resultString = (item.lookupString.startsWith("\\") ? element.getFQN() : PhpLangUtil.toPresentableFQN(element.getFQN())).replace("\\", "\\\\");
                    resultString = resultString.replace(".", PhpStringLiteralClassesCompletionProvider.SEPARATOR);
                    context.getDocument().replaceString(PsiUtilCore.getElementAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset()).getTextOffset() + 1, context.getTailOffset(), (CharSequence)resultString);
                    context.getEditor().getCaretModel().moveToOffset(context.getTailOffset());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/composer/json/PhpComposerJsonCompletionContributor$PhpStringLiteralClassesCompletionProvider$ComposerJsonClassInsertHandler";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class PhpPackagistOrgDisabledRepositoryCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private static final String PACKAGIST_DISABLED_PROPERTY_TEXT = "\"packagist.org\":false";

        private PhpPackagistOrgDisabledRepositoryCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                PhpPackagistOrgDisabledRepositoryCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpPackagistOrgDisabledRepositoryCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpPackagistOrgDisabledRepositoryCompletionProvider.$$$reportNull$$$0(2);
            }
            result.addElement((LookupElement)LookupElementBuilder.create((String)"packagist.org").withInsertHandler((InsertHandler)PhpPackagistDisabledInsertHandler.INSTANCE));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/composer/json/PhpComposerJsonCompletionContributor$PhpPackagistOrgDisabledRepositoryCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class PhpPackagistDisabledInsertHandler
        implements InsertHandler<LookupElement> {
            private static final PhpPackagistDisabledInsertHandler INSTANCE = new PhpPackagistDisabledInsertHandler();

            private PhpPackagistDisabledInsertHandler() {
            }

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                PsiElement element;
                JsonStringLiteral literal;
                if (context == null) {
                    PhpPackagistDisabledInsertHandler.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    PhpPackagistDisabledInsertHandler.$$$reportNull$$$0(1);
                }
                if ((literal = PhpPsiUtil.getParentOfClass(element = context.getFile().findElementAt(context.getStartOffset()), false, JsonStringLiteral.class)) == null) {
                    return;
                }
                JsonProperty property = (JsonProperty)ObjectUtils.tryCast((Object)literal.getParent(), JsonProperty.class);
                if (property == null) {
                    return;
                }
                if (property.getValue() == null) {
                    TextRange propertyTextRange = property.getTextRange();
                    context.getDocument().replaceString(propertyTextRange.getStartOffset(), propertyTextRange.getEndOffset(), (CharSequence)PhpPackagistOrgDisabledRepositoryCompletionProvider.PACKAGIST_DISABLED_PROPERTY_TEXT);
                    int endOffsetNewProperty = propertyTextRange.getStartOffset() + PhpPackagistOrgDisabledRepositoryCompletionProvider.PACKAGIST_DISABLED_PROPERTY_TEXT.length();
                    context.getEditor().getCaretModel().moveToOffset(endOffsetNewProperty);
                    PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getDocument());
                    CodeStyleManager.getInstance((Project)context.getProject()).reformatText(context.getFile(), propertyTextRange.getStartOffset(), endOffsetNewProperty);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/composer/json/PhpComposerJsonCompletionContributor$PhpPackagistOrgDisabledRepositoryCompletionProvider$PhpPackagistDisabledInsertHandler";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static class PhpComposerPackagesProvider
    extends CompletionProvider<CompletionParameters> {
        private final boolean myInsideStringLiteral;

        public PhpComposerPackagesProvider(boolean insideStringLiteral) {
            this.myInsideStringLiteral = insideStringLiteral;
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement psiElement;
            if (parameters == null) {
                PhpComposerPackagesProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpComposerPackagesProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpComposerPackagesProvider.$$$reportNull$$$0(2);
            }
            if (JsonPsiUtil.isPropertyValue((PsiElement)(psiElement = parameters.getPosition()).getParent())) {
                return;
            }
            if (PhpComposerJsonUtils.insidePackagesSection(parameters.getOriginalPosition())) {
                ArrayList<String> packages = new ArrayList<String>(ComposerPackagesCache.getPackageNames());
                packages.addAll(ContainerUtil.map(PhpProjectConfigurableForm.getExtensionToCategory().keySet(), element -> PhpComposerJsonCompletionContributor.EXT + StringUtil.toLowerCase((String)element)));
                packages.add(PhpComposerJsonCompletionContributor.PHP);
                packages.stream().map(packageName -> !this.myInsideStringLiteral ? "\"" + packageName + "\"" : packageName).forEach(packageName -> result.addElement(LookupElementBuilder.create((Object)new ComposerPackage((String)packageName), (String)packageName).withInsertHandler((InsertHandler)new JsonStringPropertyInsertHandler(StringUtil.unquoteString((String)packageName))).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE)));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/composer/json/PhpComposerJsonCompletionContributor$PhpComposerPackagesProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PhpComposerPackageVersionsProvider
    extends CompletionProvider<CompletionParameters> {
        private static final Map<String, List<String>> ourVersionCache = CollectionFactory.createConcurrentSoftMap();
        public static final String STAR = "*";
        private static final Pattern DEV_SUFFIX = Pattern.compile("(.x)?-dev$");
        private static Set<String> BEFORE_SIGNS = Set.of("~", "^", ">=");

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement psiElement;
            if (parameters == null) {
                PhpComposerPackageVersionsProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpComposerPackageVersionsProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpComposerPackageVersionsProvider.$$$reportNull$$$0(2);
            }
            if ((psiElement = parameters.getOriginalPosition()) != null && JsonPsiUtil.isPropertyKey((PsiElement)psiElement.getParent())) {
                return;
            }
            JsonProperty packageEntry = PhpPsiUtil.getParentOfClass(psiElement, JsonProperty.class);
            if (packageEntry != null && PhpComposerJsonUtils.insidePackagesSection(psiElement)) {
                result = PhpComposerPackageVersionsProvider.adjustPrefixIfRange(result);
                result = PhpComposerPackageVersionsProvider.addSorter(result);
                PhpComposerPackageVersionsProvider.addBeforeSigns(result);
                PhpComposerPackageVersionsProvider.addWildCardVersions(result);
                result = PhpComposerPackageVersionsProvider.adjustPrefixIfSignificantRelease(result);
                PhpComposerPackageVersionsProvider.addPackageVersions(result, psiElement, packageEntry);
            }
        }

        private static void addPackageVersions(@NotNull CompletionResultSet result, PsiElement psiElement, JsonProperty packageEntry) {
            if (result == null) {
                PhpComposerPackageVersionsProvider.$$$reportNull$$$0(3);
            }
            ArrayList<String> versions = new ArrayList<String>();
            if (packageEntry.getName().startsWith(PhpComposerJsonCompletionContributor.EXT) && !packageEntry.getName().contains("/")) {
                versions.add(STAR);
            } else {
                List<String> versionConstrains = Arrays.asList("@stable", "@dev");
                versions.addAll(versionConstrains);
                if (packageEntry.getName().equalsIgnoreCase(PhpComposerJsonCompletionContributor.PHP)) {
                    versions.addAll(ContainerUtil.map((Object[])PhpLanguageLevel.values(), PhpLanguageLevel::getPresentableName));
                } else {
                    PhpComposerPackageVersionsProvider.fetchPackageVersions(packageEntry.getName(), psiElement.getProject(), psiElement.getContainingFile().getVirtualFile(), result);
                }
            }
            PhpComposerPackageVersionsProvider.addResults(versions, result);
        }

        private static void addWildCardVersions(@NotNull CompletionResultSet result) {
            String prefix;
            if (result == null) {
                PhpComposerPackageVersionsProvider.$$$reportNull$$$0(4);
            }
            if (!((prefix = result.getPrefixMatcher().getPrefix()).isEmpty() || prefix.contains(STAR) || StringUtil.containsAlphaCharacters((String)prefix))) {
                if (!ContainerUtil.exists(BEFORE_SIGNS, prefix::startsWith)) {
                    PhpComposerPackageVersionsProvider.addResults(Collections.singletonList(prefix.endsWith(".") ? prefix + STAR : prefix + ".*"), result);
                }
            }
        }

        @NotNull
        private static CompletionResultSet addSorter(@NotNull CompletionResultSet result) {
            if (result == null) {
                PhpComposerPackageVersionsProvider.$$$reportNull$$$0(5);
            }
            CompletionSorter sorter = CompletionSorter.emptySorter().weigh((LookupElementWeigher)new LiveTemplateWeigher()).weigh(new LookupElementWeigher("prefer new versions"){

                public Integer weigh(@NotNull LookupElement element) {
                    String normalizedVersion;
                    Object object;
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String version = (object = element.getObject()) instanceof String ? (normalizedVersion = (String)object) : element.getLookupString();
                    List parts1 = StringUtil.split((String)version, (String)".");
                    int power = 1;
                    int result = 0;
                    for (int i = Math.min(parts1.size() - 1, 2); i >= 0; --i) {
                        result += StringUtil.parseInt((String)((String)parts1.get(i)), (int)0) * power;
                        power *= 100;
                    }
                    return -result;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/composer/json/PhpComposerJsonCompletionContributor$PhpComposerPackageVersionsProvider$1", "weigh"));
                }
            });
            CompletionResultSet completionResultSet = result = result.withRelevanceSorter(sorter);
            if (completionResultSet == null) {
                PhpComposerPackageVersionsProvider.$$$reportNull$$$0(6);
            }
            return completionResultSet;
        }

        private static void addBeforeSigns(@NotNull CompletionResultSet result) {
            if (result == null) {
                PhpComposerPackageVersionsProvider.$$$reportNull$$$0(7);
            }
            final String prefix = result.getPrefixMatcher().getPrefix();
            if (!(ContainerUtil.exists(BEFORE_SIGNS, prefix::startsWith) || prefix.contains(STAR) || StringUtil.containsAlphaCharacters((String)prefix))) {
                result.addAllElements((Iterable)ContainerUtil.map(BEFORE_SIGNS, i -> LookupElementBuilder.create((Object)(i + prefix), (String)(i + StringUtil.trimEnd((String)prefix, (String)"."))).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                        if (context == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (item == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        if (prefix.isEmpty()) {
                            AutoPopupController.getInstance((Project)context.getProject()).autoPopupMemberLookup(context.getEditor(), null);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "context";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "item";
                                break;
                            }
                        }
                        objectArray[1] = "com/jetbrains/php/composer/json/PhpComposerJsonCompletionContributor$PhpComposerPackageVersionsProvider$2";
                        objectArray[2] = "handleInsert";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }).withAutoCompletionPolicy(AutoCompletionPolicy.ALWAYS_AUTOCOMPLETE)));
            }
        }

        @NotNull
        private static CompletionResultSet adjustPrefixIfRange(@NotNull CompletionResultSet result) {
            if (result == null) {
                PhpComposerPackageVersionsProvider.$$$reportNull$$$0(8);
            }
            List<String> versionSplitters = Arrays.asList(" ", ",", "|", "-");
            for (String splitter : versionSplitters) {
                String newPrefix;
                String currentPrefix = result.getPrefixMatcher().getPrefix();
                if (!currentPrefix.contains(splitter) || (newPrefix = StringUtil.substringAfterLast((String)currentPrefix, (String)splitter)) == null) continue;
                result = result.withPrefixMatcher(newPrefix);
            }
            CompletionResultSet completionResultSet = result;
            if (completionResultSet == null) {
                PhpComposerPackageVersionsProvider.$$$reportNull$$$0(9);
            }
            return completionResultSet;
        }

        @NotNull
        private static CompletionResultSet adjustPrefixIfSignificantRelease(@NotNull CompletionResultSet result) {
            if (result == null) {
                PhpComposerPackageVersionsProvider.$$$reportNull$$$0(10);
            }
            String prefix = result.getPrefixMatcher().getPrefix();
            String startPrefix = (String)ContainerUtil.find(BEFORE_SIGNS, prefix::startsWith);
            if (startPrefix != null) {
                result = result.withPrefixMatcher(StringUtil.trimStart((String)prefix, (String)startPrefix));
            }
            CompletionResultSet completionResultSet = result;
            if (completionResultSet == null) {
                PhpComposerPackageVersionsProvider.$$$reportNull$$$0(11);
            }
            return completionResultSet;
        }

        private static void addResults(List<String> versions, @NotNull CompletionResultSet result) {
            if (result == null) {
                PhpComposerPackageVersionsProvider.$$$reportNull$$$0(12);
            }
            List normalizedVersions = ContainerUtil.map(versions, v -> PhpComposerPackageVersionsProvider.normalizeVersion(v));
            result.addAllElements((Iterable)StreamEx.zip(versions, (List)normalizedVersions, (ver, normVer) -> LookupElementBuilder.create((Object)normVer, (String)ver).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE)));
        }

        @NotNull
        public static List<String> fetchPackageVersions(@NotNull String packageName) {
            List list;
            if (packageName == null) {
                PhpComposerPackageVersionsProvider.$$$reportNull$$$0(13);
            }
            try {
                list = (List)ApplicationUtil.runWithCheckCanceled(() -> {
                    if (ComposerPackagesCache.getPackageNames().contains(packageName)) {
                        return ComposerPackagesUtil.getPackagistPackage(packageName).getVersions();
                    }
                    return Collections.emptyList();
                }, (ProgressIndicator)EmptyProgressIndicator.notNullize((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator()));
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                List<String> list2 = Collections.emptyList();
                if (list2 == null) {
                    PhpComposerPackageVersionsProvider.$$$reportNull$$$0(15);
                }
                return list2;
            }
            if (list == null) {
                PhpComposerPackageVersionsProvider.$$$reportNull$$$0(14);
            }
            return list;
        }

        public static void fetchPackageVersions(@NotNull String packageName, @Nullable Project project, @Nullable VirtualFile config, CompletionResultSet result) {
            if (packageName == null) {
                PhpComposerPackageVersionsProvider.$$$reportNull$$$0(16);
            }
            ProgressIndicator indicator = EmptyProgressIndicator.notNullize((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator());
            if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                PhpComposerPackageVersionsProvider.addPackagistVersions(packageName, result, indicator);
                PhpComposerPackageVersionsProvider.addCustomVersions(packageName, project, config, result, ComposerConfigUtils.customRepos(config), indicator);
            } else {
                PhpComposerPackageVersionsProvider.addResults(PhpComposerPackageVersionsProvider.getVersions(packageName, project, indicator), result);
            }
        }

        @NotNull
        public static String normalizeVersion(@NotNull String v) {
            if (v == null) {
                PhpComposerPackageVersionsProvider.$$$reportNull$$$0(17);
            }
            String string = DEV_SUFFIX.matcher(StringUtil.trimStart((String)v, (String)"v")).replaceFirst(".99");
            if (string == null) {
                PhpComposerPackageVersionsProvider.$$$reportNull$$$0(18);
            }
            return string;
        }

        private static void addCustomVersions(@NotNull String packageName, @Nullable Project project, @Nullable VirtualFile config, CompletionResultSet result, boolean customRepos, ProgressIndicator indicator) {
            List<String> cached;
            if (packageName == null) {
                PhpComposerPackageVersionsProvider.$$$reportNull$$$0(19);
            }
            if ((cached = ourVersionCache.get(packageName)) != null) {
                PhpComposerPackageVersionsProvider.addResults(cached, result);
                return;
            }
            try {
                Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    if (project != null && config != null && customRepos) {
                        return PhpComposerPackageVersionsProvider.getVersions(packageName, project, indicator);
                    }
                    return Collections.emptyList();
                });
                while (true) {
                    try {
                        List versions = (List)future.get(100L, TimeUnit.MILLISECONDS);
                        ourVersionCache.put(packageName, versions);
                        if (versions != null) {
                            PhpComposerPackageVersionsProvider.addResults(versions, result);
                            return;
                        }
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ProgressManager.checkCanceled();
                }
            }
            catch (Exception exception) {
                return;
            }
        }

        private static void addPackagistVersions(@NotNull String packageName, CompletionResultSet result, ProgressIndicator indicator) {
            if (packageName == null) {
                PhpComposerPackageVersionsProvider.$$$reportNull$$$0(20);
            }
            try {
                PhpComposerPackageVersionsProvider.addResults((List)ApplicationUtil.runWithCheckCanceled(() -> ComposerPackagesCache.getPackageNames().contains(packageName) ? ComposerPackagesUtil.getPackagistPackage(packageName).getVersions() : Collections.emptyList(), (ProgressIndicator)indicator), result);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private static List<String> getVersions(@NotNull String packageName, @Nullable Project project, ProgressIndicator indicator) {
            if (packageName == null) {
                PhpComposerPackageVersionsProvider.$$$reportNull$$$0(21);
            }
            try {
                ComposerPackage aPackage = ComposerPackagesUtil.getComposerPackage(packageName, project, ComposerPackagesCache.getValidComposerJson(), indicator);
                return aPackage != null ? aPackage.getVersions() : Collections.emptyList();
            }
            catch (IOException e) {
                return Collections.emptyList();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 9, 11, 14, 15, 18 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 6: 
                case 9: 
                case 11: 
                case 14: 
                case 15: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/composer/json/PhpComposerJsonCompletionContributor$PhpComposerPackageVersionsProvider";
                    break;
                }
                case 13: 
                case 16: 
                case 19: 
                case 20: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/composer/json/PhpComposerJsonCompletionContributor$PhpComposerPackageVersionsProvider";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addSorter";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "adjustPrefixIfRange";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "adjustPrefixIfSignificantRelease";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fetchPackageVersions";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "normalizeVersion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addCompletions";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addPackageVersions";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addWildCardVersions";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addSorter";
                    break;
                }
                case 6: 
                case 9: 
                case 11: 
                case 14: 
                case 15: 
                case 18: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addBeforeSigns";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "adjustPrefixIfRange";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "adjustPrefixIfSignificantRelease";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "addResults";
                    break;
                }
                case 13: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "fetchPackageVersions";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "normalizeVersion";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "addCustomVersions";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "addPackagistVersions";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "getVersions";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 9, 11, 14, 15, 18 -> new IllegalStateException(string);
            };
        }
    }

    public static class PhpLicenseProvider
    extends CompletionProvider<CompletionParameters> {
        @NonNls
        private static final List<String> LICENSES = new SmartList((Object[])new String[]{"MIT", "BSD-3-Clause", "JSON", "GPL-2.0-only", "GPL-2.0-or-later", "OSL-3.0", "AFL-3.0", "OpenSSL", "Apache-2.0", "curl", "DOC", "LGPL-2.0-only", "LGPL-2.0-or-later", "LGPL-2.1-only", "LGPL-2.1-or-later", "BSD-2-Clause", "GPL-3.0-only", "GPL-3.0-or-later", "Zlib", "ICU", "LGPL-3.0-only", "LGPL-3.0-or-later", "MPL-1.0", "MPL-1.1", "ISC", "proprietary"});

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                PhpLicenseProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpLicenseProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpLicenseProvider.$$$reportNull$$$0(2);
            }
            LICENSES.forEach(version -> result.addElement(LookupElementBuilder.create((String)version).withAutoCompletionPolicy(AutoCompletionPolicy.ALWAYS_AUTOCOMPLETE)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/composer/json/PhpComposerJsonCompletionContributor$PhpLicenseProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PhpStabilityProvider
    extends CompletionProvider<CompletionParameters> {
        @NonNls
        private static final List<String> STABILITIES = new SmartList((Object[])new String[]{"dev", "alpha", "beta", "RC", "stable"});

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                PhpStabilityProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpStabilityProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpStabilityProvider.$$$reportNull$$$0(2);
            }
            STABILITIES.forEach(version -> result.addElement(LookupElementBuilder.create((String)version).withAutoCompletionPolicy(AutoCompletionPolicy.ALWAYS_AUTOCOMPLETE)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/composer/json/PhpComposerJsonCompletionContributor$PhpStabilityProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class PhpComposerEventNamesCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        @NonNls
        static final List<String> EVENTS_NAMES = new SmartList((Object[])new String[]{"pre-archive-cmd", "post-archive-cmd", "pre-dependencies-solving", "post-dependencies-solving", "init", "command", "pre-file-download", "pre-command-run"});

        PhpComposerEventNamesCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                PhpComposerEventNamesCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpComposerEventNamesCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpComposerEventNamesCompletionProvider.$$$reportNull$$$0(2);
            }
            EVENTS_NAMES.forEach(version -> result.addElement(LookupElementBuilder.create((String)version).withIcon(IconManager.getInstance().getPlatformIcon(PlatformIcons.Property)).withInsertHandler((InsertHandler)new JsonStringPropertyInsertHandler(version)).withAutoCompletionPolicy(AutoCompletionPolicy.ALWAYS_AUTOCOMPLETE)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/composer/json/PhpComposerJsonCompletionContributor$PhpComposerEventNamesCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpScriptsReferencesCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        @NonNls
        static final List<String> BASE_REFS = new SmartList((Object[])new String[]{"@php", "@composer", "@putenv"});

        private PhpScriptsReferencesCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                PhpScriptsReferencesCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpScriptsReferencesCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpScriptsReferencesCompletionProvider.$$$reportNull$$$0(2);
            }
            JsonProperty property = PhpPsiUtil.getParentOfClass(parameters.getOriginalPosition(), JsonProperty.class);
            BASE_REFS.forEach(ref -> result.addElement(LookupElementBuilder.create((String)ref).withAutoCompletionPolicy(AutoCompletionPolicy.ALWAYS_AUTOCOMPLETE)));
            JsonPsiUtil.getOtherSiblingPropertyNames((JsonProperty)property).forEach(name -> {
                if (!PhpComposerEventNamesCompletionProvider.EVENTS_NAMES.contains(name)) {
                    result.addElement(LookupElementBuilder.create((String)("@" + name)).withAutoCompletionPolicy(AutoCompletionPolicy.ALWAYS_AUTOCOMPLETE));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/composer/json/PhpComposerJsonCompletionContributor$PhpScriptsReferencesCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

