/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.json.cache;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.json.JsonUtil;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.actions.ComposerCommandRunner;
import com.jetbrains.php.composer.addDependency.ComposerPackagesUtil;
import com.jetbrains.php.composer.addDependency.ShowPackageNamesResult;
import com.jetbrains.php.composer.execution.ComposerExecution;
import com.jetbrains.php.composer.json.cache.ComposerPackagesCacheStatusProvider;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComposerPackagesCache {
    private static final Logger LOG = Logger.getInstance(ComposerPackagesCache.class);
    @NonNls
    private static final String CACHE_FILE_NAME = "composer-cache.json";
    @NonNls
    public static final String PACKAGES_CACHE_DIR = "composer_packages";

    private ComposerPackagesCache() {
    }

    public static synchronized void reload(@Nullable Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        VirtualFile file = project == null ? null : ComposerDataService.getInstance(project).getConfigFile();
        PsiFile psiFile = (PsiFile)ReadAction.compute(() -> project != null && file != null ? PsiManager.getInstance((Project)project).findFile(file) : null);
        ComposerPackagesCacheStatusProvider.getInstance().setStatus(ComposerPackagesCacheStatusProvider.Status.REFRESHING, project, psiFile);
        try {
            if (file == null) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    try {
                        ComposerPackagesCache.store(ComposerPackagesUtil.getPackagistPackageNames());
                        ComposerPackagesCacheStatusProvider.getInstance().setStatus(ComposerPackagesCacheStatusProvider.Status.PACKAGIST, project, psiFile);
                    }
                    catch (IOException e) {
                        LOG.warn("Composer cache could not be downloaded");
                        ComposerPackagesCacheStatusProvider.getInstance().setStatus(ComposerPackagesCacheStatusProvider.Status.NOT_DEFINED, project, psiFile);
                    }
                });
            } else if (ComposerConfigUtils.parseJson(file) != null) {
                VirtualFile cacheDir = ComposerPackagesCache.getOrCreateCacheDir();
                ApplicationManager.getApplication().invokeLater(() -> ComposerPackagesCache.updateComposerCache(project, cacheDir, file, psiFile));
            }
        }
        catch (IOException ignore) {
            ComposerPackagesCacheStatusProvider.getInstance().setStatus(ComposerPackagesCacheStatusProvider.Status.NOT_DEFINED, project, psiFile);
            LOG.warn("Composer cache could not be downloaded");
        }
        catch (JsonSyntaxException ignore) {
            ComposerPackagesCacheStatusProvider.getInstance().setStatus(ComposerPackagesCacheStatusProvider.Status.INVALID_JSON, project, psiFile);
        }
    }

    private static void updateComposerCache(final @NotNull Project project, @NotNull VirtualFile cacheDir, VirtualFile file, final PsiFile psiFile) {
        VirtualFile composerCopy;
        if (project == null) {
            ComposerPackagesCache.$$$reportNull$$$0(0);
        }
        if (cacheDir == null) {
            ComposerPackagesCache.$$$reportNull$$$0(1);
        }
        if ((composerCopy = (VirtualFile)WriteAction.compute(() -> ComposerPackagesCache.createSimplifiedComposer(cacheDir, project, file))) == null) {
            ComposerPackagesCacheStatusProvider.getInstance().setStatus(ComposerPackagesCacheStatusProvider.Status.NOT_DEFINED, project, psiFile);
            LOG.warn("No composer.json copy was created");
            return;
        }
        ComposerExecution execution = ComposerDataService.getInstance(project).getComposerExecution();
        ComposerCommandRunner executor = new ComposerCommandRunner(execution, project, composerCopy.getParent().getPath(), EmptyProgressIndicator.notNullize((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator()));
        ApplicationManager.getApplication().executeOnPooledThread(() -> executor.runCommand(ComposerUtils.getValidateCommand(), (ProcessListener)new CapturingProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event.getExitCode() == 0) {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        try {
                            Pair<List<String>, ComposerPackagesCacheStatusProvider.Status> result = ComposerPackagesCache.getCustomPackagesNames(project, composerCopy);
                            ComposerPackagesCache.store((List)result.first);
                            ComposerPackagesCacheStatusProvider.getInstance().setStatus((ComposerPackagesCacheStatusProvider.Status)((Object)((Object)result.second)), project, psiFile);
                        }
                        catch (IOException e) {
                            ComposerPackagesCacheStatusProvider.getInstance().setStatus(ComposerPackagesCacheStatusProvider.Status.NOT_DEFINED, project, psiFile);
                            LOG.warn("Composer cache could not be downloaded");
                        }
                    });
                } else {
                    ComposerPackagesCacheStatusProvider.getInstance().setStatus(ComposerPackagesCacheStatusProvider.Status.NOT_DEFINED, project, psiFile);
                    LOG.warn("composer.json is not valid, packages cache has not been updated");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/composer/json/cache/ComposerPackagesCache$1", "processTerminated"));
            }
        }));
    }

    public static VirtualFile getOrCreateCacheDir() throws IOException {
        VirtualFile file = LocalFileSystem.getInstance().findFileByNioFile(ComposerPackagesCache.getDefaultCachePath().getParent());
        if (file != null && file.isDirectory()) {
            return file;
        }
        return VfsUtil.createDirectories((String)ComposerPackagesCache.getDefaultCachePath().getParent().toString());
    }

    @Nullable
    private static VirtualFile createSimplifiedComposer(@NotNull VirtualFile dir, @NotNull Project project, @NotNull VirtualFile userComposer) {
        if (dir == null) {
            ComposerPackagesCache.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ComposerPackagesCache.$$$reportNull$$$0(3);
        }
        if (userComposer == null) {
            ComposerPackagesCache.$$$reportNull$$$0(4);
        }
        if (project.isDisposed()) {
            return null;
        }
        PsiDirectory directory = PsiManager.getInstance((Project)project).findDirectory(dir);
        if (directory == null) {
            return null;
        }
        PsiFile jsonCopy = ComposerPackagesCache.getOrCreateComposerJsonCopy(project, directory);
        if (jsonCopy == null) {
            return null;
        }
        JsonProperty newRepos = ComposerPackagesCache.getNewRepoProperty(project, userComposer);
        ComposerPackagesCache.replaceWithUserRepos(newRepos, (JsonFile)jsonCopy);
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document = documentManager.getDocument(jsonCopy.getVirtualFile());
        if (document != null) {
            documentManager.saveDocument(document);
        }
        return jsonCopy.getVirtualFile();
    }

    @Nullable
    private static PsiFile getOrCreateComposerJsonCopy(@NotNull Project project, PsiDirectory directory) {
        PsiFile psiFile;
        if (project == null) {
            ComposerPackagesCache.$$$reportNull$$$0(5);
        }
        if ((psiFile = directory.findFile("composer.json")) == null) {
            @NonNls FileTemplate template = FileTemplateManager.getInstance((Project)project).getInternalTemplate("composer.json");
            String text = template.getText().replace("#[[$email$]]#", "user@gmail.com").replace("#[[$stability$]]#", "stable").replace("#[[$END$]]#", "").replace("#[[$vendor_name$]]#/#[[$package_name$]]#", "dummy/dummy");
            psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("composer.json", Objects.requireNonNull(Language.findLanguageByID((String)"JSON")), (CharSequence)text);
            psiFile = directory.add((PsiElement)psiFile).getContainingFile();
        }
        return psiFile;
    }

    private static void replaceWithUserRepos(JsonProperty newRepos, JsonFile psiFile) {
        JsonObject topLevelObject = JsonUtil.getTopLevelObject((JsonFile)psiFile);
        if (topLevelObject == null) {
            return;
        }
        JsonProperty repos = topLevelObject.findProperty("repositories");
        CommandProcessor.getInstance().runUndoTransparentAction(() -> WriteAction.run(() -> {
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)psiFile.getProject());
            Document document = manager.getDocument((PsiFile)psiFile);
            if (document == null) {
                return;
            }
            manager.commitDocument(document);
            if (repos != null) {
                repos.replace((PsiElement)newRepos);
            } else {
                JsonPsiUtil.addProperty((JsonObject)topLevelObject, (JsonProperty)newRepos, (boolean)false);
            }
        }));
    }

    @NotNull
    private static JsonProperty getNewRepoProperty(@NotNull Project project, @NotNull VirtualFile userComposer) {
        JsonProperty userRepos;
        if (project == null) {
            ComposerPackagesCache.$$$reportNull$$$0(6);
        }
        if (userComposer == null) {
            ComposerPackagesCache.$$$reportNull$$$0(7);
        }
        JsonProperty newRepos = new JsonElementGenerator(project).createProperty("repositories", "{}");
        JsonObject jsonObject = JsonUtil.getTopLevelObject((JsonFile)((JsonFile)PsiManager.getInstance((Project)project).findFile(userComposer)));
        if (jsonObject != null && (userRepos = (JsonProperty)ReadAction.compute(() -> jsonObject.findProperty("repositories"))) != null) {
            newRepos = userRepos;
        }
        JsonProperty jsonProperty = newRepos;
        if (jsonProperty == null) {
            ComposerPackagesCache.$$$reportNull$$$0(8);
        }
        return jsonProperty;
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static List<String> load(@NotNull Path cacheFilePath) {
        List list;
        BufferedReader reader;
        block13: {
            if (cacheFilePath == null) {
                ComposerPackagesCache.$$$reportNull$$$0(9);
            }
            reader = Files.newBufferedReader(cacheFilePath, StandardCharsets.UTF_8);
            list = (List)ObjectUtils.notNull((Object)((List)new GsonBuilder().create().fromJson((Reader)reader, new TypeToken<ArrayList<String>>(){}.getType())), Collections.emptyList());
            if (reader == null) break block13;
            ((Reader)reader).close();
        }
        List list2 = list;
        if (list2 == null) {
            ComposerPackagesCache.$$$reportNull$$$0(10);
        }
        return list2;
        {
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException exception) {
                    LOG.info("Composer packages cache " + cacheFilePath + " was not found");
                }
                catch (IOException exception) {
                    LOG.warn("Failed to load composer package cache " + cacheFilePath, (Throwable)exception);
                }
                catch (JsonSyntaxException e) {
                    LOG.warn("Malformed composer packages cache", (Throwable)e);
                }
            }
        }
        List<String> list3 = Collections.emptyList();
        if (list3 == null) {
            ComposerPackagesCache.$$$reportNull$$$0(11);
        }
        return list3;
    }

    private static Pair<List<String>, ComposerPackagesCacheStatusProvider.Status> getCustomPackagesNames(@NotNull Project project, @NotNull VirtualFile file) throws IOException {
        ShowPackageNamesResult names;
        if (project == null) {
            ComposerPackagesCache.$$$reportNull$$$0(12);
        }
        if (file == null) {
            ComposerPackagesCache.$$$reportNull$$$0(13);
        }
        return (names = ComposerPackagesUtil.getPackagesNames(project, file, EmptyProgressIndicator.notNullize((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator()))).getError() != null ? Pair.create(ComposerPackagesUtil.getPackagistPackageNames(), (Object)((Object)ComposerPackagesCacheStatusProvider.Status.PACKAGIST)) : Pair.create(names.getPackageNames(), (Object)((Object)(ContainerUtil.isEmpty(names.getPackageNames()) ? ComposerPackagesCacheStatusProvider.Status.EMPTY : ComposerPackagesCacheStatusProvider.Status.COMPOSER)));
    }

    private static void store(@NotNull List<String> newValue) {
        if (newValue == null) {
            ComposerPackagesCache.$$$reportNull$$$0(14);
        }
        try {
            ComposerPackagesCache.getOrCreateCacheDir();
            try (BufferedWriter writer = Files.newBufferedWriter(ComposerPackagesCache.getDefaultCachePath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                new GsonBuilder().create().toJson(newValue, (Appendable)writer);
            }
        }
        catch (IOException exception) {
            LOG.warn("Failed to save composer-cache.jsoncomposer package cache", (Throwable)exception);
        }
    }

    @NotNull
    private static Path getDefaultCachePath() {
        Path path = Paths.get(PathManager.getSystemPath(), PACKAGES_CACHE_DIR, CACHE_FILE_NAME);
        if (path == null) {
            ComposerPackagesCache.$$$reportNull$$$0(15);
        }
        return path;
    }

    @NotNull
    public static List<String> getPackageNames() {
        return ComposerPackagesCache.load(ComposerPackagesCache.getDefaultCachePath());
    }

    @Nullable
    public static String getValidComposerJson() {
        return ComposerPackagesCache.getDefaultCachePath().toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 10, 11, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userComposer";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/json/cache/ComposerPackagesCache";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheFilePath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/json/cache/ComposerPackagesCache";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewRepoProperty";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCachePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateComposerCache";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createSimplifiedComposer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateComposerJsonCopy";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNewRepoProperty";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 15: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCustomPackagesNames";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "store";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 10, 11, 15 -> new IllegalStateException(string);
        };
    }
}

