/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.lib;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.jetbrains.php.composer.configData.ComposerConfigManager;
import com.jetbrains.php.composer.lib.ComposerLibraryService;
import com.jetbrains.php.composer.lib.ComposerLibraryServiceFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0006\u0010\u0010\u001a\u00020\u000bJ\u0006\u0010\u0011\u001a\u00020\u000bJ\b\u0010\u0012\u001a\u00020\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/php/composer/lib/ComposerFileListener;", "Lcom/intellij/openapi/vfs/VirtualFileListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "disposable", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "isActive", "Ljava/util/concurrent/atomic/AtomicBoolean;", "contentsChanged", "", "event", "Lcom/intellij/openapi/vfs/VirtualFileEvent;", "fileCreated", "fileDeleted", "start", "stop", "dispose", "Companion", "intellij.php.impl"})
@SourceDebugExtension(value={"SMAP\nComposerFileListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposerFileListener.kt\ncom/jetbrains/php/composer/lib/ComposerFileListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,64:1\n68#2,4:65\n68#2,4:69\n68#2,4:73\n*S KotlinDebug\n*F\n+ 1 ComposerFileListener.kt\ncom/jetbrains/php/composer/lib/ComposerFileListener\n*L\n48#1:65,4\n55#1:69,4\n61#1:73,4\n*E\n"})
public final class ComposerFileListener
implements VirtualFileListener,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicBoolean isActive;
    @NotNull
    private static final Logger logger;

    public ComposerFileListener(@NotNull Project project, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.project = project;
        Disposer.register((Disposable)disposable, (Disposable)this);
        this.isActive = new AtomicBoolean(false);
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ComposerLibraryService composerLibraryManager = ComposerLibraryServiceFactory.Companion.getInstance(this.project, event.getFile());
        if (Intrinsics.areEqual((Object)composerLibraryManager.getConfig(), (Object)event.getFile())) {
            ApplicationManager.getApplication().invokeLater(() -> ComposerFileListener.contentsChanged$lambda$0(composerLibraryManager));
        }
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ComposerLibraryServiceFactory.Companion.getInstance(this.project, event.getFile()).resetLibsIfNeeded(event.getFile(), false);
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ComposerConfigManager configManager = ComposerConfigManager.Companion.getInstance(this.project);
        ComposerLibraryService composerLibraryManager = ComposerLibraryServiceFactory.Companion.getInstance(this.project, event.getFile());
        if (!Intrinsics.areEqual((Object)event.getFile(), (Object)configManager.getMainConfig()) && Intrinsics.areEqual((Object)event.getFile().getPath(), (Object)configManager.getConfigPath(event.getFile().getPath()))) {
            String string = event.getFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            configManager.removeConfig(string);
            String string2 = event.getFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            ComposerLibraryServiceFactory.Companion.remove(this.project, string2);
        } else {
            composerLibraryManager.resetLibsIfNeeded(event.getFile(), true);
        }
    }

    public final void start() {
        if (this.isActive.compareAndSet(false, true)) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("start composer file listener for project " + this.project.getName());
            }
            LocalFileSystem.getInstance().addVirtualFileListener((VirtualFileListener)this);
        }
    }

    public final void stop() {
        if (this.isActive.compareAndSet(true, false)) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("stop composer file listener for project " + this.project.getName());
            }
            LocalFileSystem.getInstance().removeVirtualFileListener((VirtualFileListener)this);
        }
    }

    public void dispose() {
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("dispose composer file listener for project " + this.project.getName());
        }
        this.stop();
    }

    private static final void contentsChanged$lambda$0(ComposerLibraryService $composerLibraryManager) {
        $composerLibraryManager.configContentChanged();
    }

    static {
        Logger logger = Logger.getInstance(ComposerFileListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ComposerFileListener.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/php/composer/lib/ComposerFileListener$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.php.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

