/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.lib;

import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ExternalLibrariesNode;
import com.intellij.ide.projectView.impl.nodes.ExternalLibrariesWorkspaceModelNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.lib.ComposerLibraryService;
import com.jetbrains.php.composer.lib.ComposerLibraryServiceFactory;
import com.jetbrains.php.config.library.PhpExternalLibrariesNodePatcher;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComposerLibrariesNodePatcher
implements TreeStructureProvider,
DumbAware {
    @NotNull
    public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<AbstractTreeNode<?>> children, ViewSettings settings) {
        if (parent == null) {
            ComposerLibrariesNodePatcher.$$$reportNull$$$0(0);
        }
        if (children == null) {
            ComposerLibrariesNodePatcher.$$$reportNull$$$0(1);
        }
        if (parent instanceof ExternalLibrariesNode) {
            ExternalLibrariesNode externalLibrariesNode = (ExternalLibrariesNode)parent;
            Collection<AbstractTreeNode<?>> collection = ComposerLibrariesNodePatcher.filterPhpLibIfEmpty(externalLibrariesNode, children);
            if (collection == null) {
                ComposerLibrariesNodePatcher.$$$reportNull$$$0(2);
            }
            return collection;
        }
        ExternalLibrariesWorkspaceModelNode parentNode = PhpExternalLibrariesNodePatcher.getAsPhpLibraryNode(parent);
        if (parentNode == null) {
            Collection<AbstractTreeNode<?>> collection = children;
            if (collection == null) {
                ComposerLibrariesNodePatcher.$$$reportNull$$$0(3);
            }
            return collection;
        }
        return ComposerLibrariesNodePatcher.filterComposerRoots(children, parentNode);
    }

    private static Collection<AbstractTreeNode<?>> filterPhpLibIfEmpty(ExternalLibrariesNode parent, Collection<AbstractTreeNode<?>> children) {
        Project project = parent.getProject();
        if (project == null) {
            return children;
        }
        return ContainerUtil.filter(children, abstractTreeNode -> !ComposerLibrariesNodePatcher.isEmptyPhpLib(abstractTreeNode, project));
    }

    private static boolean isEmptyPhpLib(AbstractTreeNode<?> node, Project project) {
        ExternalLibrariesWorkspaceModelNode libraryNode = PhpExternalLibrariesNodePatcher.getAsPhpLibraryNode(node);
        if (libraryNode == null) {
            return false;
        }
        if (!ComposerDataService.getInstance(project).isUpdateLibrary()) {
            return false;
        }
        Collection roots = libraryNode.getRoots();
        for (VirtualFile root : roots) {
            ProgressManager.checkCanceled();
            if (ComposerLibrariesNodePatcher.isComposerRoot(project, root)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Collection<AbstractTreeNode<?>> filterComposerRoots(@NotNull Collection<AbstractTreeNode<?>> children, ExternalLibrariesWorkspaceModelNode parentNode) {
        Project project;
        if (children == null) {
            ComposerLibrariesNodePatcher.$$$reportNull$$$0(4);
        }
        if ((project = parentNode.getProject()) == null) {
            Collection<AbstractTreeNode<?>> collection = children;
            if (collection == null) {
                ComposerLibrariesNodePatcher.$$$reportNull$$$0(5);
            }
            return collection;
        }
        List list = ContainerUtil.filter(children, abstractTreeNode -> !ComposerLibrariesNodePatcher.isComposerRoot(abstractTreeNode));
        if (list == null) {
            ComposerLibrariesNodePatcher.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static boolean isComposerRoot(AbstractTreeNode<?> node) {
        if (!(node instanceof PsiDirectoryNode)) {
            return false;
        }
        VirtualFile file = ((PsiDirectoryNode)node).getVirtualFile();
        return ComposerLibrariesNodePatcher.isComposerRoot(node.getProject(), file);
    }

    private static boolean isComposerRoot(Project project, @Nullable VirtualFile file) {
        ComposerLibraryService composerLibraryService = ComposerLibraryServiceFactory.getInstance(project, file);
        if (!composerLibraryService.isUpdatingLibrary()) {
            return false;
        }
        return composerLibraryService.isRootToAdd(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/lib/ComposerLibrariesNodePatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/lib/ComposerLibrariesNodePatcher";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "modify";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "filterComposerRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "filterComposerRoots";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

