/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.lib;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ModuleAttachProcessor;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.actions.log.ComposerLogService;
import com.jetbrains.php.composer.lib.ComposerLibraryNotificationService;
import com.jetbrains.php.composer.lib.ExcludedDirectoriesApplier;
import com.jetbrains.php.composer.lib.IncludePathApplier;
import com.jetbrains.php.composer.lib.MainComposerLibraryService;
import com.jetbrains.php.config.PhpRuntimeConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerLibraryService
implements Disposable {
    @NonNls
    private static final String COMPOSER_VENDORS_SUBDIRECTORY_NAME = "composer";
    protected final Project myProject;
    protected VirtualFile myConfig;
    private String myVendorRelativePath;
    private VirtualFile myVendorDir;
    private VirtualFile myBinDir;
    private final ComposerLibraryNotificationService myNotificationService;

    @Deprecated(forRemoval=true)
    public static ComposerLibraryService getInstance(@NotNull Project project) {
        if (project == null) {
            ComposerLibraryService.$$$reportNull$$$0(0);
        }
        return (ComposerLibraryService)project.getService(MainComposerLibraryService.class);
    }

    @NonInjectable
    ComposerLibraryService(@NotNull Project project, @Nullable VirtualFile config) {
        if (project == null) {
            ComposerLibraryService.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myConfig = config;
        this.myNotificationService = ComposerLibraryNotificationService.getInstance(project);
    }

    @Nullable
    public VirtualFile refreshVendorDir(boolean asynchronous, @Nullable Runnable postRefresh) {
        if (this.myVendorDir == null && this.myConfig != null && this.myVendorRelativePath != null) {
            VirtualFile vendorDir = this.findVendorDir();
            ComposerUtils.refreshVendorDirectory(vendorDir, asynchronous, postRefresh);
            this.myVendorDir = vendorDir;
        }
        return this.myVendorDir;
    }

    @Nullable
    VirtualFile findVendorDir() {
        return ComposerUtils.findVendorDir(this.myConfig, this.myVendorRelativePath);
    }

    public boolean vendorDirExists() {
        if (this.myConfig == null || this.myVendorRelativePath == null) {
            return false;
        }
        VirtualFile parent = this.myConfig.getParent();
        if (parent == null) {
            return false;
        }
        File file = new File(parent.getPath());
        File target = new File(file, this.myVendorRelativePath);
        return LocalFileSystem.getInstance().findFileByPath(target.getPath()) != null;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @ApiStatus.Internal
    public void reloadLibraries(boolean bl, Set<VirtualFile> set, boolean bl2, boolean bl3) {
        void oldPackagesToAdd;
        void newUpdateStatus;
        void oldUpdateStatus;
        void force;
        ThreadingAssertions.softAssertReadAccess();
        if (this.myProject == null || this.myProject.isDisposed()) {
            return;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualFile oldVendor = this.myVendorDir;
        VirtualFile oldBin = this.myBinDir;
        this.reloadMainFiles();
        if (!(force == false && Objects.equals(oldVendor, this.myVendorDir) && Objects.equals(oldBin, this.myBinDir) && oldUpdateStatus == newUpdateStatus && oldPackagesToAdd.isEmpty())) {
            this.resetLibrariesAndExcludedPaths(null, (Set<VirtualFile>)oldPackagesToAdd, (boolean)oldUpdateStatus, (boolean)newUpdateStatus, oldVendor, this.myVendorDir, oldBin, this.myBinDir);
        }
    }

    void resetLibrariesAndExcludedPaths(Collection<VirtualFile> deletedFiles, Set<VirtualFile> oldPackagesToAdd, boolean oldUpdateStatus, boolean newUpdateStatus) {
        this.resetLibrariesAndExcludedPaths(deletedFiles, oldPackagesToAdd, oldUpdateStatus, newUpdateStatus, this.myVendorDir, this.myVendorDir, this.myBinDir, this.myBinDir);
    }

    private void resetLibrariesAndExcludedPaths(Collection<VirtualFile> deletedFiles, Set<VirtualFile> oldPackagesToAdd, boolean oldUpdateStatus, boolean newUpdateStatus, VirtualFile oldVendorDir, VirtualFile vendorDir, VirtualFile oldBinDir, VirtualFile binDir) {
        if (oldUpdateStatus && !newUpdateStatus) {
            this.removeAllPackagesWithInfo(oldVendorDir, oldBinDir);
        } else if (oldUpdateStatus) {
            this.addOldPackages(oldPackagesToAdd);
            this.changePackages(deletedFiles, oldVendorDir, vendorDir, oldBinDir, binDir, false);
        } else if (newUpdateStatus) {
            this.changePackages(deletedFiles, oldVendorDir, vendorDir, oldBinDir, binDir, true);
        }
    }

    private void addOldPackages(Set<VirtualFile> add) {
        if (add.isEmpty()) {
            return;
        }
        this.changeIncludePaths(add, Collections.emptySet(), null, null);
        ComposerLogService.getInstance(this.myProject).report(PhpBundle.message("framework.composer.packages.were.moved.to.0.php.include.paths.popup", new Object[0]), ComposerLogMessageBuilder.Settings.PHP);
    }

    private void changePackages(Collection<VirtualFile> deletedFiles, VirtualFile oldVendorDir, VirtualFile vendorDir, VirtualFile oldBinDir, VirtualFile binDir, boolean syncTurnedOn) {
        HashSet<VirtualFile> filesToRemove = new HashSet<VirtualFile>(ComposerLibraryService.getPackages(oldVendorDir, oldBinDir));
        HashSet<VirtualFile> filesToAdd = new HashSet<VirtualFile>(ComposerLibraryService.getPackages(vendorDir, binDir));
        if (deletedFiles != null && !deletedFiles.isEmpty()) {
            List deleted = ContainerUtil.filter(filesToAdd, file -> {
                for (VirtualFile deletedFile : deletedFiles) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)deletedFile, (VirtualFile)file, (boolean)false)) continue;
                    return true;
                }
                return false;
            });
            deleted.forEach(filesToAdd::remove);
        }
        filesToRemove.removeAll(filesToAdd);
        String includePathsNotificationMessage = PhpBundle.message(syncTurnedOn ? "framework.composer.packages.were.added.0.php.include.paths.popup" : "framework.composer.packages.were.changed.0.php.include.paths.popup", new Object[0]);
        IncludePathApplier includeApplier = this.prepareIncludePathChanges(filesToAdd, filesToRemove, deletedFiles, includePathsNotificationMessage);
        Module targetModule = null;
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        if (this.myConfig != null && vendorDir != null && vendorDir.isValid()) {
            targetModule = fileIndex.getModuleForFile(vendorDir);
        }
        if (targetModule == null && this.myConfig != null && deletedFiles != null && !deletedFiles.isEmpty()) {
            targetModule = fileIndex.getModuleForFile(deletedFiles.iterator().next());
        }
        if (targetModule == null && this.myConfig != null && this.myConfig.isValid()) {
            targetModule = fileIndex.getModuleForFile(this.myConfig);
        }
        if (targetModule == null) {
            targetModule = ModuleAttachProcessor.getPrimaryModule((Project)this.myProject);
        }
        String notificationMessage = PhpBundle.message(syncTurnedOn ? "framework.composer.packages.were.added.0.excluded.folders.popup" : "framework.composer.packages.were.changed.0.excluded.folders.popup", new Object[0]);
        ExcludedDirectoriesApplier excludeApplier = targetModule != null ? new ExcludedDirectoriesApplier(targetModule, filesToAdd, filesToRemove, deletedFiles, notificationMessage) : null;
        this.executeInBackground(() -> {
            includeApplier.run();
            if (excludeApplier != null) {
                excludeApplier.run();
            }
        });
    }

    private void removeAllPackagesWithInfo(VirtualFile oldVendorDir, VirtualFile oldBinDir) {
        Collection<VirtualFile> oldPackages = ComposerLibraryService.getPackages(oldVendorDir, oldBinDir);
        if (oldPackages.isEmpty()) {
            return;
        }
        String notificationMessage = PhpBundle.message("framework.composer.packages.were.removed.0.php.include.paths.popup", new Object[0]);
        this.changeIncludePaths(Collections.emptyList(), oldPackages, null, notificationMessage);
        Module targetModule = null;
        if (this.myConfig != null && oldVendorDir != null) {
            targetModule = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getModuleForFile(oldVendorDir);
        }
        if (targetModule == null && ApplicationManager.getApplication().isUnitTestMode()) {
            targetModule = ModuleAttachProcessor.getPrimaryModule((Project)this.myProject);
        }
        if (targetModule != null) {
            this.changeExcludedFolders(targetModule, Collections.emptyList(), oldPackages, Collections.emptySet(), PhpBundle.message("framework.composer.packages.were.removed.0.excluded.folders.popup", new Object[0]));
        }
    }

    private void changeIncludePaths(Collection<VirtualFile> filesToAdd, Collection<VirtualFile> filesToRemove, @Nullable Collection<VirtualFile> deletedFilesToRemove, String notificationMessage) {
        IncludePathApplier applier = this.prepareIncludePathChanges(filesToAdd, filesToRemove, deletedFilesToRemove, notificationMessage);
        this.executeInBackground(applier);
    }

    @NotNull
    private IncludePathApplier prepareIncludePathChanges(Collection<VirtualFile> filesToAdd, Collection<VirtualFile> filesToRemove, @Nullable Collection<VirtualFile> deletedFilesToRemove, String notificationMessage) {
        VirtualFile customStubsFile;
        if (!filesToAdd.isEmpty() && (customStubsFile = this.getStubsFileFromComposer()) != null && !this.isConfiguredAsCustomStubsForPS(customStubsFile)) {
            filesToAdd = ContainerUtil.filter(filesToAdd, file -> !customStubsFile.equals(file));
            filesToRemove = new ArrayList<VirtualFile>(filesToRemove);
            filesToRemove.add(customStubsFile);
        }
        return new IncludePathApplier(this.myProject, filesToAdd, filesToRemove, deletedFilesToRemove, notificationMessage);
    }

    private void executeInBackground(Runnable runnable) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            runnable.run();
        } else {
            ((MainComposerLibraryService)this.myProject.getService(MainComposerLibraryService.class)).getPathExecutor().execute(runnable);
        }
    }

    private boolean isConfiguredAsCustomStubsForPS(@NotNull VirtualFile stubsFile) {
        PhpRuntimeConfiguration instance;
        String path;
        if (stubsFile == null) {
            ComposerLibraryService.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)(path = (instance = PhpRuntimeConfiguration.getInstance(this.myProject)).getDefaultStubsPath()))) {
            return false;
        }
        VirtualFile stubs = LocalFileSystem.getInstance().findFileByPath(path);
        return stubsFile.equals(stubs);
    }

    @Nullable
    VirtualFile getStubsFileFromComposer() {
        if (this.myVendorDir == null) {
            return null;
        }
        VirtualFile jetbrains = this.myVendorDir.findChild("jetbrains");
        if (jetbrains == null || !jetbrains.isDirectory()) {
            return null;
        }
        return jetbrains.findChild("phpstorm-stubs");
    }

    private static Collection<VirtualFile> getPackages(@Nullable VirtualFile vendorDir, @Nullable VirtualFile binDir) {
        ArrayList<VirtualFile> packages = new ArrayList<VirtualFile>();
        if (vendorDir != null && vendorDir.exists()) {
            for (VirtualFile childFile : vendorDir.getChildren()) {
                if (!childFile.isDirectory() || childFile.equals(binDir)) continue;
                if (COMPOSER_VENDORS_SUBDIRECTORY_NAME.equals(childFile.getName())) {
                    packages.add(childFile);
                    continue;
                }
                for (VirtualFile file : childFile.getChildren()) {
                    if (!file.isDirectory()) continue;
                    packages.add(file);
                }
            }
        }
        return packages;
    }

    protected void reloadMainFiles() {
        this.reloadComposerDirs();
    }

    private void reloadComposerDirs() {
        this.myVendorRelativePath = null;
        this.myVendorDir = null;
        this.myBinDir = null;
        VirtualFile config = this.myConfig;
        if (config == null || !config.exists() || config.isDirectory()) {
            return;
        }
        Pair<String, String> vendorAndBinDirs = ComposerConfigUtils.getVendorAndBinDirs(config);
        if (vendorAndBinDirs == null) {
            return;
        }
        String vendorRelativePath = (String)vendorAndBinDirs.getFirst();
        if (!StringUtil.isEmpty((String)vendorRelativePath)) {
            this.myVendorRelativePath = vendorRelativePath;
            this.myVendorDir = this.findVendorDir();
        }
        String binDirRelativePath = (String)vendorAndBinDirs.getSecond();
        if (this.myVendorDir != null && binDirRelativePath != null) {
            this.myBinDir = VfsUtil.findRelativeFile((VirtualFile)config.getParent(), (String[])new String[]{binDirRelativePath});
        }
    }

    private void changeExcludedFolders(Module module, Collection<VirtualFile> exclude, Collection<VirtualFile> backToProject, Collection<VirtualFile> deletedPackages, String notificationMessage) {
        ExcludedDirectoriesApplier applier = new ExcludedDirectoriesApplier(module, exclude, backToProject, deletedPackages, notificationMessage);
        this.executeInBackground(applier);
    }

    public void dispose() {
        this.myNotificationService.cancelAllRequests();
    }

    void configContentChanged() {
        if (this.myProject == null || this.myProject.isDisposed()) {
            return;
        }
        VirtualFile oldVendorDir = this.myVendorDir;
        VirtualFile oldBinDir = this.myBinDir;
        this.reloadComposerDirs();
        if (!Objects.equals(oldVendorDir, this.myVendorDir) || !Objects.equals(oldBinDir, this.myBinDir)) {
            boolean status = ComposerDataService.getInstance(this.myProject).isUpdateLibrary();
            this.resetLibrariesAndExcludedPaths(null, Collections.emptySet(), status, status, oldVendorDir, this.myVendorDir, oldBinDir, this.myBinDir);
        }
    }

    void resetLibsIfNeeded(VirtualFile file, boolean deleted) {
        if (this.myProject == null || this.myProject.isDisposed() || this.myConfig == null) {
            return;
        }
        if (!this.myConfig.isValid()) {
            this.reloadMainFiles();
            if (this.myConfig == null) {
                return;
            }
        }
        if (this.myVendorDir == null) {
            if (!StringUtil.isEmpty((String)this.myVendorRelativePath)) {
                this.myVendorDir = VfsUtil.findRelativeFile((VirtualFile)this.myConfig.getParent(), (String[])new String[]{this.myVendorRelativePath});
            }
            if (this.myVendorDir == null) {
                return;
            }
        }
        if (!file.isDirectory()) {
            return;
        }
        VirtualFile parent = file.getParent();
        if (parent == null) {
            return;
        }
        if (this.myVendorDir.equals(parent) || this.myVendorDir.equals(parent.getParent()) || this.myVendorDir.equals(file)) {
            if (!this.myVendorDir.exists()) {
                this.myVendorDir = null;
            }
            if (this.myBinDir != null && !this.myBinDir.exists()) {
                this.myBinDir = null;
            }
            List<VirtualFile> deletedFiles = deleted ? Collections.singleton(file) : Collections.emptyList();
            boolean status = ComposerDataService.getInstance(this.myProject).isUpdateLibrary();
            this.resetLibrariesAndExcludedPaths(deletedFiles, Collections.emptySet(), status, status);
        }
    }

    public boolean isRootToAdd(VirtualFile file) {
        if (file == null || this.myVendorDir == null) {
            return false;
        }
        VirtualFile parent = file.getParent();
        if (COMPOSER_VENDORS_SUBDIRECTORY_NAME.equals(file.getName()) && this.myVendorDir.equals(parent)) {
            return true;
        }
        return parent != null && this.myVendorDir.equals(parent.getParent());
    }

    public boolean isUpdatingLibrary() {
        return ComposerDataService.getInstance(this.myProject).isUpdateLibrary() && this.myVendorDir != null;
    }

    @ApiStatus.Internal
    public VirtualFile getConfig() {
        return this.myConfig;
    }

    @ApiStatus.Internal
    public VirtualFile getVendorDir() {
        return this.myVendorDir;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubsFile";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/composer/lib/ComposerLibraryService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfiguredAsCustomStubsForPS";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

