/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.lib;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.composer.ComposerConfigListener;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.configData.ComposerConfigManager;
import com.jetbrains.php.composer.lib.ComposerLibraryService;
import com.jetbrains.php.composer.lib.MainComposerLibraryService;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0007J\b\u0010\u0012\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/php/composer/lib/ComposerLibraryServiceFactory;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "instances", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/jetbrains/php/composer/lib/ComposerLibraryService;", "composerConfigListeners", "Lcom/jetbrains/php/composer/ComposerConfigListener;", "getOrCreate", "configFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "remove", "", "configPath", "dispose", "Companion", "intellij.php.impl"})
@SourceDebugExtension(value={"SMAP\nComposerLibraryServiceFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposerLibraryServiceFactory.kt\ncom/jetbrains/php/composer/lib/ComposerLibraryServiceFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1#2:76\n1863#3,2:77\n*S KotlinDebug\n*F\n+ 1 ComposerLibraryServiceFactory.kt\ncom/jetbrains/php/composer/lib/ComposerLibraryServiceFactory\n*L\n71#1:77,2\n*E\n"})
public final class ComposerLibraryServiceFactory
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<String, ComposerLibraryService> instances;
    @NotNull
    private final ConcurrentHashMap<ComposerLibraryService, ComposerConfigListener> composerConfigListeners;

    public ComposerLibraryServiceFactory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.instances = new ConcurrentHashMap();
        this.composerConfigListeners = new ConcurrentHashMap();
    }

    private final ComposerLibraryService getOrCreate(VirtualFile configFile) {
        ComposerLibraryService composerLibraryService;
        if (configFile == null || Intrinsics.areEqual((Object)configFile, (Object)ComposerConfigManager.Companion.getInstance(this.project).getMainConfig())) {
            Object object = this.project.getService(MainComposerLibraryService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (ComposerLibraryService)object;
        }
        ComposerLibraryService newInstance = new ComposerLibraryService(this.project, configFile);
        ComposerLibraryService oldInstance = this.instances.putIfAbsent(configFile.getPath(), newInstance);
        if (oldInstance == null) {
            newInstance.reloadMainFiles();
            ComposerConfigListener composerConfigListener2 = new ComposerConfigListener(newInstance){
                final /* synthetic */ ComposerLibraryService $newInstance;
                {
                    this.$newInstance = $newInstance;
                }

                public void configPathOrLibraryStatusChanged(boolean oldStatus, boolean newStatus) {
                    this.$newInstance.reloadLibraries(false, SetsKt.emptySet(), oldStatus, newStatus);
                }
            };
            ComposerDataService.getInstance(this.project).addConfigListener(composerConfigListener2);
            ((Map)this.composerConfigListeners).put(newInstance, composerConfigListener2);
            Disposer.register((Disposable)this, (Disposable)newInstance);
        }
        if ((composerLibraryService = oldInstance) == null) {
            composerLibraryService = newInstance;
        }
        return composerLibraryService;
    }

    @ApiStatus.Internal
    public final void remove(@NotNull String configPath) {
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        ComposerLibraryService instance = this.instances.get(configPath);
        if (instance != null && instance.getConfig() != null) {
            ComposerConfigListener composerConfigListener2 = this.composerConfigListeners.remove(instance);
            if (composerConfigListener2 != null) {
                ComposerConfigListener it = composerConfigListener2;
                boolean bl = false;
                ComposerDataService.getInstance(this.project).removeConfigListener(it);
            }
            this.instances.remove(configPath);
            instance.reloadLibraries(true, SetsKt.emptySet(), instance.isUpdatingLibrary(), false);
        }
    }

    public void dispose() {
        Collection<ComposerConfigListener> collection = this.composerConfigListeners.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ComposerConfigListener it = (ComposerConfigListener)element$iv;
            boolean bl = false;
            ComposerDataService.getInstance(this.project).removeConfigListener(it);
        }
        this.composerConfigListeners.clear();
    }

    @JvmStatic
    @NotNull
    public static final ComposerLibraryService getInstance(@NotNull Project project, @Nullable PsiElement context) {
        return Companion.getInstance(project, context);
    }

    @JvmStatic
    @NotNull
    public static final ComposerLibraryService getInstance(@NotNull Project project, @Nullable VirtualFile context) {
        return Companion.getInstance(project, context);
    }

    @JvmStatic
    public static final void remove(@NotNull Project project, @NotNull String configPath) {
        Companion.remove(project, configPath);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\nH\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/php/composer/lib/ComposerLibraryServiceFactory$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/php/composer/lib/ComposerLibraryService;", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/openapi/vfs/VirtualFile;", "remove", "", "configPath", "", "intellij.php.impl"})
    @SourceDebugExtension(value={"SMAP\nComposerLibraryServiceFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposerLibraryServiceFactory.kt\ncom/jetbrains/php/composer/lib/ComposerLibraryServiceFactory$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,75:1\n31#2,2:76\n31#2,2:78\n31#2,2:80\n*S KotlinDebug\n*F\n+ 1 ComposerLibraryServiceFactory.kt\ncom/jetbrains/php/composer/lib/ComposerLibraryServiceFactory$Companion\n*L\n55#1:76,2\n61#1:78,2\n66#1:80,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ComposerLibraryService getInstance(@NotNull Project project, @Nullable PsiElement context) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            VirtualFile configFile = ComposerConfigManager.Companion.getInstance(project).getConfig(context);
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ComposerLibraryServiceFactory> serviceClass$iv = ComposerLibraryServiceFactory.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return ((ComposerLibraryServiceFactory)object).getOrCreate(configFile);
        }

        @JvmStatic
        @NotNull
        public final ComposerLibraryService getInstance(@NotNull Project project, @Nullable VirtualFile context) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            VirtualFile configFile = ComposerConfigManager.Companion.getInstance(project).getConfig(context);
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ComposerLibraryServiceFactory> serviceClass$iv = ComposerLibraryServiceFactory.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return ((ComposerLibraryServiceFactory)object).getOrCreate(configFile);
        }

        @JvmStatic
        public final void remove(@NotNull Project project, @NotNull String configPath) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ComposerLibraryServiceFactory> serviceClass$iv = ComposerLibraryServiceFactory.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((ComposerLibraryServiceFactory)object).remove(configPath);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

