/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.lib;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.lib.ComposerLibraryNotificationService;
import com.jetbrains.php.config.library.PhpIncludePathManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class IncludePathApplier
implements Runnable {
    private final Project myProject;
    private final Collection<VirtualFile> myFilesToAdd;
    private final Collection<VirtualFile> myFilesToRemove;
    @Nullable
    private final Set<VirtualFile> myDeletedFilesToRemove;
    @Nullable
    private final String myNotificationMessage;
    private static final Logger LOG = Logger.getInstance(IncludePathApplier.class);

    IncludePathApplier(@NotNull Project project, @NotNull Collection<VirtualFile> filesToAdd, @NotNull Collection<VirtualFile> filesToRemove, @Nullable Collection<VirtualFile> deletedFilesToRemove, @Nullable String notificationMessage) {
        if (project == null) {
            IncludePathApplier.$$$reportNull$$$0(0);
        }
        if (filesToAdd == null) {
            IncludePathApplier.$$$reportNull$$$0(1);
        }
        if (filesToRemove == null) {
            IncludePathApplier.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myFilesToAdd = filesToAdd;
        this.myFilesToRemove = filesToRemove;
        this.myDeletedFilesToRemove = deletedFilesToRemove == null ? Collections.emptySet() : new HashSet<VirtualFile>(deletedFilesToRemove);
        this.myNotificationMessage = notificationMessage;
    }

    @Override
    public void run() {
        PhpIncludePathManager facade = PhpIncludePathManager.getInstance(this.myProject);
        List<String> paths = facade.getIncludePath();
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        ArrayList<String> newPaths = new ArrayList<String>();
        boolean changed = false;
        block0: for (String path : paths) {
            VirtualFile file = fileSystem.findFileByPath(path);
            if (file != null && this.myFilesToRemove.contains(file)) {
                changed = true;
                continue;
            }
            if (file == null && this.myDeletedFilesToRemove != null && !this.myDeletedFilesToRemove.isEmpty()) {
                for (VirtualFile deletedFileToRemove : this.myDeletedFilesToRemove) {
                    if (!VfsUtilCore.isEqualOrAncestor((String)deletedFileToRemove.getPath(), (String)path)) continue;
                    changed = true;
                    continue block0;
                }
            }
            if (file != null) {
                this.myFilesToAdd.remove(file);
            }
            newPaths.add(path);
        }
        if (!this.myFilesToAdd.isEmpty()) {
            changed = true;
            for (VirtualFile file : this.myFilesToAdd) {
                newPaths.add(file.getPath());
            }
        }
        if (changed) {
            LOG.info("Updated composer include paths. Add " + this.myFilesToAdd + ",\nremove " + this.myFilesToRemove + ",\ndeleted files " + this.myDeletedFilesToRemove);
            facade.setIncludePath(newPaths);
            if (this.myNotificationMessage != null) {
                ComposerLibraryNotificationService notificationService = ComposerLibraryNotificationService.getInstance(this.myProject);
                notificationService.notifyWithPopupAndLinks(this.myNotificationMessage, ComposerLogMessageBuilder.Settings.PHP);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "filesToAdd";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "filesToRemove";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/composer/lib/IncludePathApplier";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

