/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.run;

import com.intellij.DynamicBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.run.ComposerScriptRunConfiguration;
import com.jetbrains.php.composer.run.ComposerScriptRunConfigurationSettings;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerScriptRunConfigurationEditor
extends SettingsEditor<ComposerScriptRunConfiguration> {
    private TextFieldWithBrowseButton myComposerJsonPathField;
    private JPanel myMainPanel;
    private RawCommandLineEditor myCommandLineParametersEditor;
    private ComboBox<String> myScriptComboBox;

    public ComposerScriptRunConfigurationEditor(final @NotNull Project project) {
        if (project == null) {
            ComposerScriptRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withTitle(PhpBundle.message("framework.composer.path.dialog.path.to.composer.json", new Object[0])).withDescription(PhpBundle.message("framework.composer.path.dialog.specify.composer.json", new Object[0]));
        this.myComposerJsonPathField.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>((ComponentWithBrowseButton)this.myComposerJsonPathField, project, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            @Nullable
            protected VirtualFile getInitialFile() {
                VirtualFile file;
                String text = ComposerScriptRunConfigurationEditor.this.myComposerJsonPathField.getText();
                if (StringUtil.isEmpty((String)text) && (file = ComposerUtils.findFileInProject(project, "composer.json")) != null) {
                    return file;
                }
                return super.getInitialFile();
            }
        });
        this.myComposerJsonPathField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                ComposerScriptRunConfigurationEditor.this.updateScriptsComboBox(ComposerScriptRunConfigurationEditor.this.myComposerJsonPathField.getText(), null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/composer/run/ComposerScriptRunConfigurationEditor$2", "textChanged"));
            }
        });
    }

    private void updateScriptsComboBox(@Nullable String pathToComposerJson, @Nullable @NlsSafe String itemToSelect) {
        this.myScriptComboBox.removeAllItems();
        if (StringUtil.isEmptyOrSpaces((String)pathToComposerJson)) {
            return;
        }
        VirtualFile configFile = VfsUtil.findFileByIoFile((File)new File(pathToComposerJson), (boolean)true);
        if (configFile == null) {
            return;
        }
        List<String> scripts = ComposerConfigUtils.getScripts(configFile);
        scripts.forEach(script -> this.myScriptComboBox.addItem(script));
        if (itemToSelect != null) {
            this.myScriptComboBox.setSelectedItem((Object)(scripts.contains(itemToSelect) ? itemToSelect : null));
        }
    }

    protected void resetEditorFrom(@NotNull ComposerScriptRunConfiguration s) {
        ComposerScriptRunConfigurationSettings settings;
        String pathToComposerJson;
        if (s == null) {
            ComposerScriptRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        if ((pathToComposerJson = (settings = (ComposerScriptRunConfigurationSettings)s.getSettings()).getPathToComposerJson()) != null) {
            this.myComposerJsonPathField.setText(pathToComposerJson);
            this.updateScriptsComboBox(pathToComposerJson, settings.getScript());
        }
        this.myCommandLineParametersEditor.setText(settings.getCommandLineParameters());
    }

    protected void applyEditorTo(@NotNull ComposerScriptRunConfiguration s) throws ConfigurationException {
        if (s == null) {
            ComposerScriptRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        ComposerScriptRunConfigurationSettings settings = (ComposerScriptRunConfigurationSettings)s.getSettings();
        settings.setPathToComposerJson(this.myComposerJsonPathField.getText());
        settings.setScript((String)this.myScriptComboBox.getSelectedItem());
        settings.setCommandLineParameters(this.myCommandLineParametersEditor.getText());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            ComposerScriptRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        RawCommandLineEditor rawCommandLineEditor;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCommandLineParametersEditor = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel.add((Component)rawCommandLineEditor, new GridConstraints(2, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", ComposerScriptRunConfigurationEditor.class).getString("framework.composer.add.dependency.settings.cl.label"));
        jPanel.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myComposerJsonPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/PhpBundle", ComposerScriptRunConfigurationEditor.class).getString("framework.composer.run.path.to.composer.json"));
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myScriptComboBox = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/PhpBundle", ComposerScriptRunConfigurationEditor.class).getString("framework.composer.run.script"));
        jPanel.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/run/ComposerScriptRunConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/run/ComposerScriptRunConfigurationEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

