/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config;

import com.intellij.DynamicBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.config.ClassWithMethodOrFunctionChooserForm;
import com.jetbrains.php.config.PhpClassWithMethodChooserForm;
import com.jetbrains.php.debug.xdebug.XdebugUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCustomFormatFunctionsChooserForm {
    private final PhpClassWithMethodChooserForm myClassWithMethodChooserForm;
    private JBTextField myFormatParameterIndexTextField;
    private JPanel classWithMethodChooserPanel;
    private JPanel myPanel;

    public PhpCustomFormatFunctionsChooserForm(Project project, Disposable disposable) {
        this.$$$setupUI$$$();
        this.myClassWithMethodChooserForm = new ClassWithMethodOrFunctionChooserForm(project, disposable);
        this.classWithMethodChooserPanel.add(this.myClassWithMethodChooserForm.getPanel());
        new ComponentValidator(disposable).withValidator(() -> this.validateFormatIndex()).installOn((JComponent)this.myFormatParameterIndexTextField);
        this.myFormatParameterIndexTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ComponentValidator.getInstance((JComponent)PhpCustomFormatFunctionsChooserForm.this.myFormatParameterIndexTextField).ifPresent(v -> v.revalidate());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/config/PhpCustomFormatFunctionsChooserForm$1", "textChanged"));
            }
        });
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    @Nullable
    public ValidationInfo validate(@NotNull PhpIndex index) {
        ValidationInfo validate;
        if (index == null) {
            PhpCustomFormatFunctionsChooserForm.$$$reportNull$$$0(0);
        }
        if ((validate = this.myClassWithMethodChooserForm.validate(index)) != null) {
            return validate;
        }
        if (StringUtil.isEmptyOrSpaces((String)this.myClassWithMethodChooserForm.getClassFqn()) && index.getFunctionsByFQN(this.myClassWithMethodChooserForm.getMethodText()).isEmpty()) {
            return new ValidationInfo(PhpBundle.message("custom.format.functions.dialog.validation.function.not.found", this.myClassWithMethodChooserForm.getMethodText()), (JComponent)this.myClassWithMethodChooserForm.myMethodTextField);
        }
        return this.validateFormatIndex();
    }

    private ValidationInfo validateFormatIndex() {
        if (!XdebugUtil.isInteger(this.getFormatIndexText())) {
            return new ValidationInfo(PhpBundle.message("custom.format.functions.dialog.validation.format.index", new Object[0]), (JComponent)this.myFormatParameterIndexTextField);
        }
        return null;
    }

    public void setFormatParameterIndex(int value) {
        this.myFormatParameterIndexTextField.setText(String.valueOf(value));
    }

    public void setClassFqn(String value) {
        this.myClassWithMethodChooserForm.setClassText(value);
    }

    public void setFunctionFqn(String value) {
        this.myClassWithMethodChooserForm.setMethodText(value);
    }

    @NotNull
    public String getFormatIndexText() {
        String string = this.myFormatParameterIndexTextField.getText();
        if (string == null) {
            PhpCustomFormatFunctionsChooserForm.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getClassFqn() {
        String fqn = this.myClassWithMethodChooserForm.getClassFqn();
        String string = StringUtil.isEmptyOrSpaces((String)fqn) ? "" : PhpLangUtil.toFQN(fqn);
        if (string == null) {
            PhpCustomFormatFunctionsChooserForm.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFunctionText() {
        String string = this.myClassWithMethodChooserForm.getMethodText();
        if (string == null) {
            PhpCustomFormatFunctionsChooserForm.$$$reportNull$$$0(3);
        }
        return string;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBTextField jBTextField;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpCustomFormatFunctionsChooserForm.class).getString("custom.format.functions.dialog.format.index.title"));
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFormatParameterIndexTextField = jBTextField = new JBTextField();
        jBTextField.setText("0");
        jPanel3.add((Component)jBTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.classWithMethodChooserPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/PhpCustomFormatFunctionsChooserForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/PhpCustomFormatFunctionsChooserForm";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormatIndexText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassFqn";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

