/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.config.PhpExtensionsManager;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpLanguageLevelDfaProcessor;
import com.jetbrains.php.lang.psi.PhpDeprecationProvider;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpExtensionBasedDeprecationProvider
implements PhpDeprecationProvider {
    @Override
    public boolean isDeprecated(@NotNull PhpNamedElement element, @NotNull String version) {
        if (element == null) {
            PhpExtensionBasedDeprecationProvider.$$$reportNull$$$0(0);
        }
        if (version == null) {
            PhpExtensionBasedDeprecationProvider.$$$reportNull$$$0(1);
        }
        return PhpExtensionBasedDeprecationProvider.getLanguageLevel(element).isAtLeast((PhpLanguageLevel)ObjectUtils.notNull((Object)PhpLanguageLevel.parse((String)version), (Object)PhpLanguageLevel.DEFAULT));
    }

    @NotNull
    private static PhpLanguageLevel getLanguageLevel(@NotNull PhpNamedElement element) {
        if (element == null) {
            PhpExtensionBasedDeprecationProvider.$$$reportNull$$$0(2);
        }
        PhpLanguageLevel phpLanguageLevel = PhpLanguageLevel.current((Project)element.getProject());
        if (phpLanguageLevel == null) {
            PhpExtensionBasedDeprecationProvider.$$$reportNull$$$0(3);
        }
        return phpLanguageLevel;
    }

    @Override
    public boolean isNotAvailable(@Nullable PsiElement context, @NotNull PhpNamedElement element, @NotNull String version) {
        PhpLanguageLevel parsedVersion;
        if (element == null) {
            PhpExtensionBasedDeprecationProvider.$$$reportNull$$$0(4);
        }
        if (version == null) {
            PhpExtensionBasedDeprecationProvider.$$$reportNull$$$0(5);
        }
        if ((parsedVersion = PhpLanguageLevel.parse((String)version)) != null && !PhpExtensionBasedDeprecationProvider.getLanguageLevel(element).isAtLeast(parsedVersion)) {
            if (context != null) {
                PhpLanguageLevel languageLevelFromDFAConditions = PhpLanguageLevelDfaProcessor.getCurrentLanguageLevelFromDFAConditions(context);
                return languageLevelFromDFAConditions == null || !languageLevelFromDFAConditions.isAtLeast(parsedVersion);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isAvailable(@NotNull PhpNamedElement element) {
        if (element == null) {
            PhpExtensionBasedDeprecationProvider.$$$reportNull$$$0(6);
        }
        return PhpExtensionsManager.getExtensionName(element) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/PhpExtensionBasedDeprecationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/PhpExtensionBasedDeprecationProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isDeprecated";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevel";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isNotAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

