/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config;

import com.google.common.collect.ImmutableMap;
import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.util.TreeChooser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.composer.ComposerConfigurationDialog;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.config.PhpAnalysisConfiguration;
import com.jetbrains.php.config.PhpAnalysisTab;
import com.jetbrains.php.config.PhpComposerFilesView;
import com.jetbrains.php.config.PhpCustomFormatFunction;
import com.jetbrains.php.config.PhpCustomFormatFunctionsChooserDialog;
import com.jetbrains.php.config.PhpCustomFormatFunctionsConfiguration;
import com.jetbrains.php.config.PhpExtensionsHolder;
import com.jetbrains.php.config.PhpExtensionsManager;
import com.jetbrains.php.config.PhpInterpreterConfigurationForm;
import com.jetbrains.php.config.PhpInterpreterFormProvider;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpLanguageLevelComboBox;
import com.jetbrains.php.config.PhpProjectConfigurableFormCollector;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.PhpProjectWorkspaceConfiguration;
import com.jetbrains.php.config.PhpRuntimeConfiguration;
import com.jetbrains.php.config.PhpRuntimeTab;
import com.jetbrains.php.config.PhpTreeClassChooserDialog;
import com.jetbrains.php.config.include.path.PhpIncludePathsView;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.library.PhpExtensionsDetectorKt;
import com.jetbrains.php.config.library.PhpIncludePathManager;
import com.jetbrains.php.config.library.PhpRuntimeLibraryRootsProvider;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.lang.inspections.PhpThrownExceptionsAnalyzer;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.util.ConfigurableForm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultRowSorter;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpProjectConfigurableForm
implements ConfigurableForm {
    private JPanel myMainPanel;
    private JBTabbedPane myTabbedPane;
    private JPanel myIncludePathPanel;
    private PhpIncludePathsView myIncludePathView;
    private PhpLanguageLevelComboBox myLanguageLevelComboBox;
    private JPanel myInterpreterPanel;
    private final CheckboxTree myExtensionTree;
    private final CheckedTreeNode myExtensionTreeRoot;
    private final TableView<Ref<String>> myUncheckedExceptionsTable;
    private final TableView<PhpCustomFormatFunction> myCustomFormatFunctionsTable;
    private ContextHelpLabel myLanguageLevelHelpLabel;
    private JPanel phpRuntimePanel;
    private JPanel phpAnalysisPanel;
    private JPanel myComposerConfigsPanel;
    private final PhpComposerFilesView myComposerFilesView;
    private final PhpRuntimeTab phpRuntimeTab;
    private final PhpAnalysisTab phpAnalysisTab;
    private final PhpInterpreterConfigurationForm myInterpreterConfigurationForm;
    private ItemListener myCallTreeAnalysisDepthItemListener;
    private static final String IMPORT_ALL_ITEM = new String();
    private final TableView<Ref<String>> myIncludePathTable;
    @NotNull
    private final Project myProject;
    private static final Map<String, PhpExtensionsManager.ExtensionCategory> EXTENSION_TO_CATEGORY;

    public PhpProjectConfigurableForm(@NotNull Project project, boolean restrictSizes, Disposable parentDisposable) {
        if (project == null) {
            PhpProjectConfigurableForm.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.myUncheckedExceptionsTable = new TableView();
        this.myCustomFormatFunctionsTable = new TableView();
        this.myIncludePathTable = new TableView();
        this.myProject = project;
        PhpProjectWorkspaceConfiguration.State projectConfig = PhpProjectConfigurationFacade.getInstance(this.myProject).getProjectConfiguration();
        this.myInterpreterConfigurationForm = PhpInterpreterFormProvider.createForm(project, projectConfig);
        this.myInterpreterPanel.setLayout(new BorderLayout());
        this.myInterpreterPanel.add((Component)this.myInterpreterConfigurationForm.getMainComponent(), "Center");
        if (Registry.is((String)"php.include.paths.tree.view", (boolean)true)) {
            this.myIncludePathView = new PhpIncludePathsView(project);
            this.myIncludePathPanel.add(this.myIncludePathView.getComponent());
        } else {
            ToolbarDecorator toolbarDecorator = this.initIncludePathTable();
            this.myIncludePathPanel.add((Component)toolbarDecorator.createPanel(), "Center");
        }
        this.myExtensionTreeRoot = new CheckedTreeNode((Object)"PHP Runtime");
        this.myExtensionTree = new CheckboxTree(new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                this.getTextRenderer().append((String)((CheckedTreeNode)value).getUserObject());
            }
        }, this.myExtensionTreeRoot){

            protected void installSpeedSearch() {
                TreeSpeedSearch.installOn((JTree)((Object)this), (boolean)true, path -> (String)((CheckedTreeNode)path.getLastPathComponent()).getUserObject());
            }
        };
        this.myExtensionTree.setRootVisible(true);
        this.myExtensionTree.setVisibleRowCount(10);
        this.phpRuntimeTab = new PhpRuntimeTab(this.myExtensionTree);
        this.phpRuntimePanel.add((Component)this.phpRuntimeTab.panel);
        this.buildExtensionTree();
        TreeUtil.expand((JTree)this.myExtensionTree, (int)1);
        this.phpRuntimeTab.myExtensionsValidationLabel.setVisible(false);
        this.myExtensionTree.addCheckboxTreeListener(new CheckboxTreeListener(){

            public void nodeStateChanged(@NotNull CheckedTreeNode node) {
                if (node == null) {
                    3.$$$reportNull$$$0(0);
                }
                CheckedTreeNode core = (CheckedTreeNode)PhpProjectConfigurableForm.this.myExtensionTreeRoot.getFirstChild();
                if (PhpExtensionsManager.ExtensionCategory.CORE.getName().equals(core.getUserObject()) && core.isNodeChild((TreeNode)node)) {
                    if (node.isChecked()) {
                        Enumeration children = core.children();
                        boolean allChecked = StreamEx.of((Enumeration)children).allMatch(CheckedTreeNode::isChecked);
                        PhpProjectConfigurableForm.this.phpRuntimeTab.myExtensionsValidationLabel.setVisible(!allChecked);
                    } else {
                        PhpProjectConfigurableForm.this.phpRuntimeTab.myExtensionsValidationLabel.setVisible(true);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/php/config/PhpProjectConfigurableForm$3", "nodeStateChanged"));
            }
        });
        this.phpRuntimeTab.mySyncExtensionsWithInterpreterButton.addActionListener(e -> {
            String interpreterName = this.myInterpreterConfigurationForm.getInterpreterName();
            PhpInfo phpInfo = PhpInterpretersPhpInfoCacheImpl.getInstance(project).getPhpInfo(interpreterName);
            if (phpInfo != null) {
                PhpExtensionsDetectorKt.detectAndApply(project, this, phpInfo, this.phpRuntimeTab.mySyncExtensionsWithInterpreterButton);
            }
        });
        this.myInterpreterConfigurationForm.addInterpreterListener(e -> {
            String interpreterName = this.myInterpreterConfigurationForm.getInterpreterName();
            PhpInfo phpInfo = PhpInterpretersPhpInfoCacheImpl.getInstance(project).getPhpInfo(interpreterName);
            this.phpRuntimeTab.mySyncExtensionsWithInterpreterButton.setEnabled(phpInfo != null);
        });
        FileChooserDescriptor stubsDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(PhpBundle.message("PhpProjectConfigurable.select.default.stubs.path.title", new Object[0])).withDescription(PhpBundle.message("PhpProjectConfigurable.select.default.stubs.path.description", new Object[0]));
        this.phpRuntimeTab.myDefaultStubsPath.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener((ComponentWithBrowseButton)this.phpRuntimeTab.myDefaultStubsPath, project, stubsDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT));
        this.logSelectedTab();
        this.myTabbedPane.addChangeListener(e -> {
            this.logSelectedTab();
            if (this.myTabbedPane.getSelectedIndex() == 1 && this.phpRuntimeTab.myDefaultStubsPath.getText().isEmpty()) {
                this.phpRuntimeTab.defaultStubsPathRow.setExpanded(false);
            }
        });
        ToolbarDecorator uncheckedExceptionsToolbarDecorator = PhpProjectConfigurableForm.initClassesTable(this.myProject, this.myUncheckedExceptionsTable, (TreeChooser.Filter<? super PhpClass>)((TreeChooser.Filter)phpClass -> PhpThrownExceptionsAnalyzer.isException(phpClass.getFQN(), PhpIndex.getInstance(this.myProject))));
        this.myUncheckedExceptionsTable.setShowGrid(false);
        this.myUncheckedExceptionsTable.getEmptyText().setText(PhpBundle.message("all.exceptions.considered.checked", new Object[0]));
        this.phpAnalysisTab = new PhpAnalysisTab(uncheckedExceptionsToolbarDecorator.createPanel(), this.createCustomFormatFunctionPanel());
        this.phpAnalysisPanel.add((Component)this.phpAnalysisTab.panel);
        FileChooserDescriptor rootDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(PhpBundle.message("PhpProjectConfigurable.select.document.root.path.title", new Object[0])).withDescription(PhpBundle.message("PhpProjectConfigurable.select.document.root.path.description", new Object[0]));
        this.phpAnalysisTab.myDocumentRootPath.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>((ComponentWithBrowseButton)this.phpAnalysisTab.myDocumentRootPath, project, rootDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            @NotNull
            protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
                String relativePath;
                VirtualFile baseDir;
                if (chosenFile == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (!PhpProjectConfigurableForm.this.myProject.isDefault() && (baseDir = PhpProjectConfigurableForm.this.myProject.getBaseDir()) != null && (relativePath = FileUtil.getRelativePath((String)baseDir.getPath(), (String)chosenFile.getPath(), (char)'/')) != null) {
                    String string = relativePath;
                    if (string == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                String string = super.chosenFileToResultingText(chosenFile);
                if (string == null) {
                    4.$$$reportNull$$$0(2);
                }
                return string;
            }

            @NotNull
            protected String expandPath(@NotNull String path) {
                if (path == null) {
                    4.$$$reportNull$$$0(3);
                }
                String string = PhpProjectConfigurableForm.doExpandPath(path, PhpProjectConfigurableForm.this.myProject);
                if (string == null) {
                    4.$$$reportNull$$$0(4);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "chosenFile";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/config/PhpProjectConfigurableForm$4";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/config/PhpProjectConfigurableForm$4";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "chosenFileToResultingText";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "expandPath";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "chosenFileToResultingText";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "expandPath";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2, 4 -> new IllegalStateException(string);
                };
            }
        });
        this.initCallTreeAnalysisDepthCombo();
        this.myComposerFilesView = new PhpComposerFilesView(this.myProject, parentDisposable);
        this.myComposerConfigsPanel.add(this.myComposerFilesView.getComponent());
        this.myLanguageLevelComboBox.setMinimumAndPreferredWidth(350);
        if (restrictSizes) {
            this.myInterpreterConfigurationForm.myInterpreterComboBox.setTextFieldPreferredWidth(38);
            this.myTabbedPane.setPreferredSize((Dimension)new JBDimension(-1, 250));
        }
        JComponent component = this.getComponent();
        ComponentAdapter componentAdapter = new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent event) {
                PhpProjectConfigurableForm.this.validate();
            }
        };
        component.addComponentListener(componentAdapter);
        Disposer.register((Disposable)parentDisposable, () -> component.removeComponentListener(componentAdapter));
        Disposer.register((Disposable)parentDisposable, (Disposable)this.myInterpreterConfigurationForm);
        Disposer.register((Disposable)parentDisposable, () -> HelpTooltip.dispose((Component)this.myLanguageLevelHelpLabel));
    }

    private ToolbarDecorator initIncludePathTable() {
        this.myIncludePathTable.setModelAndUpdateColumns(new ListTableModel(new ColumnInfo[]{new ColumnInfo<Ref<String>, String>(""){
            final TableCellRenderer myRenderer;
            {
                this.myRenderer = new ColoredTableCellRenderer(){

                    protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                        if (table == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        this.append(row + 1 + ". ");
                        if (value instanceof String) {
                            @NlsSafe String path = (String)value;
                            boolean hasError = FileUtil.isAbsolute((String)path) ? LocalFileSystem.getInstance().findFileByPath(path) == null : StringUtil.isEmptyOrSpaces((String)path);
                            this.append("\"" + path + "\"", !hasError ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.ERROR_ATTRIBUTES);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/php/config/PhpProjectConfigurableForm$6$1", "customizeCellRenderer"));
                    }
                };
            }

            public String valueOf(Ref<String> stringRef) {
                return (String)stringRef.get();
            }

            public boolean isCellEditable(Ref<String> stringRef) {
                return true;
            }

            public void setValue(Ref<String> stringRef, String value) {
                stringRef.set((Object)value);
            }

            public TableCellRenderer getRenderer(Ref<String> stringRef) {
                return this.myRenderer;
            }

            public TableCellEditor getEditor(Ref<String> o) {
                return new AbstractTableCellEditor(){
                    final TextFieldWithBrowseButton myComponent = new TextFieldWithBrowseButton();
                    {
                        this.myComponent.addBrowseFolderListener(new TextBrowseFolderListener(FileChooserDescriptorFactory.createSingleFolderDescriptor(), PhpProjectConfigurableForm.this.myProject){

                            @NotNull
                            protected String expandPath(@NotNull String path) {
                                if (path == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                String string = PhpProjectConfigurableForm.doExpandPath(path, PhpProjectConfigurableForm.this.myProject);
                                if (string == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                return string;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2;
                                Object[] objectArray3 = new Object[switch (n) {
                                    default -> 3;
                                    case 1 -> 2;
                                }];
                                switch (n) {
                                    default: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "path";
                                        break;
                                    }
                                    case 1: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "com/jetbrains/php/config/PhpProjectConfigurableForm$6$2$1";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "com/jetbrains/php/config/PhpProjectConfigurableForm$6$2$1";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "expandPath";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        objectArray = objectArray;
                                        objectArray[2] = "expandPath";
                                        break;
                                    }
                                    case 1: {
                                        break;
                                    }
                                }
                                String string = String.format(v0, objectArray);
                                throw switch (n) {
                                    default -> new IllegalArgumentException(string);
                                    case 1 -> new IllegalStateException(string);
                                };
                            }
                        });
                    }

                    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                        ((JTextField)this.myComponent.getChildComponent()).setText((String)value);
                        return this.myComponent;
                    }

                    public Object getCellEditorValue() {
                        return 2.getText((JTextField)this.myComponent.getChildComponent());
                    }

                    @NlsSafe
                    private static String getText(JTextField component) {
                        return component.getText();
                    }
                };
            }
        }}));
        this.myIncludePathTable.setShowGrid(false);
        this.myIncludePathTable.setTableHeader(null);
        this.myIncludePathTable.getEmptyText().setText(PhpBundle.message("PhpProjectConfigurable.provide.include.path", new Object[0]));
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator(this.myIncludePathTable, null);
        toolbarDecorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                List alreadyAddedPaths;
                final PhpInterpreter selectedInterpreter = PhpProjectConfigurableForm.this.findSelectedInterpreter();
                if (selectedInterpreter == null) {
                    PhpProjectConfigurableForm.this.doSpecifyOther();
                    return;
                }
                PhpInfo phpInfo = PhpInterpretersPhpInfoCacheImpl.getInstance(PhpProjectConfigurableForm.this.myProject).getPhpInfo(selectedInterpreter.getName());
                if (phpInfo == null) {
                    PhpProjectConfigurableForm.this.doSpecifyOther();
                    return;
                }
                List<String> cachedIncludePath = phpInfo.getIncludePath();
                final List notAddedIncludePath = ContainerUtil.filter(cachedIncludePath, arg_0 -> 7.lambda$run$0(alreadyAddedPaths = ContainerUtil.map((Collection)PhpProjectConfigurableForm.this.myIncludePathTable.getItems(), Ref::get), arg_0));
                if (notAddedIncludePath.size() == 0) {
                    PhpProjectConfigurableForm.this.doSpecifyOther();
                    return;
                }
                final ArrayList<String> popupList = new ArrayList<String>(notAddedIncludePath);
                popupList.add(0, null);
                if (notAddedIncludePath.size() > 1) {
                    popupList.add(1, IMPORT_ALL_ITEM);
                }
                BaseListPopupStep<String> phpHomeSteps = new BaseListPopupStep<String>(null, popupList){

                    @NotNull
                    public String getTextFor(@NlsSafe String value) {
                        if (value == null) {
                            String string = PhpBundle.message("PhpProjectConfigurable.specify.other", new Object[0]);
                            if (string == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return string;
                        }
                        if (Strings.areSameInstance((String)value, (String)IMPORT_ALL_ITEM)) {
                            String string = PhpBundle.message("PhpProjectConfigurable.all", new Object[0]);
                            if (string == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return string;
                        }
                        String string = "\"" + value + "\"";
                        if (string == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return string;
                    }

                    public PopupStep<?> onChosen(String selectedValue, boolean finalChoice) {
                        SwingUtilities.invokeLater(() -> {
                            if (selectedValue == null) {
                                PhpProjectConfigurableForm.this.doSpecifyOther();
                            } else if (Strings.areSameInstance((String)selectedValue, (String)IMPORT_ALL_ITEM)) {
                                PhpProjectConfigurableForm.this.addPathToIncludePathTable(notAddedIncludePath);
                            } else {
                                PhpProjectConfigurableForm.this.addPathToIncludePathTable(selectedValue);
                            }
                        });
                        return FINAL_CHOICE;
                    }

                    public ListSeparator getSeparatorAbove(String value) {
                        if (popupList.indexOf(value) == 1) {
                            return new ListSeparator(PhpBundle.message("PhpProjectConfigurable.0.interpreter.include.path", selectedInterpreter.getName()));
                        }
                        return super.getSeparatorAbove((Object)value);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/config/PhpProjectConfigurableForm$7$1", "getTextFor"));
                    }
                };
                JBPopupFactory.getInstance().createListPopup((ListPopupStep)phpHomeSteps).show(button.getPreferredPopupPoint());
            }

            private static /* synthetic */ boolean lambda$run$0(List alreadyAddedPaths, String s) {
                return !alreadyAddedPaths.contains(s) && FileUtil.isAbsolute((String)s);
            }
        });
        AnActionButtonUpdater moveUpDownUpdater = e -> {
            RowSorter sorter = this.myIncludePathTable.getRowSorter();
            if (sorter == null) {
                return true;
            }
            List<RowSorter.SortKey> keys = sorter.getSortKeys();
            if (keys == null) {
                return true;
            }
            for (RowSorter.SortKey key : keys) {
                if (key.getSortOrder() == SortOrder.UNSORTED) continue;
                return false;
            }
            return true;
        };
        toolbarDecorator.setMoveUpActionUpdater(moveUpDownUpdater);
        toolbarDecorator.setMoveDownActionUpdater(moveUpDownUpdater);
        toolbarDecorator.addExtraAction((AnAction)new DumbAwareToggleAction("", null, AllIcons.ObjectBrowser.Sorted){
            private boolean isSorted;
            {
                this.isSorted = false;
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    8.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(1);
                }
                super.update(e);
                e.getPresentation().setEnabled(PhpProjectConfigurableForm.this.myIncludePathTable.getRowCount() > 1);
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(2);
                }
                return this.isSorted;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    8.$$$reportNull$$$0(3);
                }
                this.isSorted = state;
                Ref selectedObject = (Ref)PhpProjectConfigurableForm.this.myIncludePathTable.getSelectedObject();
                PhpProjectConfigurableForm.this.myIncludePathTable.stopEditing();
                PhpProjectConfigurableForm.this.myIncludePathTable.setAutoCreateRowSorter(true);
                DefaultRowSorter sorter = (DefaultRowSorter)PhpProjectConfigurableForm.this.myIncludePathTable.getRowSorter();
                ArrayList<RowSorter.SortKey> list = new ArrayList<RowSorter.SortKey>();
                list.add(new RowSorter.SortKey(0, this.isSorted ? SortOrder.ASCENDING : SortOrder.UNSORTED));
                sorter.setSortKeys(list);
                sorter.sort();
                if (selectedObject != null && !selectedObject.isNull()) {
                    PhpProjectConfigurableForm.this.myIncludePathTable.setSelection(Collections.singleton(selectedObject));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 3 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/config/PhpProjectConfigurableForm$8";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/config/PhpProjectConfigurableForm$8";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2, 3 -> new IllegalArgumentException(string);
                };
            }
        });
        return toolbarDecorator;
    }

    private void logSelectedTab() {
        PhpProjectConfigurableFormCollector.Tabs[] values = PhpProjectConfigurableFormCollector.Tabs.values();
        int selectedIndex = this.myTabbedPane.getSelectedIndex();
        if (selectedIndex < values.length) {
            PhpProjectConfigurableFormCollector.logSelectedTab(values[selectedIndex]);
        }
    }

    public void openTab(@NotNull @Nls String label) {
        if (label == null) {
            PhpProjectConfigurableForm.$$$reportNull$$$0(1);
        }
        int count = this.myTabbedPane.getTabCount();
        for (int i = 0; i < count; ++i) {
            if (!label.equals(this.myTabbedPane.getTitleAt(i))) continue;
            this.myTabbedPane.setSelectedIndex(i);
            return;
        }
    }

    @NotNull
    public static ToolbarDecorator initClassesTable(@NotNull Project project, @NotNull TableView<Ref<String>> table, @NotNull TreeChooser.Filter<? super PhpClass> classFilter) {
        if (project == null) {
            PhpProjectConfigurableForm.$$$reportNull$$$0(2);
        }
        if (table == null) {
            PhpProjectConfigurableForm.$$$reportNull$$$0(3);
        }
        if (classFilter == null) {
            PhpProjectConfigurableForm.$$$reportNull$$$0(4);
        }
        table.setModelAndUpdateColumns(new ListTableModel(new ColumnInfo[]{new ColumnInfo<Ref<String>, String>(""){
            final TableCellRenderer myRenderer = new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    if (table == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (value instanceof String) {
                        this.append((String)value);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/php/config/PhpProjectConfigurableForm$9$1", "customizeCellRenderer"));
                }
            };

            public String valueOf(Ref<String> stringRef) {
                return (String)stringRef.get();
            }

            public boolean isCellEditable(Ref<String> stringRef) {
                return true;
            }

            public void setValue(Ref<String> stringRef, String value) {
                stringRef.set((Object)value);
            }

            public TableCellRenderer getRenderer(Ref<String> stringRef) {
                return this.myRenderer;
            }
        }}));
        table.setTableHeader(null);
        ToolbarDecorator tableToolbarDecorator = ToolbarDecorator.createDecorator(table, null).disableUpDownActions();
        if (project.isDefault()) {
            tableToolbarDecorator.setAddAction(button -> PhpProjectConfigurableForm.addToTable("\\", table));
        } else {
            tableToolbarDecorator.setAddAction(button -> {
                Set<String> classFqns = PhpProjectConfigurableForm.getClassFqns(table);
                TreeChooser.Filter filter = phpClass -> !classFqns.contains(phpClass.getFQN()) && classFilter.isAccepted(phpClass);
                PhpTreeClassChooserDialog chooser = new PhpTreeClassChooserDialog(PhpBundle.message("choose.class", new Object[0]), project, (TreeChooser.Filter<PhpClass>)filter);
                if (chooser.showAndGet()) {
                    PhpProjectConfigurableForm.addToTable(((PhpClass)chooser.getSelected()).getFQN(), table);
                }
            }).setAddActionName(PhpBundle.message("add.class", new Object[0])).setAddIcon(AllIcons.General.Add);
        }
        ToolbarDecorator toolbarDecorator = tableToolbarDecorator;
        if (toolbarDecorator == null) {
            PhpProjectConfigurableForm.$$$reportNull$$$0(5);
        }
        return toolbarDecorator;
    }

    private JPanel createCustomFormatFunctionPanel() {
        this.myCustomFormatFunctionsTable.setShowGrid(false);
        this.myCustomFormatFunctionsTable.setTableHeader(null);
        this.myCustomFormatFunctionsTable.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.myCustomFormatFunctionsTable.setModelAndUpdateColumns(new ListTableModel(new ColumnInfo[]{new ColumnInfo<PhpCustomFormatFunction, PhpCustomFormatFunction>(""){
            final TableCellRenderer myRenderer;
            {
                this.myRenderer = new ColoredTableCellRenderer(){

                    protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                        if (table == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (value instanceof PhpCustomFormatFunction) {
                            PhpCustomFormatFunction formatFunction = (PhpCustomFormatFunction)value;
                            this.append(formatFunction.getNamespaceName());
                            if (formatFunction.getClassName() != null) {
                                this.append(PhpBundle.message("02", formatFunction.getClassName()));
                            }
                            this.append(formatFunction.getFunctionName());
                            if (formatFunction.getFormatParameterIndex() > 0) {
                                this.append(":" + formatFunction.getFormatParameterIndex(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                            }
                            this.setIcon(formatFunction.isMethod() ? PhpIcons.METHOD : PhpIcons.FUNCTION);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/php/config/PhpProjectConfigurableForm$10$1", "customizeCellRenderer"));
                    }
                };
            }

            @NotNull
            public PhpCustomFormatFunction valueOf(PhpCustomFormatFunction s) {
                PhpCustomFormatFunction phpCustomFormatFunction = s;
                if (phpCustomFormatFunction == null) {
                    10.$$$reportNull$$$0(0);
                }
                return phpCustomFormatFunction;
            }

            @NotNull
            public TableCellRenderer getRenderer(PhpCustomFormatFunction s) {
                TableCellRenderer tableCellRenderer = this.myRenderer;
                if (tableCellRenderer == null) {
                    10.$$$reportNull$$$0(1);
                }
                return tableCellRenderer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/php/config/PhpProjectConfigurableForm$10";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "valueOf";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRenderer";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }}));
        return ToolbarDecorator.createDecorator(this.myCustomFormatFunctionsTable, null).disableUpDownActions().setAddActionName(PhpBundle.message("add.custom.format.function", new Object[0])).setAddAction(button -> {
            PhpCustomFormatFunction selected;
            PhpCustomFormatFunctionsChooserDialog dialog = new PhpCustomFormatFunctionsChooserDialog(this.myProject, PhpBundle.message("add.custom.format.function1", new Object[0]));
            if (dialog.showAndGet() && (selected = dialog.getSelected()) != null) {
                ListTableModel model = this.myCustomFormatFunctionsTable.getListTableModel();
                model.addRow((Object)selected);
                this.myCustomFormatFunctionsTable.setRowSelectionInterval(model.getRowCount() - 1, model.getRowCount() - 1);
            }
        }).setEditAction(button -> {
            PhpCustomFormatFunction format = (PhpCustomFormatFunction)this.myCustomFormatFunctionsTable.getSelectedObject();
            int selectedRow = this.myCustomFormatFunctionsTable.getSelectedRow();
            PhpCustomFormatFunctionsChooserDialog dialog = new PhpCustomFormatFunctionsChooserDialog(this.myProject, PhpBundle.message("edit.custom.format.function", new Object[0]), format);
            if (dialog.showAndGet()) {
                ListTableModel model = this.myCustomFormatFunctionsTable.getListTableModel();
                model.addRow((Object)dialog.getSelected());
                int lastRow = model.getRowCount() - 1;
                model.exchangeRows(selectedRow, lastRow);
                model.removeRow(lastRow);
                this.myCustomFormatFunctionsTable.setRowSelectionInterval(selectedRow, selectedRow);
            }
        }).createPanel();
    }

    @NotNull
    @NlsSafe
    private static String doExpandPath(@NotNull String path, @NotNull Project project) {
        if (path == null) {
            PhpProjectConfigurableForm.$$$reportNull$$$0(6);
        }
        if (project == null) {
            PhpProjectConfigurableForm.$$$reportNull$$$0(7);
        }
        if (FileUtil.isAbsolute((String)path)) {
            String string = path;
            if (string == null) {
                PhpProjectConfigurableForm.$$$reportNull$$$0(8);
            }
            return string;
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            String string = path;
            if (string == null) {
                PhpProjectConfigurableForm.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = FileUtil.toCanonicalPath((String)(baseDir.getPath() + "/" + path));
        if (string == null) {
            PhpProjectConfigurableForm.$$$reportNull$$$0(10);
        }
        return string;
    }

    private void validate() {
        boolean synchronize = ComposerDataService.getInstance(this.myProject).syncLanguageLevel();
        this.myLanguageLevelComboBox.setEnabled(!synchronize);
        this.myLanguageLevelHelpLabel.setVisible(synchronize);
    }

    private void buildExtensionTree() {
        this.myExtensionTreeRoot.removeAllChildren();
        LinkedHashMap categories = new LinkedHashMap();
        Arrays.stream(PhpExtensionsManager.ExtensionCategory.values()).forEach(category -> categories.put(category, new CheckedTreeNode((Object)category.getName())));
        Set<VirtualFile> extensions = PhpRuntimeLibraryRootsProvider.getLibraryRootsBeforeFiltering(this.myProject);
        for (VirtualFile extensionFile : ContainerUtil.sorted(extensions, Comparator.comparing(VirtualFile::getName, String::compareToIgnoreCase))) {
            String extension = extensionFile.getName();
            PhpExtensionsManager.ExtensionCategory category2 = EXTENSION_TO_CATEGORY.getOrDefault(extension, PhpExtensionsManager.ExtensionCategory.OTHERS);
            ((CheckedTreeNode)categories.get((Object)category2)).add((MutableTreeNode)new CheckedTreeNode((Object)extension));
        }
        for (CheckedTreeNode category3 : categories.values()) {
            if (category3.isLeaf()) continue;
            this.myExtensionTreeRoot.add((MutableTreeNode)category3);
        }
        ((DefaultTreeModel)this.myExtensionTree.getModel()).reload();
    }

    private void initCallTreeAnalysisDepthCombo() {
        Integer[] items = (Integer[])IntStream.rangeClosed(0, 3).boxed().toArray(Integer[]::new);
        this.phpAnalysisTab.myCallTreeAnalysisDepth.setModel(new DefaultComboBoxModel<Integer>(items));
        this.myCallTreeAnalysisDepthItemListener = new ItemListener(){
            private int prev;

            @Override
            public void itemStateChanged(ItemEvent event) {
                int item = (Integer)event.getItem();
                if (event.getStateChange() == 2) {
                    this.prev = item;
                } else if (event.getStateChange() == 1 && item > this.prev && item > 1 && !((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.okCancel((String)PhpBundle.message("phpdoc.code.style.throws.analysis.depth.performance.note.title", new Object[0]), (String)PhpBundle.message("phpdoc.code.style.throws.analysis.depth.performance.note.message", new Object[0])).yesText(PhpBundle.message("proceed", new Object[0]))).icon(Messages.getWarningIcon())).ask(PhpProjectConfigurableForm.this.myProject)) {
                    PhpProjectConfigurableForm.this.setCallTreeAnalysisDepthIndexWithoutEvent(this.prev);
                }
            }
        };
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            PhpProjectConfigurableForm.$$$reportNull$$$0(11);
        }
        return jPanel;
    }

    @Nullable
    public String getInterpreterName() {
        return this.myInterpreterConfigurationForm.getInterpreterName();
    }

    @NotNull
    public PhpLanguageLevel getLanguageLevel() {
        PhpLanguageLevel phpLanguageLevel = this.myLanguageLevelComboBox.getLanguageLevel();
        if (phpLanguageLevel == null) {
            PhpProjectConfigurableForm.$$$reportNull$$$0(12);
        }
        return phpLanguageLevel;
    }

    @NotNull
    public List<String> getIncludePath() {
        List<String> list = PhpDebugUtil.unwrap(this.myIncludePathTable.getListTableModel().getItems());
        if (list == null) {
            PhpProjectConfigurableForm.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public String getDefaultStubsPath() {
        String string = this.phpRuntimeTab.myDefaultStubsPath.getText();
        if (string == null) {
            PhpProjectConfigurableForm.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public String getDocumentRootPath() {
        String string = this.phpAnalysisTab.myDocumentRootPath.getText();
        if (string == null) {
            PhpProjectConfigurableForm.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Nullable
    private PhpInterpreter findSelectedInterpreter() {
        return this.myInterpreterConfigurationForm.findSelectedInterpreter();
    }

    private void doSpecifyOther() {
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor(), (Project)this.myProject, null);
        if (file == null) {
            this.addPathToIncludePathTable("");
        } else {
            this.addPathToIncludePathTable(file.getPresentableUrl());
        }
    }

    private void addPathToIncludePathTable(@NotNull String path) {
        if (path == null) {
            PhpProjectConfigurableForm.$$$reportNull$$$0(16);
        }
        this.addPathToIncludePathTable(Collections.singletonList(path));
    }

    private void addPathToIncludePathTable(@NotNull List<String> paths) {
        if (paths == null) {
            PhpProjectConfigurableForm.$$$reportNull$$$0(17);
        }
        PhpProjectConfigurableForm.addToTable(paths, this.myIncludePathTable);
    }

    private static void addToTable(@NotNull String path, @NotNull TableView<Ref<String>> table) {
        if (path == null) {
            PhpProjectConfigurableForm.$$$reportNull$$$0(18);
        }
        if (table == null) {
            PhpProjectConfigurableForm.$$$reportNull$$$0(19);
        }
        PhpProjectConfigurableForm.addToTable(Collections.singletonList(path), table);
    }

    private static void addToTable(@NotNull List<String> paths, @NotNull TableView<Ref<String>> table) {
        if (paths == null) {
            PhpProjectConfigurableForm.$$$reportNull$$$0(20);
        }
        if (table == null) {
            PhpProjectConfigurableForm.$$$reportNull$$$0(21);
        }
        ListTableModel tableModel = table.getListTableModel();
        TableUtil.stopEditing(table);
        int rowCount = table.getRowCount();
        tableModel.addRows(PhpDebugUtil.wrap(paths));
        if (rowCount == table.getRowCount()) {
            return;
        }
        int index = tableModel.getRowCount() - 1;
        table.editCellAt(index, 0);
        table.setRowSelectionInterval(index - paths.size() + 1, index);
        table.setColumnSelectionInterval(0, 0);
        table.getParent().repaint();
        Component editorComponent = table.getEditorComponent();
        if (editorComponent != null) {
            Rectangle bounds = editorComponent.getBounds();
            table.scrollRectToVisible(bounds);
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(editorComponent, true));
        }
    }

    @Override
    public boolean isModified() {
        PhpAnalysisConfiguration analysisConfiguration;
        if (this.myInterpreterConfigurationForm.isModified()) {
            return true;
        }
        PhpRuntimeConfiguration runtimeConfiguration = PhpRuntimeConfiguration.getInstance(this.myProject);
        if (!PhpRuntimeConfiguration.getExtensionsWithoutDefault(this.getExtensions()).equals(PhpRuntimeConfiguration.getExtensionsWithoutDefault(runtimeConfiguration.getExtensions()))) {
            return true;
        }
        if (!this.getDefaultStubsPath().equals(runtimeConfiguration.getDefaultStubsPath())) {
            return true;
        }
        if (!this.getDocumentRootPath().equals(runtimeConfiguration.getDocumentRootPath())) {
            return true;
        }
        PhpProjectConfigurationFacade configurationFacade = PhpProjectConfigurationFacade.getInstance(this.myProject);
        if (this.myLanguageLevelComboBox.getSelectedItem() != configurationFacade.getLanguageLevel()) {
            return true;
        }
        if (Registry.is((String)"php.include.paths.tree.view", (boolean)false)) {
            if (this.myIncludePathView.isModified()) {
                return true;
            }
        } else {
            PhpIncludePathManager includePathManager = PhpIncludePathManager.getInstance(this.myProject);
            if (!PhpDebugUtil.unwrap(this.myIncludePathTable.getListTableModel().getItems()).equals(includePathManager.getIncludePath())) {
                return true;
            }
        }
        if ((analysisConfiguration = PhpAnalysisConfiguration.getInstance(this.myProject)).getCallTreeAnalysisDepth() != this.getCallTreeAnalysisDepth()) {
            return true;
        }
        if (!this.getUncheckedExceptions().equals(analysisConfiguration.getUncheckedExceptions())) {
            return true;
        }
        if (this.getSkipConstantParams() != analysisConfiguration.getSkipConstantParams()) {
            return true;
        }
        if (!this.getCustomFormatFunctions().equals(PhpCustomFormatFunctionsConfiguration.getInstance(this.myProject).getFunctions())) {
            return true;
        }
        return this.myComposerFilesView.isModified();
    }

    @Override
    public void apply() {
        this.myInterpreterConfigurationForm.apply();
        PhpProjectConfigurationFacade projectConfigurationFacade = PhpProjectConfigurationFacade.getInstance(this.myProject);
        projectConfigurationFacade.setLanguageLevel(this.getLanguageLevel());
        PhpRuntimeConfiguration runtimeConfiguration = PhpRuntimeConfiguration.getInstance(this.myProject);
        if (!this.getDefaultStubsPath().equals(runtimeConfiguration.getDefaultStubsPath())) {
            Map<String, Boolean> extensions = this.getExtensions();
            this.buildExtensionTree();
            this.setExtensions(extensions);
        }
        runtimeConfiguration.setExtensions(this.getExtensions());
        runtimeConfiguration.setDefaultStubsPath(this.getDefaultStubsPath());
        runtimeConfiguration.setDocumentRootPath(this.getDocumentRootPath());
        if (Registry.is((String)"php.include.paths.tree.view", (boolean)false)) {
            this.myIncludePathView.apply();
        } else {
            PhpIncludePathManager.getInstance(this.myProject).setIncludePath(this.getIncludePath());
        }
        PhpAnalysisConfiguration analysisConfiguration = PhpAnalysisConfiguration.getInstance(this.myProject);
        analysisConfiguration.setCallTreeAnalysisDepth(this.getCallTreeAnalysisDepth());
        analysisConfiguration.setUncheckedExceptions(this.getUncheckedExceptions());
        analysisConfiguration.setSkipConstantParams(this.getSkipConstantParams());
        PhpCustomFormatFunctionsConfiguration formatFunctionsConfiguration = PhpCustomFormatFunctionsConfiguration.getInstance(this.myProject);
        formatFunctionsConfiguration.setCustomFormatFunctions(this.getCustomFormatFunctions());
        this.myComposerFilesView.apply();
    }

    @NotNull
    private List<PhpCustomFormatFunction> getCustomFormatFunctions() {
        List list = this.myCustomFormatFunctionsTable.getListTableModel().getItems();
        if (list == null) {
            PhpProjectConfigurableForm.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    public Map<String, Boolean> getExtensions() {
        HashMap<String, Boolean> extensions = new HashMap<String, Boolean>();
        TreeUtil.treeNodeTraverser((TreeNode)this.myExtensionTreeRoot).traverse(TreeTraversal.POST_ORDER_DFS).processEach(node -> {
            CheckedTreeNode leaf = (CheckedTreeNode)node;
            if (leaf.isLeaf()) {
                extensions.put((String)leaf.getUserObject(), leaf.isChecked());
            }
            return true;
        });
        HashMap<String, Boolean> hashMap = extensions;
        if (hashMap == null) {
            PhpProjectConfigurableForm.$$$reportNull$$$0(23);
        }
        return hashMap;
    }

    public int getCallTreeAnalysisDepth() {
        return (Integer)this.phpAnalysisTab.myCallTreeAnalysisDepth.getSelectedItem();
    }

    public boolean getSkipConstantParams() {
        return this.phpAnalysisTab.mySkipConstantParams.isSelected();
    }

    @NotNull
    public Set<String> getUncheckedExceptions() {
        return PhpProjectConfigurableForm.getClassFqns(this.myUncheckedExceptionsTable);
    }

    @NotNull
    private static Set<String> getClassFqns(@NotNull TableView<Ref<String>> table) {
        if (table == null) {
            PhpProjectConfigurableForm.$$$reportNull$$$0(24);
        }
        Set set = StreamEx.of((Collection)table.getListTableModel().getItems()).map(Ref::get).toSet();
        if (set == null) {
            PhpProjectConfigurableForm.$$$reportNull$$$0(25);
        }
        return set;
    }

    @Override
    public void reset() {
        this.myInterpreterConfigurationForm.reset();
        PhpProjectConfigurationFacade configurationFacade = PhpProjectConfigurationFacade.getInstance(this.myProject);
        this.myLanguageLevelComboBox.setLanguageLevel(configurationFacade.getLanguageLevel());
        PhpRuntimeConfiguration runtimeConfiguration = PhpRuntimeConfiguration.getInstance(this.myProject);
        if (!this.getDefaultStubsPath().equals(runtimeConfiguration.getDefaultStubsPath())) {
            this.buildExtensionTree();
        }
        this.setExtensions(runtimeConfiguration.getExtensions());
        this.phpRuntimeTab.myDefaultStubsPath.setText(runtimeConfiguration.getDefaultStubsPath());
        this.phpAnalysisTab.myDocumentRootPath.setText(runtimeConfiguration.getDocumentRootPath());
        if (Registry.is((String)"php.include.paths.tree.view", (boolean)false)) {
            this.myIncludePathView.reset();
        } else {
            ArrayList items = PhpDebugUtil.wrap(PhpIncludePathManager.getInstance(this.myProject).getIncludePath());
            this.myIncludePathTable.getListTableModel().setItems((List)(items.isEmpty() ? new ArrayList() : items));
        }
        PhpAnalysisConfiguration analysisConfiguration = PhpAnalysisConfiguration.getInstance(this.myProject);
        this.setCallTreeAnalysisDepthIndexWithoutEvent(Integer.min(analysisConfiguration.getCallTreeAnalysisDepth(), 3));
        this.setSkipConstantParams(analysisConfiguration.getSkipConstantParams());
        this.myUncheckedExceptionsTable.getListTableModel().setItems(new ArrayList<Ref<String>>(PhpDebugUtil.wrap(analysisConfiguration.getUncheckedExceptions())));
        ArrayList<PhpCustomFormatFunction> functions = new ArrayList<PhpCustomFormatFunction>(PhpCustomFormatFunctionsConfiguration.getInstance(this.myProject).getFunctions());
        this.myCustomFormatFunctionsTable.getListTableModel().setItems(functions);
        this.phpAnalysisTab.customFormatFunctionsRow.setExpanded(!functions.isEmpty());
        this.myComposerFilesView.reset();
    }

    public void setExtensions(@NotNull Map<String, Boolean> extensions) {
        if (extensions == null) {
            PhpProjectConfigurableForm.$$$reportNull$$$0(26);
        }
        TreeUtil.treeNodeTraverser((TreeNode)this.myExtensionTreeRoot).traverse(TreeTraversal.POST_ORDER_DFS).processEach(node -> {
            CheckedTreeNode leaf = (CheckedTreeNode)node;
            if (leaf.isLeaf()) {
                this.myExtensionTree.setNodeState(leaf, extensions.getOrDefault((String)leaf.getUserObject(), true).booleanValue());
            }
            return true;
        });
    }

    private void setCallTreeAnalysisDepthIndexWithoutEvent(int index) {
        try {
            this.phpAnalysisTab.myCallTreeAnalysisDepth.removeItemListener(this.myCallTreeAnalysisDepthItemListener);
            this.phpAnalysisTab.myCallTreeAnalysisDepth.setSelectedIndex(index);
        }
        finally {
            this.phpAnalysisTab.myCallTreeAnalysisDepth.addItemListener(this.myCallTreeAnalysisDepthItemListener);
        }
    }

    private void setSkipConstantParams(boolean value) {
        this.phpAnalysisTab.mySkipConstantParams.setSelected(value);
    }

    private void createUIComponents() {
        String title = PhpBundle.message("action.detect.settings.sync.turned.on.title", new Object[0]);
        String description = PhpBundle.message("action.detect.settings.sync.turned.on", new Object[0]);
        String link = PhpBundle.message("actions.detect.common.setting.from.composer.show.settings", new Object[0]);
        this.myLanguageLevelHelpLabel = ContextHelpLabel.createWithLink((String)title, (String)description, (String)link, () -> {
            ComposerDataService dataService = ComposerDataService.getInstance(this.myProject);
            boolean okDialog = new ComposerConfigurationDialog(this.myProject, dataService, true, false).showAndGet();
            if (okDialog) {
                this.validate();
            }
        });
    }

    public void openPhpRuntimeTab(boolean openDefaultStubsPanel, @Nullable String extension) {
        this.myTabbedPane.setSelectedIndex(1);
        if (openDefaultStubsPanel) {
            this.phpRuntimeTab.defaultStubsPathRow.setExpanded(true);
        }
        if (extension != null) {
            TreeUtil.treeNodeTraverser((TreeNode)this.myExtensionTreeRoot).traverse(TreeTraversal.POST_ORDER_DFS).processEach(node -> {
                CheckedTreeNode leaf = (CheckedTreeNode)node;
                if (leaf.isLeaf() && extension.equals(leaf.getUserObject())) {
                    TreePath path = TreeUtil.getPath((TreeNode)this.myExtensionTreeRoot, (TreeNode)leaf);
                    TreeUtil.selectPath((JTree)this.myExtensionTree, (TreePath)path);
                }
                return true;
            });
        }
    }

    @NotNull
    public static Map<String, PhpExtensionsManager.ExtensionCategory> getExtensionToCategory() {
        Map<String, PhpExtensionsManager.ExtensionCategory> map = EXTENSION_TO_CATEGORY;
        if (map == null) {
            PhpProjectConfigurableForm.$$$reportNull$$$0(27);
        }
        return map;
    }

    static {
        ImmutableMap.Builder builder2 = ImmutableMap.builder();
        PhpExtensionsHolder manager = PhpExtensionsManager.getHolderInstance();
        for (PhpExtensionsManager.ExtensionCategory category : PhpExtensionsManager.ExtensionCategory.values()) {
            for (String name : manager.getAllExtensionsNames(category)) {
                builder2.put((Object)name, (Object)category);
            }
        }
        EXTENSION_TO_CATEGORY = builder2.build();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JBTabbedPane jBTabbedPane;
        PhpLanguageLevelComboBox phpLanguageLevelComboBox;
        JPanel jPanel5;
        JPanel jPanel6;
        this.createUIComponents();
        this.myMainPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        this.myInterpreterPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel5, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.putClientProperty("BorderFactoryClass", "");
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpProjectConfigurableForm.class).getString("PhpProjectConfigurable.language.level"));
        jPanel8.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel9, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myLanguageLevelComboBox = phpLanguageLevelComboBox = new PhpLanguageLevelComboBox();
        jPanel9.add((Component)((Object)phpLanguageLevelComboBox), new GridConstraints(0, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        ContextHelpLabel contextHelpLabel = this.myLanguageLevelHelpLabel;
        contextHelpLabel.setAlignmentY(0.0f);
        contextHelpLabel.setHorizontalAlignment(2);
        contextHelpLabel.setIconTextGap(0);
        jPanel9.add((Component)contextHelpLabel, new GridConstraints(0, 1, 1, 1, 8, 2, 0, 3, null, null, null));
        this.myTabbedPane = jBTabbedPane = new JBTabbedPane();
        jPanel6.add((Component)jBTabbedPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab(DynamicBundle.getBundle((String)"messages/PhpBundle", PhpProjectConfigurableForm.class).getString("PhpProjectConfigurable.include.path"), null, jPanel10, null);
        this.myIncludePathPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel10.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.phpRuntimePanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jBTabbedPane.addTab(DynamicBundle.getBundle((String)"messages/PhpBundle", PhpProjectConfigurableForm.class).getString("PhpProjectConfigurable.php.runtime"), null, jPanel3, null);
        this.phpAnalysisPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jBTabbedPane.addTab(DynamicBundle.getBundle((String)"messages/PhpBundle", PhpProjectConfigurableForm.class).getString("PhpProjectConfigurable.analysis"), null, jPanel2, null);
        this.myComposerConfigsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jBTabbedPane.addTab(DynamicBundle.getBundle((String)"messages/PhpBundle", PhpProjectConfigurableForm.class).getString("php.project.configurable.composer.configs.tab.name"), null, jPanel, null);
        jBLabel.setLabelFor((Component)((Object)phpLanguageLevelComboBox));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8, 9, 10, 11, 12, 13, 14, 15, 22, 23, 25, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 3: 
            case 19: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFilter";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 22: 
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/PhpProjectConfigurableForm";
                break;
            }
            case 6: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/PhpProjectConfigurableForm";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "initClassesTable";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doExpandPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludePath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultStubsPath";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentRootPath";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomFormatFunctions";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassFqns";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionToCategory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "openTab";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "initClassesTable";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 22: 
            case 23: 
            case 25: 
            case 27: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doExpandPath";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addPathToIncludePathTable";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addToTable";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getClassFqns";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setExtensions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8, 9, 10, 11, 12, 13, 14, 15, 22, 23, 25, 27 -> new IllegalStateException(string);
        };
    }
}

