/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.include.path;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.config.library.PhpIncludePathManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00062\b\b\u0002\u0010 \u001a\u00020\u001eJ\u0018\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00062\b\b\u0002\u0010 \u001a\u00020\u001eJ\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017H\u0002J\u0006\u0010#\u001a\u00020$J\n\u0010%\u001a\u0004\u0018\u00010\u0006H\u0002J\u0006\u0010&\u001a\u00020$J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003JS\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010-\u001a\u00020\u001e2\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010/\u001a\u000200H\u00d6\u0001J\t\u00101\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\"\u0010\u0014\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R*\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u00172\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000f\u00a8\u00062"}, d2={"Lcom/jetbrains/php/config/include/path/PhpIncludePathsModel;", "", "project", "Lcom/intellij/openapi/project/Project;", "addedIncludePaths", "", "", "removedIncludePaths", "addedExcludedPaths", "removedExcludedPaths", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getAddedIncludePaths", "()Ljava/util/Set;", "getRemovedIncludePaths", "getAddedExcludedPaths", "getRemovedExcludedPaths", "value", "basePath", "getBasePath", "()Ljava/lang/String;", "", "externalIncludes", "getExternalIncludes", "getAllIncludedPaths", "getAllExcludedPaths", "getInvalidPaths", "isUnderExcluded", "", "path", "strict", "isUnderIncluded", "computeExternalIncludes", "updateBasePath", "", "computeBasePath", "clear", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "intellij.php.impl"})
@SourceDebugExtension(value={"SMAP\nPhpIncludePathsModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpIncludePathsModel.kt\ncom/jetbrains/php/config/include/path/PhpIncludePathsModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n774#2:67\n865#2,2:68\n1755#2,3:70\n1755#2,3:73\n774#2:76\n865#2:77\n866#2:79\n774#2:80\n865#2,2:81\n1557#2:83\n1628#2,3:84\n2737#2,7:87\n1#3:78\n*S KotlinDebug\n*F\n+ 1 PhpIncludePathsModel.kt\ncom/jetbrains/php/config/include/path/PhpIncludePathsModel\n*L\n34#1:67\n34#1:68,2\n38#1:70,3\n39#1:73,3\n42#1:76\n42#1:77\n42#1:79\n53#1:80\n53#1:81,2\n54#1:83\n54#1:84,3\n55#1:87,7\n*E\n"})
public final class PhpIncludePathsModel {
    @NotNull
    private final Project project;
    @NotNull
    private final Set<String> addedIncludePaths;
    @NotNull
    private final Set<String> removedIncludePaths;
    @NotNull
    private final Set<String> addedExcludedPaths;
    @NotNull
    private final Set<String> removedExcludedPaths;
    @Nullable
    private String basePath;
    @NotNull
    private Set<String> externalIncludes;

    public PhpIncludePathsModel(@NotNull Project project, @NotNull Set<String> addedIncludePaths, @NotNull Set<String> removedIncludePaths, @NotNull Set<String> addedExcludedPaths, @NotNull Set<String> removedExcludedPaths) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(addedIncludePaths, (String)"addedIncludePaths");
        Intrinsics.checkNotNullParameter(removedIncludePaths, (String)"removedIncludePaths");
        Intrinsics.checkNotNullParameter(addedExcludedPaths, (String)"addedExcludedPaths");
        Intrinsics.checkNotNullParameter(removedExcludedPaths, (String)"removedExcludedPaths");
        this.project = project;
        this.addedIncludePaths = addedIncludePaths;
        this.removedIncludePaths = removedIncludePaths;
        this.addedExcludedPaths = addedExcludedPaths;
        this.removedExcludedPaths = removedExcludedPaths;
        this.basePath = this.computeBasePath();
        this.externalIncludes = this.computeExternalIncludes();
    }

    public /* synthetic */ PhpIncludePathsModel(Project project, Set set, Set set2, Set set3, Set set4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            set = new LinkedHashSet();
        }
        if ((n & 4) != 0) {
            set2 = new LinkedHashSet();
        }
        if ((n & 8) != 0) {
            set3 = new LinkedHashSet();
        }
        if ((n & 0x10) != 0) {
            set4 = new LinkedHashSet();
        }
        this(project, set, set2, set3, set4);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Set<String> getAddedIncludePaths() {
        return this.addedIncludePaths;
    }

    @NotNull
    public final Set<String> getRemovedIncludePaths() {
        return this.removedIncludePaths;
    }

    @NotNull
    public final Set<String> getAddedExcludedPaths() {
        return this.addedExcludedPaths;
    }

    @NotNull
    public final Set<String> getRemovedExcludedPaths() {
        return this.removedExcludedPaths;
    }

    @Nullable
    public final String getBasePath() {
        return this.basePath;
    }

    @NotNull
    public final Set<String> getExternalIncludes() {
        return this.externalIncludes;
    }

    @NotNull
    public final Set<String> getAllIncludedPaths() {
        List<String> list = PhpIncludePathManager.getInstance(this.project).getIncludePath();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getIncludePath(...)");
        return CollectionsKt.toSet((Iterable)SetsKt.minus((Set)SetsKt.plus(this.addedIncludePaths, (Iterable)list), (Iterable)this.removedIncludePaths));
    }

    @NotNull
    public final Set<String> getAllExcludedPaths() {
        Collection<String> collection = PhpIncludePathManager.getInstance(this.project).getExcludePath();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getExcludePath(...)");
        return CollectionsKt.toSet((Iterable)SetsKt.minus((Set)SetsKt.plus(this.addedExcludedPaths, (Iterable)collection), (Iterable)this.removedExcludedPaths));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> getInvalidPaths() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = SetsKt.plus(this.getAllIncludedPaths(), (Iterable)this.getAllExcludedPaths());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(it);
            if (!(!(virtualFile != null ? virtualFile.isValid() : false))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public final boolean isUnderExcluded(@NotNull String path, boolean strict) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Iterable $this$any$iv = this.getAllExcludedPaths();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!FileUtil.isAncestor((String)it, (String)path, (boolean)strict)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean isUnderExcluded$default(PhpIncludePathsModel phpIncludePathsModel, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return phpIncludePathsModel.isUnderExcluded(string, bl);
    }

    public final boolean isUnderIncluded(@NotNull String path, boolean strict) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Iterable $this$any$iv = this.getAllIncludedPaths();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!FileUtil.isAncestor((String)it, (String)path, (boolean)strict)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean isUnderIncluded$default(PhpIncludePathsModel phpIncludePathsModel, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return phpIncludePathsModel.isUnderIncluded(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> computeExternalIncludes() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getAllIncludedPaths();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            String include = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.basePath != null) {
                String it;
                boolean bl3 = false;
                bl = !FileUtil.isAncestor((String)it, (String)include, (boolean)true);
            } else {
                bl = true;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public final void updateBasePath() {
        this.basePath = this.computeBasePath();
        this.externalIncludes = this.computeExternalIncludes();
    }

    /*
     * WARNING - void declaration
     */
    private final String computeBasePath() {
        Object v3;
        void $this$mapTo$iv$iv;
        String include;
        Iterable $this$filterTo$iv$iv;
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)this.project);
        String projectDir = virtualFile != null ? virtualFile.getPath() : null;
        Iterable $this$filter$iv = this.getAllIncludedPaths();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            include = (String)element$iv$iv;
            boolean bl2 = false;
            if (projectDir != null) {
                String it;
                boolean bl3 = false;
                bl = FileUtil.isAncestor((String)it, (String)include, (boolean)true);
            } else {
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            include = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path path = Paths.get((String)it, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            collection.add(path);
        }
        Iterable $this$reduceOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$reduceOrNull = false;
        Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v3 = null;
        } else {
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void path2;
                Path $i$f$mapTo2 = (Path)iterator$iv.next();
                Path path1 = (Path)accumulator$iv;
                boolean bl = false;
                Path path = FileUtil.findAncestor((Path)path1, (Path)path2);
                if (path == null) {
                    path = path1;
                }
                accumulator$iv = path;
            }
            v3 = accumulator$iv;
        }
        Path path = v3;
        return path != null ? PathsKt.getInvariantSeparatorsPathString((Path)path) : null;
    }

    public final void clear() {
        this.removedIncludePaths.clear();
        this.addedIncludePaths.clear();
        this.removedExcludedPaths.clear();
        this.addedExcludedPaths.clear();
    }

    @NotNull
    public final Project component1() {
        return this.project;
    }

    @NotNull
    public final Set<String> component2() {
        return this.addedIncludePaths;
    }

    @NotNull
    public final Set<String> component3() {
        return this.removedIncludePaths;
    }

    @NotNull
    public final Set<String> component4() {
        return this.addedExcludedPaths;
    }

    @NotNull
    public final Set<String> component5() {
        return this.removedExcludedPaths;
    }

    @NotNull
    public final PhpIncludePathsModel copy(@NotNull Project project, @NotNull Set<String> addedIncludePaths, @NotNull Set<String> removedIncludePaths, @NotNull Set<String> addedExcludedPaths, @NotNull Set<String> removedExcludedPaths) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(addedIncludePaths, (String)"addedIncludePaths");
        Intrinsics.checkNotNullParameter(removedIncludePaths, (String)"removedIncludePaths");
        Intrinsics.checkNotNullParameter(addedExcludedPaths, (String)"addedExcludedPaths");
        Intrinsics.checkNotNullParameter(removedExcludedPaths, (String)"removedExcludedPaths");
        return new PhpIncludePathsModel(project, addedIncludePaths, removedIncludePaths, addedExcludedPaths, removedExcludedPaths);
    }

    public static /* synthetic */ PhpIncludePathsModel copy$default(PhpIncludePathsModel phpIncludePathsModel, Project project, Set set, Set set2, Set set3, Set set4, int n, Object object) {
        if ((n & 1) != 0) {
            project = phpIncludePathsModel.project;
        }
        if ((n & 2) != 0) {
            set = phpIncludePathsModel.addedIncludePaths;
        }
        if ((n & 4) != 0) {
            set2 = phpIncludePathsModel.removedIncludePaths;
        }
        if ((n & 8) != 0) {
            set3 = phpIncludePathsModel.addedExcludedPaths;
        }
        if ((n & 0x10) != 0) {
            set4 = phpIncludePathsModel.removedExcludedPaths;
        }
        return phpIncludePathsModel.copy(project, set, set2, set3, set4);
    }

    @NotNull
    public String toString() {
        return "PhpIncludePathsModel(project=" + this.project + ", addedIncludePaths=" + this.addedIncludePaths + ", removedIncludePaths=" + this.removedIncludePaths + ", addedExcludedPaths=" + this.addedExcludedPaths + ", removedExcludedPaths=" + this.removedExcludedPaths + ")";
    }

    public int hashCode() {
        int result = this.project.hashCode();
        result = result * 31 + ((Object)this.addedIncludePaths).hashCode();
        result = result * 31 + ((Object)this.removedIncludePaths).hashCode();
        result = result * 31 + ((Object)this.addedExcludedPaths).hashCode();
        result = result * 31 + ((Object)this.removedExcludedPaths).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PhpIncludePathsModel)) {
            return false;
        }
        PhpIncludePathsModel phpIncludePathsModel = (PhpIncludePathsModel)other;
        if (!Intrinsics.areEqual((Object)this.project, (Object)phpIncludePathsModel.project)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.addedIncludePaths, phpIncludePathsModel.addedIncludePaths)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.removedIncludePaths, phpIncludePathsModel.removedIncludePaths)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.addedExcludedPaths, phpIncludePathsModel.addedExcludedPaths)) {
            return false;
        }
        return Intrinsics.areEqual(this.removedExcludedPaths, phpIncludePathsModel.removedExcludedPaths);
    }
}

