/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.include.path;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.include.path.ExcludeAction;
import com.jetbrains.php.config.include.path.PhpIncludeFileTree;
import com.jetbrains.php.config.include.path.PhpIncludePathsModel;
import com.jetbrains.php.config.library.PhpIncludePathManager;
import com.jetbrains.php.util.ConfigurableForm;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/php/config/include/path/PhpIncludePathsView;", "Lcom/jetbrains/php/util/ConfigurableForm;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "projectDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "model", "Lcom/jetbrains/php/config/include/path/PhpIncludePathsModel;", "tree", "Lcom/jetbrains/php/config/include/path/PhpIncludeFileTree;", "component", "Lcom/intellij/openapi/ui/DialogPanel;", "isRemoveActionAvailable", "", "addAction", "", "removeAction", "getComponent", "Ljavax/swing/JComponent;", "isModified", "apply", "reset", "intellij.php.impl"})
@SourceDebugExtension(value={"SMAP\nPhpIncludePathView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpIncludePathView.kt\ncom/jetbrains/php/config/include/path/PhpIncludePathsView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1755#2,3:96\n1557#2:99\n1628#2,3:100\n1863#2,2:103\n1557#2:105\n1628#2,3:106\n1863#2,2:109\n*S KotlinDebug\n*F\n+ 1 PhpIncludePathView.kt\ncom/jetbrains/php/config/include/path/PhpIncludePathsView\n*L\n39#1:96,3\n48#1:99\n48#1:100,3\n48#1:103,2\n61#1:105\n61#1:106,3\n61#1:109,2\n*E\n"})
public final class PhpIncludePathsView
implements ConfigurableForm {
    @NotNull
    private final Project project;
    @Nullable
    private final VirtualFile projectDir;
    @NotNull
    private final PhpIncludePathsModel model;
    @NotNull
    private final PhpIncludeFileTree tree;
    @NotNull
    private final DialogPanel component;

    public PhpIncludePathsView(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.projectDir = ProjectUtil.guessProjectDir((Project)this.project);
        this.model = new PhpIncludePathsModel(this.project, null, null, null, null, 30, null);
        this.tree = new PhpIncludeFileTree(this.model);
        this.component = BuilderKt.panel(arg_0 -> PhpIncludePathsView.component$lambda$4(this, arg_0));
    }

    private final boolean isRemoveActionAvailable() {
        boolean bl;
        block3: {
            Set<String> includedPaths = this.model.getAllIncludedPaths();
            Set<String> invalidPaths = this.model.getInvalidPaths();
            Iterable $this$any$iv = this.tree.selectedFiles();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    if (!(includedPaths.contains(it.getPath()) || invalidPaths.contains(it.getPath()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final void addAction() {
        List addedDirectories = new ArrayList();
        FileChooser.chooseFiles((FileChooserDescriptor)FileChooserDescriptorFactory.createMultipleFoldersDescriptor(), (Project)this.project, (Component)((Component)this.tree.getComponent()), (VirtualFile)this.projectDir, arg_0 -> PhpIncludePathsView.addAction$lambda$7(arg_0 -> PhpIncludePathsView.addAction$lambda$6(addedDirectories, arg_0), arg_0));
        if (!((Collection)addedDirectories).isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = addedDirectories;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPath());
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String addedDir = (String)element$iv;
                boolean bl = false;
                if (this.model.getRemovedIncludePaths().remove(addedDir)) continue;
                Set<String> set = this.model.getAddedIncludePaths();
                Intrinsics.checkNotNull((Object)addedDir);
                set.add(addedDir);
            }
            this.model.updateBasePath();
            this.tree.update();
            this.tree.promiseExpandMarkedNodes();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void removeAction() {
        void $this$mapTo$iv$iv;
        Set<String> invalidPaths = this.model.getInvalidPaths();
        Iterable $this$map$iv = this.tree.selectedFiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String selected = (String)element$iv;
            boolean bl = false;
            if (invalidPaths.contains(selected) && this.model.getAllExcludedPaths().contains(selected) && !this.model.getAddedExcludedPaths().remove(selected)) {
                Set<String> set = this.model.getRemovedExcludedPaths();
                Intrinsics.checkNotNull((Object)selected);
                set.add(selected);
            }
            if (this.model.getAddedIncludePaths().remove(selected)) continue;
            Set<String> set = this.model.getRemovedIncludePaths();
            Intrinsics.checkNotNull((Object)selected);
            set.add(selected);
        }
        this.tree.update();
        this.tree.promiseExpandMarkedNodes();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return (JComponent)this.component;
    }

    @Override
    public boolean isModified() {
        return !((Collection)this.model.getAddedIncludePaths()).isEmpty() || !((Collection)this.model.getRemovedIncludePaths()).isEmpty() || !((Collection)this.model.getAddedExcludedPaths()).isEmpty() || !((Collection)this.model.getRemovedExcludedPaths()).isEmpty();
    }

    @Override
    public void apply() {
        PhpIncludePathManager.getInstance(this.project).setIncludePath(CollectionsKt.toList((Iterable)this.model.getAllIncludedPaths()));
        PhpIncludePathManager.getInstance(this.project).setExcludePath(CollectionsKt.toList((Iterable)this.model.getAllExcludedPaths()));
        this.model.clear();
    }

    @Override
    public void reset() {
        this.model.clear();
    }

    private static final void component$lambda$4$lambda$3$lambda$0(PhpIncludePathsView this$0, AnActionButton it) {
        this$0.addAction();
    }

    private static final void component$lambda$4$lambda$3$lambda$1(PhpIncludePathsView this$0, AnActionButton it) {
        this$0.removeAction();
    }

    private static final boolean component$lambda$4$lambda$3$lambda$2(PhpIncludePathsView this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isRemoveActionAvailable();
    }

    private static final Unit component$lambda$4$lambda$3(PhpIncludePathsView this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        AnAction[] anActionArray = new AnAction[]{new ExcludeAction(this$0.tree, this$0.model)};
        JPanel jPanel = ToolbarDecorator.createDecorator((JTree)((JTree)this$0.tree.getComponent())).setAddAction(arg_0 -> PhpIncludePathsView.component$lambda$4$lambda$3$lambda$0(this$0, arg_0)).setAddIcon(AllIcons.ToolbarDecorator.AddFolder).setAddActionName(PhpBundle.message("php.include.path.action.add.text", new Object[0])).setRemoveAction(arg_0 -> PhpIncludePathsView.component$lambda$4$lambda$3$lambda$1(this$0, arg_0)).setRemoveActionUpdater(arg_0 -> PhpIncludePathsView.component$lambda$4$lambda$3$lambda$2(this$0, arg_0)).addExtraActions(anActionArray).createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        $this$row.cell((JComponent)jPanel).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit component$lambda$4(PhpIncludePathsView this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PhpIncludePathsView.component$lambda$4$lambda$3(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit addAction$lambda$6(List $addedDirectories, List it) {
        Collection collection = $addedDirectories;
        Intrinsics.checkNotNull((Object)it);
        CollectionsKt.addAll((Collection)collection, (Iterable)it);
        return Unit.INSTANCE;
    }

    private static final void addAction$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

