/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters;

import com.intellij.DynamicBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpConfigurationFileAction;
import com.jetbrains.php.config.interpreters.PhpConfigurationFilePanelGenerator;
import com.jetbrains.php.config.interpreters.PhpConfigurationOptionData;
import com.jetbrains.php.config.interpreters.PhpConfigurationOptionsComponent;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpTextFieldWithSdkBasedBrowse;
import com.jetbrains.php.config.interpreters.remote.PhpUnknownRemoteSdkAdditionalData;
import com.jetbrains.php.config.phpInfo.PhpBinaryType;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.config.phpInfo.PhpInfoUtil;
import com.jetbrains.php.config.phpInfo.PhpNonPersistedInfo;
import com.jetbrains.php.run.PhpConfigurationOption;
import com.jetbrains.php.ui.PhpCompositeDebuggerComponent;
import com.jetbrains.php.ui.PhpInfoLabelPanel;
import com.jetbrains.php.ui.PhpUiUtil;
import com.jetbrains.php.ui.PhpVersionLabel;
import com.jetbrains.php.ui.ResultMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Pair;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpInterpreterComponent {
    private static final Logger LOG = Logger.getInstance(PhpInterpreterComponent.class);
    @Nls
    protected static final String OPEN_IN_EDITOR = PhpBundle.message("open.in.editor", new Object[0]);
    @Nls
    protected static final String FIX = PhpBundle.message("how.to.fix", new Object[0]);
    @Nls
    public static final String PATH_TO_PHP = PhpBundle.message("path.to.php", new Object[0]);
    protected JPanel myMainPanel;
    protected JBCheckBox myIsProjectLevel;
    private JPanel myGeneral;
    private JPanel myPhpHomePanel;
    protected PhpTextFieldWithSdkBasedBrowse myPathTextField;
    private PhpVersionLabel myPhpVersionLabel;
    private JPanel myPhpDebuggerPanel;
    private JPanel myAdditionalInfoPanel;
    private PhpCompositeDebuggerComponent myPhpDebuggerComponent;
    protected PhpConfigurationOptionsComponent myOptionsComponent;
    private JBLabel myWarningLabel;
    protected PhpTextFieldWithSdkBasedBrowse myDebuggerExtensionTextField;
    private JBLabel myDebuggerExtensionLabel;
    private JLabel myInvalidInterpreterLabel;
    protected PhpTextFieldWithSdkBasedBrowse myCustomIniTextField;
    @NotNull
    protected final Project myProject;
    protected PhpSdkAdditionalData mySdkAdditionalData;
    @Nullable
    protected PhpInfo myLastLoadedInfo;
    protected PhpNonPersistedInfo myLastLoadedNonPersistedInfo;
    private final PhpConfigurationFileAction myFixConfigurationFileAction;

    protected PhpInterpreterComponent(@NotNull Project project, @NotNull PhpSdkAdditionalData data) {
        if (project == null) {
            PhpInterpreterComponent.$$$reportNull$$$0(0);
        }
        if (data == null) {
            PhpInterpreterComponent.$$$reportNull$$$0(1);
        }
        this.myLastLoadedInfo = null;
        this.myLastLoadedNonPersistedInfo = null;
        this.$$$setupUI$$$();
        this.myFixConfigurationFileAction = new PhpConfigurationFileAction(FIX){

            @Override
            public void run(@Nullable String path) {
                String message = this.createConfigurationFileFix();
                String title = PhpBundle.message("PhpInterpreterConfigurable.configuration.file.fix.title", new Object[0]);
                Messages.showMessageDialog((Project)PhpInterpreterComponent.this.myProject, (String)PhpUiUtil.surroundWithHtml(message), (String)title, (Icon)Messages.getInformationIcon());
            }

            @NotNull
            @NlsContexts.Label
            public String createConfigurationFileFix() {
                Object message;
                String parentPath;
                if (PhpInterpreterComponent.this.myLastLoadedInfo != null && PhpInterpreterComponent.this.myLastLoadedInfo.getBinaryType() == PhpBinaryType.HHVM) {
                    String string = PhpBundle.message("PhpInterpreterConfigurable.configuration.file.hhvm.fix", new Object[0]);
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }
                ArrayList<CallSite> configDirs = new ArrayList<CallSite>();
                String pathToPhp = PhpInterpreterComponent.this.myPathTextField.getText();
                if (StringUtil.isNotEmpty((String)pathToPhp) && FileUtil.isWindowsAbsolutePath((String)pathToPhp) && StringUtil.isNotEmpty((String)(parentPath = PathUtil.getParentPath((String)pathToPhp)))) {
                    configDirs.add((CallSite)((Object)("<b>'" + parentPath + "'</b>")));
                }
                UIUtil.invokeAndWaitIfNeeded(() -> {
                    try {
                        ProcessOutput output = PhpInterpreterComponent.this.executeCommand(PhpBundle.message("PhpInterpreterConfigurable.configuration.file.evaluate.dir", new Object[0]), "--ini");
                        if (output != null) {
                            configDirs.add((CallSite)((Object)("<b>'" + PhpInfoUtil.parsePhpIniOutput(output.getStdout()) + "'</b>")));
                        }
                    }
                    catch (ExecutionException e) {
                        LOG.warn("Can not evaluate configuration directory", (Throwable)e);
                    }
                });
                if (configDirs.isEmpty()) {
                    if (StringUtil.isEmpty((String)pathToPhp)) {
                        pathToPhp = PATH_TO_PHP;
                    }
                    message = PhpBundle.message("PhpInterpreterConfigurable.configuration.file.fix.failed.to.detect", pathToPhp);
                } else {
                    message = PhpBundle.message("PhpInterpreterConfigurable.configuration.file.fix", StringUtil.join(configDirs, (String)" or "));
                }
                Object object = message = (String)message + PhpBundle.message("PhpInterpreterConfigurable.configuration.file.fix.link", new Object[0]);
                if (object == null) {
                    1.$$$reportNull$$$0(1);
                }
                return object;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/config/interpreters/PhpInterpreterComponent$1", "createConfigurationFileFix"));
            }
        };
        this.myProject = project;
        this.mySdkAdditionalData = data;
        this.myIsProjectLevel = new JBCheckBox(PhpBundle.message("PhpInterpreterConfigurable.configuration.project.level", new Object[0]));
        this.myDebuggerExtensionLabel.setToolTipText(PhpBundle.message("PhpInterpreterConfigurable.debugger.extension.description", new Object[0]));
        this.myDebuggerExtensionLabel.setLabelFor((Component)((Object)this.myDebuggerExtensionTextField));
        if (data instanceof PhpUnknownRemoteSdkAdditionalData) {
            this.myInvalidInterpreterLabel.setIcon(UIUtil.getBalloonWarningIcon());
            this.myInvalidInterpreterLabel.setVisible(true);
            this.myPathTextField.setEnabled(false);
            this.myCustomIniTextField.setEnabled(false);
        } else {
            this.myInvalidInterpreterLabel.setVisible(false);
        }
    }

    protected void init(@NotNull String interpreterName) {
        if (interpreterName == null) {
            PhpInterpreterComponent.$$$reportNull$$$0(2);
        }
        this.myPhpDebuggerPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        this.myPhpDebuggerPanel.add((Component)new JLabel(PhpBundle.message("PhpInterpreter.php.debugger.label", new Object[0])), constraints);
        this.myPhpDebuggerComponent = new PhpCompositeDebuggerComponent();
        constraints.gridx = 2;
        constraints.insets = JBUI.insets((int)0, (int)5, (int)0, (int)10);
        this.myPhpDebuggerPanel.add((Component)this.myPhpDebuggerComponent.getMainPanel(), constraints);
        this.myPathTextField.init(this.myProject, this.mySdkAdditionalData, PhpBundle.message("choose.php.home", new Object[0]), true, false);
        this.myDebuggerExtensionTextField.init(this.myProject, this.mySdkAdditionalData, PhpBundle.message("PhpInterpreterConfigurable.debugger.extension.title", new Object[0]), true, false);
        this.myCustomIniTextField.init(this.myProject, this.mySdkAdditionalData, PhpBundle.message("PhpInterpreterConfigurable.php.ini.title", new Object[0]), true, true);
        this.myPhpHomePanel.add((Component)PhpUiUtil.createHorizontalActionsToolbar("PhpInterpreterToolbar", PhpUiUtil.createReloadAction((Computable<ResultMessage>)((Computable)() -> this.reloadPhpInfo()), () -> this.canReloadPhpInfo()), PhpUiUtil.createShowPhpInfoAction(this.myMainPanel, () -> this.getWholePhpInfoNullably(), () -> this.getWholePhpInfoNullably())), "East");
        this.myWarningLabel.setText("");
        this.myWarningLabel.setVisible(false);
        this.myGeneral.setBorder(IdeBorderFactory.createTitledBorder((String)PhpBundle.message("PhpInterpreter.php.general.title", new Object[0])));
    }

    @Nullable
    private Pair<PhpInfo, PhpNonPersistedInfo> getWholePhpInfoNullably() {
        PhpInfo info = this.getLastLoadedPhpInfo();
        PhpNonPersistedInfo nonPersistedInfo = this.getLastLoadedNonPersistedPhpInfo();
        return info == null || nonPersistedInfo == null ? null : new Pair((Object)info, (Object)nonPersistedInfo);
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    @Nullable
    public PhpInfo getLastLoadedPhpInfo() {
        return this.myLastLoadedInfo;
    }

    @Nullable
    public PhpNonPersistedInfo getLastLoadedNonPersistedPhpInfo() {
        return this.myLastLoadedNonPersistedInfo;
    }

    @NotNull
    protected JComponent getProjectLevelComboBox() {
        if (this.myProject.isDefault()) {
            this.myIsProjectLevel.setEnabled(false);
            this.myIsProjectLevel.setToolTipText(PhpBundle.message("PhpInterpreterConfigurable.configuration.default.project.tooltip", new Object[0]));
        } else {
            this.myIsProjectLevel.setEnabled(true);
            this.myIsProjectLevel.setToolTipText(PhpBundle.message("PhpInterpreterConfigurable.configuration.project.tooltip", new Object[0]));
        }
        JBCheckBox jBCheckBox = this.myIsProjectLevel;
        if (jBCheckBox == null) {
            PhpInterpreterComponent.$$$reportNull$$$0(3);
        }
        return jBCheckBox;
    }

    private void updateWarningLabel(@Nullable @NlsContexts.Label String warning) {
        if (warning != null) {
            this.myWarningLabel.setVisible(true);
            this.myWarningLabel.setText(PhpUiUtil.surroundWithHtml(warning));
            this.myWarningLabel.setIcon(UIUtil.getBalloonWarningIcon());
        } else {
            this.myWarningLabel.setVisible(false);
        }
    }

    @NotNull
    protected abstract ResultMessage reloadPhpInfo();

    protected abstract boolean canReloadPhpInfo();

    protected void resetPhpInfo() {
        UIUtil.invokeAndWaitIfNeeded(() -> {
            this.myPhpVersionLabel.setVersion(this.myLastLoadedInfo != null ? this.myLastLoadedInfo.getVersion() : null);
            this.myPhpDebuggerComponent.reset(this.myLastLoadedInfo);
            if (this.isSdkSupported(this.mySdkAdditionalData)) {
                this.updateAdditionalInfo(this.myLastLoadedInfo);
                this.updateWarningLabel(this.myLastLoadedInfo == null ? null : this.myLastLoadedInfo.getWarning());
            }
        });
    }

    protected void updateAdditionalInfo(@Nullable PhpInfo phpInfo) {
        this.myAdditionalInfoPanel.removeAll();
        PhpConfigurationFileAction open = this.myProject.isDefault() ? null : this.createOpenFileAction();
        PhpInfoLabelPanel panel = PhpConfigurationFilePanelGenerator.createConfigurationFileInfo(phpInfo, open, this.myFixConfigurationFileAction);
        if (panel != null) {
            this.myAdditionalInfoPanel.add((Component)panel, "West");
        }
        this.myAdditionalInfoPanel.updateUI();
    }

    @Nullable
    protected abstract ProcessOutput executeCommand(@NotNull String var1, @NotNull String var2) throws ExecutionException;

    @Nullable
    protected PhpConfigurationFileAction createOpenFileAction() {
        return new PhpConfigurationFileAction(OPEN_IN_EDITOR){

            @Override
            public void run(String filePath) {
                VirtualFile file = (VirtualFile)WriteAction.compute(() -> StringUtil.isEmpty((String)filePath) ? null : LocalFileSystem.getInstance().findFileByPath(filePath));
                if (file == null) {
                    String title = PhpBundle.message("PhpInterpreterConfigurable.configuration.file.can.not.find.title", new Object[0]);
                    String message = PhpBundle.message("PhpInterpreterConfigurable.configuration.file.can.not.find", filePath);
                    Messages.showMessageDialog((Project)PhpInterpreterComponent.this.myProject, (String)message, (String)title, (Icon)Messages.getErrorIcon());
                    LOG.warn(message);
                    return;
                }
                FileEditorManager fileManager = FileEditorManager.getInstance((Project)PhpInterpreterComponent.this.myProject);
                if (fileManager != null) {
                    fileManager.openFile(file, true);
                }
            }
        };
    }

    @NotNull
    @NlsSafe
    protected abstract String getPresentableInterpreterPath(@NotNull String var1, @NotNull PhpSdkAdditionalData var2, @NotNull PhpInterpreter var3);

    @Nullable
    @NlsSafe
    protected abstract String getInterpreterPath(@NotNull String var1, @NotNull PhpSdkAdditionalData var2, @NotNull PhpInterpreter var3);

    @Nullable
    @NlsSafe
    protected abstract String getNewFullInterpreterPath() throws RemoteSdkException;

    @NotNull
    protected List<PhpConfigurationOption> getConfigurationOption() {
        List<PhpConfigurationOption> options = this.myOptionsComponent.getConfigurationOptions();
        String debuggerExtension = this.myDebuggerExtensionTextField.getText();
        if (StringUtil.isNotEmpty((String)debuggerExtension)) {
            options.add(PhpConfigurationOption.createZendExtensionOption(debuggerExtension));
        }
        List<PhpConfigurationOption> list = options;
        if (list == null) {
            PhpInterpreterComponent.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public Icon getIcon(@NotNull PhpSdkAdditionalData data) {
        if (data == null) {
            PhpInterpreterComponent.$$$reportNull$$$0(5);
        }
        Icon icon = data.getDecorator().getIcon(this.myLastLoadedInfo);
        if (icon == null) {
            PhpInterpreterComponent.$$$reportNull$$$0(6);
        }
        return icon;
    }

    public boolean isModified(@NotNull String name, @NotNull PhpSdkAdditionalData data, @NotNull PhpInterpreter interpreter) {
        if (name == null) {
            PhpInterpreterComponent.$$$reportNull$$$0(7);
        }
        if (data == null) {
            PhpInterpreterComponent.$$$reportNull$$$0(8);
        }
        if (interpreter == null) {
            PhpInterpreterComponent.$$$reportNull$$$0(9);
        }
        if (interpreter.isProjectLevel() != this.myIsProjectLevel.isSelected()) {
            return true;
        }
        if (!this.myPathTextField.getText().equals(StringUtil.notNullize((String)this.getInterpreterPath(name, data, interpreter)))) {
            return true;
        }
        if (!StringUtil.equals((CharSequence)this.myPhpDebuggerComponent.getSelectedDebuggerId(), (CharSequence)data.getDebuggerId())) {
            return true;
        }
        if (!Objects.equals(this.myLastLoadedInfo, PhpInterpretersPhpInfoCacheImpl.getInstance(this.myProject).getPhpInfo(name))) {
            return true;
        }
        if (!StringUtil.equals((CharSequence)this.myDebuggerExtensionTextField.getText(), (CharSequence)StringUtil.notNullize((String)interpreter.getDebuggerExtension()))) {
            return true;
        }
        if (!StringUtil.equals((CharSequence)this.myCustomIniTextField.getText(), (CharSequence)StringUtil.notNullize((String)interpreter.getCustomIni()))) {
            return true;
        }
        return !this.myOptionsComponent.getConfigurationOptionsData().equals(interpreter.getConfigurationOptions());
    }

    public void apply(@NotNull PhpInterpreter interpreter) throws RemoteSdkException, ConfigurationException {
        if (interpreter == null) {
            PhpInterpreterComponent.$$$reportNull$$$0(10);
        }
        interpreter.setIsProjectLevel(this.myIsProjectLevel.isSelected());
        interpreter.setHomePath(this.getNewFullInterpreterPath());
        interpreter.setDebuggerId(this.myPhpDebuggerComponent.getSelectedDebuggerId());
        interpreter.setDebuggerExtension(StringUtil.nullize((String)this.myDebuggerExtensionTextField.getText()));
        List<PhpConfigurationOptionData> items = this.myOptionsComponent.getConfigurationOptionsData();
        for (PhpConfigurationOptionData item : items) {
            if (!StringUtil.isEmptyOrSpaces((String)item.getName())) continue;
            throw new ConfigurationException(PhpBundle.message("PhpInterpreterConfigurable.configuration.options.with.empty.name.are.not.allowed", new Object[0]));
        }
        interpreter.setCustomIni(this.myCustomIniTextField.getText());
        interpreter.setConfigurationOptions(items);
    }

    public void reset(@NotNull String name, @NotNull PhpSdkAdditionalData data, @NotNull PhpInterpreter interpreter) {
        if (name == null) {
            PhpInterpreterComponent.$$$reportNull$$$0(11);
        }
        if (data == null) {
            PhpInterpreterComponent.$$$reportNull$$$0(12);
        }
        if (interpreter == null) {
            PhpInterpreterComponent.$$$reportNull$$$0(13);
        }
        this.myIsProjectLevel.setSelected(interpreter.isProjectLevel());
        this.myPathTextField.setText(this.getPresentableInterpreterPath(name, data, interpreter));
        this.myLastLoadedInfo = PhpInterpretersPhpInfoCacheImpl.getInstance(this.myProject).getPhpInfo(name);
        this.myLastLoadedNonPersistedInfo = null;
        this.myPhpDebuggerComponent.setPreviouslySelectedDebugger(interpreter.getDebuggerId());
        this.myDebuggerExtensionTextField.setText(interpreter.getDebuggerExtension());
        this.myCustomIniTextField.setText(interpreter.getCustomIni());
        this.resetPhpInfo();
        this.myOptionsComponent.setConfigurationOptions(interpreter.getConfigurationOptions());
        this.updateFormEditability();
    }

    protected final void updateFormEditability() {
        this.setEnabled(this.isSdkSupported(this.mySdkAdditionalData));
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myOptionsComponent);
        Disposer.dispose((Disposable)this.myDebuggerExtensionTextField);
    }

    protected void setEnabled(boolean enabled) {
        this.myIsProjectLevel.setEnabled(enabled);
        this.myPathTextField.setEditable(enabled);
        this.myDebuggerExtensionTextField.setEditable(enabled);
        this.myCustomIniTextField.setEditable(enabled);
        this.myOptionsComponent.getButton().setEnabled(enabled);
        this.myPhpHomePanel.setEnabled(enabled);
    }

    protected boolean isSdkSupported(PhpSdkAdditionalData additionalData) {
        return true;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        PhpConfigurationOptionsComponent phpConfigurationOptionsComponent;
        PhpTextFieldWithSdkBasedBrowse phpTextFieldWithSdkBasedBrowse;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        PhpTextFieldWithSdkBasedBrowse phpTextFieldWithSdkBasedBrowse2;
        JLabel jLabel;
        JPanel jPanel;
        JPanel jPanel2;
        PhpVersionLabel phpVersionLabel;
        PhpTextFieldWithSdkBasedBrowse phpTextFieldWithSdkBasedBrowse3;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myMainPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel5.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        this.myGeneral = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPhpHomePanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel8, "Center");
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpInterpreterComponent.class).getString("PhpInterpreter.php.home.path.label"));
        jPanel8.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPathTextField = phpTextFieldWithSdkBasedBrowse3 = new PhpTextFieldWithSdkBasedBrowse();
        jPanel8.add((Component)((Object)phpTextFieldWithSdkBasedBrowse3), new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel9, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myPhpVersionLabel = phpVersionLabel = new PhpVersionLabel();
        jPanel9.add((Component)((Object)phpVersionLabel), new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myPhpDebuggerPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, true, true));
        jPanel9.add((Component)jPanel2, new GridConstraints(0, 3, 1, 1, 9, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel9.add((Component)spacer, new GridConstraints(0, 1, 1, 2, 0, 1, 6, 1, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel10, new GridConstraints(4, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel10.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(10, 0, 5, 0), null, 0, 0, null, null));
        Spacer spacer2 = new Spacer();
        jPanel10.add((Component)spacer2, "Center");
        this.myAdditionalInfoPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel10.add((Component)jPanel, "West");
        this.myInvalidInterpreterLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpInterpreterComponent.class).getString("PhpInterpreter.configuration.interpreter.is.invalid"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpInterpreterComponent.class).getString("php.interpreter.custom.ini.label"));
        jPanel4.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCustomIniTextField = phpTextFieldWithSdkBasedBrowse2 = new PhpTextFieldWithSdkBasedBrowse();
        jPanel4.add((Component)((Object)phpTextFieldWithSdkBasedBrowse2), new GridConstraints(2, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel5.add((Component)jPanel11, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel11.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", PhpInterpreterComponent.class).getString("PhpInterpreterConfigurable.configuration.title"), (int)0, (int)0, null, null));
        Spacer spacer3 = new Spacer();
        jPanel11.add((Component)spacer3, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel12, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myWarningLabel = jBLabel2 = new JBLabel();
        jBLabel2.setEnabled(true);
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpInterpreterComponent.class).getString("php.interpreter.label.label"));
        jPanel12.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel12.add((Component)spacer4, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.add((Component)jPanel13, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpInterpreterComponent.class).getString("PhpInterpreterConfigurable.configuration.options.label"));
        jPanel13.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDebuggerExtensionLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpInterpreterComponent.class).getString("PhpInterpreterConfigurable.debugger.extension.label"));
        jPanel13.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDebuggerExtensionTextField = phpTextFieldWithSdkBasedBrowse = new PhpTextFieldWithSdkBasedBrowse();
        jPanel13.add((Component)((Object)phpTextFieldWithSdkBasedBrowse), new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setComponentStyle(UIUtil.ComponentStyle.MINI);
        jBLabel5.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.$$$loadLabelText$$$((JLabel)jBLabel5, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpInterpreterComponent.class).getString("PhpInterpreterConfigurable.configuration.options.description"));
        jPanel13.add((Component)jBLabel5, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null, 1));
        this.myOptionsComponent = phpConfigurationOptionsComponent = new PhpConfigurationOptionsComponent();
        jPanel13.add((Component)((Object)phpConfigurationOptionsComponent), new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel6.add((Component)spacer5, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterName";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/interpreters/PhpInterpreterComponent";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpInterpreterComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectLevelComboBox";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationOption";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6 -> new IllegalStateException(string);
        };
    }
}

