/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManager;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpInterpretersSerializer;
import com.jetbrains.php.config.interpreters.PhpInterpretersStateListener;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpInterpretersBaseManager
implements PersistentStateComponent<Element>,
PhpInterpretersManager,
Disposable {
    private List<PhpInterpreter> myInterpreters = new ArrayList<PhpInterpreter>();
    private final List<PhpInterpretersStateListener> myStateListeners = new SmartList();

    public Element getState() {
        return PhpInterpretersSerializer.serialize(this.myInterpreters);
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            PhpInterpretersBaseManager.$$$reportNull$$$0(0);
        }
        this.myInterpreters.clear();
        this.myInterpreters.addAll(PhpInterpretersSerializer.deserialize(this.getProject(), element));
        Project project = this.getProject();
        if (project != null) {
            this.onInterpretersUpdate(project);
        }
    }

    protected void onInterpretersUpdate(@NotNull Project project) {
        if (project == null) {
            PhpInterpretersBaseManager.$$$reportNull$$$0(1);
        }
        for (PhpInterpretersStateListener listener : this.myStateListeners) {
            listener.onInterpretersUpdate(project);
        }
    }

    @Nullable
    protected abstract Project getProject();

    @Override
    public void addListener(@NotNull Project project, @NotNull PhpInterpretersStateListener listener) {
        if (project == null) {
            PhpInterpretersBaseManager.$$$reportNull$$$0(2);
        }
        if (listener == null) {
            PhpInterpretersBaseManager.$$$reportNull$$$0(3);
        }
        ContainerUtil.add((Object)listener, this.myStateListeners, (Disposable)PhpInterpretersManagerImpl.PhpProjectInterpretersManager.getInstance(project));
    }

    @Override
    public void removeListener(@NotNull Project project, @NotNull PhpInterpretersStateListener listener) {
        if (project == null) {
            PhpInterpretersBaseManager.$$$reportNull$$$0(4);
        }
        if (listener == null) {
            PhpInterpretersBaseManager.$$$reportNull$$$0(5);
        }
        this.myStateListeners.remove(listener);
    }

    @Override
    @NotNull
    public List<PhpInterpreter> getInterpreters() {
        return new ArrayList<PhpInterpreter>(this.myInterpreters);
    }

    @Override
    public void setInterpreters(@NotNull List<PhpInterpreter> interpreters) {
        if (interpreters == null) {
            PhpInterpretersBaseManager.$$$reportNull$$$0(6);
        }
        this.myInterpreters = new ArrayList<PhpInterpreter>(interpreters);
    }

    @Override
    public void addInterpreter(@NotNull PhpInterpreter interpreter) {
        if (interpreter == null) {
            PhpInterpretersBaseManager.$$$reportNull$$$0(7);
        }
        this.myInterpreters.add(interpreter);
    }

    @Override
    @Nullable
    public PhpInterpreter findInterpreter(@Nullable String interpreterName) {
        return interpreterName == null ? null : (PhpInterpreter)ContainerUtil.find(this.myInterpreters, interpreter -> interpreterName.equals(interpreter.getName()));
    }

    @Override
    @Nullable
    @NlsSafe
    public String findInterpreterId(@Nullable String interpreterName) {
        PhpInterpreter interpreter = this.findInterpreter(interpreterName);
        return interpreter == null ? null : interpreter.getId();
    }

    @Override
    @Nullable
    public PhpInterpreter findInterpreterById(@Nullable String interpreterId) {
        if (StringUtil.isEmpty((String)interpreterId)) {
            return null;
        }
        return (PhpInterpreter)ContainerUtil.find(this.myInterpreters, interpreter -> interpreterId.equals(interpreter.getId()));
    }

    @Override
    @Nullable
    public PhpSdkAdditionalData findInterpreterDataById(@Nullable String interpreterId) {
        PhpInterpreter interpreter = this.findInterpreterById(interpreterId);
        return interpreter == null ? null : interpreter.getPhpSdkAdditionalData();
    }

    @Override
    @Nullable
    @NlsSafe
    public String findInterpreterName(@Nullable String interpreterId) {
        PhpInterpreter interpreter = this.findInterpreterById(interpreterId);
        return interpreter == null ? null : interpreter.getName();
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreters";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpInterpretersBaseManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onInterpretersUpdate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "removeListener";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setInterpreters";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addInterpreter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

