/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.library;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsListener;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.SourceRootEntity;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.workspaceModel.ide.impl.legacyBridge.project.ProjectRootManagerBridge;
import com.jetbrains.php.config.library.PhpIncludePathsEntity;
import com.jetbrains.php.config.library.PhpLibraryUpdater;
import com.jetbrains.php.config.library.PhpLibraryUpdaterKt;
import com.jetbrains.php.phar.PharFileType;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpAdditionalLibraryManager
implements AdditionalLibraryRootsListener,
Disposable {
    private final Logger LOG;
    private static final Comparator<VirtualFile> FILE_COMPARATOR = (o1, o2) -> StringUtil.compare((String)o1.getUrl(), (String)o2.getUrl(), (boolean)false);
    protected final Project myProject;
    private final Object ROOTS_WRITE_LOCK;
    private volatile List<VirtualFile> myRoots;
    private long myLastRootsChangeTimestampMillis;
    protected boolean myWorkSynchronouslyInHeadlessEnvironment;
    private final PhpLibraryUpdater myLibraryUpdater;

    protected PhpAdditionalLibraryManager(@NotNull Project project, @NotNull CoroutineScope scope, @NotNull Logger logger) {
        if (project == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(1);
        }
        if (logger == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(2);
        }
        this.ROOTS_WRITE_LOCK = new Object();
        this.myRoots = PhpAdditionalLibraryManager.createInitialEmptyRootList();
        this.myProject = project;
        this.LOG = logger;
        Duration updaterDelay = Duration.ofMillis(10L);
        boolean isNewUpdater = SystemProperties.getBooleanProperty((String)"php.additional.library.manager.new.updater", (boolean)false);
        this.myLibraryUpdater = isNewUpdater ? PhpLibraryUpdaterKt.phpLibraryUpdaterNonCancellable(project, scope, updaterDelay, () -> this.updateProjectLibrary()) : PhpLibraryUpdaterKt.oldPhpLibraryUpdater(project, this, updaterDelay, () -> this.updateProjectLibrary());
    }

    public PhpLibraryUpdater getLibraryUpdater() {
        return this.myLibraryUpdater;
    }

    public List<VirtualFile> getRoots() {
        List<VirtualFile> roots = Collections.unmodifiableList(this.myRoots);
        this.LOG.trace("myRoots " + roots);
        return roots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectOpened() {
        if (this.myProject.isDefault()) {
            return;
        }
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this);
        connection.subscribe(AdditionalLibraryRootsListener.TOPIC, (Object)this);
        connection.subscribe(WorkspaceModelTopics.CHANGED, (Object)new WorkspaceModelChangeListener(){

            public void changed(@NotNull VersionedStorageChange event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PhpAdditionalLibraryManager.shouldUpdateOnEvent(event)) {
                    PhpAdditionalLibraryManager.this.scheduleLibraryUpdate();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/config/library/PhpAdditionalLibraryManager$1", "changed"));
            }
        });
        connection.subscribe(FileTypeIndex.INDEX_CHANGE_TOPIC, (Object)new FileTypeIndex.IndexChangeListener(){

            public void onChangedForFileType(@NotNull FileType fileType) {
                if (fileType == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (fileType == PharFileType.INSTANCE && PhpAdditionalLibraryManager.this.myProject.isInitialized()) {
                    PhpAdditionalLibraryManager.this.scheduleLibraryUpdate();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/jetbrains/php/config/library/PhpAdditionalLibraryManager$2", "onChangedForFileType"));
            }
        });
        List<VirtualFile> roots = PhpAdditionalLibraryManager.createInitialEmptyRootList();
        this.loadInitialRoots(roots);
        Object object = this.ROOTS_WRITE_LOCK;
        synchronized (object) {
            this.myRoots = roots;
        }
        StartupManager.getInstance((Project)this.myProject).runAfterOpened(() -> {
            this.LOG.trace("projectOpened()");
            this.scheduleLibraryUpdate();
        });
    }

    protected void loadInitialRoots(List<VirtualFile> roots) {
    }

    private static boolean shouldUpdateOnEvent(@NotNull VersionedStorageChange event) {
        if (event == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(3);
        }
        return !event.getChanges(ModuleEntity.class).isEmpty() || !event.getChanges(SourceRootEntity.class).isEmpty() || !event.getChanges(ContentRootEntity.class).isEmpty() || !event.getChanges(PhpIncludePathsEntity.class).isEmpty();
    }

    public void libraryRootsChanged(@Nullable @Nls String presentableLibraryName, @NotNull Collection<? extends VirtualFile> oldRoots, @NotNull Collection<? extends VirtualFile> newRoots, @NotNull String libraryNameForDebug) {
        if (oldRoots == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(4);
        }
        if (newRoots == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(5);
        }
        if (libraryNameForDebug == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(6);
        }
        if (this.myProject.isDefault()) {
            return;
        }
        this.LOG.trace("library roots changed for " + presentableLibraryName);
        this.scheduleLibraryUpdate();
    }

    public void scheduleLibraryUpdate() {
        this.myLibraryUpdater.requestUpdate();
    }

    private void updateProjectLibrary() {
        if (this.myProject.isDisposed()) {
            return;
        }
        this.LOG.trace("updateProjectLibrary()");
        Collection<VirtualFile> roots = this.collectRoots();
        if (this.myProject.isDisposed()) {
            return;
        }
        if (this.LOG.isTraceEnabled()) {
            StringBuilder stringBuilder = new StringBuilder("Found roots: ");
            for (VirtualFile root : roots) {
                stringBuilder.append(root.getPath()).append('\n');
            }
            this.LOG.trace(stringBuilder.toString());
        }
        this.applyRootsChange(roots, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyRootsChange(@NotNull Collection<? extends VirtualFile> rootsToAdd, boolean reset, boolean removeInvalid) {
        boolean isChanged;
        List<VirtualFile> list;
        if (rootsToAdd == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(7);
        }
        if (this.LOG.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder("Applying change, reset ").append(reset).append(", removeInvalid ").append(removeInvalid).append("\nTo add:\n");
            for (VirtualFile virtualFile : rootsToAdd) {
                sb.append(virtualFile.getPath()).append('\n');
            }
            this.LOG.trace(sb.toString());
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        List<VirtualFile> newRoots = PhpAdditionalLibraryManager.createInitialEmptyRootList();
        Object object = this.ROOTS_WRITE_LOCK;
        synchronized (object) {
            if (!reset) {
                for (VirtualFile file : this.myRoots) {
                    if (removeInvalid && !file.isValid()) continue;
                    this.LOG.trace("Retained " + file.getPath());
                    newRoots.add(file);
                }
            }
            this.addPatchedRoots(rootsToAdd, newRoots);
            list = this.myRoots;
            boolean bl = isChanged = !this.myRoots.equals(newRoots);
            if (isChanged) {
                long timestamp = System.currentTimeMillis();
                long delta = timestamp - this.myLastRootsChangeTimestampMillis;
                if (delta < 10000L) {
                    this.LOG.warn("Frequent root change. Source " + this.getClass() + ", delta " + delta + ".\n" + PhpAdditionalLibraryManager.getDescription(this.myRoots, newRoots));
                }
                this.myLastRootsChangeTimestampMillis = timestamp;
                this.myRoots = newRoots;
            }
        }
        this.LOG.trace("applyRootsChange(); isChanged " + isChanged);
        if (isChanged) {
            this.notifyPlatformLibraryRootsChanged(newRoots, list);
        }
    }

    @NotNull
    private static List<VirtualFile> createInitialEmptyRootList() {
        return new SortedList(FILE_COMPARATOR);
    }

    protected void notifyPlatformLibraryRootsChanged(@NotNull List<VirtualFile> newRoots, @NotNull Collection<VirtualFile> oldRoots) {
        if (newRoots == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(8);
        }
        if (oldRoots == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(9);
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() || !this.myWorkSynchronouslyInHeadlessEnvironment) {
            PhpAdditionalLibraryManager.fireLibraryChanged(this.myProject, this.getPresentableLibraryName(), newRoots, oldRoots);
        }
    }

    @NotNull
    @Nls
    protected abstract String getPresentableLibraryName();

    private static String getDescription(List<? extends VirtualFile> oldRoots, List<? extends VirtualFile> newRoots) {
        String rootList = "Old roots: " + oldRoots + "\nNew Roots: " + newRoots;
        if (oldRoots.size() != newRoots.size()) {
            return rootList;
        }
        for (int i = 0; i < oldRoots.size(); ++i) {
            VirtualFile newFile;
            VirtualFile oldFile = oldRoots.get(i);
            if (oldFile.equals(newFile = newRoots.get(i))) continue;
            return rootList + ".\n Nonequality index " + i + ". Classes: old " + oldFile.getClass() + ", new " + newFile.getClass();
        }
        return rootList + ". But all files are equal 0_o";
    }

    protected void addPatchedRoots(@NotNull Collection<? extends VirtualFile> rootsToAdd, @NotNull List<? super VirtualFile> newRoots) {
        if (rootsToAdd == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(10);
        }
        if (newRoots == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(11);
        }
        this.LOG.trace("Added " + rootsToAdd);
        newRoots.addAll(rootsToAdd);
    }

    public static void fireLibraryChanged(@NotNull Project project, @NotNull @Nls String presentableLibraryName, @NotNull Collection<VirtualFile> newRoots, @NotNull Collection<VirtualFile> oldRoots) {
        if (project == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(12);
        }
        if (presentableLibraryName == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(13);
        }
        if (newRoots == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(14);
        }
        if (oldRoots == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(15);
        }
        boolean headlessEnvironment = ApplicationManager.getApplication().isHeadlessEnvironment();
        ProjectRootManagerEx projectRootManager = ProjectRootManagerEx.getInstanceEx((Project)project);
        if (projectRootManager instanceof ProjectRootManagerBridge && ((ProjectRootManagerBridge)projectRootManager).isFiringEvent() && (headlessEnvironment || ApplicationManager.getApplication().isDispatchThread())) {
            throw new IllegalStateException("ProjectRootManager is already firing event. Don't invoke AdditionalLibraryRootsListener.fireAdditionalLibraryChanged from rootsChanged event.");
        }
        Runnable writeAction = () -> WriteAction.run(() -> AdditionalLibraryRootsListener.fireAdditionalLibraryChanged((Project)project, (String)presentableLibraryName, (Collection)oldRoots, (Collection)newRoots, (String)presentableLibraryName));
        if (headlessEnvironment) {
            writeAction.run();
        } else {
            DumbService.getInstance((Project)project).runWhenSmart(writeAction);
        }
    }

    public static void modifyWorkspaceModel(@NotNull Project project, @NonNls @NotNull String description, Function1<? super MutableEntityStorage, Unit> update) {
        if (project == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(16);
        }
        if (description == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(17);
        }
        Runnable writeAction = () -> WriteAction.run(() -> WorkspaceModel.getInstance((Project)project).updateProjectModel(description, update));
        Application application = ApplicationManager.getApplication();
        if (application.isWriteIntentLockAcquired()) {
            writeAction.run();
        } else {
            application.invokeLater(writeAction);
        }
    }

    protected void modifyLibraries(@Nullable VirtualFile fileToAdd, boolean removeInvalidFiles) {
        if (this.myProject.isDisposed()) {
            return;
        }
        if (fileToAdd == null && !removeInvalidFiles) {
            return;
        }
        this.LOG.trace("Modifying libraries");
        Collection<Object> rootsToAdd = fileToAdd == null ? Collections.emptyList() : Collections.singleton(fileToAdd);
        this.applyRootsChange(rootsToAdd, false, removeInvalidFiles);
    }

    @NotNull
    protected abstract Collection<VirtualFile> collectRoots();

    public static void deleteOldStyleLibrary(@NotNull Project project, @NotNull String libraryName) {
        if (project == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(18);
        }
        if (libraryName == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(19);
        }
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> {
            if (project.isDisposed()) {
                return;
            }
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                PhpAdditionalLibraryManager.deleteLibrary(libraryName, module);
            }
        });
    }

    public static void deleteLibrary(@NotNull String libraryName, @NotNull Module module) {
        if (libraryName == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(20);
        }
        if (module == null) {
            PhpAdditionalLibraryManager.$$$reportNull$$$0(21);
        }
        if (PhpAdditionalLibraryManager.findLibraryByName(OrderEntryUtil.getModuleLibraries((ModuleRootModel)ModuleRootManager.getInstance((Module)module)), libraryName) == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            LibraryTable.ModifiableModel libraryTableModel = model.getModuleLibraryTable().getModifiableModel();
            Library phpLibrary = PhpAdditionalLibraryManager.findLibraryByName(Arrays.asList(libraryTableModel.getLibraries()), libraryName);
            if (phpLibrary == null) {
                model.dispose();
                return;
            }
            libraryTableModel.removeLibrary(phpLibrary);
            libraryTableModel.commit();
            model.commit();
        });
    }

    @Nullable
    private static Library findLibraryByName(List<? extends Library> libraries, String name) {
        return (Library)ContainerUtil.find(libraries, l -> name.equals(l.getName()));
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoots";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRoots";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryNameForDebug";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToAdd";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableLibraryName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/config/library/PhpAdditionalLibraryManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldUpdateOnEvent";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "libraryRootsChanged";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "applyRootsChange";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyPlatformLibraryRootsChanged";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "addPatchedRoots";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "fireLibraryChanged";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "modifyWorkspaceModel";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteOldStyleLibrary";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteLibrary";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

