/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.library;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpRuntimeConfiguration;
import com.jetbrains.php.config.library.PhpLibraryRootProvider;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class PhpConfiguredStubsLibraryRootProvider
implements PhpLibraryRootProvider {
    private static final Logger LOG = Logger.getInstance(PhpConfiguredStubsLibraryRootProvider.class);
    private static final Key<String> CONFIGURED_PATH = Key.create((String)"PhpConfiguredStubsLibraryRootProvider.configured.path");
    private static final String DEFAULT_STUBS_GROUP_DISPLAY_ID = "Default stubs";

    @Override
    @NotNull
    public Stream<VirtualFile> getLibraryRoots(@NotNull Project project) {
        String configuredPath;
        if (project == null) {
            PhpConfiguredStubsLibraryRootProvider.$$$reportNull$$$0(0);
        }
        if (!(configuredPath = PhpRuntimeConfiguration.getInstance(project).getDefaultStubsPath()).isEmpty()) {
            VirtualFile localFile = LocalFileSystem.getInstance().findFileByPath(configuredPath);
            if (localFile != null) {
                Stream<VirtualFile> stream = Stream.of(localFile);
                if (stream == null) {
                    PhpConfiguredStubsLibraryRootProvider.$$$reportNull$$$0(1);
                }
                return stream;
            }
            if (!configuredPath.equals(CONFIGURED_PATH.get((UserDataHolder)project))) {
                CONFIGURED_PATH.set((UserDataHolder)project, (Object)configuredPath);
                String message = PhpBundle.message("php.embedded.stubs.incorrect.path.warning.message", configuredPath);
                LOG.warn(message);
                Notifications.Bus.notify((Notification)new Notification(DEFAULT_STUBS_GROUP_DISPLAY_ID, PhpBundle.message("php.embedded.stubs.incorrect.path.warning.title", new Object[0]), message, NotificationType.WARNING), (Project)project);
            }
        }
        Stream<VirtualFile> stream = Stream.empty();
        if (stream == null) {
            PhpConfiguredStubsLibraryRootProvider.$$$reportNull$$$0(2);
        }
        return stream;
    }

    @Override
    public boolean isRuntime() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/library/PhpConfiguredStubsLibraryRootProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/library/PhpConfiguredStubsLibraryRootProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryRoots";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

