/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.library;

import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.io.DataExternalizer;
import com.jetbrains.php.config.PhpRuntimeConfiguration;
import com.jetbrains.php.config.library.PhpRuntimeLibraryRootsProvider;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.classAlias.PhpClassAliasProvider;
import com.jetbrains.php.lang.classAlias.PhpClassAliasUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.stubs.indexes.StringSetDataExternalizer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpExtensionStubsMetadataProvider {
    public static final VirtualFileGist<Set<String>> GIST = GistManager.getInstance().newVirtualFileGist("PhpExtensionStubsMetadataProvider", PhpClassAliasUtil.getVersion() + 1, (DataExternalizer)StringSetDataExternalizer.INSTANCE, (project, file) -> {
        final HashSet signatures = new HashSet();
        if (file.isDirectory()) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!file.isDirectory()) {
                        PsiFile psiFile = PhpExtensionStubsMetadataProvider.getPsiFile(project, file);
                        if (psiFile instanceof PhpFile) {
                            for (Map.Entry entry : ((PhpFile)psiFile).getTopLevelDefs().entrySet()) {
                                String fqn = (String)entry.getKey();
                                for (PhpNamedElement element : (Collection)entry.getValue()) {
                                    if (element instanceof PhpClass) {
                                        signatures.add(PhpTypeSignatureKey.CLASS.sign(fqn));
                                        continue;
                                    }
                                    if (element instanceof Function) {
                                        signatures.add(PhpTypeSignatureKey.FUNCTION.sign(fqn));
                                        continue;
                                    }
                                    if (!(element instanceof Constant)) continue;
                                    signatures.add(PhpTypeSignatureKey.CONSTANT.sign(fqn));
                                }
                            }
                            CharSequence contents = psiFile.getViewProvider().getContents();
                            List<PhpClassAliasProvider> providers = PhpClassAliasUtil.getRelevantProviders(contents);
                            PhpClassAliasUtil.processClassAliasDeclarations((PsiElement)psiFile, providers, (reference, result) -> signatures.add(PhpTypeSignatureKey.CLASS.sign(result.getAliasFqn())));
                        }
                        return false;
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/php/config/library/PhpExtensionStubsMetadataProvider$1", "visitFile"));
                }
            });
        }
        return signatures;
    });

    @Nullable
    private static PsiFile getPsiFile(@NotNull Project project, @NotNull VirtualFile file) {
        PsiFile psi;
        if (project == null) {
            PhpExtensionStubsMetadataProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PhpExtensionStubsMetadataProvider.$$$reportNull$$$0(1);
        }
        if (!((psi = PsiManager.getInstance((Project)project).findFile(file)) instanceof PsiFileImpl) || ((PsiFileImpl)psi).isContentsLoaded()) {
            return psi;
        }
        return FileContentImpl.createFileFromText((Project)project, (CharSequence)psi.getViewProvider().getContents(), (LanguageFileType)PhpFileType.INSTANCE, (VirtualFile)file, (String)file.getName());
    }

    @Nullable
    public static String findDisabledExtension(@NotNull Project project, @NotNull String signature) {
        if (project == null) {
            PhpExtensionStubsMetadataProvider.$$$reportNull$$$0(2);
        }
        if (signature == null) {
            PhpExtensionStubsMetadataProvider.$$$reportNull$$$0(3);
        }
        Map signatureToDisabledExtension = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> PhpRuntimeLibraryRootsProvider.createCacheResult(PhpExtensionStubsMetadataProvider.getSignatureToDisabledExtension(project), project, new Object[0]));
        return (String)signatureToDisabledExtension.get(signature);
    }

    @NotNull
    private static Map<String, String> getSignatureToDisabledExtension(@NotNull Project project) {
        Set<Map.Entry<String, Boolean>> extensions;
        Set disabledExtensions;
        if (project == null) {
            PhpExtensionStubsMetadataProvider.$$$reportNull$$$0(4);
        }
        if ((disabledExtensions = ((StreamEx)StreamEx.of(extensions = PhpRuntimeConfiguration.getInstance(project).getExtensions().entrySet()).filter(entry -> (Boolean)entry.getValue() == false)).map(Map.Entry::getKey).toSet()).isEmpty()) {
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                PhpExtensionStubsMetadataProvider.$$$reportNull$$$0(5);
            }
            return map;
        }
        Set<VirtualFile> roots = PhpRuntimeLibraryRootsProvider.getLibraryRootsBeforeFiltering(project);
        Map nameToRoot = StreamEx.of(roots).toMap(VirtualFile::getName, x -> x);
        TreeMap<String, String> signatureToDisabledExtension = new TreeMap<String, String>(String::compareToIgnoreCase);
        for (String extension : disabledExtensions) {
            VirtualFile root = (VirtualFile)nameToRoot.get(extension);
            if (root == null) continue;
            for (String signature : (Set)GIST.getFileData(project, root)) {
                signatureToDisabledExtension.put(signature, extension);
            }
        }
        TreeMap<String, String> treeMap = signatureToDisabledExtension;
        if (treeMap == null) {
            PhpExtensionStubsMetadataProvider.$$$reportNull$$$0(6);
        }
        return treeMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/library/PhpExtensionStubsMetadataProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/library/PhpExtensionStubsMetadataProvider";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignatureToDisabledExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findDisabledExtension";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSignatureToDisabledExtension";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

