/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.library;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpExtensionsManager;
import com.jetbrains.php.config.PhpProjectConfigurableForm;
import com.jetbrains.php.config.PhpRuntimeConfiguration;
import com.jetbrains.php.config.library.PhpRuntimeLibraryRootsProvider;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\"\u0010\u000f\u001a\u00020\u00012\b\b\u0001\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u0012"}, d2={"detectAndApply", "", "project", "Lcom/intellij/openapi/project/Project;", "configurable", "Lcom/jetbrains/php/config/PhpProjectConfigurableForm;", "phpInfo", "Lcom/jetbrains/php/config/phpInfo/PhpInfo;", "balloonAnchor", "Ljava/awt/Component;", "getLoadedExtensions", "", "", "", "getConfiguredExtensions", "showBalloon", "message", "anchor", "intellij.php.impl"})
@SourceDebugExtension(value={"SMAP\nPhpExtensionsDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpExtensionsDetector.kt\ncom/jetbrains/php/config/library/PhpExtensionsDetectorKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n205#2,4:73\n774#3:77\n865#3,2:78\n1187#3,2:80\n1261#3,4:82\n1557#3:86\n1628#3,3:87\n774#3:90\n865#3,2:91\n1187#3,2:93\n1261#3,2:95\n1264#3:98\n1#4:97\n*S KotlinDebug\n*F\n+ 1 PhpExtensionsDetector.kt\ncom/jetbrains/php/config/library/PhpExtensionsDetectorKt\n*L\n36#1:73,4\n48#1:77\n48#1:78,2\n49#1:80,2\n49#1:82,4\n56#1:86\n56#1:87,3\n57#1:90\n57#1:91,2\n58#1:93,2\n58#1:95,2\n58#1:98\n*E\n"})
public final class PhpExtensionsDetectorKt {
    public static final void detectAndApply(@NotNull Project project, @NotNull PhpProjectConfigurableForm configurable, @NotNull PhpInfo phpInfo, @NotNull Component balloonAnchor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
        Intrinsics.checkNotNullParameter((Object)phpInfo, (String)"phpInfo");
        Intrinsics.checkNotNullParameter((Object)balloonAnchor, (String)"balloonAnchor");
        Map<String, Boolean> loadedExtensions = PhpExtensionsDetectorKt.getLoadedExtensions(phpInfo);
        Map<String, Boolean> configuredExtensions = PhpExtensionsDetectorKt.getConfiguredExtensions(project);
        Map modifications = new LinkedHashMap();
        Map map = ContainerUtil.diff(loadedExtensions, configuredExtensions);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"diff(...)");
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Couple couple = (Couple)entry.getValue();
            if (couple.first != null && couple.second != null) {
                modifications.put(key, true);
            }
            if (couple.first != null || !((Boolean)couple.second).booleanValue()) continue;
            modifications.put(key, false);
        }
        if (!modifications.isEmpty()) {
            int n;
            configurable.setExtensions(MapsKt.plus(configuredExtensions, (Map)modifications));
            Map $this$count$iv = modifications;
            boolean $i$f$count = false;
            if ($this$count$iv.isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                Iterator iterator = $this$count$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator.next();
                    boolean bl = false;
                    if (!((Boolean)it.getValue()).booleanValue()) continue;
                    ++count$iv;
                }
                n = count$iv;
            }
            int enabled = n;
            int disabled = modifications.size() - enabled;
            Object[] objectArray = new Object[]{enabled, disabled};
            String string = PhpBundle.message("popup.content.enabled.disabled.extensions", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            PhpExtensionsDetectorKt.showBalloon(string, balloonAnchor, project);
        } else {
            String string = PhpBundle.message("popup.content.configuration.remains.unchanged", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            PhpExtensionsDetectorKt.showBalloon(string, balloonAnchor, project);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, Boolean> getLoadedExtensions(PhpInfo phpInfo) {
        void $this$associateTo$iv$iv;
        void $this$filterTo$iv$iv;
        Map<String, PhpExtensionsManager.ExtensionCategory> map = PhpProjectConfigurableForm.getExtensionToCategory();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getExtensionToCategory(...)");
        Map<String, PhpExtensionsManager.ExtensionCategory> extensionToCategory = map;
        Set<String> set = phpInfo.getLoadedExtensions();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getLoadedExtensions(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String extension = (String)element$iv$iv;
            boolean bl = false;
            if (!(PhpExtensionsManager.ExtensionCategory.CORE != extensionToCategory.get(extension))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv2;
            String extension = (String)element$iv$iv;
            boolean bl = false;
            Pair pair = new Pair((Object)extension, (Object)true);
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, Boolean> getConfiguredExtensions(Project project) {
        void $this$associateTo$iv$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Map<String, PhpExtensionsManager.ExtensionCategory> map = PhpProjectConfigurableForm.getExtensionToCategory();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getExtensionToCategory(...)");
        Map<String, PhpExtensionsManager.ExtensionCategory> extensionToCategory = map;
        Map<String, Boolean> map2 = PhpRuntimeConfiguration.getInstance(project).getExtensions();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"getExtensions(...)");
        Map<String, Boolean> extensions = map2;
        Set<VirtualFile> set = PhpRuntimeLibraryRootsProvider.getLibraryRootsBeforeFiltering(project);
        Intrinsics.checkNotNullExpressionValue(set, (String)"getLibraryRootsBeforeFiltering(...)");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void file;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(file.getName());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String extension = (String)element$iv$iv;
            boolean bl = false;
            if (!(PhpExtensionsManager.ExtensionCategory.CORE != extensionToCategory.get(extension))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map3 = destination$iv$iv2;
            String extension = (String)element$iv$iv;
            boolean bl = false;
            String string = extension;
            Boolean bl2 = extensions.get(extension);
            if (bl2 == null) {
                String string2 = string;
                boolean bl3 = false;
                bl2 = true;
                string = string2;
            }
            Boolean bl4 = bl2;
            String string3 = string;
            Pair pair = new Pair((Object)string3, (Object)bl4);
            map3.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    private static final void showBalloon(@NlsContexts.PopupContent String message, Component anchor, Project project) {
        MessageType type = MessageType.INFO;
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, type.getDefaultIcon(), type.getPopupBackground(), null);
        Intrinsics.checkNotNullExpressionValue((Object)balloonBuilder, (String)"createHtmlTextBalloonBuilder(...)");
        BalloonBuilder balloonBuilder2 = balloonBuilder;
        balloonBuilder2.setFadeoutTime(3000L);
        Balloon balloon = balloonBuilder2.createBalloon();
        Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"createBalloon(...)");
        Balloon balloon2 = balloon;
        RelativePoint point = new RelativePoint(anchor, new Point(0, 0));
        Disposer.register((Disposable)PhpRuntimeConfiguration.getInstance(project), (Disposable)((Disposable)balloon2));
        balloon2.show(point, Balloon.Position.above);
    }
}

