/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.library;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ExternalLibrariesNode;
import com.intellij.ide.projectView.impl.nodes.ExternalLibrariesWorkspaceModelNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NavigatableWithText;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurable;
import com.jetbrains.php.phar.PharFileSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpExternalLibrariesNodePatcher
implements TreeStructureProvider,
DumbAware {
    @NotNull
    public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<AbstractTreeNode<?>> children, ViewSettings settings) {
        if (parent == null) {
            PhpExternalLibrariesNodePatcher.$$$reportNull$$$0(0);
        }
        if (children == null) {
            PhpExternalLibrariesNodePatcher.$$$reportNull$$$0(1);
        }
        if (parent instanceof ExternalLibrariesNode) {
            Collection<AbstractTreeNode<?>> collection = PhpExternalLibrariesNodePatcher.unifyNodesUnderPHPNode(children, parent.getProject(), settings);
            if (collection == null) {
                PhpExternalLibrariesNodePatcher.$$$reportNull$$$0(2);
            }
            return collection;
        }
        if (PlatformUtils.isPhpStorm()) {
            List list = ContainerUtil.map(children, node -> {
                if (node instanceof ExternalLibrariesNode) {
                    return new PatchedExternalLibrariesNode(node.getProject(), ((ExternalLibrariesNode)node).getSettings());
                }
                return node;
            });
            if (list == null) {
                PhpExternalLibrariesNodePatcher.$$$reportNull$$$0(3);
            }
            return list;
        }
        Collection<AbstractTreeNode<?>> collection = children;
        if (collection == null) {
            PhpExternalLibrariesNodePatcher.$$$reportNull$$$0(4);
        }
        return collection;
    }

    private static Collection<AbstractTreeNode<?>> unifyNodesUnderPHPNode(Collection<AbstractTreeNode<?>> children, Project project, ViewSettings settings) {
        ArrayList<NodeToIncludeIntoPhpLibrariesNode> nodesToMerge = new ArrayList<NodeToIncludeIntoPhpLibrariesNode>();
        ArrayList filteredChildren = new ArrayList(children.size());
        for (AbstractTreeNode<?> abstractTreeNode : children) {
            if (abstractTreeNode instanceof NodeToIncludeIntoPhpLibrariesNode) {
                nodesToMerge.add((NodeToIncludeIntoPhpLibrariesNode)abstractTreeNode);
                continue;
            }
            filteredChildren.add(abstractTreeNode);
        }
        if (nodesToMerge.isEmpty()) {
            return children;
        }
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        for (NodeToIncludeIntoPhpLibrariesNode node : nodesToMerge) {
            roots.addAll(node.getRoots());
        }
        PhpLibrariesNode phpLibrariesNode = new PhpLibrariesNode(project, roots, settings, nodesToMerge);
        ArrayList result = new ArrayList(filteredChildren);
        result.add((AbstractTreeNode<?>)phpLibrariesNode);
        return result;
    }

    @Nullable
    public static ExternalLibrariesWorkspaceModelNode getAsPhpLibraryNode(AbstractTreeNode<?> node) {
        if ("PHP".equals(node.getName())) {
            return (ExternalLibrariesWorkspaceModelNode)ObjectUtils.tryCast(node, ExternalLibrariesWorkspaceModelNode.class);
        }
        return null;
    }

    private static void openSettings(Project project) {
        PhpProjectConfigurable.createFix(project).run();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/library/PhpExternalLibrariesNodePatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/library/PhpExternalLibrariesNodePatcher";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "modify";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    public static class NodeToIncludeIntoPhpLibrariesNode
    extends ExternalLibrariesWorkspaceModelNode {
        public NodeToIncludeIntoPhpLibrariesNode(@NotNull Project project, @NotNull Collection<VirtualFile> roots, @NotNull @Nls String libraryName, ViewSettings settings) {
            if (project == null) {
                NodeToIncludeIntoPhpLibrariesNode.$$$reportNull$$$0(0);
            }
            if (roots == null) {
                NodeToIncludeIntoPhpLibrariesNode.$$$reportNull$$$0(1);
            }
            if (libraryName == null) {
                NodeToIncludeIntoPhpLibrariesNode.$$$reportNull$$$0(2);
            }
            super(project, roots, libraryName, settings);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "roots";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "libraryName";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/config/library/PhpExternalLibrariesNodePatcher$NodeToIncludeIntoPhpLibrariesNode";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpLibrariesNode
    extends ExternalLibrariesWorkspaceModelNode
    implements NavigatableWithText {
        private final List<NodeToIncludeIntoPhpLibrariesNode> myNodes;

        private PhpLibrariesNode(@NotNull Project project, @NotNull Collection<VirtualFile> roots, ViewSettings settings, List<NodeToIncludeIntoPhpLibrariesNode> nodesToMerge) {
            if (project == null) {
                PhpLibrariesNode.$$$reportNull$$$0(0);
            }
            if (roots == null) {
                PhpLibrariesNode.$$$reportNull$$$0(1);
            }
            super(project, roots, Collections.emptyList(), "PHP", AllIcons.Nodes.PpLibFolder, settings);
            this.myNodes = nodesToMerge;
        }

        public boolean contains(@NotNull VirtualFile file) {
            ProjectFileIndex index;
            if (file == null) {
                PhpLibrariesNode.$$$reportNull$$$0(2);
            }
            if (file.getFileSystem() == PharFileSystem.getInstance()) {
                file = VfsUtil.getLocalFile((VirtualFile)file);
            }
            if (super.contains(file)) {
                return true;
            }
            Project localProject = this.getProject();
            if (localProject != null && (index = ProjectRootManager.getInstance((Project)localProject).getFileIndex()).isInContent(file)) {
                return false;
            }
            for (NodeToIncludeIntoPhpLibrariesNode node : this.myNodes) {
                if (!node.contains(file)) continue;
                return true;
            }
            return false;
        }

        public boolean canNavigate() {
            return PlatformUtils.isPhpStorm();
        }

        public void navigate(boolean requestFocus) {
            PhpExternalLibrariesNodePatcher.openSettings(this.getProject());
        }

        public String getNavigateActionText(boolean focusEditor) {
            return PhpBundle.message("configure.php.include.paths", new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/config/library/PhpExternalLibrariesNodePatcher$PhpLibrariesNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PatchedExternalLibrariesNode
    extends ExternalLibrariesNode
    implements NavigatableWithText {
        PatchedExternalLibrariesNode(Project project, ViewSettings viewSettings) {
            super(project, viewSettings);
        }

        public boolean canNavigate() {
            return true;
        }

        public void navigate(boolean requestFocus) {
            PhpExternalLibrariesNodePatcher.openSettings(this.myProject);
        }

        public String getNavigateActionText(boolean focusEditor) {
            return PhpBundle.message("configure.php.include.paths", new Object[0]);
        }
    }
}

