/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.library;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.EntityStorageKt;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.XCollection;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.PhpProjectWorkspaceConfiguration;
import com.jetbrains.php.config.library.PhpAdditionalLibraryManager;
import com.jetbrains.php.config.library.PhpExcludePathsContainer;
import com.jetbrains.php.config.library.PhpIncludePathsEntity;
import com.jetbrains.php.config.library.PhpIncludePathsEntitySource;
import com.jetbrains.php.config.library.PhpIncludedPathsContributor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="PhpIncludePathManager", storages={@Storage(value="php.xml")})
public final class PhpIncludePathManager
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(PhpIncludePathManager.class);
    @NlsSafe
    public static final String PHP_LIBRARY_NAME = "PHP";
    private static final PhpIncludePathsEntitySource PHP_INCLUDE_PATHS_ENTITY_SOURCE = new PhpIncludePathsEntitySource();
    @NotNull
    private final Project myProject;
    @NotNull
    private List<String> myIncludePaths;
    @NotNull
    private List<String> myExcludePaths;
    private volatile boolean myMuted;

    public static PhpIncludePathManager getInstance(@NotNull Project project) {
        if (project == null) {
            PhpIncludePathManager.$$$reportNull$$$0(0);
        }
        return (PhpIncludePathManager)project.getService(PhpIncludePathManager.class);
    }

    public PhpIncludePathManager(@NotNull Project project) {
        if (project == null) {
            PhpIncludePathManager.$$$reportNull$$$0(1);
        }
        this.myIncludePaths = new SmartList();
        this.myExcludePaths = new SmartList();
        this.myProject = project;
    }

    public void projectOpened() {
        PhpAdditionalLibraryManager.deleteOldStyleLibrary(this.myProject, PHP_LIBRARY_NAME);
        PhpAdditionalLibraryManager.deleteOldStyleLibrary(this.myProject, "PHP Runtime");
    }

    public List<VirtualFile> getAllIncludedRoots() {
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>(this.getIncludePaths());
        for (PhpIncludedPathsContributor contributor : PhpIncludedPathsContributor.EP_NAME.getExtensionList()) {
            roots.addAll(contributor.getRoots(this.myProject));
        }
        return roots;
    }

    @NotNull
    public Collection<VirtualFile> getIncludePaths() {
        Sequence entities = WorkspaceModel.getInstance((Project)this.myProject).getCurrentSnapshot().entities(PhpIncludePathsEntity.class);
        List list = ContainerUtil.flatMap((Iterable)SequencesKt.asIterable((Sequence)entities), entity -> PhpIncludePathManager.getIncludePaths(entity));
        if (list == null) {
            PhpIncludePathManager.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static List<VirtualFile> getIncludePaths(@NotNull PhpIncludePathsEntity entity) {
        if (entity == null) {
            PhpIncludePathManager.$$$reportNull$$$0(3);
        }
        List<VirtualFileUrl> paths = entity.getPaths();
        List list = ContainerUtil.mapNotNull(paths, path -> VirtualFileUrls.getVirtualFile((VirtualFileUrl)path));
        if (list == null) {
            PhpIncludePathManager.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public Collection<String> getExcludePath() {
        List<String> list = this.myExcludePaths;
        if (list == null) {
            PhpIncludePathManager.$$$reportNull$$$0(5);
        }
        return list;
    }

    public void setExcludePath(@NotNull List<String> excludePath) {
        if (excludePath == null) {
            PhpIncludePathManager.$$$reportNull$$$0(6);
        }
        HashSet<String> initialExcludePaths = new HashSet<String>(this.myExcludePaths);
        this.myExcludePaths = new ArrayList<String>(PhpIncludePathManager.preparePaths(excludePath));
        HashSet<String> newExcludePaths = new HashSet<String>(this.myExcludePaths);
        if (newExcludePaths.equals(initialExcludePaths)) {
            return;
        }
        if (!this.myProject.isDefault()) {
            this.ensureWorkspaceModelSynchronised();
        }
    }

    @NotNull
    public List<String> getIncludePath() {
        this.ensureOldPathsSynchronized(null);
        return new ArrayList<String>(this.myIncludePaths);
    }

    public void setIncludePath(@NotNull List<String> includePath) {
        if (includePath == null) {
            PhpIncludePathManager.$$$reportNull$$$0(7);
        }
        HashSet<String> initialIncludePaths = new HashSet<String>(this.myIncludePaths);
        SmartList addedOldPaths = new SmartList();
        this.ensureOldPathsSynchronized((List<String>)addedOldPaths);
        this.myIncludePaths = new ArrayList<String>(PhpIncludePathManager.preparePaths(includePath));
        this.myIncludePaths.addAll((Collection<String>)addedOldPaths);
        HashSet<String> newIncludePaths = new HashSet<String>(this.myIncludePaths);
        if (newIncludePaths.equals(initialIncludePaths)) {
            return;
        }
        PhpProjectWorkspaceConfiguration.State configuration = PhpProjectConfigurationFacade.getInstance(this.myProject).getProjectConfiguration();
        configuration.setIncludePath(this.myIncludePaths);
        if (!this.myProject.isDefault()) {
            this.ensureWorkspaceModelSynchronised();
        }
    }

    private void ensureWorkspaceModelSynchronised() {
        if (this.myMuted) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        if (application.isHeadlessEnvironment() && !CoreProgressManager.shouldKeepTasksAsynchronousInHeadlessMode()) {
            this.doSaveRootsToWorkspaceModel();
        } else {
            application.executeOnPooledThread(() -> this.doSaveRootsToWorkspaceModel());
        }
    }

    private void doSaveRootsToWorkspaceModel() {
        boolean noEntitiesToRegister;
        VirtualFile baseDir = ProjectUtil.guessProjectDir((Project)this.myProject);
        List<VirtualFileUrl> newRoots = PhpIncludePathManager.toFileUrls(this.myProject, baseDir, this.getIncludePath());
        List<VirtualFileUrl> newExcluded = PhpIncludePathManager.toFileUrls(this.myProject, baseDir, this.myExcludePaths);
        ImmutableEntityStorage entityStorage = WorkspaceModel.getInstance((Project)this.myProject).getCurrentSnapshot();
        List entities = SequencesKt.toList((Sequence)entityStorage.entities(PhpIncludePathsEntity.class));
        PhpIncludePathsEntity firstEntity = (PhpIncludePathsEntity)CollectionsKt.firstOrNull((List)entities);
        boolean bl = noEntitiesToRegister = newRoots.isEmpty() && newExcluded.isEmpty();
        if (noEntitiesToRegister && firstEntity == null) {
            return;
        }
        if (!noEntitiesToRegister && firstEntity != null && entities.size() == 1) {
            PhpExcludePathsContainer exclude = firstEntity.getExclude();
            if (firstEntity.getPaths().equals(newRoots) && (exclude == null && ContainerUtil.isEmpty(newExcluded) || exclude != null && newExcluded.equals(exclude.getPaths()))) {
                return;
            }
        }
        MutableEntityStorage preliminaryBuilder = EntityStorageKt.toBuilder((ImmutableEntityStorage)entityStorage);
        for (int i = 1; i < entities.size(); ++i) {
            preliminaryBuilder.removeEntity((WorkspaceEntity)entities.get(i));
        }
        if (noEntitiesToRegister) {
            preliminaryBuilder.removeEntity((WorkspaceEntity)firstEntity);
        } else if (firstEntity == null) {
            preliminaryBuilder.addEntity((WorkspaceEntity.Builder)PhpIncludePathsEntity.create(newRoots, PHP_INCLUDE_PATHS_ENTITY_SOURCE));
        } else {
            preliminaryBuilder.modifyEntity(PhpIncludePathsEntity.Builder.class, (WorkspaceEntity)firstEntity, specLibraryEntity -> {
                specLibraryEntity.setPaths(newRoots);
                specLibraryEntity.setExclude(new PhpExcludePathsContainer(newExcluded));
                return Unit.INSTANCE;
            });
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            PhpAdditionalLibraryManager.modifyWorkspaceModel(this.myProject, "Updating PHP included paths", (Function1<? super MutableEntityStorage, Unit>)((Function1)storage -> {
                storage.applyChangesFrom(preliminaryBuilder);
                return Unit.INSTANCE;
            }));
        });
    }

    private static List<VirtualFileUrl> toFileUrls(@NotNull Project project, @Nullable VirtualFile baseDir, @NotNull Collection<String> paths) {
        if (project == null) {
            PhpIncludePathManager.$$$reportNull$$$0(8);
        }
        if (paths == null) {
            PhpIncludePathManager.$$$reportNull$$$0(9);
        }
        VirtualFileUrlManager fileUrlManager = WorkspaceModel.getInstance((Project)project).getVirtualFileUrlManager();
        return ContainerUtil.mapNotNull(paths, path -> {
            if (FileUtil.isAbsolute((String)path)) {
                return fileUrlManager.getOrCreateFromUrl(VfsUtilCore.pathToUrl((String)path));
            }
            if (baseDir != null) {
                return fileUrlManager.getOrCreateFromUrl(VfsUtilCore.pathToUrl((String)baseDir.getPath())).append(path);
            }
            return null;
        });
    }

    public void setMutedForTest(boolean muted) {
        this.myMuted = muted;
    }

    @NotNull
    public State getState() {
        State state = new State();
        state.setSerializedIncludePath(this.myIncludePaths);
        state.setSerializedExcludePath(this.myExcludePaths);
        State state2 = state;
        if (state2 == null) {
            PhpIncludePathManager.$$$reportNull$$$0(10);
        }
        return state2;
    }

    @NotNull
    private static List<String> preparePaths(List<String> includePaths) {
        List list = ContainerUtil.map(includePaths, path -> FileUtil.toSystemIndependentName((String)path));
        if (list == null) {
            PhpIncludePathManager.$$$reportNull$$$0(11);
        }
        return list;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            PhpIncludePathManager.$$$reportNull$$$0(12);
        }
        this.myIncludePaths = new ArrayList<String>(PhpIncludePathManager.preparePaths(state.getSerializedIncludePath()));
        this.myExcludePaths = new ArrayList<String>(PhpIncludePathManager.preparePaths(state.getSerializedExcludePath()));
        this.ensureOldPathsSynchronized(null);
        this.ensureWorkspaceModelSynchronised();
    }

    private void ensureOldPathsSynchronized(@Nullable List<String> addedOldPaths) {
        PhpProjectWorkspaceConfiguration.State configuration = PhpProjectConfigurationFacade.getInstance(this.myProject).getProjectConfiguration();
        List<String> oldIncludePath = PhpIncludePathManager.preparePaths(configuration.getIncludePath());
        for (String path : oldIncludePath) {
            if (this.myIncludePaths.contains(path)) continue;
            this.myIncludePaths.add(path);
            if (addedOldPaths == null) continue;
            addedOldPaths.add(path);
        }
        configuration.setIncludePath(this.myIncludePaths);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/library/PhpIncludePathManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/library/PhpIncludePathManager";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludePaths";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludePath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "preparePaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIncludePaths";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setExcludePath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setIncludePath";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toFileUrls";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 10, 11 -> new IllegalStateException(string);
        };
    }

    public static final class State {
        private List<String> myIncludePath = new ArrayList<String>();
        private List<String> myExcludePath = new ArrayList<String>();

        @XCollection(propertyElementName="include_path", elementName="path")
        public List<String> getSerializedIncludePath() {
            return this.myIncludePath;
        }

        public void setSerializedIncludePath(@NotNull List<String> includePaths) {
            if (includePaths == null) {
                State.$$$reportNull$$$0(0);
            }
            this.myIncludePath = includePaths;
        }

        @XCollection(propertyElementName="exclude_path", elementName="path")
        public List<String> getSerializedExcludePath() {
            return this.myExcludePath;
        }

        public void setSerializedExcludePath(@NotNull List<String> includePaths) {
            if (includePaths == null) {
                State.$$$reportNull$$$0(1);
            }
            this.myExcludePath = includePaths;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "includePaths";
            objectArray2[1] = "com/jetbrains/php/config/library/PhpIncludePathManager$State";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSerializedIncludePath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSerializedExcludePath";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

