/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.library;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.php.config.library.PhpLibraryRootProvider;
import java.net.URL;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PhpLibraryRoot
implements PluginAware {
    private static final Logger LOG = Logger.getInstance(PhpLibraryRoot.class);
    static final ExtensionPointName<PhpLibraryRoot> EP_NAME = new ExtensionPointName("com.jetbrains.php.libraryRoot");
    @Attribute(value="path")
    public String path;
    @Attribute(value="runtime")
    public boolean runtime;
    @Attribute(value="implementation")
    public String implementationClass;
    private PluginDescriptor pluginDescriptor;
    private final NotNullLazyValue<PhpLibraryRootProvider> myInstanceHolder = NotNullLazyValue.atomicLazy(() -> {
        if (this.implementationClass == null) {
            return new MyPhpLibraryRootProvider();
        }
        return (PhpLibraryRootProvider)ApplicationManager.getApplication().instantiateClass(this.implementationClass, this.pluginDescriptor);
    });

    @Transient
    public void setPluginDescriptor(@NotNull PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            PhpLibraryRoot.$$$reportNull$$$0(0);
        }
        this.pluginDescriptor = pluginDescriptor;
    }

    @NotNull
    public PhpLibraryRootProvider getProvider() {
        PhpLibraryRootProvider phpLibraryRootProvider = (PhpLibraryRootProvider)this.myInstanceHolder.getValue();
        if (phpLibraryRootProvider == null) {
            PhpLibraryRoot.$$$reportNull$$$0(1);
        }
        return phpLibraryRootProvider;
    }

    @NotNull
    Stream<VirtualFile> getPathBasedLibraryRoots() {
        String patchedPath;
        VirtualFile root = this.findRoot(patchedPath = patchedPath.substring((patchedPath = this.path).startsWith("/") ? 1 : 0, patchedPath.length() - (patchedPath.endsWith("/") ? 1 : 0)));
        if (root != null) {
            if (root.isDirectory()) {
                Stream<VirtualFile> stream = Stream.of(root);
                if (stream == null) {
                    PhpLibraryRoot.$$$reportNull$$$0(2);
                }
                return stream;
            }
            LOG.error("Library root must be a directory", new String[]{patchedPath});
            Stream<VirtualFile> stream = Stream.empty();
            if (stream == null) {
                PhpLibraryRoot.$$$reportNull$$$0(3);
            }
            return stream;
        }
        LOG.error("Please provide either a valid path or an appropriate implementation", new String[]{patchedPath});
        Stream<VirtualFile> stream = Stream.empty();
        if (stream == null) {
            PhpLibraryRoot.$$$reportNull$$$0(4);
        }
        return stream;
    }

    @Nullable
    private VirtualFile findRoot(String path) {
        VirtualFile root;
        URL url = this.findURL(path);
        if (url != null && (root = VfsUtil.findFileByURL((URL)url)) != null) {
            return root;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && (url = this.findURL(path + "/.gitignore")) != null && (root = VfsUtil.findFileByURL((URL)url)) != null) {
            return root.getParent();
        }
        return null;
    }

    @Nullable
    private URL findURL(String path) {
        URL url = this.pluginDescriptor.getClassLoader().getResource(path);
        if (url != null) {
            return url;
        }
        return PhpLibraryRoot.class.getClassLoader().getResource(path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/library/PhpLibraryRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/library/PhpLibraryRoot";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathBasedLibraryRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setPluginDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    private final class MyPhpLibraryRootProvider
    implements PhpLibraryRootProvider {
        private MyPhpLibraryRootProvider() {
        }

        @Override
        @NotNull
        public Stream<VirtualFile> getLibraryRoots(@NotNull Project project) {
            if (project == null) {
                MyPhpLibraryRootProvider.$$$reportNull$$$0(0);
            }
            Stream<VirtualFile> stream = PhpLibraryRoot.this.getPathBasedLibraryRoots();
            if (stream == null) {
                MyPhpLibraryRootProvider.$$$reportNull$$$0(1);
            }
            return stream;
        }

        @Override
        public boolean isRuntime() {
            return PhpLibraryRoot.this.runtime;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/config/library/PhpLibraryRoot$MyPhpLibraryRootProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/config/library/PhpLibraryRoot$MyPhpLibraryRootProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraryRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getLibraryRoots";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

