/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.servers;

import com.intellij.DynamicBundle;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.servers.PhpPathMappingsTreeTable;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.debug.mapping.PhpLocalPathFixer;
import com.jetbrains.php.util.PhpStringUtil;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import com.jetbrains.php.util.pathmapper.PhpRemotePathMapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public final class PhpPathMappingsConfigurable
implements UnnamedConfigurable {
    private JPanel myMainPanel;
    private JCheckBox myUsePathMappingsCheckBox;
    private JPanel myPathMappingsTreeTablePanel;
    private final PhpPathMappingsTreeTable myMappingsTreeTable;
    private final Project myProject;
    private final PhpServer myServer;

    public PhpPathMappingsConfigurable(@NotNull Project project, @NotNull PhpServer server) {
        if (project == null) {
            PhpPathMappingsConfigurable.$$$reportNull$$$0(0);
        }
        if (server == null) {
            PhpPathMappingsConfigurable.$$$reportNull$$$0(1);
        }
        this(project, server, true, Collections.emptySet(), Collections.emptySet());
    }

    public PhpPathMappingsConfigurable(@NotNull Project project, @NotNull PhpServer server, boolean suggestMirror, @NotNull Collection<String> fileSuggestion, @NotNull Collection<String> folderSuggestions) {
        if (project == null) {
            PhpPathMappingsConfigurable.$$$reportNull$$$0(2);
        }
        if (server == null) {
            PhpPathMappingsConfigurable.$$$reportNull$$$0(3);
        }
        if (fileSuggestion == null) {
            PhpPathMappingsConfigurable.$$$reportNull$$$0(4);
        }
        if (folderSuggestions == null) {
            PhpPathMappingsConfigurable.$$$reportNull$$$0(5);
        }
        this.myProject = project;
        this.myServer = server;
        this.$$$setupUI$$$();
        this.myMappingsTreeTable = new PhpPathMappingsTreeTable(project, suggestMirror, fileSuggestion, folderSuggestions);
        this.myPathMappingsTreeTablePanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myMappingsTreeTable)), "Center");
        this.myUsePathMappingsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhpPathMappingsConfigurable.this.myPathMappingsTreeTablePanel.setVisible(PhpPathMappingsConfigurable.this.myUsePathMappingsCheckBox.isSelected());
            }
        });
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        if (this.isUsePathMappings() != this.myServer.isUsePathMappings()) {
            return true;
        }
        return this.isMappingsModified();
    }

    public void apply() {
        this.myServer.setUsePathMappings(this.isUsePathMappings());
        this.myServer.setMappings(this.getMappings());
        PhpProjectConfigurationFacade.getInstance(this.myProject).fireStateChanged();
    }

    public void reset() {
        this.myUsePathMappingsCheckBox.setSelected(this.myServer.isUsePathMappings());
        this.myPathMappingsTreeTablePanel.setVisible(this.myUsePathMappingsCheckBox.isSelected());
        HashMap<VirtualFile, String> map = new HashMap<VirtualFile, String>();
        for (PathMappingSettings.PathMapping mapping : this.myServer.getMappings()) {
            String localRoot = PhpLocalPathFixer.fixLocalPath(mapping.getLocalRoot());
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(localRoot);
            if (file == null) continue;
            map.put(file, mapping.getRemoteRoot());
        }
        this.myMappingsTreeTable.reset(map);
        TreeUtil.collapseAll((JTree)this.myMappingsTreeTable.getTree(), (int)0);
        this.myMappingsTreeTable.expandValues(this.myMainPanel);
    }

    private boolean isMappingsModified() {
        Map values = this.myMappingsTreeTable.getValues();
        List<PathMappingSettings.PathMapping> mappings = this.myServer.getMappings();
        block0: for (PathMappingSettings.PathMapping pathMapping : mappings) {
            for (Map.Entry<VirtualFile, String> entry : values.entrySet()) {
                if (!PhpPathMappingsConfigurable.isMappingEquals(pathMapping, entry)) continue;
                continue block0;
            }
            return true;
        }
        block2: for (Map.Entry entry : values.entrySet()) {
            for (PathMappingSettings.PathMapping pathMapping : mappings) {
                if (!PhpPathMappingsConfigurable.isMappingEquals(pathMapping, entry)) continue;
                continue block2;
            }
            return true;
        }
        return false;
    }

    public boolean isUsePathMappings() {
        return this.myUsePathMappingsCheckBox.isSelected();
    }

    public List<PathMappingSettings.PathMapping> getMappings() {
        ArrayList<PathMappingSettings.PathMapping> mappings = new ArrayList<PathMappingSettings.PathMapping>();
        Map values = this.myMappingsTreeTable.getValues();
        for (Map.Entry entry : values.entrySet()) {
            String local = entry.getKey().getPath();
            String remotePath = (String)entry.getValue();
            if (remotePath.length() <= 0) continue;
            mappings.add(new PathMappingSettings.PathMapping(local, remotePath));
        }
        return mappings;
    }

    public PhpPathMapper getPathMapper() {
        return this.isUsePathMappings() ? new PhpRemotePathMapper(this.getMappings()) : new PhpRemotePathMapper();
    }

    private static boolean isMappingEquals(@NotNull PathMappingSettings.PathMapping mapping, @NotNull Map.Entry<VirtualFile, String> treeMapping) {
        String[] treeLocalPath;
        String[] localPath;
        if (mapping == null) {
            PhpPathMappingsConfigurable.$$$reportNull$$$0(6);
        }
        if (treeMapping == null) {
            PhpPathMappingsConfigurable.$$$reportNull$$$0(7);
        }
        if (PhpStringUtil.isEquals(localPath = PhpPathMapper.getPath(mapping.getLocalRoot()), treeLocalPath = PhpPathMapper.getPath(FileUtil.toSystemIndependentName((String)treeMapping.getKey().getPath())), true)) {
            String[] remotePath = PhpPathMapper.getPath(mapping.getRemoteRoot());
            String[] treeRemotePath = PhpPathMapper.getPath(FileUtil.toSystemIndependentName((String)treeMapping.getValue()));
            return PhpStringUtil.isEquals(remotePath, treeRemotePath, true);
        }
        return false;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 1, null, null, null));
        this.myUsePathMappingsCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpPathMappingsConfigurable.class).getString("PhpPathMappingsConfigurable.use.path.mappings.label"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPathMappingsTreeTablePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSuggestion";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderSuggestions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeMapping";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/config/servers/PhpPathMappingsConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isMappingEquals";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

