/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.debug.PhpDebugConnectionInfo;
import com.jetbrains.php.debug.xdebug.XdebugExtension;
import com.jetbrains.php.debug.zend.ZendDebuggerExtension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDebugSessionLogger
extends CounterUsagesCollector {
    static final EventLogGroup GROUP = new EventLogGroup("php.debug", 5);
    static final EventField<Boolean> COVERAGE = EventFields.Boolean((String)"coverage");
    static final EventField<Boolean> PROFILER = EventFields.Boolean((String)"profiler");
    static final EventField<Boolean> AUTOSTART = EventFields.Boolean((String)"autostart");
    static final EventField<Boolean> CONNECT_BACK = EventFields.Boolean((String)"connect_back");
    static final EventField<String> MODE = EventFields.String((String)"mode", Arrays.asList("req", "jit", "unknown"));
    static final VarargEventId CONFIG = GROUP.registerVarargEvent("config", new EventField[]{COVERAGE, PROFILER, AUTOSTART, CONNECT_BACK, MODE});
    static final EventField<String> TYPE = EventFields.String((String)"type", (List)ContainerUtil.map((Object[])DebugSessionType.values(), t -> StringUtil.toLowerCase((String)t.name())));
    static final EventField<String> DEBUGGER = EventFields.String((String)"debugger", Arrays.asList(XdebugExtension.INSTANCE.getName(), ZendDebuggerExtension.INSTANCE.getName(), "unknown"));
    static final EventField<String> PHP_VERSION = EventFields.StringValidatedByRegexpReference((String)"php_version", (String)"version");
    static final VarargEventId SESSION_STARTED = GROUP.registerVarargEvent("session.started", new EventField[]{TYPE, DEBUGGER, EventFields.Version, PHP_VERSION});
    static final VarargEventId SESSION_ENDED = GROUP.registerVarargEvent("session.ended", new EventField[]{DEBUGGER});
    static final VarargEventId TOO_MUCH_EVENTS = GROUP.registerVarargEvent("too.much.events", new EventField[]{DEBUGGER});
    public static final EventId VIRTUAL_FILE_FRAME_EXISTS = GROUP.registerEvent("virtual.file.frame.exists");
    public static final EventId NAVIGATE_LINK_SHOWN = GROUP.registerEvent("navigate.link.shown");
    public static final EventId NAVIGATE_LINK_CLICKED = GROUP.registerEvent("navigate.link.clicked");
    private static final PhpDebugSessionLogger INSTANCE = new PhpDebugSessionLogger();
    private final int myAllowedEventsRate;
    private final int myAllowedEventNumber;
    private final AtomicInteger myTotalEvents;
    private final PhpTimeProvider myTimeProvider;
    private final AtomicBoolean myRecordedTooMuchSessionsEvent;

    public PhpDebugSessionLogger() {
        this(new PhpSystemTimeProvider(), -1, 150);
    }

    protected PhpDebugSessionLogger(@NotNull PhpTimeProvider timeProvider, int allowedEventRate, int allowedDebugEvents) {
        if (timeProvider == null) {
            PhpDebugSessionLogger.$$$reportNull$$$0(0);
        }
        this.myTotalEvents = new AtomicInteger();
        this.myRecordedTooMuchSessionsEvent = new AtomicBoolean(false);
        this.myAllowedEventsRate = allowedEventRate;
        this.myAllowedEventNumber = allowedDebugEvents;
        this.myTimeProvider = timeProvider;
    }

    @NotNull
    public static PhpDebugSessionLogger getInstance() {
        PhpDebugSessionLogger phpDebugSessionLogger = INSTANCE;
        if (phpDebugSessionLogger == null) {
            PhpDebugSessionLogger.$$$reportNull$$$0(1);
        }
        return phpDebugSessionLogger;
    }

    public boolean isEnabled() {
        return StatisticsUploadAssistant.isCollectAllowed();
    }

    public void logDebugConfig(@NotNull PhpDebugConnectionInfo connection, String[] configurations) {
        if (connection == null) {
            PhpDebugSessionLogger.$$$reportNull$$$0(2);
        }
        if (!this.shouldRecordSession(connection, this.myTotalEvents.incrementAndGet())) {
            return;
        }
        ArrayList data = new ArrayList();
        if (configurations.length == 5) {
            String mode = configurations[4];
            data.add(COVERAGE.with((Object)StringUtil.equals((CharSequence)configurations[0], (CharSequence)"1")));
            data.add(PROFILER.with((Object)StringUtil.equals((CharSequence)configurations[1], (CharSequence)"1")));
            data.add(AUTOSTART.with((Object)StringUtil.equals((CharSequence)configurations[2], (CharSequence)"1")));
            data.add(CONNECT_BACK.with((Object)StringUtil.equals((CharSequence)configurations[3], (CharSequence)"1")));
            data.add(MODE.with((Object)(StringUtil.equals((CharSequence)mode, (CharSequence)"req") || StringUtil.equals((CharSequence)mode, (CharSequence)"jit") ? mode : "unknown")));
            this.logEvent(CONFIG, data);
        }
    }

    public void logSessionStarted(@NotNull PhpDebugConnectionInfo connection, boolean isExternalConnection, boolean isZeroConfigConnection) {
        if (connection == null) {
            PhpDebugSessionLogger.$$$reportNull$$$0(3);
        }
        if (!this.shouldRecordSession(connection, this.myTotalEvents.incrementAndGet())) {
            return;
        }
        DebugSessionType type = isZeroConfigConnection ? DebugSessionType.ZERO_CONFIG : (isExternalConnection ? DebugSessionType.WEB_SERVER : DebugSessionType.CLI);
        ArrayList data = new ArrayList();
        data.add(TYPE.with((Object)StringUtil.toLowerCase((String)type.name())));
        data.add(DEBUGGER.with((Object)PhpDebugSessionLogger.getExtensionName(connection.getEngineName())));
        Version version = connection.getEngineVersion();
        data.add(EventFields.Version.with(version != null ? version.major + "." + version.minor : "unknown.format"));
        data.add(PHP_VERSION.with((Object)PhpDebugSessionLogger.parseVersion(connection.getPhpVersion())));
        this.logEvent(SESSION_STARTED, data);
    }

    public void logSessionEnded(@NotNull PhpDebugConnectionInfo connection) {
        if (connection == null) {
            PhpDebugSessionLogger.$$$reportNull$$$0(4);
        }
        if (!this.shouldRecordSession(connection, this.myTotalEvents.incrementAndGet())) {
            return;
        }
        this.logEvent(SESSION_ENDED, Collections.singletonList(DEBUGGER.with((Object)PhpDebugSessionLogger.getExtensionName(connection.getEngineName()))));
    }

    private boolean shouldRecordSession(@NotNull PhpDebugConnectionInfo connection, int totalEvents) {
        boolean shouldRecord;
        if (connection == null) {
            PhpDebugSessionLogger.$$$reportNull$$$0(5);
        }
        if (!this.isEnabled()) {
            return false;
        }
        boolean bl = shouldRecord = totalEvents > 0 && totalEvents <= this.myAllowedEventNumber;
        if (!shouldRecord && this.myAllowedEventsRate > 0) {
            long interval = this.myTimeProvider.interval();
            boolean bl2 = shouldRecord = interval > 0L && (long)totalEvents <= interval / (long)this.myAllowedEventsRate;
        }
        if (!shouldRecord && this.myRecordedTooMuchSessionsEvent.compareAndSet(false, true)) {
            this.logEvent(TOO_MUCH_EVENTS, Collections.singletonList(DEBUGGER.with((Object)PhpDebugSessionLogger.getExtensionName(connection.getEngineName()))));
        }
        return shouldRecord;
    }

    protected void logEvent(@NotNull VarargEventId eventId, @NotNull List<EventPair<?>> data) {
        if (eventId == null) {
            PhpDebugSessionLogger.$$$reportNull$$$0(6);
        }
        if (data == null) {
            PhpDebugSessionLogger.$$$reportNull$$$0(7);
        }
        eventId.log(data);
    }

    @NotNull
    private static String getExtensionName(@NotNull String debugExtensionName) {
        if (debugExtensionName == null) {
            PhpDebugSessionLogger.$$$reportNull$$$0(8);
        }
        boolean isSupportedExtension = StringUtil.equals((CharSequence)debugExtensionName, (CharSequence)XdebugExtension.INSTANCE.getName()) || StringUtil.equals((CharSequence)debugExtensionName, (CharSequence)ZendDebuggerExtension.INSTANCE.getName());
        return isSupportedExtension ? debugExtensionName : "unknown";
    }

    @NotNull
    private static String parseVersion(@Nullable String versionAsString) {
        if (versionAsString == null) {
            return "unknown";
        }
        Version version = Version.parseVersion((String)versionAsString);
        return version != null ? version.toCompactString() : "unknown.format";
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/PhpDebugSessionLogger";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugExtensionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/PhpDebugSessionLogger";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "logDebugConfig";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "logSessionStarted";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "logSessionEnded";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldRecordSession";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "logEvent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class PhpSystemTimeProvider
    implements PhpTimeProvider {
        private final long myInitTime = System.currentTimeMillis();

        private PhpSystemTimeProvider() {
        }

        @Override
        public long interval() {
            return System.currentTimeMillis() - this.myInitTime;
        }
    }

    public static interface PhpTimeProvider {
        public long interval();
    }

    public static enum DebugSessionType {
        CLI,
        WEB_SERVER,
        ZERO_CONFIG;

    }
}

