/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.CellEditorComponentWithBrowseButton;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.PhpDebugSkippedPathsConfiguration;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.ui.PhpUiUtil;
import com.jetbrains.php.util.ConfigurableForm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;

public class PhpDebugSkippedPathsConfigurableForm
implements ConfigurableForm {
    private JPanel myMainPanel;
    private final TableView<Ref<String>> myPathListTable;
    private final ListTableModel<Ref<String>> myPathListModel;
    private final JCheckBox myNotify;
    private final Project myProject;

    public PhpDebugSkippedPathsConfigurableForm(final @NotNull Project project) {
        if (project == null) {
            PhpDebugSkippedPathsConfigurableForm.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        ColumnInfo<Ref<String>, String> ignorePathColumnInfo = new ColumnInfo<Ref<String>, String>(PhpBundle.message("PhpDebugSkippedPathsConfigurable.column.title", new Object[0])){

            public String valueOf(Ref<String> s) {
                return (String)s.get();
            }

            public boolean isCellEditable(Ref<String> s) {
                return true;
            }

            public TableCellEditor getEditor(Ref<String> o) {
                return new AbstractTableCellEditor(){
                    CellEditorComponentWithBrowseButton<JTextField> myComponent;

                    public Component getTableCellEditorComponent(final JTable table, Object value, boolean isSelected, final int row, int column) {
                        ActionListener listener = new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                VirtualFile fileOrProjectRoot = PhpUiUtil.getFileOrProjectRoot(project, (String)this.getCellEditorValue());
                                VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor((FileType)PhpFileType.INSTANCE), (Component)table, (Project)project, (VirtualFile)fileOrProjectRoot);
                                if (file != null) {
                                    ((JTextField)myComponent.getChildComponent()).setText(file.getPresentableUrl());
                                }
                            }
                        };
                        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton(listener);
                        textFieldWithBrowseButton.setEditable(false);
                        this.myComponent = new CellEditorComponentWithBrowseButton<JTextField>((ComponentWithBrowseButton)textFieldWithBrowseButton, (TableCellEditor)((Object)this)){

                            @NlsSafe
                            public JTextField getChildComponent() {
                                return (JTextField)super.getChildComponent();
                            }
                        };
                        ((JTextField)this.myComponent.getChildComponent()).setText((String)value);
                        ((JTextField)this.myComponent.getChildComponent()).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                            protected void textChanged(@NotNull DocumentEvent e) {
                                if (e == null) {
                                    3.$$$reportNull$$$0(0);
                                }
                                this.setValue((Ref<String>)((Ref)PhpDebugSkippedPathsConfigurableForm.this.myPathListModel.getItems().get(row)), PhpDebugSkippedPathsConfigurableForm.getText((JTextField)myComponent.getChildComponent()));
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/debug/PhpDebugSkippedPathsConfigurableForm$1$1$3", "textChanged"));
                            }
                        });
                        return this.myComponent;
                    }

                    public Object getCellEditorValue() {
                        return PhpDebugSkippedPathsConfigurableForm.getText((JTextField)this.myComponent.getChildComponent());
                    }
                };
            }

            public void setValue(Ref<String> s, String value) {
                s.set((Object)value);
            }
        };
        this.myMainPanel = new JPanel(new BorderLayout(10, 4));
        this.myMainPanel = new JPanel(new BorderLayout(10, 4));
        this.myNotify = new JCheckBox(PhpBundle.message("PhpDebugSkippedPathsConfigurable.notify.about.skipped.files", new Object[0]));
        this.myMainPanel.add((Component)this.myNotify, "North");
        this.myPathListTable = new TableView();
        this.myPathListTable.setShowGrid(false);
        this.myPathListModel = new ListTableModel(new ColumnInfo[]{ignorePathColumnInfo});
        this.myPathListTable.setModelAndUpdateColumns(this.myPathListModel);
        this.myPathListTable.setRowHeight(new JTextField().getPreferredSize().height);
        JPanel tablePanel = ToolbarDecorator.createDecorator(this.myPathListTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ArrayList<Ref> items = new ArrayList<Ref>(PhpDebugSkippedPathsConfigurableForm.this.myPathListModel.getItems());
                items.add(Ref.create((Object)""));
                PhpDebugSkippedPathsConfigurableForm.this.myPathListModel.setItems(items);
                int index = PhpDebugSkippedPathsConfigurableForm.this.myPathListModel.getRowCount() - 1;
                PhpDebugSkippedPathsConfigurableForm.this.myPathListTable.getSelectionModel().setSelectionInterval(index, index);
                PhpDebugSkippedPathsConfigurableForm.this.myPathListTable.scrollRectToVisible(PhpDebugSkippedPathsConfigurableForm.this.myPathListTable.getCellRect(index, 0, true));
                PhpDebugSkippedPathsConfigurableForm.this.myPathListTable.editCellAt(index, 0);
                IdeFocusManager.getInstance((Project)PhpDebugSkippedPathsConfigurableForm.this.myProject).requestFocus(PhpDebugSkippedPathsConfigurableForm.this.myPathListTable.getEditorComponent(), true);
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                PhpDebugSkippedPathsConfigurableForm.this.myPathListTable.stopEditing();
                ArrayList items = new ArrayList(PhpDebugSkippedPathsConfigurableForm.this.myPathListModel.getItems());
                int[] selectedRows = PhpDebugSkippedPathsConfigurableForm.this.myPathListTable.getSelectedRows();
                items.removeAll(PhpDebugSkippedPathsConfigurableForm.this.myPathListTable.getSelection());
                PhpDebugSkippedPathsConfigurableForm.this.myPathListModel.setItems(items);
                if (!items.isEmpty()) {
                    int index = Math.min(selectedRows[0], items.size() - 1);
                    PhpDebugSkippedPathsConfigurableForm.this.myPathListTable.getSelectionModel().addSelectionInterval(index, index);
                }
            }
        }).disableUpDownActions().createPanel();
        this.myMainPanel.add((Component)tablePanel, "Center");
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            PhpDebugSkippedPathsConfigurableForm.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @NlsSafe
    public static String getText(@NlsSafe JTextField component) {
        return component.getText();
    }

    @Override
    public boolean isModified() {
        PhpDebugSkippedPathsConfiguration.State state = PhpDebugSkippedPathsConfiguration.getInstance(this.myProject).getState();
        if (state.isNotify() != this.myNotify.isSelected()) {
            return true;
        }
        List<String> originalIgnoreFile = state.getSkippedFiles();
        List<String> modifiedIgnoreFile = PhpDebugUtil.unwrap(this.myPathListModel.getItems());
        for (String s : modifiedIgnoreFile) {
            if (originalIgnoreFile.contains(s)) continue;
            return true;
        }
        for (String s : originalIgnoreFile) {
            if (modifiedIgnoreFile.contains(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void apply() {
        this.simplify();
        List<String> unwrap = PhpDebugUtil.unwrap(this.myPathListModel.getItems());
        PhpDebugSkippedPathsConfiguration.State state = PhpDebugSkippedPathsConfiguration.getInstance(this.myProject).getState();
        state.setNotify(this.myNotify.isSelected());
        state.setSkippedFiles(unwrap);
    }

    @Override
    public void reset() {
        PhpDebugSkippedPathsConfiguration.State state = PhpDebugSkippedPathsConfiguration.getInstance(this.myProject).getState();
        this.myNotify.setSelected(state.isNotify());
        this.myPathListModel.setItems(PhpDebugUtil.wrap(state.getSkippedFiles()));
    }

    private void simplify() {
        ArrayList items = new ArrayList(this.myPathListModel.getItems());
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            if (!StringUtil.isEmptyOrSpaces((String)((String)((Ref)iterator.next()).get()))) continue;
            iterator.remove();
        }
        this.myPathListModel.setItems(items);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/PhpDebugSkippedPathsConfigurableForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/PhpDebugSkippedPathsConfigurableForm";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

