/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.ui.content.Content;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.frame.XStackFrame;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.phpInfo.PhpDebuggerInfo;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.debug.PhpCommonErrorDetector;
import com.jetbrains.php.debug.PhpDebugExtension;
import com.jetbrains.php.debug.PhpDebugSkippedPathsConfigurable;
import com.jetbrains.php.debug.PhpDebugSkippedPathsConfiguration;
import com.jetbrains.php.debug.PhpDebuggerError;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpDebugRuntimeEnvironment;
import com.jetbrains.php.debug.common.PhpStackFrame;
import com.jetbrains.php.debug.validation.PhpValidateWebServerAction;
import com.jetbrains.php.debug.xdebug.XdebugExtension;
import com.jetbrains.php.debug.zend.ZendDebuggerExtension;
import com.jetbrains.php.run.PhpExecutionUtil;
import com.jetbrains.php.util.PhpStringUtil;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDebugUtil {
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroupManager.getInstance().getNotificationGroup("PHP Debugger");
    public static final String NOTIFICATION_ID = "Debugger";
    @NlsSafe
    private static final String STDOUT_CONSOLE_ID = "PHP_REMOTE_DEBUG_STDOUT_ID";
    @NlsSafe
    public static final String EXPR_PHP_IDE_CONFIG = "getenv('PHP_IDE_CONFIG')";
    @NlsSafe
    public static final String EXPR_GET_SERVER_ADDR = "$_SERVER['SERVER_ADDR']";
    @NlsSafe
    public static final String EXPR_GET_SERVER_NAME = "$_SERVER['SERVER_NAME']";
    @NlsSafe
    public static final String EXPR_GET_SERVER_PORT = "$_SERVER['SERVER_PORT']";
    @NlsSafe
    public static final String EXPR_GET_REQUEST_URI = "$_SERVER['REQUEST_URI']";
    @NlsSafe
    public static final String EXPR_FILE_EXISTS = "file_exists('%1$s')";
    @NlsSafe
    public static final String CAST_TO_STRING = "(string)(%1$s)";
    @NlsSafe
    public static final String EXPR_TRUE = "1";
    @NlsSafe
    public static final String ZEND_DEBUGGER_ID = "php.debugger.ZendDebugger";
    @NlsSafe
    public static final String XDEBUG_DEBUGGER_ID = "php.debugger.XDebug";
    @NlsSafe
    public static final String PROTOCOL_HTTP = "http";
    @NlsSafe
    public static final String PROTOCOL_HTTPS = "https";
    @NlsSafe
    public static final String IDE_EVAL_CACHE = "IDE_EVAL_CACHE";
    @NlsSafe
    public static final String EXPR_IDE_EVAL_CACHE_VAR_TO_ASSIGN = "$GLOBALS['IDE_EVAL_CACHE']";
    @NlsSafe
    public static final String EXPR_IDE_EVAL_CACHE_VAR_TO_FETCH = "$IDE_EVAL_CACHE";
    @NlsSafe
    public static final String VALUE_TRUE = "true";
    @NlsSafe
    public static final String VALUE_FALSE = "false";
    @NlsSafe
    public static final String VALUE_NULL = "null";
    public static final byte[] EMPTY_FILE_CONTENT = ArrayUtilRt.EMPTY_BYTE_ARRAY;
    public static final int DEFAULT_EVAL_DEPTH = 1;

    private PhpDebugUtil() {
    }

    public static void addExternalStdoutTab(@NotNull RunContentDescriptor descriptor, @NotNull ConsoleView consoleView) {
        RunnerLayoutUi ui;
        if (descriptor == null) {
            PhpDebugUtil.$$$reportNull$$$0(0);
        }
        if (consoleView == null) {
            PhpDebugUtil.$$$reportNull$$$0(1);
        }
        if ((ui = descriptor.getRunnerLayoutUi()) != null) {
            Content content = ui.createContent(STDOUT_CONSOLE_ID, consoleView.getComponent(), PhpBundle.message("debug.output", new Object[0]), null, null);
            ui.addContent(content, 2, PlaceInGrid.bottom, false);
        }
    }

    public static void showWarningNotification(@Nullable Project project, @NotNull @Nls String title, @NotNull @Nls String text) {
        if (title == null) {
            PhpDebugUtil.$$$reportNull$$$0(2);
        }
        if (text == null) {
            PhpDebugUtil.$$$reportNull$$$0(3);
        }
        Notifications.Bus.notify((Notification)new Notification(NOTIFICATION_ID, title, text, NotificationType.WARNING), (Project)project);
    }

    public static String getQuery(@NotNull Map<String, String> parameters) {
        if (parameters == null) {
            PhpDebugUtil.$$$reportNull$$$0(4);
        }
        StringBuilder builder2 = new StringBuilder();
        boolean isFirst = true;
        for (String parameterName : parameters.keySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder2.append("&");
            }
            String value = parameters.get(parameterName);
            if (value != null) {
                String encodedParameterValue = URLEncoder.encode(value, StandardCharsets.UTF_8);
                builder2.append(parameterName);
                builder2.append("=");
                builder2.append(encodedParameterValue);
                continue;
            }
            builder2.append(parameterName);
        }
        return builder2.toString();
    }

    public static String getQuery(@NotNull MultiMap<String, String> parameters) {
        if (parameters == null) {
            PhpDebugUtil.$$$reportNull$$$0(5);
        }
        StringBuilder builder2 = new StringBuilder();
        boolean isFirst = true;
        for (String parameterName : parameters.keySet()) {
            if (!parameters.containsKey((Object)parameterName)) continue;
            Collection values = parameters.get((Object)parameterName);
            for (String value : values) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    builder2.append("&");
                }
                String parameterArray = URLEncoder.encode(parameterName + "[]", StandardCharsets.UTF_8);
                String encodedParameterValue = URLEncoder.encode(value, StandardCharsets.UTF_8);
                builder2.append(parameterArray);
                builder2.append("=");
                builder2.append(encodedParameterValue);
            }
        }
        return builder2.toString();
    }

    public static String joinUrl(@NotNull String url, @NotNull String query) {
        if (url == null) {
            PhpDebugUtil.$$$reportNull$$$0(6);
        }
        if (query == null) {
            PhpDebugUtil.$$$reportNull$$$0(7);
        }
        return url + (url.contains("?") ? "&" : "?") + query;
    }

    @NlsSafe
    public static String createUrl(@NotNull String host, int port, @NotNull String protocol, @NotNull String path) {
        if (host == null) {
            PhpDebugUtil.$$$reportNull$$$0(8);
        }
        if (protocol == null) {
            PhpDebugUtil.$$$reportNull$$$0(9);
        }
        if (path == null) {
            PhpDebugUtil.$$$reportNull$$$0(10);
        }
        if (path.startsWith("/")) {
            return protocol + "://" + PhpDebugUtil.getWebServerName(host, port) + path;
        }
        return path;
    }

    public static String getWebServerName(@NotNull String host, int port) {
        if (host == null) {
            PhpDebugUtil.$$$reportNull$$$0(11);
        }
        if (port == 80) {
            return host;
        }
        return host + ":" + port;
    }

    @NotNull
    public static String getFileExistsExpression(@NotNull String remoteFilePath) {
        if (remoteFilePath == null) {
            PhpDebugUtil.$$$reportNull$$$0(12);
        }
        String string = String.format(EXPR_FILE_EXISTS, remoteFilePath);
        if (string == null) {
            PhpDebugUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    public static boolean isXDebug(@NotNull String debuggerId) {
        if (debuggerId == null) {
            PhpDebugUtil.$$$reportNull$$$0(14);
        }
        return XDEBUG_DEBUGGER_ID.equals(debuggerId);
    }

    public static boolean isZendDebugger(@NotNull String debuggerId) {
        if (debuggerId == null) {
            PhpDebugUtil.$$$reportNull$$$0(15);
        }
        return ZEND_DEBUGGER_ID.equals(debuggerId);
    }

    @NotNull
    public static PhpDebugExtension getDebugExtensionByDebuggerId(@NotNull String debuggerId) {
        if (debuggerId == null) {
            PhpDebugUtil.$$$reportNull$$$0(16);
        }
        if (PhpDebugUtil.isXDebug(debuggerId)) {
            XdebugExtension xdebugExtension = XdebugExtension.INSTANCE;
            if (xdebugExtension == null) {
                PhpDebugUtil.$$$reportNull$$$0(17);
            }
            return xdebugExtension;
        }
        if (PhpDebugUtil.isZendDebugger(debuggerId)) {
            ZendDebuggerExtension zendDebuggerExtension = ZendDebuggerExtension.INSTANCE;
            if (zendDebuggerExtension == null) {
                PhpDebugUtil.$$$reportNull$$$0(18);
            }
            return zendDebuggerExtension;
        }
        assert (false) : "Can not find debugger extension by id: '" + debuggerId + "'";
        if (null == null) {
            PhpDebugUtil.$$$reportNull$$$0(19);
        }
        return null;
    }

    public static boolean isUnderSkippedPath(@NotNull Project project, @Nullable String serverName, @NotNull String remoteFilePath) {
        PhpPathMapper pathMapper;
        if (project == null) {
            PhpDebugUtil.$$$reportNull$$$0(20);
        }
        if (remoteFilePath == null) {
            PhpDebugUtil.$$$reportNull$$$0(21);
        }
        if (serverName == null) {
            pathMapper = PhpPathMapper.create(project);
        } else {
            PhpServer server = PhpProjectConfigurationFacade.getInstance(project).findServer(serverName);
            if (server == null) {
                return false;
            }
            pathMapper = PhpPathMapper.create(server);
        }
        String localPath = pathMapper.getLocalPath(remoteFilePath);
        if (localPath == null) {
            return false;
        }
        PhpDebugSkippedPathsConfiguration.State state = PhpDebugSkippedPathsConfiguration.getInstance(project).getState();
        assert (state != null);
        List<String> ignoredFiles = state.getSkippedFiles();
        String[] localFilePath = PhpPathMapper.getPath(localPath);
        for (String ignoredFile : ignoredFiles) {
            if (!PhpStringUtil.isPrefix(localFilePath, PhpPathMapper.getPath(ignoredFile))) continue;
            return true;
        }
        return false;
    }

    public static boolean isPhpInfoHelperScript(@NotNull Project project, @Nullable String serverName, @NotNull String remoteFilePath) {
        PhpPathMapper pathMapper;
        if (project == null) {
            PhpDebugUtil.$$$reportNull$$$0(22);
        }
        if (remoteFilePath == null) {
            PhpDebugUtil.$$$reportNull$$$0(23);
        }
        if (serverName == null) {
            pathMapper = PhpPathMapper.create(project);
        } else {
            PhpServer server = PhpProjectConfigurationFacade.getInstance(project).findServer(serverName);
            if (server == null) {
                return false;
            }
            pathMapper = PhpPathMapper.create(server);
        }
        String localPath = pathMapper.getLocalPath(remoteFilePath);
        if (localPath == null) {
            return false;
        }
        return PhpStringUtil.isPrefix(PhpPathMapper.getPath(localPath), PhpPathMapper.getPath(PhpExecutionUtil.getHelperScriptFilePath("phpinfo.php")));
    }

    public static boolean isHelperScript(@NotNull String remotePath) {
        String fileName;
        if (remotePath == null) {
            PhpDebugUtil.$$$reportNull$$$0(24);
        }
        return FileUtil.namesEqual((String)(fileName = PathUtil.getFileName((String)remotePath)), (String)"_intellij_phpdebug_validator.php") || FileUtil.namesEqual((String)fileName, (String)PhpExecutionUtil.getHelperScriptFileName("phpinfo.php"));
    }

    public static void notifyAboutSkippedFile(@NotNull Project project, @NotNull String remoteFilePath) {
        PhpDebugSkippedPathsConfiguration.State state;
        if (project == null) {
            PhpDebugUtil.$$$reportNull$$$0(25);
        }
        if (remoteFilePath == null) {
            PhpDebugUtil.$$$reportNull$$$0(26);
        }
        if ((state = PhpDebugSkippedPathsConfiguration.getInstance(project).getState()) != null && state.isNotify()) {
            UIUtil.invokeLaterIfNeeded(() -> {
                String message = PhpBundle.message("debug.file.is.ignored", PathUtil.getFileName((String)remoteFilePath)) + "\n" + PhpBundle.message("debug.edit.ignored.paths.list", new Object[0]);
                NOTIFICATION_GROUP.createNotification(message, NotificationType.INFORMATION).setListener((notification, e) -> {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new PhpDebugSkippedPathsConfigurable(project));
                    }
                }).notify(project);
            });
        }
    }

    @NotNull
    public static <T> List<Ref<T>> wrap(@NotNull List<T> list) {
        if (list == null) {
            PhpDebugUtil.$$$reportNull$$$0(27);
        }
        List list2 = ContainerUtil.map(list, s -> Ref.create((Object)s));
        if (list2 == null) {
            PhpDebugUtil.$$$reportNull$$$0(28);
        }
        return list2;
    }

    @NotNull
    public static <T> Set<Ref<T>> wrap(@NotNull Set<T> list) {
        if (list == null) {
            PhpDebugUtil.$$$reportNull$$$0(29);
        }
        Set set = ContainerUtil.map2Set(list, s -> Ref.create((Object)s));
        if (set == null) {
            PhpDebugUtil.$$$reportNull$$$0(30);
        }
        return set;
    }

    @NotNull
    public static <T> List<T> unwrap(@NotNull List<? extends Ref<T>> list) {
        if (list == null) {
            PhpDebugUtil.$$$reportNull$$$0(31);
        }
        List list2 = ContainerUtil.map(list, s -> s.get());
        if (list2 == null) {
            PhpDebugUtil.$$$reportNull$$$0(32);
        }
        return list2;
    }

    @NotNull
    public static String getDebugOutputEncoding(@NotNull Project project) {
        if (project == null) {
            PhpDebugUtil.$$$reportNull$$$0(33);
        }
        String string = EncodingProjectManager.getInstance((Project)project).getDefaultCharset().name();
        if (string == null) {
            PhpDebugUtil.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    public static String getDebuggerNameById(@NotNull String debuggerId) {
        if (debuggerId == null) {
            PhpDebugUtil.$$$reportNull$$$0(35);
        }
        if (PhpDebugUtil.isXDebug(debuggerId)) {
            String string = PhpBundle.message("debug.xdebug", new Object[0]);
            if (string == null) {
                PhpDebugUtil.$$$reportNull$$$0(36);
            }
            return string;
        }
        if (PhpDebugUtil.isZendDebugger(debuggerId)) {
            String string = PhpBundle.message("debug.zend.debugger", new Object[0]);
            if (string == null) {
                PhpDebugUtil.$$$reportNull$$$0(37);
            }
            return string;
        }
        return "";
    }

    @NotNull
    public static Set<String> getLoadedDebuggerIds(@NotNull PhpInfo info) {
        if (info == null) {
            PhpDebugUtil.$$$reportNull$$$0(38);
        }
        HashSet<String> ids = new HashSet<String>();
        for (PhpDebuggerInfo debugger : info.getDebuggers()) {
            String id = PhpDebugUtil.getDebuggerId(debugger);
            if (!StringUtil.isNotEmpty((String)id)) continue;
            ids.add(id);
        }
        HashSet<String> hashSet = ids;
        if (hashSet == null) {
            PhpDebugUtil.$$$reportNull$$$0(39);
        }
        return hashSet;
    }

    @Nullable
    public static String getDebuggerId(@NotNull PhpDebuggerInfo info) {
        if (info == null) {
            PhpDebugUtil.$$$reportNull$$$0(40);
        }
        if (StringUtil.equals((CharSequence)info.getDebugger(), (CharSequence)XdebugExtension.INSTANCE.getName())) {
            return XDEBUG_DEBUGGER_ID;
        }
        if (StringUtil.equals((CharSequence)info.getDebugger(), (CharSequence)ZendDebuggerExtension.INSTANCE.getName())) {
            return ZEND_DEBUGGER_ID;
        }
        return null;
    }

    public static void rebuildAllDebugViews(@NotNull Project project) {
        if (project == null) {
            PhpDebugUtil.$$$reportNull$$$0(41);
        }
        for (PhpDebugProcess process : XDebuggerManager.getInstance((Project)project).getDebugProcesses(PhpDebugProcess.class)) {
            XDebugSession session = process.getSession();
            if (!session.isSuspended()) continue;
            session.rebuildViews();
        }
    }

    public static void showFailsToConnectMessage(Project project, @Nullable String interpreterName) {
        PhpDebugUtil.showFailsToConnectMessage(project, interpreterName, null);
    }

    public static void showFailsToConnectMessage(Project project, @Nullable String interpreterName, @Nullable XDebugSession session) {
        PhpDebuggerError error = PhpCommonErrorDetector.tryToDetect(project, interpreterName, session);
        if (error != null) {
            UIUtil.invokeLaterIfNeeded(() -> error.show(project));
        } else {
            UIUtil.invokeLaterIfNeeded(() -> {
                String message = PhpBundle.message("validation.connection.was.not.established", new Object[0]);
                Notification notification = NOTIFICATION_GROUP.createNotification(message, NotificationType.ERROR);
                notification.addAction((AnAction)new PhpValidateWebServerAction());
                notification.notify(project);
            });
        }
    }

    public static void showWarningBalloon(@Nullable Project project, @NotNull @Nls String title, @NotNull @Nls String text, @Nullable NotificationListener listener) {
        if (title == null) {
            PhpDebugUtil.$$$reportNull$$$0(42);
        }
        if (text == null) {
            PhpDebugUtil.$$$reportNull$$$0(43);
        }
        Notification notification = new Notification(NOTIFICATION_ID, title, text, NotificationType.WARNING);
        if (listener != null) {
            notification.setListener(listener);
        }
        notification.notify(project);
    }

    public static void showInformationBalloon(@Nullable Project project, @NotNull @Nls String title, @NotNull @Nls String text, @Nullable NotificationListener listener) {
        if (title == null) {
            PhpDebugUtil.$$$reportNull$$$0(44);
        }
        if (text == null) {
            PhpDebugUtil.$$$reportNull$$$0(45);
        }
        Notification notification = new Notification(NOTIFICATION_ID, title, text, NotificationType.INFORMATION);
        if (listener != null) {
            notification.setListener(listener);
        }
        notification.notify(project);
    }

    @Nullable
    public static PhpDebugRuntimeEnvironment getCurrentRuntimeEnvironment(@NotNull Project project) {
        XStackFrame frame;
        XDebuggerManager debuggerManager;
        XDebugSession session;
        if (project == null) {
            PhpDebugUtil.$$$reportNull$$$0(46);
        }
        if ((session = (debuggerManager = XDebuggerManager.getInstance((Project)project)).getCurrentSession()) != null && (frame = session.getCurrentStackFrame()) instanceof PhpStackFrame) {
            return ((PhpStackFrame)frame).getRuntimeEnvironment();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 17, 18, 19, 28, 30, 32, 34, 36, 37, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 2: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: 
            case 21: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFilePath";
                break;
            }
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/PhpDebugUtil";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerId";
                break;
            }
            case 20: 
            case 22: 
            case 25: 
            case 33: 
            case 41: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/PhpDebugUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileExistsExpression";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugExtensionByDebuggerId";
                break;
            }
            case 28: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "wrap";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrap";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugOutputEncoding";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebuggerNameById";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedDebuggerIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addExternalStdoutTab";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showWarningNotification";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getQuery";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "joinUrl";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createUrl";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getWebServerName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFileExistsExpression";
                break;
            }
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 39: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isXDebug";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isZendDebugger";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDebugExtensionByDebuggerId";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isUnderSkippedPath";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isPhpInfoHelperScript";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isHelperScript";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "notifyAboutSkippedFile";
                break;
            }
            case 27: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "unwrap";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getDebugOutputEncoding";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getDebuggerNameById";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getLoadedDebuggerIds";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getDebuggerId";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "rebuildAllDebugViews";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "showWarningBalloon";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "showInformationBalloon";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRuntimeEnvironment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 17, 18, 19, 28, 30, 32, 34, 36, 37, 39 -> new IllegalStateException(string);
        };
    }
}

