/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.connection;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.jetbrains.php.debug.PhpDebugConnectionInfo;
import com.jetbrains.php.debug.PhpDebugSessionLogger;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.connection.ConnectionListener;
import com.jetbrains.php.debug.connection.ConnectionStatus;
import com.jetbrains.php.debug.connection.InputHandler;
import com.jetbrains.php.debug.connection.InputMessage;
import com.jetbrains.php.debug.connection.InputReader;
import com.jetbrains.php.debug.connection.Message;
import com.jetbrains.php.debug.connection.OutputMessage;
import com.jetbrains.php.debug.connection.OutputWriter;
import com.jetbrains.php.debug.connection.Request;
import com.jetbrains.php.debug.connection.Response;
import com.jetbrains.php.debug.connection.ResponseHandler;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpDebugConnection<I extends InputMessage, O extends OutputMessage>
implements PhpDebugConnectionInfo,
Disposable {
    protected static final Logger LOG = Logger.getInstance(PhpDebugConnection.class);
    protected final Object myLock;
    private boolean myStoppedReading;
    private boolean myStoppedWriting;
    private boolean myDisposed;
    protected final Int2ObjectMap<TimeoutHandler> myTimeoutHandlers;
    protected final Alarm myTimeoutAlarm;
    private final AtomicInteger myRequestId;
    protected Thread myReadThread;
    protected Thread myWriteThread;
    private final Int2ObjectMap<ResponseHandler<?, ?>> myResponseHandlers;
    protected final MultiValuesMap<Class<? extends Message>, InputHandler<? extends Message>> myNotificationHandlers;
    protected LinkedBlockingQueue<O> myRequests;
    protected InputReader<I> myInputReader;
    protected OutputWriter<O> myOutputWriter;
    private volatile boolean myInitialized;
    protected final EventDispatcher<ConnectionListener> myDispatcher;
    private ConnectionStatus myStatus;

    public PhpDebugConnection(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) {
        if (inputStream == null) {
            PhpDebugConnection.$$$reportNull$$$0(0);
        }
        if (outputStream == null) {
            PhpDebugConnection.$$$reportNull$$$0(1);
        }
        this.myLock = new Object();
        this.myStoppedReading = false;
        this.myStoppedWriting = false;
        this.myDisposed = false;
        this.myTimeoutHandlers = new Int2ObjectOpenHashMap();
        this.myRequestId = new AtomicInteger(0);
        this.myResponseHandlers = new Int2ObjectOpenHashMap();
        this.myNotificationHandlers = new MultiValuesMap();
        this.myInitialized = false;
        this.myDispatcher = EventDispatcher.create(ConnectionListener.class);
        this.myStatus = ConnectionStatus.NOT_CONNECTED;
        this.myTimeoutAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.myRequests = new LinkedBlockingQueue();
        this.init(inputStream, outputStream);
    }

    public void addListener(@NotNull ConnectionListener listener) {
        if (listener == null) {
            PhpDebugConnection.$$$reportNull$$$0(2);
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(@NotNull ConnectionListener listener) {
        if (listener == null) {
            PhpDebugConnection.$$$reportNull$$$0(3);
        }
        this.myDispatcher.removeListener((EventListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(ConnectionStatus status) {
        Object object = this.myLock;
        synchronized (object) {
            this.myStatus = status;
        }
        ((ConnectionListener)this.myDispatcher.getMulticaster()).statusChanged(this, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionStatus getStatus() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatus() {
        Object object = this.myLock;
        synchronized (object) {
            this.setStatus(this.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myDisposed) {
                return;
            }
            this.myDisposed = true;
        }
        this.stop();
    }

    private void init(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) {
        if (inputStream == null) {
            PhpDebugConnection.$$$reportNull$$$0(4);
        }
        if (outputStream == null) {
            PhpDebugConnection.$$$reportNull$$$0(5);
        }
        this.myInputReader = this.createInputReader(inputStream);
        this.myOutputWriter = this.createOutputWriter(outputStream);
    }

    public abstract void init() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTimeout() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myDisposed) {
                return;
            }
        }
        this.logEvent("Checking timeout");
        ArrayList timedOut = new ArrayList();
        Iterator iterator = this.myLock;
        synchronized (iterator) {
            long time = System.currentTimeMillis();
            this.myTimeoutHandlers.values().removeIf(b -> {
                if (time > b.myLastTime) {
                    timedOut.add(b);
                    return true;
                }
                return false;
            });
        }
        for (TimeoutHandler handler : timedOut) {
            this.logEvent("performing timeout action: " + handler.myAction);
            handler.myAction.run();
        }
        this.scheduleTimeoutCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleTimeoutCheck() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myDisposed) {
                return;
            }
        }
        Ref nextTime = Ref.create((Object)Long.MAX_VALUE);
        Object object2 = this.myLock;
        synchronized (object2) {
            if (this.myTimeoutHandlers.isEmpty()) {
                return;
            }
            for (TimeoutHandler handler : this.myTimeoutHandlers.values()) {
                nextTime.set((Object)Math.min((Long)nextTime.get(), handler.myLastTime));
            }
        }
        int delay = (int)((Long)nextTime.get() - System.currentTimeMillis() + 100L);
        this.logEvent("schedule timeout check in " + delay + "ms");
        if (delay > 10) {
            this.myTimeoutAlarm.cancelAllRequests();
            this.myTimeoutAlarm.addRequest(() -> this.checkTimeout(), delay);
        } else {
            this.checkTimeout();
        }
    }

    public int getNextRequestId() {
        return this.myRequestId.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTimeoutHandler(int requestId, int timeout, Runnable onTimeout) {
        Object object = this.myLock;
        synchronized (object) {
            this.myTimeoutHandlers.put(requestId, (Object)new TimeoutHandler(onTimeout, System.currentTimeMillis() + (long)timeout));
        }
        this.scheduleTimeoutCheck();
    }

    private void start() {
        this.myWriteThread = Thread.currentThread();
        this.startReading();
        this.processCommands();
    }

    public void stop() {
        this.stopReading();
        this.stopWriting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopWriting() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myStoppedWriting) {
                return;
            }
            this.myStoppedWriting = true;
        }
        if (this.myWriteThread != null) {
            this.myWriteThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopReading() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myStoppedReading) {
                return;
            }
            this.myStoppedReading = true;
        }
        if (this.myReadThread != null) {
            this.myReadThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends Response> void registerResponseHandler(Request<R> request, @NotNull ResponseHandler<R, ?> handler) {
        if (handler == null) {
            PhpDebugConnection.$$$reportNull$$$0(6);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myResponseHandlers.put(request.getRequestId(), handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Message> void registerClassHandler(@NotNull Class<T> aClass, @NotNull InputHandler<T> handler) {
        if (aClass == null) {
            PhpDebugConnection.$$$reportNull$$$0(7);
        }
        if (handler == null) {
            PhpDebugConnection.$$$reportNull$$$0(8);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myNotificationHandlers.put(aClass, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleResponse(@NotNull Response response) {
        ResponseHandler responseHandler;
        if (response == null) {
            PhpDebugConnection.$$$reportNull$$$0(9);
        }
        int requestId = response.getRequestId();
        Object object = this.myLock;
        synchronized (object) {
            this.myTimeoutHandlers.remove(requestId);
            responseHandler = (ResponseHandler)this.myResponseHandlers.get(requestId);
        }
        if (responseHandler == null) {
            return false;
        }
        if (response.isSuccessResponse()) {
            try {
                responseHandler.onSuccessResponse(response);
            }
            catch (ClassCastException e) {
                this.handleClassCastException(e);
            }
        } else {
            responseHandler.onErrorResponse(response);
        }
        return true;
    }

    protected abstract void handleClassCastException(@NotNull ClassCastException var1);

    public <R extends Response, ER extends Response> void send(@NotNull Request<R> request, @Nullable ResponseHandler<R, ER> responseHandler) {
        if (request == null) {
            PhpDebugConnection.$$$reportNull$$$0(10);
        }
        request.setRequestId(this.getNextRequestId());
        if (responseHandler != null) {
            this.registerResponseHandler(request, responseHandler);
        }
        try {
            this.myRequests.put((OutputMessage)((Object)request));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleInput(@NotNull I notification) {
        Collection notificationHandlers;
        if (notification == null) {
            PhpDebugConnection.$$$reportNull$$$0(11);
        }
        Iterator iterator = this.myLock;
        synchronized (iterator) {
            notificationHandlers = this.myNotificationHandlers.get(notification.getClass());
        }
        if (notificationHandlers != null) {
            for (InputHandler notificationHandler : notificationHandlers) {
                notificationHandler.onResponse(notification);
            }
        }
    }

    public void send(@NotNull O notification) {
        if (notification == null) {
            PhpDebugConnection.$$$reportNull$$$0(12);
        }
        try {
            this.myRequests.put(notification);
        }
        catch (InterruptedException e) {
            LOG.debug("cannot send request", (Throwable)e);
        }
    }

    public abstract void startDetach();

    public boolean isIncludeReturnValueBreakpointSupported() {
        return false;
    }

    protected abstract boolean isDebugSessionActive();

    protected void startReading() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            this.myReadThread = Thread.currentThread();
            try {
                while (this.isDebugSessionActive()) {
                    Object message = this.myInputReader.read();
                    this.logMessage(message, "<-");
                    if (message instanceof Response && this.handleResponse((Response)message)) continue;
                    this.handleInput(message);
                }
            }
            catch (IOException e) {
                this.logEvent(e.getMessage());
            }
            finally {
                this.myWriteThread.interrupt();
                this.logEvent("stop reading");
                Object object = this.myLock;
                synchronized (object) {
                    this.myStoppedReading = true;
                }
            }
        });
    }

    protected void processCommands() {
        try {
            try {
                while (true) {
                    Runnable onTimeout;
                    OutputMessage request;
                    if ((request = (OutputMessage)this.myRequests.take()) instanceof Request && (onTimeout = ((Request)((Object)request)).getOnTimeout()) != null) {
                        this.registerTimeoutHandler(((Request)((Object)request)).getRequestId(), ((Request)((Object)request)).getTimeout(), onTimeout);
                    }
                    this.myOutputWriter.write(request);
                    this.logMessage(request, "->");
                }
            }
            catch (IOException | InterruptedException exception) {
                this.logEvent("stop writing");
            }
        }
        catch (Throwable throwable) {
            this.logEvent("stop writing");
            throw throwable;
        }
    }

    public final void log(String text) {
        StringBuilder builder2 = new StringBuilder();
        builder2.append(this.hashCode());
        builder2.append("#");
        builder2.append(text);
        if (LOG.isDebugEnabled()) {
            LOG.debug(builder2.toString());
        }
    }

    protected final void logMessage(Object message, String direction) {
        if (LOG.isTraceEnabled()) {
            StringBuilder builder2 = new StringBuilder();
            builder2.append(direction);
            String fullClassName = message.getClass().getName();
            builder2.append(fullClassName.substring(fullClassName.lastIndexOf(".") + 1));
            builder2.append(" '").append(message.toString()).append("'");
            LOG.trace(this.hashCode() + "#" + builder2.toString());
        }
    }

    public final void logEvent(String text) {
        this.log("---" + text);
    }

    public void connect() {
        this.setStatus(ConnectionStatus.CONNECTED);
        this.log("----connection started");
        this.start();
        this.log("----connection stopped");
        this.setStatus(ConnectionStatus.DISCONNECTED);
    }

    @NotNull
    protected abstract InputReader<I> createInputReader(InputStream var1);

    @NotNull
    protected abstract OutputWriter<O> createOutputWriter(OutputStream var1);

    @NotNull
    public abstract String getSessionId();

    @NotNull
    public abstract String getFilePath();

    public abstract void evalBoolean(@NotNull String var1, @NotNull String var2, @NotNull PhpDebugProcess.BooleanEvaluateCallback var3);

    public abstract void evalString(@NotNull String var1, @NotNull String var2, @NotNull PhpDebugProcess.StringEvaluateCallback var3);

    public final void initializeConnection(@NotNull PhpDebugProcess.InitializeCallback callback, boolean isExternalConnection, boolean isZeroConfigConnection) {
        if (callback == null) {
            PhpDebugConnection.$$$reportNull$$$0(13);
        }
        if (this.myInitialized) {
            callback.initialized(false);
        } else {
            this.myInitialized = true;
            PhpDebugSessionLogger.getInstance().logSessionStarted(this, isExternalConnection, isZeroConfigConnection);
            this.initialize(callback, isExternalConnection);
        }
    }

    protected abstract void initialize(@NotNull PhpDebugProcess.InitializeCallback var1, boolean var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/connection/PhpDebugConnection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeListener";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "registerResponseHandler";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "registerClassHandler";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "handleResponse";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "send";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInput";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "initializeConnection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class TimeoutHandler {
        private final Runnable myAction;
        private final long myLastTime;

        public TimeoutHandler(Runnable action, long lastTime) {
            this.myAction = action;
            this.myLastTime = lastTime;
        }
    }
}

