/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.connection;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Alarm;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.common.PhpDebugDriver;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpDebugProcessFactory;
import com.jetbrains.php.debug.connection.PhpDebugConnection;
import com.jetbrains.php.debug.connection.PhpDebugNotification;
import com.jetbrains.php.debug.listener.PhpDebugExternalConnectionsAccepter;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpDebugExternalConnectionsProjectManager<C extends PhpDebugConnection>
implements Disposable {
    private static final Logger LOG = Logger.getInstance(PhpDebugExternalConnectionsProjectManager.class);
    private final Object myLock;
    private final Project myProject;
    private final Alarm myAlarm;
    private boolean myEnabled;
    private final Set<C> myOperatingConnections;
    private final LinkedList<Pair<C, String>> myWaitingConnections;
    private RunContentDescriptor myRunContentDescriptor;

    public PhpDebugExternalConnectionsProjectManager(@NotNull Project project) {
        if (project == null) {
            PhpDebugExternalConnectionsProjectManager.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myEnabled = false;
        this.myOperatingConnections = new HashSet<C>();
        this.myWaitingConnections = new LinkedList();
        this.myProject = project;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(PhpDebugExternalConnectionsAccepter.StateChangedListener.TOPIC, (Object)new PhpDebugExternalConnectionsAccepter.StateChangedListener(){

            @Override
            public void stateChanged() {
                PhpDebugExternalConnectionsProjectManager.this.accepterStateChanged();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void scheduleConnection(@NotNull C connection, @Nullable String serverName) {
        if (connection == null) {
            PhpDebugExternalConnectionsProjectManager.$$$reportNull$$$0(1);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myWaitingConnections.addLast(Pair.create(connection, (Object)serverName));
        }
    }

    public final void dispose() {
        this.detachConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEnabled() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isConnected() {
        int maxSimultaneousConnections = PhpProjectDebugConfiguration.getInstance(this.myProject).getState().getMaxSimultaneousConnections();
        Object object = this.myLock;
        synchronized (object) {
            return this.myOperatingConnections.size() >= maxSimultaneousConnections;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConnected(@NotNull C connection) {
        if (connection == null) {
            PhpDebugExternalConnectionsProjectManager.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myOperatingConnections.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDisconnected(@NotNull C connection) {
        if (connection == null) {
            PhpDebugExternalConnectionsProjectManager.$$$reportNull$$$0(3);
        }
        Object object = this.myLock;
        synchronized (object) {
            LOG.assertTrue(this.myOperatingConnections.remove(connection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accepterStateChanged() {
        PhpDebugExternalConnectionsAccepter connectionsAccepter = PhpDebugExternalConnectionsAccepter.getInstance(this.myProject);
        Object object = this.myLock;
        synchronized (object) {
            this.myEnabled = connectionsAccepter.isStarted();
            if (this.myEnabled) {
                this.scheduleOperate();
            } else {
                this.detachConnections();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detachConnections() {
        Object object = this.myLock;
        synchronized (object) {
            for (Pair pair : this.myWaitingConnections) {
                ((PhpDebugConnection)pair.getFirst()).startDetach();
            }
            this.myWaitingConnections.clear();
        }
    }

    private void scheduleOperate() {
        if (this.myAlarm.isDisposed()) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> {
            if (this.isEnabled()) {
                this.operate();
            }
        }, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void operate() {
        Pair<C, String> connection;
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myEnabled) {
                return;
            }
        }
        this.scheduleOperate();
        Object object2 = this.myLock;
        synchronized (object2) {
            if (!this.isConnected()) {
                connection = this.myWaitingConnections.pollFirst();
                if (connection != null) {
                    this.setConnected((PhpDebugConnection)connection.getFirst());
                }
            } else {
                return;
            }
        }
        if (connection != null) {
            this.handleConnection((PhpDebugConnection)connection.getFirst(), (String)connection.getSecond());
        }
    }

    private void handleConnection(@NotNull C connection, final @Nullable String serverName) {
        String remoteFilePath;
        if (connection == null) {
            PhpDebugExternalConnectionsProjectManager.$$$reportNull$$$0(4);
        }
        if (PhpDebugUtil.isUnderSkippedPath(this.myProject, serverName, remoteFilePath = ((PhpDebugConnection)connection).getFilePath())) {
            PhpDebugUtil.notifyAboutSkippedFile(this.myProject, remoteFilePath);
            ((PhpDebugConnection)connection).startDetach();
            this.setDisconnected(connection);
            return;
        }
        if (PhpDebugUtil.isPhpInfoHelperScript(this.myProject, serverName, remoteFilePath)) {
            ((PhpDebugConnection)connection).startDetach();
            this.setDisconnected(connection);
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            try {
                if (this.myProject.isDisposed()) {
                    throw new ExecutionException(PhpBundle.message("project.is.already.disposed", new Object[0]));
                }
                String tabTitle = PathUtil.getFileName((String)remoteFilePath);
                XDebugSession debugSession = XDebuggerManager.getInstance((Project)this.myProject).startSessionAndShowTab(tabTitle, this.myRunContentDescriptor, true, new XDebugProcessStarter((PhpDebugConnection)connection){
                    final /* synthetic */ PhpDebugConnection val$connection;
                    {
                        this.val$connection = phpDebugConnection;
                    }

                    @NotNull
                    public XDebugProcess start(final @NotNull XDebugSession session) {
                        if (session == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        session.addSessionListener(new XDebugSessionListener(){
                            boolean wasPaused = false;

                            public void sessionPaused() {
                                this.wasPaused = true;
                            }

                            public void sessionStopped() {
                                PhpDebugProcess debugProcess;
                                RunContentDescriptor runContentDescriptor;
                                PhpProjectDebugConfiguration.State state;
                                PhpProjectDebugConfiguration.State state2 = state = PhpDebugExternalConnectionsProjectManager.this.myProject.isDisposed() ? null : PhpProjectDebugConfiguration.getInstance(PhpDebugExternalConnectionsProjectManager.this.myProject).getState();
                                if (StringUtil.isNotEmpty((String)serverName) && state != null && state.isNotifyIfSessionWasFinishedWithoutBeingPaused() && !this.wasPaused) {
                                    PhpDebugNotification.showNotification(PhpDebugExternalConnectionsProjectManager.this.myProject, serverName);
                                }
                                if ((runContentDescriptor = (debugProcess = (PhpDebugProcess)session.getDebugProcess()).getRunContentDescriptor()) != null) {
                                    PhpDebugExternalConnectionsProjectManager.this.myRunContentDescriptor = runContentDescriptor;
                                }
                                PhpDebugExternalConnectionsProjectManager.this.setDisconnected(val$connection);
                            }
                        });
                        PhpDebugProcess phpDebugProcess = PhpDebugProcessFactory.forExternalConnection(session, serverName, PhpDebugExternalConnectionsProjectManager.this.getDriver());
                        if (phpDebugProcess == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        return phpDebugProcess;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 3;
                            case 1 -> 2;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "session";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/jetbrains/php/debug/connection/PhpDebugExternalConnectionsProjectManager$2";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/jetbrains/php/debug/connection/PhpDebugExternalConnectionsProjectManager$2";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "start";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "start";
                                break;
                            }
                            case 1: {
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalArgumentException(string);
                            case 1 -> new IllegalStateException(string);
                        };
                    }
                });
                PhpDebugProcess debugProcess = (PhpDebugProcess)debugSession.getDebugProcess();
                debugProcess.connect(connection);
            }
            catch (ExecutionException e) {
                this.setDisconnected(connection);
            }
        });
    }

    protected abstract PhpDebugDriver<C> getDriver();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/connection/PhpDebugExternalConnectionsProjectManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleConnection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setConnected";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setDisconnected";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "handleConnection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

