/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.validation;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpInfoValidationMessage;
import com.jetbrains.php.debug.validation.PhpWebServerValidator;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpLocalWebServerValidator
extends PhpWebServerValidator {
    @NlsSafe
    private static final String FILE_NAME = "file_name";
    private final String myWebPathToValidationDir;

    public PhpLocalWebServerValidator(@NotNull Project project, @Nullable String webPathToValidationDir) {
        if (project == null) {
            PhpLocalWebServerValidator.$$$reportNull$$$0(0);
        }
        super(project);
        this.myWebPathToValidationDir = webPathToValidationDir;
    }

    @Override
    @NotNull
    protected PhpInfoValidationMessage getMessageForNotAFileException(@NotNull @NlsSafe String path, @NotNull @NlsSafe String webPath, @Nullable String originalException) {
        if (path == null) {
            PhpLocalWebServerValidator.$$$reportNull$$$0(1);
        }
        if (webPath == null) {
            PhpLocalWebServerValidator.$$$reportNull$$$0(2);
        }
        Object presentableWebPath = StringUtil.endsWith((CharSequence)webPath, (CharSequence)"/") ? webPath : webPath + "/";
        HtmlBuilder builder2 = new HtmlBuilder();
        builder2.append(PhpBundle.message("validation.script.will.be.created.in.0.directory", HtmlChunk.text((String)("'" + path + "'")).bold().toString())).br();
        builder2.append(PhpBundle.message("files.in.the.directory.should.be.accessible.by.0.request", HtmlChunk.text((String)("'" + (String)presentableWebPath + "file_name'")).bold().toString())).br().br();
        builder2.append(PhpBundle.message("caused.by.0", originalException));
        String message = PhpBundle.message("php.web.server.validation.script.local.result.path.mapping.check", path);
        PhpInfoValidationMessage phpInfoValidationMessage = PhpInfoValidationMessage.failed(message, builder2.toString(), new Runnable[0]);
        if (phpInfoValidationMessage == null) {
            PhpLocalWebServerValidator.$$$reportNull$$$0(3);
        }
        return phpInfoValidationMessage;
    }

    @Override
    @Nullable
    @NlsContexts.Label
    protected String validateWebServerConfiguration(@NotNull VirtualFile baseDir, @NotNull JComponent parentComponent) {
        if (baseDir == null) {
            PhpLocalWebServerValidator.$$$reportNull$$$0(4);
        }
        if (parentComponent == null) {
            PhpLocalWebServerValidator.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmpty((String)this.myWebPathToValidationDir)) {
            return PhpBundle.message("php.web.server.validation.failed.to.find.web.path", new Object[0]);
        }
        return null;
    }

    @Override
    protected String getWebPathToValidationDir(@NotNull VirtualFile baseDir) {
        if (baseDir == null) {
            PhpLocalWebServerValidator.$$$reportNull$$$0(6);
        }
        return this.myWebPathToValidationDir;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/validation/PhpLocalWebServerValidator";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/validation/PhpLocalWebServerValidator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageForNotAFileException";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMessageForNotAFileException";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validateWebServerConfiguration";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getWebPathToValidationDir";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

