/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.xdebug.connection.XdebugConnection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\r"}, d2={"Lcom/jetbrains/php/debug/xdebug/actions/XdebugDetachFromSessionAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "getDebugSession", "Lcom/jetbrains/php/debug/common/PhpDebugProcess;", "intellij.php.impl"})
public final class XdebugDetachFromSessionAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        PhpDebugProcess<?> phpDebugProcess = this.getDebugSession(e);
        if (phpDebugProcess == null) {
            return;
        }
        PhpDebugProcess<?> debugProcess = phpDebugProcess;
        Object obj = debugProcess.getConnection();
        XdebugConnection xdebugConnection = obj instanceof XdebugConnection ? (XdebugConnection)obj : null;
        if (xdebugConnection == null) {
            return;
        }
        XdebugConnection connection = xdebugConnection;
        connection.setToDetach(true);
        debugProcess.getProcessHandler().detachProcess();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        PhpDebugProcess<?> phpDebugProcess;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible((phpDebugProcess = this.getDebugSession(e)) != null && (phpDebugProcess = phpDebugProcess.getConnection()) != null && (phpDebugProcess = phpDebugProcess.getEngineVersion()) != null ? phpDebugProcess.isOrGreaterThan(3) : false);
    }

    private final PhpDebugProcess<?> getDebugSession(AnActionEvent e) {
        PhpDebugProcess phpDebugProcess;
        Project project = e.getProject();
        if (project != null) {
            XDebugProcess xDebugProcess;
            Project it = project;
            boolean bl = false;
            XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)it).getCurrentSession();
            Object object = xDebugProcess = xDebugSession != null ? xDebugSession.getDebugProcess() : null;
            phpDebugProcess = xDebugProcess instanceof PhpDebugProcess ? (PhpDebugProcess)xDebugProcess : null;
        } else {
            phpDebugProcess = null;
        }
        return phpDebugProcess;
    }
}

