/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.dbgp.messages;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.io.URLUtil;
import com.jetbrains.php.debug.xdebug.dbgp.DbgpUtil;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpExceptionBreak;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpInputMessage;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpReason;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpStatus;
import java.io.IOException;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;

public class StatusResponse
extends DbgpResponse {
    private DbgpStatus myStatus;
    private DbgpReason myReason;
    private String myUrl;
    private DbgpExceptionBreak myException;
    private int myLineNumber;

    @Override
    public DbgpInputMessage deserialize(Element packet) throws IOException {
        super.deserialize(packet);
        String status = packet.getAttributeValue("status");
        String reason = packet.getAttributeValue("reason");
        if (reason == null || status == null) {
            throw new IOException("Deserialization exception: Status response: status or reason is null");
        }
        this.myReason = DbgpReason.deserialize(reason);
        this.myStatus = DbgpStatus.deserialize(status);
        Element messageTag = DbgpUtil.getXdebugTag(packet, "message");
        if (messageTag != null) {
            this.myUrl = URLUtil.decode((String)messageTag.getAttributeValue("filename"));
            String line = messageTag.getAttributeValue("lineno");
            this.myLineNumber = StringUtilRt.parseInt((String)line, (int)0) - 1;
            String exceptionName = messageTag.getAttributeValue("exception");
            if (StringUtil.isNotEmpty((String)exceptionName)) {
                List content = packet.getContent();
                String value = !content.isEmpty() ? ((Content)content.get(0)).getValue() : "";
                String code = messageTag.getAttributeValue("code");
                this.myException = new DbgpExceptionBreak(exceptionName, value, code);
            }
        }
        return this;
    }

    public DbgpReason getReason() {
        return this.myReason;
    }

    public DbgpStatus getStatus() {
        return this.myStatus;
    }

    public String getUrl() {
        return this.myUrl;
    }

    public int getLineNumber() {
        return this.myLineNumber;
    }

    public DbgpExceptionBreak getException() {
        return this.myException;
    }

    public String toString() {
        StringBuilder out = new StringBuilder("status=" + this.myStatus + ", reason=" + this.myReason);
        if (StringUtil.isNotEmpty((String)this.myUrl)) {
            out.append(", filename='").append(this.myUrl).append('\'');
            if (this.myLineNumber > 0) {
                out.append(", lineno='").append(this.myLineNumber).append('\'');
            }
        }
        return out.toString();
    }
}

