/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.debugger;

import com.intellij.codeInsight.navigation.PsiTargetNavigator;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.ImmediateFullValueEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.debug.PhpDebugSessionLogger;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpEvaluationResultProcessor;
import com.jetbrains.php.debug.common.PhpEvaluator;
import com.jetbrains.php.debug.common.PhpNavigatableValue;
import com.jetbrains.php.debug.connection.PhpDebugConnection;
import com.jetbrains.php.debug.xdebug.XdebugUtil;
import com.jetbrains.php.debug.xdebug.connection.XdebugConnection;
import com.jetbrains.php.debug.xdebug.dbgp.DbgpUtil;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ErrorResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.PropertyGetRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.PropertyGetResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.PropertySetRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.PropertyValueRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.PropertyValueResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.SetResponse;
import com.jetbrains.php.debug.xdebug.dbgp.model.DbgpProperty;
import com.jetbrains.php.debug.xdebug.handlers.DbgpResponseHandler;
import com.jetbrains.php.lang.PhpCallbackFunctionUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.awt.Font;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

public final class XdebugValue
extends PhpNavigatableValue {
    private static final Logger LOG = Logger.getInstance(XdebugValue.class);
    private static final String ANONYMOUS_CLASS = "class@anonymous";
    public static final String STATIC_SEPARATOR = "::";
    public static final int ARRAY_CHILDREN_LIMIT = 5;
    @NotNull
    private final PhpDebugProcess<XdebugConnection> myDebugProcess;
    private final int myStackDepth;
    private final int myContextId;
    @NotNull
    private final DbgpProperty myProperty;
    @Nullable
    private final String myNameOverride;
    @Nullable
    private final String myFullNameOverride;
    private final String myEvalCacheKey;
    private static final String ARROW = "->";
    @Nullable
    public final String myParentClassName;
    public final String myParentFullName;
    private final boolean myParentIsArray;

    public XdebugValue(@NotNull PhpDebugProcess<XdebugConnection> debugProcess, int stackDepth, int contextId, @NotNull DbgpProperty property, @Nullable String nameOverride, @Nullable String parentClassName, @Nullable String parentFullName, boolean parentIsArray, @Nullable String fullNameOverride, @Nullable String evalCacheKey) {
        if (debugProcess == null) {
            XdebugValue.$$$reportNull$$$0(0);
        }
        if (property == null) {
            XdebugValue.$$$reportNull$$$0(1);
        }
        this.myDebugProcess = debugProcess;
        this.myStackDepth = stackDepth;
        this.myContextId = contextId;
        this.myProperty = property;
        this.myNameOverride = nameOverride;
        this.myParentClassName = parentClassName;
        this.myParentFullName = parentFullName;
        this.myParentIsArray = parentIsArray;
        this.myFullNameOverride = fullNameOverride;
        this.myEvalCacheKey = evalCacheKey;
    }

    public XdebugValue(@NotNull PhpDebugProcess<XdebugConnection> debugProcess, int stackDepth, int contextId, @NotNull DbgpProperty property) {
        if (debugProcess == null) {
            XdebugValue.$$$reportNull$$$0(2);
        }
        if (property == null) {
            XdebugValue.$$$reportNull$$$0(3);
        }
        this(debugProcess, stackDepth, contextId, property, null, null, null, false, null, null);
    }

    public ValueDescriptor getValue() {
        return XdebugValue.getValue(this.myDebugProcess.getSession().getProject(), this.myProperty);
    }

    @NotNull
    public static ValueDescriptor getValue(@NotNull Project project, @NotNull DbgpProperty property) {
        String type;
        if (project == null) {
            XdebugValue.$$$reportNull$$$0(4);
        }
        if (property == null) {
            XdebugValue.$$$reportNull$$$0(5);
        }
        String encoding = PhpDebugUtil.getDebugOutputEncoding(project);
        if (property.isBoolean()) {
            boolean booleanValue = DbgpUtil.toBoolean((String)property.getLoadedValue((String)encoding).first);
            return new ValueDescriptor(booleanValue ? "true" : "false", false);
        }
        if (property.isArray() && (type = XdebugValue.getConcreteArrayType(property)) != null && PhpType.isNotExtendablePrimitiveType(type)) {
            List children = ((StreamEx)StreamEx.of(property.getLoadedChildren()).limit(5L)).map(p -> {
                String value = (String)p.getLoadedValue(encoding).getFirst();
                return PhpType.isString(type) ? XdebugValue.compactString(value) : value;
            }).toList();
            int remainingCount = property.getChildCount() - 5;
            if (remainingCount > 0) {
                children = ContainerUtil.append((List)children, (Object[])new String[]{String.format("+%d more", remainingCount)});
            }
            return new ValueDescriptor("[" + StringUtil.join((Collection)children, (String)", ") + "]", false);
        }
        if (property.isNull()) {
            return new ValueDescriptor("null", false);
        }
        boolean isTrimmed = false;
        Pair<String, Integer> valueAndSize = property.getLoadedValue(encoding);
        String value = (String)valueAndSize.first;
        if ((Integer)valueAndSize.second < property.getValueSize()) {
            isTrimmed = true;
        }
        return new ValueDescriptor(value, isTrimmed);
    }

    @NotNull
    private static String compactString(String first) {
        String string = "\"" + StringUtil.first((String)StringUtil.unquoteString((String)first), (int)15, (boolean)true) + "\"";
        if (string == null) {
            XdebugValue.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        String possibleElementRef;
        Icon icon;
        if (node == null) {
            XdebugValue.$$$reportNull$$$0(7);
        }
        if (place == null) {
            XdebugValue.$$$reportNull$$$0(8);
        }
        StringBuilder type = new StringBuilder();
        if (this.myProperty.isObject()) {
            icon = AllIcons.Debugger.Value;
            type.append(this.myProperty.getClassName(PhpDebugUtil.getDebugOutputEncoding(this.getSession().getProject())));
        } else if (this.myProperty.isArray()) {
            icon = AllIcons.Debugger.Db_array;
            String concreteArrayType = (String)ObjectUtils.notNull((Object)XdebugValue.getConcreteArrayType(this.myProperty), (Object)"\\array");
            type.append(String.format("%s[%d]", PhpLangUtil.toPresentableFQN(concreteArrayType), this.myProperty.getChildCount()));
        } else if (this.myProperty.isResource()) {
            icon = AllIcons.Debugger.Db_primitive;
            type.append(PhpBundle.message("debug.type.resource", new Object[0]));
        } else if (this.myProperty.isNumber()) {
            icon = AllIcons.Debugger.Db_primitive;
            if (this.myProperty.isFloat()) {
                type.append(PhpBundle.message("debug.type.float", new Object[0]));
            } else {
                type.append(PhpBundle.message("debug.type.int", new Object[0]));
            }
        } else {
            icon = AllIcons.Debugger.Db_primitive;
        }
        if (this.myProperty.isReturnValue()) {
            icon = AllIcons.Debugger.WatchLastReturnValue;
        }
        ValueDescriptor value = this.getValue();
        String typePresentation = type.length() > 0 ? type.toString() : null;
        boolean isTrimmed = value.isTrimmed();
        String valuePresentation = value.value();
        if (valuePresentation.length() > 1000 && !isTrimmed) {
            node.setFullValueEvaluator((XFullValueEvaluator)new ImmediateFullValueEvaluator(valuePresentation));
        } else if (!isTrimmed && PhpProjectDebugConfiguration.getInstance(this.getSession().getProject()).getState().isEnableNavigateToElementRenderer() && (possibleElementRef = this.getPossibleClosureElementRef(typePresentation)) != null) {
            this.setNavigateToSourceRenderer(node, possibleElementRef);
        }
        this.updatePresentation(valuePresentation, typePresentation, node, icon);
        if (!this.myProperty.isReturnValue() && this.myProperty.isObject() && PhpProjectDebugConfiguration.getInstance(this.getSession().getProject()).getState().isEnableToStringObjectView()) {
            PhpLanguageLevel level;
            XdebugConnection connection = this.myDebugProcess.getConnection();
            String version = connection != null ? connection.getPhpVersion() : null;
            PhpLanguageLevel phpLanguageLevel = level = version != null ? PhpLanguageLevel.parse((String)version) : null;
            if (level != null && level.isAtLeast(PhpLanguageLevel.PHP700)) {
                this.setToStringPresentation(node, icon, typePresentation);
            }
        }
        if (isTrimmed) {
            node.setFullValueEvaluator(new XFullValueEvaluator(){

                public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                    if (callback == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    XdebugValue.this.evaluateFullValue(callback);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/jetbrains/php/debug/xdebug/debugger/XdebugValue$1", "startEvaluation"));
                }
            });
        }
    }

    @Nullable
    private String getPossibleClosureElementRef(String typePresentation) {
        DbgpProperty closurePropertyChild;
        if (PhpLangUtil.toPresentableFQN("\\Closure").equals(typePresentation) && (closurePropertyChild = (DbgpProperty)ContainerUtil.find(this.myProperty.getLoadedChildren(), c -> {
            String shortName = c.getShortName(PhpDebugUtil.getDebugOutputEncoding(this.getSession().getProject()));
            return "function".equals(shortName) || "{closure}".equals(shortName);
        })) != null) {
            return this.getPossibleElementRef(closurePropertyChild);
        }
        return this.getPossibleElementRef(this.myProperty);
    }

    private String getPossibleElementRef(DbgpProperty property) {
        List<DbgpProperty> children = property.getLoadedChildren();
        if (property.isArray()) {
            if (children.size() == 2) {
                String className = this.loadString(children.get(0));
                String methodName = this.loadString(children.get(1));
                if (className != null && methodName != null) {
                    return className + STATIC_SEPARATOR + methodName;
                }
            } else if (children.size() == 1) {
                return this.loadString(children.get(0));
            }
        }
        return this.loadString(property);
    }

    @Nullable
    private String loadString(DbgpProperty property) {
        ValueDescriptor valueDescriptor = property.isString() ? XdebugValue.getValue(this.myDebugProcess.getSession().getProject(), property) : null;
        return valueDescriptor != null && !valueDescriptor.isTrimmed() ? valueDescriptor.value() : null;
    }

    private void setNavigateToSourceRenderer(@NotNull XValueNode node, String possibleElementRef) {
        if (node == null) {
            XdebugValue.$$$reportNull$$$0(9);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Collection<? extends PhpNamedElement> elements = XdebugValue.getElements(this.getSession().getProject(), possibleElementRef);
            if (!elements.isEmpty()) {
                node.setFullValueEvaluator((XFullValueEvaluator)new PhpNavigateToNamedElementEvaluator(possibleElementRef));
            }
            return;
        }
        ReadAction.nonBlocking(() -> XdebugValue.getElements(this.getSession().getProject(), possibleElementRef)).expireWhen(() -> ((XValueNode)node).isObsolete()).inSmartMode(this.getSession().getProject()).finishOnUiThread(ModalityState.defaultModalityState(), classes -> {
            if (!classes.isEmpty()) {
                PhpDebugSessionLogger.NAVIGATE_LINK_SHOWN.log(this.getSession().getProject());
                node.setFullValueEvaluator((XFullValueEvaluator)new PhpNavigateToNamedElementEvaluator(possibleElementRef));
            }
        }).submit((Executor)NonUrgentExecutor.getInstance());
    }

    private static void navigate(List<? extends PhpNamedElement> classes) {
        if (classes.size() == 1) {
            ((PhpNamedElement)ContainerUtil.getFirstItem(classes)).navigate(true);
        } else if (!classes.isEmpty()) {
            PsiTargetNavigator navigator = new PsiTargetNavigator(classes).presentationProvider(e -> new DefaultPsiElementCellRenderer().computePresentation(e)).builderConsumer(builder2 -> builder2.setMovable(false).setRequestFocus(true).setResizable(false));
            JBPopup popup = navigator.createPopup(((PhpNamedElement)ContainerUtil.getFirstItem(classes)).getProject(), null);
            popup.showInFocusCenter();
        }
    }

    @NotNull
    public static @Unmodifiable Collection<? extends PhpNamedElement> getElements(@NotNull Project project, @NotNull String valuePresentation) {
        PhpCallbackFunctionUtil.PhpStaticCallback callback;
        if (project == null) {
            XdebugValue.$$$reportNull$$$0(10);
        }
        if (valuePresentation == null) {
            XdebugValue.$$$reportNull$$$0(11);
        }
        if ((callback = PhpCallbackFunctionUtil.createStaticCallback(valuePresentation)) != null) {
            Collection collection = PhpIndex.getInstance(project).getAnyByFQN(callback.myClassName).stream().map(c -> c.findMethodByName(callback.myMethodName)).filter(Objects::nonNull).collect(Collectors.toSet());
            if (collection == null) {
                XdebugValue.$$$reportNull$$$0(12);
            }
            return collection;
        }
        PhpIndex index = PhpIndex.getInstance(project);
        Set set = ContainerUtil.union(index.getAnyByFQN(PhpLangUtil.toFQN(valuePresentation)), index.getFunctionsByFQN(PhpLangUtil.toFQN(valuePresentation)));
        if (set == null) {
            XdebugValue.$$$reportNull$$$0(13);
        }
        return set;
    }

    @Nullable
    public static String getConcreteArrayType(DbgpProperty property) {
        String concreteArrayType = (String)ContainerUtil.getOnlyItem((Collection)ContainerUtil.map2Set(property.getLoadedChildren(), DbgpProperty::getType));
        return concreteArrayType != null ? PhpLangUtil.toFQN(concreteArrayType) : null;
    }

    private void updatePresentation(String valuePresentation, String typePresentation, @NotNull XValueNode node, Icon icon) {
        if (node == null) {
            XdebugValue.$$$reportNull$$$0(14);
        }
        node.setPresentation(icon, this.createPresentation(valuePresentation, typePresentation, this.myProperty), this.myProperty.hasChildren());
    }

    private void setToStringPresentation(final @NotNull XValueNode node, final Icon icon, final String typePresentation) {
        if (node == null) {
            XdebugValue.$$$reportNull$$$0(15);
        }
        PhpDebugProcess.StringEvaluateCallback callback = new PhpDebugProcess.StringEvaluateCallback(){

            @Override
            public void evaluated(@NotNull String result) {
                if (result == null) {
                    2.$$$reportNull$$$0(0);
                }
                XdebugValue.this.updatePresentation("\"" + result + "\"", typePresentation, node, icon);
            }

            @Override
            public void errorOccurred() {
            }

            @Override
            public void evaluate(PhpDebugConnection connection, String expression, String encoding) {
                if (connection instanceof XdebugConnection) {
                    String e = String.format("(function ($tmp) {\n    try {\n        set_error_handler(function () {\n            return true;\n        });\n        return @%s;\n    } finally {\n        restore_error_handler();\n    }\n})(%s)", XdebugConnection.getToStringExpression("$tmp"), expression);
                    ((XdebugConnection)connection).doEvaluate(e, encoding, this);
                } else {
                    PhpDebugProcess.StringEvaluateCallback.super.evaluate(connection, expression, encoding);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/php/debug/xdebug/debugger/XdebugValue$2", "evaluated"));
            }
        };
        this.evaluateToStringIfNoSideEffects(node, callback, PhpLangUtil.toFQN(typePresentation));
    }

    private void evaluateToStringIfNoSideEffects(@NotNull XValueNode node, PhpDebugProcess.StringEvaluateCallback callback, String fqn) {
        if (node == null) {
            XdebugValue.$$$reportNull$$$0(16);
        }
        if ("\\resource".equals(fqn)) {
            return;
        }
        Project project = this.getSession().getProject();
        if (PhpType.isPrimitiveType(fqn)) {
            this.evaluateToString(project, callback);
        } else {
            ReadAction.nonBlocking(() -> this.toStringCanContainsSideEffect(fqn)).expireWhen(() -> ((XValueNode)node).isObsolete()).inSmartMode(project).finishOnUiThread(ModalityState.defaultModalityState(), toStringCanContainsSideEffect -> {
                if (!toStringCanContainsSideEffect.booleanValue()) {
                    this.evaluateToString(project, callback);
                }
            }).submit((Executor)NonUrgentExecutor.getInstance());
        }
    }

    private void evaluateToString(@NotNull Project project, PhpDebugProcess.StringEvaluateCallback callback) {
        if (project == null) {
            XdebugValue.$$$reportNull$$$0(17);
        }
        this.myDebugProcess.evalString(this.myProperty.getFullName(PhpDebugUtil.getDebugOutputEncoding(project), true), callback);
    }

    private boolean toStringCanContainsSideEffect(@NotNull String fqn) {
        List<Method> methods;
        if (fqn == null) {
            XdebugValue.$$$reportNull$$$0(18);
        }
        return (methods = PhpIndex.getInstance(this.getSession().getProject()).getAnyByFQN(fqn).stream().map(e -> e.findMethodByName("__toString")).filter(Objects::nonNull).toList()).isEmpty() || ContainerUtil.exists(methods, e -> !PhpSideEffectDetector.isPure(e, true, false, new HashSet<Function>()));
    }

    private void evaluateFullValue(final @NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
        XdebugConnection connection;
        if (callback == null) {
            XdebugValue.$$$reportNull$$$0(19);
        }
        if ((connection = this.myDebugProcess.getConnection()) == null) {
            callback.errorOccurred(PhpBundle.message("debug.error", new Object[0]));
            return;
        }
        String fullName = this.myContextId == 1 && this.myEvalCacheKey != null ? PhpEvaluator.getEvalCacheVariable("$IDE_EVAL_CACHE", this.myEvalCacheKey) : this.getFullName();
        connection.send(new PropertyValueRequest(fullName, this.myStackDepth, this.myContextId, 0, this.myProperty.getValueSize()), new DbgpResponseHandler<PropertyValueResponse>(){

            @Override
            public void onSuccessResponse(@NotNull PropertyValueResponse message) {
                if (message == null) {
                    3.$$$reportNull$$$0(0);
                }
                String encoding = PhpDebugUtil.getDebugOutputEncoding(XdebugValue.this.myDebugProcess.getSession().getProject());
                try {
                    String fullValue = message.getValue(encoding);
                    callback.evaluated(fullValue);
                }
                catch (UnsupportedEncodingException e) {
                    callback.errorOccurred(e.getMessage());
                }
            }

            @Override
            public void onErrorResponse(@NotNull ErrorResponse errorResponse) {
                if (errorResponse == null) {
                    3.$$$reportNull$$$0(1);
                }
                callback.errorOccurred(errorResponse.getErrorMessage());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorResponse";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugValue$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onSuccessResponse";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onErrorResponse";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public String getShortName() {
        return this.getName();
    }

    @Override
    public void processFullValue(final @NotNull PhpEvaluationResultProcessor evaluationCallback) {
        ValueDescriptor value;
        boolean isTrimmed;
        if (evaluationCallback == null) {
            XdebugValue.$$$reportNull$$$0(20);
        }
        if (!(isTrimmed = (value = this.getValue()).isTrimmed())) {
            evaluationCallback.success(value.value(), this.myProperty, this);
        } else {
            this.evaluateFullValue(new XFullValueEvaluator.XFullValueEvaluationCallback(){

                public void evaluated(@NotNull String fullValue, @Nullable Font font) {
                    if (fullValue == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    evaluationCallback.success(fullValue, XdebugValue.this.myProperty, XdebugValue.this);
                }

                public void errorOccurred(@NotNull String errorMessage) {
                    if (errorMessage == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    evaluationCallback.error(errorMessage);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "fullValue";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "errorMessage";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugValue$4";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "evaluated";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "errorOccurred";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    public String getName() {
        String name;
        String encoding = PhpDebugUtil.getDebugOutputEncoding(this.getSession().getProject());
        String string = name = this.myNameOverride != null ? this.myNameOverride : this.myProperty.getShortName(encoding);
        if (name == null) {
            LOG.warn("Null property name, fullName=" + this.myProperty.getFullName(encoding, false));
            name = PhpBundle.message("unnamed.variable", new Object[0]);
        }
        return name;
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        List<DbgpProperty> loadedChildren;
        if (node == null) {
            XdebugValue.$$$reportNull$$$0(21);
        }
        if (this.myProperty.getChildCount() == 0) {
            node.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        this.appendChildren(node, loadedChildren, (loadedChildren = this.myProperty.getLoadedChildren()).isEmpty() ? 0 : 1, 0);
    }

    private void appendChildren(final XCompositeNode node, List<DbgpProperty> properties, final int page, int reported) {
        int childCount = this.myProperty.getChildCount();
        if (properties.isEmpty()) {
            if (page > 0) {
                if (reported < childCount) {
                    LOG.warn("Not all children reported: " + reported + " out of " + childCount);
                }
                node.addChildren(XValueChildrenList.EMPTY, true);
                return;
            }
        } else {
            XValueChildrenList children = new XValueChildrenList();
            for (DbgpProperty child : properties) {
                if (!child.isInitialized()) continue;
                String encoding = PhpDebugUtil.getDebugOutputEncoding(this.getSession().getProject());
                XdebugValue value = new XdebugValue(this.myDebugProcess, this.myStackDepth, this.myContextId, child, null, this.myProperty.getClassName(encoding), this.getFullName(), this.myProperty.isArray(), null, null);
                children.add(value.getName(), (XValue)value);
            }
            if ((reported += properties.size()) > childCount) {
                LOG.warn("Too much children reported: " + reported + " out of " + childCount);
            }
            node.addChildren(children, reported == childCount);
        }
        if (reported < childCount) {
            final int reported1 = reported;
            XdebugConnection connection = this.myDebugProcess.getConnection();
            if (connection == null) {
                node.addChildren(XValueChildrenList.EMPTY, true);
                return;
            }
            connection.send(new PropertyGetRequest(this.getFullName(), this.myStackDepth, this.myContextId, page), new DbgpResponseHandler<PropertyGetResponse>(){

                @Override
                public void onSuccessResponse(@NotNull PropertyGetResponse message) {
                    if (message == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    DbgpProperty property = message.getProperty();
                    XdebugValue.this.appendChildren(node, property.getLoadedChildren(), page + 1, reported1);
                }

                @Override
                public void onErrorResponse(@NotNull ErrorResponse errorResponse) {
                    if (errorResponse == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    node.setErrorMessage(errorResponse.getErrorMessage());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "message";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "errorResponse";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugValue$5";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onSuccessResponse";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onErrorResponse";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    @NotNull
    public String getFullName() {
        String string = this.getFullName(false);
        if (string == null) {
            XdebugValue.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public String getFullName(boolean forEvaluation) {
        if (this.myFullNameOverride != null) {
            String string = this.myFullNameOverride;
            if (string == null) {
                XdebugValue.$$$reportNull$$$0(23);
            }
            return string;
        }
        String encoding = PhpDebugUtil.getDebugOutputEncoding(this.getSession().getProject());
        Object fullName = this.myProperty.getFullName(encoding, forEvaluation);
        if (StringUtil.isEmpty((String)fullName)) {
            String shortName = this.myProperty.getShortName(encoding);
            if (this.myParentIsArray) {
                LOG.assertTrue(this.myParentFullName != null);
                String arrayKey = XdebugUtil.isInteger(shortName) ? shortName : (String)StringUtil.SINGLE_QUOTER.apply(shortName);
                fullName = this.myParentFullName + "[" + arrayKey + "]";
            } else {
                String separator = this.myProperty.isStaticField() ? STATIC_SEPARATOR : ARROW;
                fullName = (String)(StringUtil.isNotEmpty((String)this.myParentFullName) ? this.myParentFullName + separator : "") + shortName;
            }
        }
        String string = fullName;
        if (string == null) {
            XdebugValue.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public String getEvaluationExpression() {
        String string = this.getFullName(true);
        if (string == null) {
            XdebugValue.$$$reportNull$$$0(25);
        }
        return string;
    }

    public XValueModifier getModifier() {
        if (this.myProperty.isArray() || this.myProperty.isObject()) {
            return null;
        }
        final String fullName = this.getFullName();
        return new XValueModifier(){

            public void setValue(@NotNull XExpression expression, final @NotNull XValueModifier.XModificationCallback callback) {
                if (expression == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (callback == null) {
                    6.$$$reportNull$$$0(1);
                }
                String encoding = PhpDebugUtil.getDebugOutputEncoding(XdebugValue.this.myDebugProcess.getSession().getProject());
                XdebugConnection connection = XdebugValue.this.myDebugProcess.getConnection();
                if (connection == null) {
                    callback.errorOccurred(PhpBundle.message("debug.error", new Object[0]));
                    return;
                }
                PropertySetRequest propertySetRequest = new PropertySetRequest(fullName, XdebugValue.this.myContextId, XdebugValue.this.myStackDepth, expression.getExpression(), encoding);
                connection.send(propertySetRequest, new DbgpResponseHandler<SetResponse>(){

                    @Override
                    public void onSuccessResponse(@NotNull SetResponse message) {
                        if (message == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (message.isSuccess()) {
                            callback.valueModified();
                        } else {
                            callback.errorOccurred(PhpBundle.message("debug.error.cannot.modify.value", new Object[0]));
                        }
                    }

                    @Override
                    public void onErrorResponse(@NotNull ErrorResponse errorResponse) {
                        if (errorResponse == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        callback.errorOccurred(errorResponse.getErrorMessage());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "message";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "errorResponse";
                                break;
                            }
                        }
                        objectArray2[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugValue$6$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onSuccessResponse";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onErrorResponse";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }

            public String getInitialValueEditorText() {
                String value = XdebugValue.this.getValue().value();
                if (XdebugValue.this.myProperty.isString()) {
                    return StringUtil.wrapWithDoubleQuote((String)StringUtil.escapeStringCharacters((String)value));
                }
                return value;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callback";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugValue$6";
                objectArray[2] = "setValue";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    public String getAddress() {
        return this.myProperty.getAddress();
    }

    @Override
    protected XDebugSession getSession() {
        return this.myDebugProcess.getSession();
    }

    @Override
    @Nullable
    protected PsiElement findTargetElement(@NotNull Project project, @NotNull XSourcePosition position, @NotNull Editor editor) {
        boolean isVariable;
        if (project == null) {
            XdebugValue.$$$reportNull$$$0(26);
        }
        if (position == null) {
            XdebugValue.$$$reportNull$$$0(27);
        }
        if (editor == null) {
            XdebugValue.$$$reportNull$$$0(28);
        }
        boolean bl = isVariable = StringUtil.isEmpty((String)this.myParentFullName) || this.myParentIsArray;
        if (isVariable) {
            if (!this.myProperty.isConstant()) {
                return this.findTargetVariable(project, position, editor, this.getFullName());
            }
        } else if (StringUtil.equalsIgnoreCase((CharSequence)this.myParentFullName, (CharSequence)"$this")) {
            return this.findTargetField(project, position, editor, this.getName());
        }
        return null;
    }

    @Override
    public boolean isArray() {
        return this.myProperty.isArray();
    }

    @Override
    public boolean isObject() {
        return this.myProperty.isObject();
    }

    @Override
    public int getChildrenCount() {
        return this.myProperty.getChildCount();
    }

    @Override
    public List<String> getChildren(int count) {
        String encoding = PhpDebugUtil.getDebugOutputEncoding(this.getSession().getProject());
        if (this.myProperty.isArray() || this.myProperty.isObject()) {
            List<DbgpProperty> children = this.myProperty.getLoadedChildren();
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 0; i < children.size() && i < count; ++i) {
                DbgpProperty child = children.get(i);
                String name = child.getShortName(encoding);
                StringBuilder presentableValue = new StringBuilder();
                if (StringUtil.isNotEmpty((String)name) && !name.equals(String.valueOf(i))) {
                    presentableValue.append(name);
                    presentableValue.append(" => ");
                }
                String value = XdebugValue.getPresentableValue(this.myDebugProcess.getSession().getProject(), child);
                presentableValue.append(this.wrapPresentableValue(child, value));
                values.add(presentableValue.toString());
            }
            return values;
        }
        return new SmartList((Object)XdebugValue.getPresentableValue(this.myDebugProcess.getSession().getProject(), this.myProperty));
    }

    @Override
    @Nullable
    public Map<String, String> getLoadedChildren() {
        if (this.myProperty.isArray() || this.myProperty.isObject()) {
            HashMap<String, String> values = new HashMap<String, String>();
            List<DbgpProperty> children = this.myProperty.getLoadedChildren();
            String encoding = PhpDebugUtil.getDebugOutputEncoding(this.getSession().getProject());
            for (DbgpProperty child : children) {
                values.put(child.getShortName(encoding), XdebugValue.getPresentableValue(this.myDebugProcess.getSession().getProject(), child));
            }
            return values;
        }
        return null;
    }

    @Override
    @NotNull
    public String getPresentableValue() {
        return XdebugValue.getPresentableValue(this.myDebugProcess.getSession().getProject(), this.myProperty);
    }

    @NotNull
    public static String getPresentableValue(@NotNull Project project, @NotNull DbgpProperty property) {
        if (project == null) {
            XdebugValue.$$$reportNull$$$0(29);
        }
        if (property == null) {
            XdebugValue.$$$reportNull$$$0(30);
        }
        if (property.isObject()) {
            String string = property.getClassName(PhpDebugUtil.getDebugOutputEncoding(project));
            if (string == null) {
                XdebugValue.$$$reportNull$$$0(31);
            }
            return string;
        }
        String string = XdebugValue.getValue(project, property).value();
        if (string == null) {
            XdebugValue.$$$reportNull$$$0(32);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = StringUtil.trimStart((String)this.getShortName(), (String)"$");
        if (string == null) {
            XdebugValue.$$$reportNull$$$0(33);
        }
        return string;
    }

    @Override
    @NotNull
    protected PhpType calculateType() {
        return XdebugValue.calculateType(this.getSession().getProject(), this.myProperty);
    }

    @NotNull
    public static PhpType calculateType(@NotNull Project project, @NotNull DbgpProperty property) {
        if (project == null) {
            XdebugValue.$$$reportNull$$$0(34);
        }
        if (property == null) {
            XdebugValue.$$$reportNull$$$0(35);
        }
        if (property.isObject()) {
            String encoding = PhpDebugUtil.getDebugOutputEncoding(project);
            String className = property.getClassName(encoding);
            if (ANONYMOUS_CLASS.equals(className)) {
                PhpType phpType = new PhpType().add(className);
                if (phpType == null) {
                    XdebugValue.$$$reportNull$$$0(36);
                }
                return phpType;
            }
            PhpType phpType = new PhpType().add(PhpLangUtil.toFQN(className));
            if (phpType == null) {
                XdebugValue.$$$reportNull$$$0(37);
            }
            return phpType;
        }
        if (property.isBoolean()) {
            PhpType phpType = PhpType.BOOLEAN;
            if (phpType == null) {
                XdebugValue.$$$reportNull$$$0(38);
            }
            return phpType;
        }
        if (property.isFloat()) {
            PhpType phpType = PhpType.FLOAT;
            if (phpType == null) {
                XdebugValue.$$$reportNull$$$0(39);
            }
            return phpType;
        }
        if (property.isInt()) {
            PhpType phpType = PhpType.INT;
            if (phpType == null) {
                XdebugValue.$$$reportNull$$$0(40);
            }
            return phpType;
        }
        if (property.isArray()) {
            PhpType phpType = PhpType.ARRAY;
            if (phpType == null) {
                XdebugValue.$$$reportNull$$$0(41);
            }
            return phpType;
        }
        if (property.isString()) {
            PhpType phpType = PhpType.STRING;
            if (phpType == null) {
                XdebugValue.$$$reportNull$$$0(42);
            }
            return phpType;
        }
        if (property.isNull()) {
            PhpType phpType = PhpType.NULL;
            if (phpType == null) {
                XdebugValue.$$$reportNull$$$0(43);
            }
            return phpType;
        }
        if (property.isResource()) {
            PhpType phpType = PhpType.RESOURCE;
            if (phpType == null) {
                XdebugValue.$$$reportNull$$$0(44);
            }
            return phpType;
        }
        PhpType phpType = PhpType.EMPTY;
        if (phpType == null) {
            XdebugValue.$$$reportNull$$$0(45);
        }
        return phpType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 12, 13, 22, 23, 24, 25, 31, 32, 33, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 4: 
            case 10: 
            case 17: 
            case 26: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 12: 
            case 13: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/debugger/XdebugValue";
                break;
            }
            case 7: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuePresentation";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationCallback";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugValue";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "compactString";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluationExpression";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableValue";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 6: 
            case 12: 
            case 13: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computePresentation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setNavigateToSourceRenderer";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getElements";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updatePresentation";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setToStringPresentation";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "evaluateToStringIfNoSideEffects";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "evaluateToString";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "toStringCanContainsSideEffect";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "evaluateFullValue";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processFullValue";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findTargetElement";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableValue";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "calculateType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 12, 13, 22, 23, 24, 25, 31, 32, 33, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45 -> new IllegalStateException(string);
        };
    }

    public record ValueDescriptor(String value, boolean isTrimmed) {
    }

    public class PhpNavigateToNamedElementEvaluator
    extends XFullValueEvaluator {
        @NotNull
        @NlsSafe
        private final String myElementRef;

        private PhpNavigateToNamedElementEvaluator(String elementRef) {
            if (elementRef == null) {
                PhpNavigateToNamedElementEvaluator.$$$reportNull$$$0(0);
            }
            super(PhpBundle.message("navigate", new Object[0]));
            this.myElementRef = elementRef;
        }

        public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
            if (callback == null) {
                PhpNavigateToNamedElementEvaluator.$$$reportNull$$$0(1);
            }
            PhpDebugSessionLogger.NAVIGATE_LINK_CLICKED.log(XdebugValue.this.getSession().getProject());
            XdebugValue.navigate(XdebugValue.getElements(XdebugValue.this.getSession().getProject(), this.myElementRef).stream().toList());
            callback.evaluated("");
        }

        public boolean isShowValuePopup() {
            return false;
        }

        @TestOnly
        @NotNull
        public String getElementRef() {
            String string = this.myElementRef;
            if (string == null) {
                PhpNavigateToNamedElementEvaluator.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementRef";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/xdebug/debugger/XdebugValue$PhpNavigateToNamedElementEvaluator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/xdebug/debugger/XdebugValue$PhpNavigateToNamedElementEvaluator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementRef";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "startEvaluation";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

