/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.debugger.dfa;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Range;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.TextRangeUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.dfaassist.DfaAssistBase;
import com.intellij.xdebugger.impl.dfaassist.DfaHint;
import com.intellij.xdebugger.impl.dfaassist.DfaResult;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpHostInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpConditionInstructionImpl;
import com.jetbrains.php.codeInsight.dataFlow.type.PhpTypeConditionDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBaseStateConditionDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedAnalyzerProcessor;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaDelegateBasedTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpExhaustiveDelegateState;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.debug.PhpApplicationDebugConfiguration;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpStackFrame;
import com.jetbrains.php.debug.connection.ConnectionListener;
import com.jetbrains.php.debug.connection.ConnectionStatus;
import com.jetbrains.php.debug.connection.PhpDebugConnection;
import com.jetbrains.php.debug.xdebug.connection.XdebugConnection;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ContextGetRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ContextGetResponse;
import com.jetbrains.php.debug.xdebug.dbgp.model.DbgpProperty;
import com.jetbrains.php.debug.xdebug.debugger.XdebugValue;
import com.jetbrains.php.debug.xdebug.debugger.dfa.XdebugStackFramePrimitiveOperandDescriptor;
import com.jetbrains.php.debug.xdebug.handlers.DbgpResponseHandler;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpUndefinedClassInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpConditionAlreadyCheckedInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.concurrency.CancellablePromise;

public class XdebugDfaAssist
extends DfaAssistBase {
    private static final int LOCAL_CONTEXT_ID = 0;
    private volatile CancellablePromise<DfaResult> myComputeDfaResultJob;
    private volatile boolean myDisposed;

    public XdebugDfaAssist(Project project) {
        super(project);
        this.myMode = XdebugDfaAssist.fromSettings();
    }

    public void processDfa(@NotNull PhpDebugProcess<XdebugConnection> debugProcess, @NotNull PhpStackFrame currentFrame) {
        if (debugProcess == null) {
            XdebugDfaAssist.$$$reportNull$$$0(0);
        }
        if (currentFrame == null) {
            XdebugDfaAssist.$$$reportNull$$$0(1);
        }
        if (DumbService.isDumb((Project)this.myProject)) {
            return;
        }
        XSourcePosition position = currentFrame.getSourcePosition();
        if (position == null) {
            return;
        }
        BreakPointDescriptor descriptor = (BreakPointDescriptor)ReadAction.nonBlocking(() -> {
            PsiElement element = XDebuggerUtil.getInstance().findContextElement(position.getFile(), position.getOffset(), this.myProject, false);
            PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder(element);
            return new BreakPointDescriptor(element, scopeHolder);
        }).executeSynchronously();
        PsiElement elementUnderBreakPoint = descriptor.elementUnderBreakPoint;
        PhpScopeHolder scopeHolder = descriptor.scopeHolder;
        if (scopeHolder == null) {
            return;
        }
        XdebugDfaAssist.processXdebugValues(debugProcess, currentFrame, xdebugProperties -> {
            if (xdebugProperties.isEmpty()) {
                return;
            }
            this.myComputeDfaResultJob = ReadAction.nonBlocking(() -> XdebugDfaAssist.computeDfaResult(scopeHolder, elementUnderBreakPoint, xdebugProperties, this.myMode)).withDocumentsCommitted(this.myProject).inSmartMode(this.myProject).coalesceBy(new Object[]{this}).finishOnUiThread(ModalityState.nonModal(), hints -> this.displayInlays((DfaResult)hints)).submit((Executor)AppExecutorUtil.getAppExecutorService());
        });
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    private static void processXdebugValues(@NotNull PhpDebugProcess<XdebugConnection> debugProcess, @NotNull PhpStackFrame currentFrame, final Consumer<List<DbgpProperty>> consumer) {
        XdebugConnection connection;
        if (debugProcess == null) {
            XdebugDfaAssist.$$$reportNull$$$0(2);
        }
        if (currentFrame == null) {
            XdebugDfaAssist.$$$reportNull$$$0(3);
        }
        if ((connection = debugProcess.getConnection()) == null) {
            return;
        }
        connection.loadContextNames(names -> {
            Integer localContext = (Integer)ContainerUtil.find(names.keySet(), nameId -> nameId == 0);
            if (localContext == null) {
                return;
            }
            connection.send(new ContextGetRequest(currentFrame.getDepth(), 0), new DbgpResponseHandler<ContextGetResponse>(){

                @Override
                public void onSuccessResponse(@NotNull ContextGetResponse message) {
                    if (message == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    consumer.accept(message.getProperties());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/xdebug/debugger/dfa/XdebugDfaAssist$1", "onSuccessResponse"));
                }
            });
        });
    }

    @NotNull
    protected @NotNull List<@NotNull AnAction> getInlayHintActions() {
        List list = ContainerUtil.append((List)super.getInlayHintActions(), (Object[])new AnAction[]{new DisableXdebugDfaAssistAction()});
        if (list == null) {
            XdebugDfaAssist.$$$reportNull$$$0(4);
        }
        return list;
    }

    public void dispose() {
        if (!this.myDisposed) {
            this.myDisposed = true;
            this.cleanUp();
        }
    }

    protected void cleanUp() {
        this.cancelComputation();
        super.cleanUp();
    }

    private void cancelComputation() {
        CancellablePromise<DfaResult> computeDfaResultJob = this.myComputeDfaResultJob;
        if (computeDfaResultJob != null) {
            computeDfaResultJob.cancel();
        }
    }

    @VisibleForTesting
    @NotNull
    static DfaResult computeDfaResult(@NotNull PhpScopeHolder scopeHolder, @NotNull PsiElement elementUnderBreakPoint, List<DbgpProperty> xdebugProperties, DfaAssistBase.AssistMode mode) {
        PhpInstruction startInstruction;
        if (scopeHolder == null) {
            XdebugDfaAssist.$$$reportNull$$$0(5);
        }
        if (elementUnderBreakPoint == null) {
            XdebugDfaAssist.$$$reportNull$$$0(6);
        }
        if ((startInstruction = PhpUndefinedClassInspection.findNearestInstruction(elementUnderBreakPoint)) == null || startInstruction instanceof PhpEntryPointInstruction) {
            DfaResult dfaResult = DfaResult.EMPTY;
            if (dfaResult == null) {
                XdebugDfaAssist.$$$reportNull$$$0(7);
            }
            return dfaResult;
        }
        final List<PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState>> statesFromStackFrame = XdebugDfaAssist.createInitialStates(scopeHolder.getProject(), xdebugProperties);
        if (statesFromStackFrame.isEmpty()) {
            DfaResult dfaResult = DfaResult.EMPTY;
            if (dfaResult == null) {
                XdebugDfaAssist.$$$reportNull$$$0(8);
            }
            return dfaResult;
        }
        final HashMap<PsiElement, DfaHint> hints = new HashMap<PsiElement, DfaHint>();
        PhpControlFlow flow = scopeHolder.getControlFlow();
        final HashSet checkedRanges = new HashSet();
        PhpControlFlowUtil.processFlow(flow, new PhpInstructionProcessor(){

            @Override
            public boolean processConditionInstruction(PhpConditionInstruction instruction) {
                PsiElement condition;
                if (instruction.num() <= startInstruction.num()) {
                    return true;
                }
                PsiElement circuitRightOperand = ((PhpConditionInstructionImpl)instruction).getShortCircuitRightOperand();
                if (circuitRightOperand != null) {
                    this.doCheckCondition(instruction, circuitRightOperand, true, checkedRanges);
                }
                if ((condition = instruction.getCondition()) != null && instruction.getResult()) {
                    this.doCheckCondition(instruction, condition, false, checkedRanges);
                }
                return true;
            }

            private void doCheckCondition(@NotNull PhpConditionInstruction instruction, @NotNull PsiElement condition, boolean startFromSelf, Collection<TextRange> checkedRanges2) {
                TextRange currentTextRange;
                if (instruction == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (condition == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (ContainerUtil.exists(checkedRanges2, arg_0 -> 2.lambda$doCheckCondition$0(currentTextRange = condition.getTextRange(), arg_0))) {
                    return;
                }
                checkedRanges2.add(currentTextRange);
                Collection<PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState>> currInstructionStates = PhpConditionAlreadyCheckedInspection.getState(instruction, condition, startFromSelf || instruction.getResult(), true);
                for (PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> state : currInstructionStates) {
                    for (PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState stateFromStackFrame : statesFromStackFrame) {
                        PhpConditionAlreadyCheckedInspection.PhpStateCompatibilityDescriptor compatibility;
                        if (!PhpLangUtil.equalsVariableNames(state.getVariableName(), stateFromStackFrame.getVariableName()) || (compatibility = XdebugDfaAssist.getAlreadyCheckedInstruction(instruction, condition, state, stateFromStackFrame, startInstruction, startFromSelf)) == null) continue;
                        if (compatibility.myCompatibilityResult) {
                            hints.put(condition, DfaHint.TRUE);
                            continue;
                        }
                        hints.put(condition, DfaHint.FALSE);
                    }
                }
            }

            private static /* synthetic */ boolean lambda$doCheckCondition$0(TextRange currentTextRange, TextRange t) {
                return currentTextRange.contains(t);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "instruction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "condition";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/debug/xdebug/debugger/dfa/XdebugDfaAssist$2";
                objectArray[2] = "doCheckCondition";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        List unreachable = mode.displayGrayOut() ? XdebugDfaAssist.collectUnreachableRanges(flow, startInstruction, hints) : Collections.emptyList();
        HashMap<PsiElement, DfaHint> reachableHints = unreachable.isEmpty() ? hints : EntryStream.of(hints).filterKeys(e -> ContainerUtil.find((Iterable)unreachable, unreachableRange -> unreachableRange.contains(e.getTextRange())) == null).toMap();
        return new DfaResult(scopeHolder.getContainingFile(), reachableHints, unreachable);
    }

    @NotNull
    private static Collection<TextRange> collectUnreachableRanges(@NotNull PhpControlFlow flow, @NotNull PhpInstruction startInstruction, final @NotNull Map<PsiElement, DfaHint> hints) {
        if (flow == null) {
            XdebugDfaAssist.$$$reportNull$$$0(9);
        }
        if (startInstruction == null) {
            XdebugDfaAssist.$$$reportNull$$$0(10);
        }
        if (hints == null) {
            XdebugDfaAssist.$$$reportNull$$$0(11);
        }
        HashSet<TextRange> unreachable = new HashSet<TextRange>();
        for (PhpInstruction curInstruction : flow.getInstructions()) {
            PsiElement currAnchor;
            if (curInstruction.num() < startInstruction.num() || curInstruction instanceof PhpHostInstruction || (currAnchor = curInstruction.getAnchor()) == null) continue;
            final Ref reachedEntryPoint = new Ref((Object)Boolean.FALSE);
            PhpControlFlowUtil.processPredecessors(curInstruction, false, new PhpInstructionProcessor(){

                @Override
                public boolean processConditionInstruction(PhpConditionInstruction instruction) {
                    DfaHint dfaResult = this.evaluateCondition(instruction.getCondition());
                    if (instruction.getResult() && dfaResult == DfaHint.FALSE || !instruction.getResult() && dfaResult == DfaHint.TRUE) {
                        return false;
                    }
                    return super.processConditionInstruction(instruction);
                }

                @Nullable
                private DfaHint evaluateCondition(@Nullable PsiElement condition) {
                    if (condition == null) {
                        return null;
                    }
                    DfaHint hint = (DfaHint)hints.get(condition);
                    if (hint != null) {
                        return hint;
                    }
                    if (condition instanceof BinaryExpression) {
                        BinaryExpression binaryExpression = (BinaryExpression)condition;
                        IElementType operationType = binaryExpression.getOperationType();
                        if (operationType != PhpTokenTypes.opOR && operationType != PhpTokenTypes.opAND) {
                            return null;
                        }
                        DfaHint left = this.evaluateCondition(binaryExpression.getLeftOperand());
                        if (left == DfaHint.TRUE && operationType == PhpTokenTypes.opOR) {
                            return DfaHint.TRUE;
                        }
                        if (left == DfaHint.FALSE && operationType == PhpTokenTypes.opAND) {
                            return DfaHint.FALSE;
                        }
                        DfaHint right = this.evaluateCondition(binaryExpression.getRightOperand());
                        if (right == DfaHint.FALSE) {
                            return DfaHint.FALSE;
                        }
                        if (right == DfaHint.TRUE) {
                            return DfaHint.TRUE;
                        }
                    }
                    return null;
                }

                @Override
                public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                    reachedEntryPoint.set((Object)Boolean.TRUE);
                    return super.processEntryPointInstruction(instruction);
                }
            });
            if (reachedEntryPoint.get() != Boolean.FALSE) continue;
            if (curInstruction instanceof PhpConditionInstructionImpl) {
                BinaryExpression binaryExpression;
                PhpConditionInstructionImpl conditionInstruction = (PhpConditionInstructionImpl)curInstruction;
                PsiElement psiElement = PhpPsiUtil.unparenthesize(currAnchor);
                if (!(psiElement instanceof BinaryExpression) || (binaryExpression = (BinaryExpression)psiElement).getRightOperand() == null) continue;
                if (binaryExpression.getLeftOperand() instanceof ParenthesizedExpression || binaryExpression.getRightOperand() instanceof ParenthesizedExpression) {
                    DfaHint unreachableHint;
                    DfaHint dfaHint = unreachableHint = binaryExpression.getOperationType() == PhpTokenTypes.opAND ? DfaHint.FALSE : DfaHint.TRUE;
                    if (unreachableHint == DfaHint.FALSE && conditionInstruction.getResult() || unreachableHint == DfaHint.TRUE && !conditionInstruction.getResult()) {
                        LastReachableConditionDescriptor lastReachable = XdebugDfaAssist.findLastAlwaysReachableCondition(hints, binaryExpression.getLeftOperand(), unreachableHint);
                        if (lastReachable != null) {
                            unreachable.add(TextRange.create((int)lastReachable.condition.getTextRange().getEndOffset(), (int)binaryExpression.getTextRange().getEndOffset()));
                            continue;
                        }
                        lastReachable = XdebugDfaAssist.findLastAlwaysReachableCondition(hints, binaryExpression.getRightOperand(), unreachableHint);
                        if (lastReachable != null) {
                            unreachable.add(TextRange.create((int)lastReachable.condition.getTextRange().getEndOffset(), (int)binaryExpression.getTextRange().getEndOffset()));
                            continue;
                        }
                    }
                }
                unreachable.add(binaryExpression.getRightOperand().getTextRange());
                continue;
            }
            unreachable.add(currAnchor.getTextRange());
        }
        return XdebugDfaAssist.mergeRanges(unreachable);
    }

    @NotNull
    private static Collection<TextRange> mergeRanges(@NotNull Collection<TextRange> ranges) {
        if (ranges == null) {
            XdebugDfaAssist.$$$reportNull$$$0(12);
        }
        if (ranges.isEmpty()) {
            List<TextRange> list = Collections.emptyList();
            if (list == null) {
                XdebugDfaAssist.$$$reportNull$$$0(13);
            }
            return list;
        }
        List<TextRange> sortedRanges = ranges.stream().sorted(TextRangeUtil.RANGE_COMPARATOR).toList();
        ArrayList<TextRange> mergedRanges = new ArrayList<TextRange>();
        for (TextRange curr : sortedRanges) {
            TextRange last = (TextRange)ContainerUtil.getLastItem(mergedRanges);
            if (last == null || !last.intersects(curr)) {
                mergedRanges.add(curr);
                continue;
            }
            mergedRanges.remove(mergedRanges.size() - 1);
            mergedRanges.add(last.union(curr));
        }
        ArrayList<TextRange> arrayList = mergedRanges;
        if (arrayList == null) {
            XdebugDfaAssist.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @Nullable
    private static LastReachableConditionDescriptor findLastAlwaysReachableCondition(Map<PsiElement, DfaHint> hints, PsiElement condition, DfaHint unreachableHint) {
        BinaryExpression binaryExpression;
        if ((condition = PhpPsiUtil.unparenthesize(condition)) == null) {
            return null;
        }
        DfaHint hint = hints.get(condition);
        if (hint == unreachableHint) {
            return new LastReachableConditionDescriptor(hint, condition);
        }
        if (condition instanceof BinaryExpression && ((binaryExpression = (BinaryExpression)condition).getOperationType() == PhpTokenTypes.opOR || binaryExpression.getOperationType() == PhpTokenTypes.opAND)) {
            LastReachableConditionDescriptor right;
            LastReachableConditionDescriptor left = XdebugDfaAssist.findLastAlwaysReachableCondition(hints, binaryExpression.getLeftOperand(), unreachableHint);
            if (left != null && binaryExpression.getOperationType() == (unreachableHint == DfaHint.FALSE ? PhpTokenTypes.opAND : PhpTokenTypes.opOR)) {
                return left;
            }
            if (left != null && binaryExpression.getOperationType() == (unreachableHint == DfaHint.FALSE ? PhpTokenTypes.opOR : PhpTokenTypes.opAND) && (right = XdebugDfaAssist.findLastAlwaysReachableCondition(hints, binaryExpression.getRightOperand(), unreachableHint)) != null) {
                return new LastReachableConditionDescriptor(unreachableHint, (PsiElement)binaryExpression);
            }
        }
        return null;
    }

    @Nullable
    private static PhpConditionAlreadyCheckedInspection.PhpStateCompatibilityDescriptor getAlreadyCheckedInstruction(@NotNull PhpConditionInstruction instruction, @NotNull PsiElement condition, @NotNull PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> state, @NotNull PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState> stateFromStackFrame, @NotNull PhpInstruction startInstruction, boolean startFromSelf) {
        if (instruction == null) {
            XdebugDfaAssist.$$$reportNull$$$0(15);
        }
        if (condition == null) {
            XdebugDfaAssist.$$$reportNull$$$0(16);
        }
        if (state == null) {
            XdebugDfaAssist.$$$reportNull$$$0(17);
        }
        if (stateFromStackFrame == null) {
            XdebugDfaAssist.$$$reportNull$$$0(18);
        }
        if (startInstruction == null) {
            XdebugDfaAssist.$$$reportNull$$$0(19);
        }
        return PhpConditionAlreadyCheckedInspection.getAlreadyCheckedInstruction(instruction, condition, state, startFromSelf, processor -> {
            processor.setInjectedState(stateFromStackFrame);
            processor.setConditionToStop(anotherInstruction -> anotherInstruction.num() < startInstruction.num());
        });
    }

    @NotNull
    private static List<PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState>> createInitialStates(@NotNull Project project, List<DbgpProperty> stackFrameProperties) {
        if (project == null) {
            XdebugDfaAssist.$$$reportNull$$$0(20);
        }
        ArrayList<PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState>> variableDfaStates = new ArrayList<PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState>>();
        for (DbgpProperty stackFrameProperty : stackFrameProperties) {
            PhpDfaBasedTypeState state = XdebugDfaAssist.createDFAStateFromXdebugValue(project, stackFrameProperty);
            if (state == null) continue;
            String encoding = PhpDebugUtil.getDebugOutputEncoding(project);
            PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState> variableDfaState = new PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState>(stackFrameProperty.getFullName(encoding, false).substring(1), state);
            variableDfaStates.add(variableDfaState);
        }
        ArrayList<PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState>> arrayList = variableDfaStates;
        if (arrayList == null) {
            XdebugDfaAssist.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    @Nullable
    private static PhpDfaBasedTypeState createDFAStateFromXdebugValue(@NotNull Project project, @NotNull DbgpProperty property) {
        Collection<String> primitiveTypeCheckerTypeFromName;
        XdebugValue.ValueDescriptor value;
        if (project == null) {
            XdebugDfaAssist.$$$reportNull$$$0(22);
        }
        if (property == null) {
            XdebugDfaAssist.$$$reportNull$$$0(23);
        }
        if ((value = XdebugValue.getValue(project, property)).isTrimmed()) {
            return null;
        }
        if (!property.isInitialized()) {
            return null;
        }
        if (property.isObject()) {
            return PhpDfaBaseStateConditionDFAnalyzer.PhpClassEqualToState.createClassEqualInstance(project, XdebugValue.getPresentableValue(project, property), false);
        }
        if (property.isNull()) {
            return PhpDfaBasedTypeState.NULL;
        }
        if (property.isArray()) {
            return PhpDfaDelegateBasedTypeState.PhpNotNullByPrimitiveTypeChecker.IS_ARRAY_CHECK;
        }
        if ((property.isString() || property.isBoolean() || property.isNumber()) && !(primitiveTypeCheckerTypeFromName = PhpTypeConditionDFAnalyzer.getPrimitiveTypeCheckerTypeFromName(XdebugValue.calculateType(project, property))).isEmpty()) {
            String xdebugValueStr = value.value();
            XdebugStackFramePrimitiveOperandDescriptor operandDescriptor = new XdebugStackFramePrimitiveOperandDescriptor(xdebugValueStr, property, PhpLanguageLevel.current((Project)project));
            PhpDfaDelegateBasedTypeState.PhpPrimitiveTypeCheckByStrictComparison typeState = new PhpDfaDelegateBasedTypeState.PhpPrimitiveTypeCheckByStrictComparison(primitiveTypeCheckerTypeFromName, operandDescriptor, false, true);
            Integer intValue = operandDescriptor.getIntValue();
            if (intValue != null) {
                PhpDfaBasedTypeState rangeState = PhpDfaBaseStateConditionDFAnalyzer.createRangeState((Range<Integer>)new Range((Comparable)intValue, (Comparable)intValue));
                return new PhpExhaustiveDelegateState("State with int range", rangeState, typeState);
            }
            return typeState;
        }
        return null;
    }

    public static XdebugDfaAssist createDfaAssist(@NotNull PhpDebugProcess<XdebugConnection> process) {
        if (process == null) {
            XdebugDfaAssist.$$$reportNull$$$0(24);
        }
        XDebugSession session = process.getSession();
        final XdebugDfaAssist assist = new XdebugDfaAssist(session.getProject());
        XdebugConnection connection = process.getConnection();
        if (connection != null) {
            connection.addListener(new ConnectionListener<PhpDebugConnection>(){

                @Override
                public void statusChanged(@NotNull PhpDebugConnection connection11, @NotNull ConnectionStatus status) {
                    if (connection11 == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (status == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    if (status == ConnectionStatus.DISCONNECTED) {
                        Disposer.dispose((Disposable)assist);
                        connection11.removeListener(this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "connection11";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "status";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/php/debug/xdebug/debugger/dfa/XdebugDfaAssist$4";
                    objectArray[2] = "statusChanged";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        return assist;
    }

    private static DfaAssistBase.AssistMode fromSettings() {
        PhpApplicationDebugConfiguration.State settings = PhpApplicationDebugConfiguration.getInstance().getState();
        if (settings.isEnableDfaAssist() && settings.isEnableDfaAssistGrayMode()) {
            return DfaAssistBase.AssistMode.BOTH;
        }
        if (settings.isEnableDfaAssist()) {
            return DfaAssistBase.AssistMode.INLAYS;
        }
        if (settings.isEnableDfaAssistGrayMode()) {
            return DfaAssistBase.AssistMode.GRAY_OUT;
        }
        return DfaAssistBase.AssistMode.NONE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 8, 13, 14, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFrame";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/debugger/dfa/XdebugDfaAssist";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementUnderBreakPoint";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startInstruction";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateFromStackFrame";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/debugger/dfa/XdebugDfaAssist";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlayHintActions";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDfaResult";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeRanges";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createInitialStates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processDfa";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processXdebugValues";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 21: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeDfaResult";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectUnreachableRanges";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "mergeRanges";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAlreadyCheckedInstruction";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createInitialStates";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createDFAStateFromXdebugValue";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createDfaAssist";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 8, 13, 14, 21 -> new IllegalStateException(string);
        };
    }

    private record BreakPointDescriptor(PsiElement elementUnderBreakPoint, PhpScopeHolder scopeHolder) {
    }

    private final class DisableXdebugDfaAssistAction
    extends AnAction {
        private DisableXdebugDfaAssistAction() {
            super(PhpBundle.message("action.DisableXdebugDfaAssist.text", new Object[0]), PhpBundle.message("action.DisableXdebugDfaAssist.description", new Object[0]), AllIcons.Actions.Cancel);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                DisableXdebugDfaAssistAction.$$$reportNull$$$0(0);
            }
            PhpApplicationDebugConfiguration.State settings = PhpApplicationDebugConfiguration.getInstance().getState();
            settings.setEnableDfaAssist(false);
            settings.setEnableDfaAssistGrayMode(false);
            Disposer.dispose((Disposable)XdebugDfaAssist.this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/debug/xdebug/debugger/dfa/XdebugDfaAssist$DisableXdebugDfaAssistAction", "actionPerformed"));
        }
    }

    private record LastReachableConditionDescriptor(DfaHint hint, PsiElement condition) {
    }
}

