/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.install;

import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ExecutionDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.PhpDebuggerError;
import com.jetbrains.php.debug.xdebug.install.XdebugDownloaderLinux;
import com.jetbrains.php.debug.xdebug.install.XdebugDownloaderWindows;
import com.jetbrains.php.util.PhpConfigurationUtil;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XdebugDownloader {
    protected AnAction downloadAndInstall;
    public static final String DIRECTORY = "Extensions directory:";
    public static final String UPDATE = "Update";
    public static final String PHP_INI = "php.ini";
    public static final String DOWNLOAD = "Download";
    public static final String DATA = "data";
    public static final String SUBMIT = "submit";
    public static final String ANALYSE_MY_PHPINFO_28_29_OUTPUT = "Analyse+my+phpinfo%28%29+output";
    public static final String WIZARD = "https://xdebug.org/wizard";
    public static final String VERSION_5_6_IS_NOT_SUPPORTED = "PHP version 5.6 is not supported";
    private static final String LINK = "(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
    private static final String INI = "<code>.*</code>";
    protected final Project myProject;
    protected final String myPhpinfo;
    protected final XDebugSession mySession;
    protected final String myPhpHomePath;
    private String link;
    protected String directory;
    protected String phpiniPath;
    protected String phpIniLine;
    @Nullable
    protected VirtualFile myDownloadedFile;

    public XdebugDownloader(@NotNull Project project, @NotNull String phpinfo, @Nullable XDebugSession session, @Nullable String phpHomePath) {
        if (project == null) {
            XdebugDownloader.$$$reportNull$$$0(0);
        }
        if (phpinfo == null) {
            XdebugDownloader.$$$reportNull$$$0(1);
        }
        this.downloadAndInstall = NotificationAction.createSimpleExpiring((String)PhpBundle.message("PhpInterpreterConfigurable.install.xdebug.extension", new Object[0]), () -> this.downloadAndInstall());
        this.myProject = project;
        this.myPhpinfo = phpinfo;
        this.mySession = session;
        this.myPhpHomePath = phpHomePath;
    }

    public static XdebugDownloader getInstance(@NotNull Project project, @NotNull String phpinfo, @Nullable XDebugSession session, @Nullable String phpHomePath) {
        if (project == null) {
            XdebugDownloader.$$$reportNull$$$0(2);
        }
        if (phpinfo == null) {
            XdebugDownloader.$$$reportNull$$$0(3);
        }
        return SystemInfo.isWindows ? new XdebugDownloaderWindows(project, phpinfo, session, phpHomePath) : new XdebugDownloaderLinux(project, phpinfo, session, phpHomePath);
    }

    public void downloadAndInstall() {
        this.analyseInfoFromPhpInfo();
        this.download();
        this.install();
        this.updatePhpIni();
    }

    void analyseInfoFromPhpInfo() {
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
        pairs.add(new BasicNameValuePair(DATA, this.myPhpinfo));
        pairs.add(new BasicNameValuePair(SUBMIT, ANALYSE_MY_PHPINFO_28_29_OUTPUT));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(pairs, Consts.UTF_8);
        HttpPost httppost = new HttpPost(WIZARD);
        httppost.setEntity((HttpEntity)entity);
        try (CloseableHttpClient client = HttpClientBuilder.create().disableAutomaticRetries().build();){
            String line;
            CloseableHttpResponse response = client.execute((HttpUriRequest)httppost);
            BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));
            while ((line = rd.readLine()) != null) {
                Matcher m;
                Pattern p;
                String s;
                if (line.contains(VERSION_5_6_IS_NOT_SUPPORTED)) {
                    PhpDebuggerError.create(PhpBundle.message("php.5.6.is.not.supported", new Object[0])).show(this.myProject);
                    return;
                }
                if (line.contains(DIRECTORY) && (s = StringUtil.substringAfter((String)line, (String)DIRECTORY)) != null) {
                    this.directory = StringUtil.stripHtml((String)s.stripLeading(), (boolean)true).stripLeading();
                }
                if ((line.contains(PHP_INI) || line.contains("xdebug.ini")) && (line.contains(UPDATE) || line.contains("Create"))) {
                    p = Pattern.compile(INI);
                    m = p.matcher(line.substring(0, line.indexOf("<br/>")));
                    while (m.find()) {
                        this.phpiniPath = StringUtil.stripHtml((String)m.group(), (boolean)true);
                    }
                    this.phpIniLine = StringUtil.stripHtml((String)line.substring(line.indexOf("<br/>")), (boolean)true).stripLeading();
                }
                if (!line.contains(DOWNLOAD)) continue;
                p = Pattern.compile(LINK);
                m = p.matcher(line);
                while (m.find()) {
                    this.link = m.group();
                }
            }
        }
        catch (UnknownHostException uhe) {
            PhpDebuggerError.create(PhpBundle.message("connection.failed.message", new Object[0])).show(this.myProject);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void download() {
        if (this.link != null) {
            this.myDownloadedFile = PhpConfigurationUtil.downloadFile(this.myProject, null, this.getDirectory(), this.link, this.getName(this.link));
        }
    }

    protected String getDirectory() {
        return this.myProject.getBasePath();
    }

    protected abstract String getName(String var1);

    protected void install() {
    }

    public void updatePhpIni() {
    }

    public abstract AnAction[] getActions();

    protected void restartDebug() {
        if (this.mySession == null) {
            return;
        }
        XDebugSessionTab sessionTab = ((XDebugSessionImpl)this.mySession).getSessionTab();
        if (sessionTab == null || Disposer.isDisposed((Disposable)sessionTab)) {
            return;
        }
        RunContentDescriptor runContentDescriptor = sessionTab.getRunContentDescriptor();
        if (runContentDescriptor == null) {
            return;
        }
        JComponent component = runContentDescriptor.getComponent();
        if (component == null) {
            return;
        }
        DataContext context = DataManager.getInstance().getDataContext((Component)component);
        ExecutionEnvironment environment = (ExecutionEnvironment)ExecutionDataKeys.EXECUTION_ENVIRONMENT.getData(context);
        if (environment == null) {
            return;
        }
        ExecutionUtil.restart((ExecutionEnvironment)environment);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpinfo";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/xdebug/install/XdebugDownloader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

