/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.install;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.xdebug.install.XdebugDownloader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XdebugDownloaderLinux
extends XdebugDownloader {
    AnAction generateSsh;

    public XdebugDownloaderLinux(@NotNull Project project, @NotNull String phpinfo, @Nullable XDebugSession session, @Nullable String phpHomePath) {
        if (project == null) {
            XdebugDownloaderLinux.$$$reportNull$$$0(0);
        }
        if (phpinfo == null) {
            XdebugDownloaderLinux.$$$reportNull$$$0(1);
        }
        super(project, phpinfo, session, phpHomePath);
        this.generateSsh = NotificationAction.createSimpleExpiring((String)PhpBundle.message("PhpInterpreterConfigurable.generate.xdebug.extension", new Object[0]), () -> {
            this.analyseInfoFromPhpInfo();
            this.download();
            this.generateShellScript(false);
        });
    }

    @Override
    protected void install() {
        this.generateShellScript(true);
    }

    @Override
    public AnAction[] getActions() {
        return new AnAction[]{this.downloadAndInstall, this.generateSsh};
    }

    protected void generateShellScript(boolean run) {
        if (this.myDownloadedFile == null || this.myPhpHomePath == null) {
            return;
        }
        try {
            if (run) {
                GeneralCommandLine line = new GeneralCommandLine(this.createCommandForSudo());
                line.setWorkDirectory(this.myProject.getBasePath());
                final GeneralCommandLine sudoCommandLine = ExecUtil.sudoCommand((GeneralCommandLine)line, (String)PhpBundle.message("please.enter.your.password.to.make.install.xdebug.extension", new Object[0]));
                Task.Backgroundable task = new Task.Backgroundable(this.myProject, PhpBundle.message("xdebug.compile.task", new Object[0]), true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        try {
                            CapturingProcessHandler handler = new CapturingProcessHandler(sudoCommandLine){

                                protected CapturingProcessAdapter createProcessAdapter(ProcessOutput processOutput) {
                                    return new CapturingProcessAdapter(processOutput){

                                        public void processTerminated(@NotNull ProcessEvent event) {
                                            if (event == null) {
                                                1.$$$reportNull$$$0(0);
                                            }
                                            ApplicationManager.getApplication().invokeLater(XdebugDownloaderLinux.this::restartDebug, ModalityState.any());
                                        }

                                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/debug/xdebug/install/XdebugDownloaderLinux$1$1$1", "processTerminated"));
                                        }
                                    };
                                }
                            };
                            handler.runProcessWithProgressIndicator(indicator);
                        }
                        catch (ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/php/debug/xdebug/install/XdebugDownloaderLinux$1", "run"));
                    }
                };
                ProgressManager.getInstance().run((Task)task);
            } else {
                PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
                VirtualFile file = VfsUtil.findFileByIoFile((File)this.getScript(), (boolean)true);
                if (file == null) {
                    return;
                }
                PsiFile psiFile = psiManager.findFile(file);
                if (psiFile != null) {
                    EditorHelper.openInEditor((PsiElement)psiFile);
                }
            }
        }
        catch (ExecutionException | IOException throwable) {
            // empty catch block
        }
    }

    @NotNull
    private List<String> createCommandForSudo() throws IOException, ExecutionException {
        ArrayList<String> command = new ArrayList<String>();
        command.add("sh");
        command.add(this.getScript().getAbsolutePath());
        ArrayList<String> arrayList = command;
        if (arrayList == null) {
            XdebugDownloaderLinux.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    private File getScript() throws IOException, ExecutionException {
        assert (this.myDownloadedFile != null);
        assert (this.myPhpHomePath != null);
        Path path = this.myDownloadedFile.toNioPath();
        String dir = StringUtil.trimEnd((String)path.toString(), (String)".tgz");
        String scriptText = "#!/bin/bash\n\nARCHIVE_NAME=\"" + path + "\"\ntar -xvzf $ARCHIVE_NAME --directory " + this.myDownloadedFile.getParent().toNioPath() + "\nrm $ARCHIVE_NAME\n\ncd " + dir + "\n\nphpize\n./configure --with-php-config=" + this.myPhpHomePath.replaceFirst("php$", "php-config") + "\nmake\n\nPATH_TO_XDEBUG_SO=\"" + this.directory + "\"\nsudo mkdir -p $PATH_TO_XDEBUG_SO\nsudo cp " + dir + "/modules/xdebug.so $PATH_TO_XDEBUG_SO\nsudo rm -R " + dir + "\nZEND_EXTENSION='" + this.phpIniLine + "'\nFILE=\"" + this.phpiniPath + "\"\nLAST_LINE=$(tail -n 1 \"${FILE}\")\nif [[ $LAST_LINE != \"${ZEND_EXTENSION}\" ]]; then\n   echo \"${ZEND_EXTENSION}\" | sudo tee -a \"${FILE}\"\nfi";
        File file = ExecUtil.createTempExecutableScript((String)"compileAndInstallXdebug", (String)".sh", (String)scriptText);
        if (file == null) {
            XdebugDownloaderLinux.$$$reportNull$$$0(3);
        }
        return file;
    }

    @Override
    protected String getName(String link) {
        return Objects.requireNonNull(StringUtil.substringAfterLast((String)link, (String)"/"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpinfo";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/install/XdebugDownloaderLinux";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/install/XdebugDownloaderLinux";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandForSudo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getScript";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

