/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.install;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.PhpDebuggerError;
import com.jetbrains.php.debug.xdebug.install.XdebugDownloader;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XdebugDownloaderWindows
extends XdebugDownloader {
    public static final String PHP_XDEBUG_DLL = "php_xdebug.dll";

    public XdebugDownloaderWindows(@NotNull Project project, @NotNull String phpinfo, @Nullable XDebugSession session, @Nullable String phpHomePath) {
        if (project == null) {
            XdebugDownloaderWindows.$$$reportNull$$$0(0);
        }
        if (phpinfo == null) {
            XdebugDownloaderWindows.$$$reportNull$$$0(1);
        }
        super(project, phpinfo, session, phpHomePath);
    }

    @Override
    protected String getName(String link) {
        return PHP_XDEBUG_DLL;
    }

    @Override
    public void updatePhpIni() {
        if (this.phpiniPath != null && this.phpIniLine != null) {
            VirtualFile file = (VirtualFile)WriteAction.compute(() -> StringUtil.isEmpty((String)this.phpiniPath) ? null : LocalFileSystem.getInstance().findFileByPath(this.phpiniPath));
            if (file == null) {
                String title = PhpBundle.message("PhpInterpreterConfigurable.configuration.file.can.not.find.title", new Object[0]);
                String message = PhpBundle.message("PhpInterpreterConfigurable.configuration.file.can.not.find", this.phpiniPath);
                Messages.showMessageDialog((Project)this.myProject, (String)message, (String)title, (Icon)Messages.getErrorIcon());
                return;
            }
            FileEditorManager fileManager = FileEditorManager.getInstance((Project)this.myProject);
            if (fileManager != null) {
                try {
                    File file1 = VfsUtilCore.virtualToIoFile((VirtualFile)file);
                    if (!FileUtil.loadLines((File)file1).contains(this.phpIniLine)) {
                        FileUtil.appendToFile((File)file1, (String)("\n" + this.phpIniLine));
                    }
                    fileManager.openFile(file, true);
                    this.restartDebug();
                }
                catch (IOException e) {
                    if (e.getMessage().contains("Access is denied")) {
                        String message = PhpBundle.message("couldnt.update.php.ini", this.phpiniPath);
                        PhpDebuggerError.create(message).show(this.myProject);
                    }
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    protected String getDirectory() {
        return this.directory;
    }

    @Override
    public AnAction[] getActions() {
        return new AnAction[]{this.downloadAndInstall};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "phpinfo";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/debug/xdebug/install/XdebugDownloaderWindows";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

