/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.feedback;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.feedback.InIdeFeedbackSurveyConfig;
import com.intellij.platform.feedback.dialog.BlockBasedFeedbackDialog;
import com.intellij.platform.feedback.dialog.SystemDataJsonSerializable;
import com.intellij.platform.feedback.impl.notification.RequestFeedbackNotification;
import com.intellij.util.PlatformUtils;
import com.jetbrains.php.composer.actions.update.ComposerInstalledPackagesService;
import com.jetbrains.php.feedback.SymfonySupportSurveyBundle;
import com.jetbrains.php.feedback.SymfonySupportSurveyDialog;
import java.time.Month;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\rH\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\rH\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/php/feedback/SymfonySupportSurveyConfig;", "Lcom/intellij/platform/feedback/InIdeFeedbackSurveyConfig;", "<init>", "()V", "surveyId", "", "getSurveyId", "()Ljava/lang/String;", "lastDayOfFeedbackCollection", "Lkotlinx/datetime/LocalDate;", "getLastDayOfFeedbackCollection", "()Lkotlinx/datetime/LocalDate;", "requireIdeEAP", "", "getRequireIdeEAP", "()Z", "checkIdeIsSuitable", "checkExtraConditionSatisfied", "project", "Lcom/intellij/openapi/project/Project;", "updateStateAfterDialogClosedOk", "", "createFeedbackDialog", "Lcom/intellij/platform/feedback/dialog/BlockBasedFeedbackDialog;", "Lcom/intellij/platform/feedback/dialog/SystemDataJsonSerializable;", "forTest", "createNotification", "Lcom/intellij/platform/feedback/impl/notification/RequestFeedbackNotification;", "updateStateAfterNotificationShowed", "intellij.php.impl"})
@SourceDebugExtension(value={"SMAP\nSymfonySupportSurveyConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SymfonySupportSurveyConfig.kt\ncom/jetbrains/php/feedback/SymfonySupportSurveyConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n1755#2,3:49\n*S KotlinDebug\n*F\n+ 1 SymfonySupportSurveyConfig.kt\ncom/jetbrains/php/feedback/SymfonySupportSurveyConfig\n*L\n25#1:49,3\n*E\n"})
public final class SymfonySupportSurveyConfig
implements InIdeFeedbackSurveyConfig {
    @NotNull
    private final String surveyId;
    @NotNull
    private final LocalDate lastDayOfFeedbackCollection = new LocalDate(2024, Month.JUNE, 4);
    private final boolean requireIdeEAP;

    public SymfonySupportSurveyConfig() {
        this.surveyId = "symfony_support_survey";
    }

    @NotNull
    public String getSurveyId() {
        return this.surveyId;
    }

    @NotNull
    public LocalDate getLastDayOfFeedbackCollection() {
        return this.lastDayOfFeedbackCollection;
    }

    public boolean getRequireIdeEAP() {
        return this.requireIdeEAP;
    }

    public boolean checkIdeIsSuitable() {
        return PlatformUtils.isPhpStorm();
    }

    public boolean checkExtraConditionSatisfied(@NotNull Project project) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Collection<ComposerInstalledPackagesService.InstalledPackage> collection = ComposerInstalledPackagesService.getAllInstalledPackages(project);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getAllInstalledPackages(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ComposerInstalledPackagesService.InstalledPackage it = (ComposerInstalledPackagesService.InstalledPackage)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.name(), (Object)"symfony/framework-bundle")) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public void updateStateAfterDialogClosedOk(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    @NotNull
    public BlockBasedFeedbackDialog<? extends SystemDataJsonSerializable> createFeedbackDialog(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (BlockBasedFeedbackDialog)new SymfonySupportSurveyDialog(project, Registry.Companion.is("php.symfony.plugin.feedback.form.test", forTest));
    }

    @NotNull
    public RequestFeedbackNotification createNotification(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new RequestFeedbackNotification("Feedback In IDE", SymfonySupportSurveyBundle.INSTANCE.message("notification.symfony.support.request.title", new Object[0]), SymfonySupportSurveyBundle.INSTANCE.message("notification.symfony.support.request.content", new Object[0]));
    }

    public void updateStateAfterNotificationShowed(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }
}

