/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.hints;

import com.intellij.codeInsight.codeVision.CodeVisionRelativeOrdering;
import com.intellij.codeInsight.hints.codeVision.CodeVisionProviderBase;
import com.intellij.codeInsight.hints.codeVision.ReferencesCodeVisionProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.hints.PhpCodeVisionUsageCollector;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocPsiElement;
import com.jetbrains.php.lang.inspections.deadcode.local.PhpUnusedGlobalSymbolsPass;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassAlias;
import com.jetbrains.php.lang.psi.elements.PhpClassFieldsList;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPropertyHook;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.refactoring.rename.PhpRenameSearchParameters;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpReferencesCodeVisionProvider
extends ReferencesCodeVisionProvider {
    public static final String ID = "php.references";

    public boolean acceptsFile(@NotNull PsiFile file) {
        if (file == null) {
            PhpReferencesCodeVisionProvider.$$$reportNull$$$0(0);
        }
        return file instanceof PhpFile;
    }

    public boolean acceptsElement(@NotNull PsiElement element) {
        if (element == null) {
            PhpReferencesCodeVisionProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof PhpPropertyHook) {
            return false;
        }
        return element instanceof PhpClass && !((PhpClass)element).isAnonymous() && !(element instanceof PhpClassAlias) || element instanceof PhpClassFieldsList && ((PhpClassFieldsList)element).getFields().size() == 1 || element instanceof PhpClassMember && !(element instanceof Field) && !(element instanceof PhpDocPsiElement) && !(element instanceof RenameableFakePsiElement) || element instanceof Function && !((Function)element).isClosure() || element instanceof PhpPsiElement && PhpPsiUtil.isOfType(element, PhpElementTypes.CONSTANTS) && PhpReferencesCodeVisionProvider.getOnlyConstant(element) != null;
    }

    @Nullable
    public CodeVisionProviderBase.CodeVisionInfo getVisionInfo(@NotNull PsiElement element, @NotNull PsiFile file) {
        GlobalSearchScope adjustedScope;
        PhpClassMember member;
        Method method;
        PhpNamedElement namedElement;
        PsiElement adjustedElement;
        if (element == null) {
            PhpReferencesCodeVisionProvider.$$$reportNull$$$0(2);
        }
        if (file == null) {
            PhpReferencesCodeVisionProvider.$$$reportNull$$$0(3);
        }
        if (!((adjustedElement = PhpReferencesCodeVisionProvider.adjustElement(element)) instanceof PhpNamedElement)) {
            return null;
        }
        String preview = PhpReferencesCodeVisionProvider.getHintForPreview(file, adjustedElement, false);
        if (preview != null) {
            return new CodeVisionProviderBase.CodeVisionInfo(preview, null, true);
        }
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)adjustedElement.getProject());
        PhpNamedElement phpNamedElement = namedElement = adjustedElement instanceof Method && (method = (Method)adjustedElement).getMethodType(false) == Method.MethodType.CONSTRUCTOR ? method.getContainingClass() : (PhpNamedElement)adjustedElement;
        if (namedElement == null) {
            return null;
        }
        if (adjustedElement instanceof PhpClassMember && (member = (PhpClassMember)adjustedElement).getModifier().isPrivate() && member.getContainingClass() != null) {
            adjustedScope = new LocalSearchScope((PsiElement)member.getContainingClass());
        } else {
            PsiSearchHelper.SearchCostResult costSearchOutsideCurrentFile = PhpReferencesCodeVisionProvider.computeCostOfSearchOutsideCurrentFile(file, scope, namedElement);
            if (costSearchOutsideCurrentFile == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                return null;
            }
            adjustedScope = costSearchOutsideCurrentFile == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES ? GlobalSearchScope.fileScope((PsiFile)file) : scope;
        }
        AtomicInteger usagesCount = new AtomicInteger();
        int limit = AdvancedSettings.getInt((String)"php.code.vision.usages.limit");
        ReferencesSearch.search((ReferencesSearch.SearchParameters)new PhpRenameSearchParameters(adjustedElement, (SearchScope)adjustedScope)).allowParallelProcessing().forEach(r -> usagesCount.incrementAndGet() <= limit);
        int result = usagesCount.get();
        if (result == 0 && PhpReferencesCodeVisionProvider.isTestElement(adjustedElement)) {
            return null;
        }
        return new CodeVisionProviderBase.CodeVisionInfo(PhpBundle.message("inlay.hints.usages.text", Math.min(result, limit), result > limit ? 1 : 0), Integer.valueOf(result), result <= limit);
    }

    @Nullable
    public String getHint(@NotNull PsiElement element, @NotNull PsiFile file) {
        CodeVisionProviderBase.CodeVisionInfo info;
        if (element == null) {
            PhpReferencesCodeVisionProvider.$$$reportNull$$$0(4);
        }
        if (file == null) {
            PhpReferencesCodeVisionProvider.$$$reportNull$$$0(5);
        }
        if ((info = this.getVisionInfo(element, file)) == null) {
            return null;
        }
        return info.getText();
    }

    @NotNull
    private static PsiSearchHelper.SearchCostResult computeCostOfSearchOutsideCurrentFile(@NotNull PsiFile file, GlobalSearchScope scope, PhpNamedElement namedElement) {
        PhpUnusedGlobalSymbolsPass.TwigScope twigScope;
        PsiSearchHelper.SearchCostResult costInTwigFiles;
        PsiSearchHelper searchHelper;
        PsiSearchHelper.SearchCostResult costOutsideCurrentFile;
        if (file == null) {
            PhpReferencesCodeVisionProvider.$$$reportNull$$$0(6);
        }
        if ((costOutsideCurrentFile = (searchHelper = PsiSearchHelper.getInstance((Project)file.getProject())).isCheapEnoughToSearch(namedElement.getName(), scope, file)) == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
            PsiSearchHelper.SearchCostResult searchCostResult = PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
            if (searchCostResult == null) {
                PhpReferencesCodeVisionProvider.$$$reportNull$$$0(7);
            }
            return searchCostResult;
        }
        String twigShortName = PhpUnusedGlobalSymbolsPass.extractTwigShortName((PsiElement)namedElement);
        if (StringUtil.isNotEmpty((String)twigShortName) && (costInTwigFiles = searchHelper.isCheapEnoughToSearch(twigShortName, (GlobalSearchScope)(twigScope = new PhpUnusedGlobalSymbolsPass.TwigScope(scope)), file)) != PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES) {
            PsiSearchHelper.SearchCostResult searchCostResult = costInTwigFiles;
            if (searchCostResult == null) {
                PhpReferencesCodeVisionProvider.$$$reportNull$$$0(8);
            }
            return searchCostResult;
        }
        PsiSearchHelper.SearchCostResult searchCostResult = costOutsideCurrentFile;
        if (searchCostResult == null) {
            PhpReferencesCodeVisionProvider.$$$reportNull$$$0(9);
        }
        return searchCostResult;
    }

    private static boolean isTestElement(@NotNull PsiElement element) {
        if (element == null) {
            PhpReferencesCodeVisionProvider.$$$reportNull$$$0(10);
        }
        return element instanceof PhpClass && PhpUnitUtil.isTestClass((PhpClass)element) || element instanceof Method && PhpUnitUtil.isTestMethod((Method)element);
    }

    @NotNull
    static PsiElement adjustElement(@NotNull PsiElement element) {
        if (element == null) {
            PhpReferencesCodeVisionProvider.$$$reportNull$$$0(11);
        }
        if (element instanceof PhpClassFieldsList) {
            PsiElement psiElement = (PsiElement)ContainerUtil.getFirstItem(((PhpClassFieldsList)element).getFields());
            if (psiElement == null) {
                PhpReferencesCodeVisionProvider.$$$reportNull$$$0(12);
            }
            return psiElement;
        }
        if (PhpPsiUtil.isOfType(element, PhpElementTypes.CONSTANTS)) {
            PsiElement psiElement = Objects.requireNonNull(PhpReferencesCodeVisionProvider.getOnlyConstant(element));
            if (psiElement == null) {
                PhpReferencesCodeVisionProvider.$$$reportNull$$$0(13);
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            PhpReferencesCodeVisionProvider.$$$reportNull$$$0(14);
        }
        return psiElement;
    }

    @Nullable
    private static PsiElement getOnlyConstant(@NotNull PsiElement element) {
        if (element == null) {
            PhpReferencesCodeVisionProvider.$$$reportNull$$$0(15);
        }
        return (PsiElement)ContainerUtil.getOnlyItem(PhpPsiUtil.getChildren(element, Constant.INSTANCEOF));
    }

    public void handleClick(@NotNull Editor editor, @NotNull PsiElement element, @Nullable MouseEvent event) {
        if (editor == null) {
            PhpReferencesCodeVisionProvider.$$$reportNull$$$0(16);
        }
        if (element == null) {
            PhpReferencesCodeVisionProvider.$$$reportNull$$$0(17);
        }
        super.handleClick(editor, PhpReferencesCodeVisionProvider.adjustElement(element), event);
    }

    public void logClickToFUS(@NotNull PsiElement element, @NotNull String hint) {
        if (element == null) {
            PhpReferencesCodeVisionProvider.$$$reportNull$$$0(18);
        }
        if (hint == null) {
            PhpReferencesCodeVisionProvider.$$$reportNull$$$0(19);
        }
        PhpCodeVisionUsageCollector.logReferenceHintClicked(PhpReferencesCodeVisionProvider.adjustElement(element), hint);
    }

    @NotNull
    public List<CodeVisionRelativeOrdering> getRelativeOrderings() {
        List<CodeVisionRelativeOrdering.CodeVisionRelativeOrderingBefore> list = List.of(new CodeVisionRelativeOrdering.CodeVisionRelativeOrderingBefore("php.inheritors"));
        if (list == null) {
            PhpReferencesCodeVisionProvider.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @Nullable
    @Nls
    static String getHintForPreview(@NotNull PsiFile file, @NotNull PsiElement element, boolean isInheritance) {
        if (file == null) {
            PhpReferencesCodeVisionProvider.$$$reportNull$$$0(21);
        }
        if (element == null) {
            PhpReferencesCodeVisionProvider.$$$reportNull$$$0(22);
        }
        if (file.getVirtualFile() == null && element instanceof PhpNamedElement) {
            PhpNamedElement namedElement = (PhpNamedElement)element;
            if (namedElement instanceof Method) {
                Method method = (Method)namedElement;
                if ("method".equals(namedElement.getName()) && method.getContainingClass() != null && "CodeVisionPreview".equals(method.getContainingClass().getName())) {
                    return PhpBundle.message("inlay.hints.usages.text", 0, 0);
                }
            }
            if (namedElement instanceof PhpClass && "CodeVisionPreview".equals(namedElement.getName())) {
                return isInheritance ? PhpBundle.message("code.vision.implementations.hint", 1, 0) : PhpBundle.message("inlay.hints.usages.text", 1, 0);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 12, 13, 14, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/hints/PhpReferencesCodeVisionProvider";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/hints/PhpReferencesCodeVisionProvider";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "computeCostOfSearchOutsideCurrentFile";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustElement";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativeOrderings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "acceptsElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVisionInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getHint";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeCostOfSearchOutsideCurrentFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 20: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isTestElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "adjustElement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getOnlyConstant";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "handleClick";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "logClickToFUS";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getHintForPreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 12, 13, 14, 20 -> new IllegalStateException(string);
        };
    }
}

