/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.injection;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpClassConstantAccessInstructionImpl;
import com.jetbrains.php.codeInsight.regexp.PhpRegexpLanguage;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableInferredTypeAnalyzerProcessor;
import com.jetbrains.php.injection.PhpInjectionUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpMetaTypeMappingsTable;
import com.jetbrains.php.lang.psi.resolve.types.PhpParameterBasedTypeProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.intellij.lang.regexp.RegExpLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpInjectorBase
implements MultiHostInjector {
    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        PhpInjectionUtil.InjectionResult result;
        if (registrar == null) {
            PhpInjectorBase.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpInjectorBase.$$$reportNull$$$0(1);
        }
        if ((result = this.registerInjection(registrar, context)).isInjected()) {
            this.processInjectedResult(result, context);
        }
    }

    protected void processInjectedResult(PhpInjectionUtil.InjectionResult result, @NotNull PsiElement context) {
        Pair<PsiElement, Language> language;
        if (context == null) {
            PhpInjectorBase.$$$reportNull$$$0(2);
        }
        if (result.containsUnparsableFragment() && (language = this.getInjectedLanguage(context)) != null) {
            InjectorUtils.putInjectedFileUserData((PsiElement)context, (Language)((Language)language.getSecond()), (Key)InjectedLanguageUtil.FRANKENSTEIN_INJECTION, (Object)Boolean.TRUE);
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<? extends PhpExpression>> list = PhpInjectionUtil.ELEMENTS_TO_INJECT_IN;
        if (list == null) {
            PhpInjectorBase.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    protected abstract Language doGetInjectedLanguage(@NotNull PsiElement var1);

    @Nullable
    public @Nullable Pair<@Nullable PsiElement, @NotNull Language> getInjectedLanguage(@NotNull PsiElement context) {
        if (context == null) {
            PhpInjectorBase.$$$reportNull$$$0(4);
        }
        if (context instanceof PsiLanguageInjectionHost && ((PsiLanguageInjectionHost)context).isValidHost()) {
            Language language = this.getSubstitutedLanguage(context);
            if (language != null) {
                return Pair.create(null, (Object)language);
            }
            Pair<PsiElement, Language> languageFromUsages = this.getInjectedLanguageFromUsages(context);
            if (languageFromUsages != null) {
                return languageFromUsages;
            }
        }
        return null;
    }

    @Nullable
    private Pair<PsiElement, Language> getInjectedLanguageFromUsages(@NotNull PsiElement context) {
        PsiElement largestStringLiteral;
        if (context == null) {
            PhpInjectorBase.$$$reportNull$$$0(5);
        }
        if ((largestStringLiteral = PhpInjectorBase.getTopmostValueInjectionCapable(context)) == null) {
            return null;
        }
        PsiElement parent = largestStringLiteral.getParent();
        if (parent instanceof FieldImpl && ((FieldImpl)parent).getDefaultValue() == largestStringLiteral) {
            return this.getLanguageFromFieldUsages((Field)parent);
        }
        if (!(parent instanceof AssignmentExpression)) {
            return null;
        }
        if (((AssignmentExpression)parent).getValue() != largestStringLiteral) {
            return null;
        }
        PhpPsiElement variable = ((AssignmentExpression)parent).getVariable();
        if (variable instanceof Variable) {
            return this.getLanguageFromVariableUsages((Variable)variable);
        }
        if (variable instanceof FieldReference && !(parent instanceof SelfAssignmentExpression)) {
            return StreamEx.of(((FieldReference)variable).resolveLocal()).select(Field.class).map(this::getLanguageFromFieldUsages).findFirst(Objects::nonNull).orElse(null);
        }
        return null;
    }

    @Nullable
    private Pair<PsiElement, Language> getLanguageFromFieldUsages(@NotNull Field field) {
        PhpClass containingClass;
        if (field == null) {
            PhpInjectorBase.$$$reportNull$$$0(6);
        }
        if ((containingClass = field.getContainingClass()) == null) {
            return null;
        }
        Map<Pair<String, Boolean>, Pair<PsiElement, Language>> languageFieldSubstitutedLanguagesFromUsages = this.getLanguageFieldSubstitutedLanguagesFromUsages(containingClass);
        return languageFieldSubstitutedLanguagesFromUsages.get(Pair.create((Object)field.getName(), (Object)field.isConstant()));
    }

    private Map<Pair<String, Boolean>, Pair<PsiElement, Language>> getLanguageFieldSubstitutedLanguagesFromUsages(PhpClass aClass) {
        return (Map)CachedValuesManager.getCachedValue((PsiElement)aClass, this.getLanguageFromFieldUsageCacheKey(), () -> CachedValueProvider.Result.create(this.doGetLanguageFieldSubstitutedLanguagesFromUsages(aClass), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @NotNull
    protected abstract Key<CachedValue<Map<Pair<String, Boolean>, Pair<PsiElement, Language>>>> getLanguageFromFieldUsageCacheKey();

    @NotNull
    private Map<Pair<String, Boolean>, Pair<PsiElement, Language>> doGetLanguageFieldSubstitutedLanguagesFromUsages(PhpClass containingClass) {
        HashMap<Pair<String, Boolean>, Pair<PsiElement, Language>> res = new HashMap<Pair<String, Boolean>, Pair<PsiElement, Language>>();
        Set<Field> fields = Set.of(containingClass.getOwnFields());
        Set fieldNames = ContainerUtil.map2Set(fields, PhpNamedElement::getName);
        for (Method method : containingClass.getOwnMethods()) {
            for (PhpInstruction instruction : method.getControlFlow().getInstructions()) {
                boolean mightBeResolvedToContainingField;
                PsiElement anchor = instruction.getAnchor();
                if (!(instruction instanceof PhpClassConstantAccessInstructionImpl) && !(instruction instanceof PhpAccessFieldByVariableInstruction) || !(anchor instanceof MemberReference)) continue;
                MemberReference memberReference = (MemberReference)anchor;
                String name = memberReference.getName();
                boolean bl = mightBeResolvedToContainingField = StringUtil.isNotEmpty((String)name) && fieldNames.contains(name) && (memberReference instanceof ClassConstantReference && !res.containsKey(Pair.create((Object)name, (Object)true)) || memberReference instanceof FieldReference && !memberReference.isStatic() && !res.containsKey(Pair.create((Object)name, (Object)false)) && PhpLangUtil.isThisReference((PsiElement)memberReference.getClassReference()));
                if (!mightBeResolvedToContainingField) continue;
                this.fillSubstitutedLanguage(res, fields, anchor, memberReference);
            }
        }
        HashMap<Pair<String, Boolean>, Pair<PsiElement, Language>> hashMap = res;
        if (hashMap == null) {
            PhpInjectorBase.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    private void fillSubstitutedLanguage(Map<Pair<String, Boolean>, Pair<PsiElement, Language>> res, Collection<Field> fields, PsiElement anchor, MemberReference memberReference) {
        Language substitutedLanguage;
        PhpNamedElement resolvedField = (PhpNamedElement)ContainerUtil.find(memberReference.resolveLocal(), fields::contains);
        if (resolvedField instanceof Field && (substitutedLanguage = this.getSubstitutedLanguage(anchor)) != null) {
            res.put((Pair<String, Boolean>)Pair.create((Object)resolvedField.getName(), (Object)((Field)resolvedField).isConstant()), (Pair<PsiElement, Language>)Pair.create((Object)anchor, (Object)substitutedLanguage));
        }
    }

    @Nullable
    private static PsiElement getTopmostValueInjectionCapable(@NotNull PsiElement context) {
        PsiElement literal;
        ArrayCreationExpression arrayLiteral;
        if (context == null) {
            PhpInjectorBase.$$$reportNull$$$0(8);
        }
        return (arrayLiteral = PhpInjectorBase.getEnclosingArrayLiteralForValue(literal = PhpInjectionUtil.getLargestStringLiteral(context))) != null ? arrayLiteral : literal;
    }

    @Nullable
    private static ArrayCreationExpression getEnclosingArrayLiteralForValue(PsiElement literal) {
        PsiElement parent;
        PsiElement psiElement = parent = literal != null ? literal.getParent() : null;
        if (PhpPsiUtil.isOfType(parent, PhpElementTypes.ARRAY_VALUE)) {
            if ((parent = parent.getParent()) instanceof ArrayHashElement) {
                parent = parent.getParent();
            }
            return (ArrayCreationExpression)ObjectUtils.tryCast((Object)parent, ArrayCreationExpression.class);
        }
        return null;
    }

    @Nullable
    private Pair<PsiElement, Language> getLanguageFromVariableUsages(final @NotNull Variable variable) {
        PhpAccessVariableInstruction instruction;
        if (variable == null) {
            PhpInjectorBase.$$$reportNull$$$0(9);
        }
        if ((instruction = PhpControlFlowUtil.getAccessInstruction(variable, PhpAccessVariableInstruction.class)) != null) {
            final HashSet languages = new HashSet();
            PhpControlFlowUtil.processSuccessors(instruction, false, new PhpInstructionProcessor(){

                @Override
                public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                    if (this.processVariableAccess(instruction.getVariableName(), instruction.getAnchor())) {
                        return false;
                    }
                    return super.processAccessVariableInstruction(instruction);
                }

                @Override
                public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                    CharSequence variableName = PhpVariableInferredTypeAnalyzerProcessor.getBaseVariableName(instruction);
                    if (this.processVariableAccess(variableName, instruction.getAnchor())) {
                        return false;
                    }
                    return super.processArrayAccessInstruction(instruction);
                }

                private boolean processVariableAccess(@Nullable CharSequence name, @Nullable PhpPsiElement anchor) {
                    if (anchor != null && PhpLangUtil.equalsVariableNames(name, variable.getName())) {
                        Language substitutedLanguage = PhpInjectorBase.this.getSubstitutedLanguage((PsiElement)anchor);
                        if (VariableImpl.isLocalWriteAccess((PsiElement)anchor)) {
                            return true;
                        }
                        if (substitutedLanguage != null) {
                            languages.add(Pair.create((Object)anchor, (Object)substitutedLanguage));
                            return true;
                        }
                    }
                    return false;
                }
            });
            return (Pair)ContainerUtil.getOnlyItem(languages);
        }
        return null;
    }

    @Nullable
    private Language getSubstitutedLanguage(@NotNull PsiElement context) {
        Language language;
        if (context == null) {
            PhpInjectorBase.$$$reportNull$$$0(10);
        }
        if (RegExpLanguage.INSTANCE.is(language = this.doGetInjectedLanguage(context))) {
            return PhpRegexpLanguage.INSTANCE;
        }
        if (PhpLanguage.INSTANCE.is(language)) {
            return PhpLanguage.INJECTABLE_INSTANCE;
        }
        return language;
    }

    protected PhpInjectionUtil.InjectionResult registerInjection(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        Pair<PsiElement, Language> language;
        if (registrar == null) {
            PhpInjectorBase.$$$reportNull$$$0(11);
        }
        if (context == null) {
            PhpInjectorBase.$$$reportNull$$$0(12);
        }
        if ((language = this.getInjectedLanguage(context)) == null) {
            return PhpInjectionUtil.InjectionResult.EMPTY;
        }
        PsiElement element = PhpInjectionUtil.getLargestStringLiteral(context);
        if (element == null) {
            return PhpInjectionUtil.InjectionResult.EMPTY;
        }
        PhpInjectionUtil.InjectionResult result = PhpInjectionUtil.collectInjections(element, (Language)language.getSecond(), (PsiElement)language.getFirst());
        return PhpInjectionUtil.registerStringLiteralInjection(element, context, registrar, (Language)language.getSecond(), PhpInjectorBase.patchResult(context.getProject(), result));
    }

    @Nullable
    protected PhpInjectionUtil.InjectionResult patchInjectionResult(@NotNull PhpInjectionUtil.InjectionResult result) {
        PhpInjectionUtil.PhpInjectionInfo info1;
        if (result == null) {
            PhpInjectorBase.$$$reportNull$$$0(13);
        }
        if (result.getLanguage() != null && result.getLanguage().getDisplayName().contains("SQL") && (info1 = (PhpInjectionUtil.PhpInjectionInfo)result.getInjectionInfos().stream().findAny().orElse(null)) != null) {
            PhpMetaTypeMappingsTable map;
            Map<String, PhpMetaTypeMappingsTable> mappings = PhpParameterBasedTypeProvider.getStaticMethodTypesMap(info1.getHost().getProject());
            PhpMetaTypeMappingsTable phpMetaTypeMappingsTable = map = mappings != null ? mappings.get("#g#F\\PHPSTORM_META\\sql_injection_subst") : null;
            if (map != null && !map.getKeys().isEmpty()) {
                for (String key : map.getKeys()) {
                    List<PhpInjectionUtil.PhpInjectionInfo> fragmentsSubstitutions = result.getInjectionInfos().stream().flatMap(info -> PhpInjectorBase.substitute(info, key, map.get(key).stream().findFirst().orElse(key))).collect(Collectors.toList());
                    result = new PhpInjectionUtil.InjectionResult(result.isInjected(), fragmentsSubstitutions, result.containsUnparsableFragment(), result.getLanguage());
                }
                return result;
            }
        }
        return null;
    }

    private static Stream<PhpInjectionUtil.PhpInjectionInfo> substitute(PhpInjectionUtil.PhpInjectionInfo info, String lookup, String subst) {
        Collection substitutions = null;
        int originalStartOffset = info.getRange().getStartOffset();
        String text = info.getRange().substring(info.getHost().getText());
        int prefixIndex = text.indexOf(lookup);
        if (prefixIndex != -1) {
            SmartList toReturn = new SmartList();
            int chunkStartOffset = 0;
            String externalPrefix = info.getPrefix();
            while (prefixIndex >= 0) {
                toReturn.add(new PhpInjectionUtil.PhpInjectionInfo(externalPrefix, subst, info.getHost(), new TextRange(chunkStartOffset, prefixIndex).shiftRight(originalStartOffset)));
                externalPrefix = "";
                chunkStartOffset = prefixIndex + lookup.length();
                prefixIndex = text.indexOf(lookup, chunkStartOffset);
            }
            String concatenatedSuffix = info.getSuffix();
            toReturn.add(new PhpInjectionUtil.PhpInjectionInfo("", concatenatedSuffix, info.getHost(), TextRange.create((int)(chunkStartOffset + originalStartOffset), (int)info.getRange().getEndOffset())));
            substitutions = toReturn;
        }
        if (substitutions == null) {
            return Stream.of(info);
        }
        return substitutions.stream();
    }

    @NotNull
    private static PhpInjectionUtil.InjectionResult patchResult(@NotNull Project project, @NotNull PhpInjectionUtil.InjectionResult result) {
        if (project == null) {
            PhpInjectorBase.$$$reportNull$$$0(14);
        }
        if (result == null) {
            PhpInjectorBase.$$$reportNull$$$0(15);
        }
        PhpInjectionUtil.InjectionResult injectionResult = StreamEx.of((Collection)MultiHostInjector.MULTIHOST_INJECTOR_EP_NAME.getExtensions((AreaInstance)project)).select(PhpInjectorBase.class).map(injector -> injector.patchInjectionResult(result)).nonNull().findFirst().orElse(result);
        if (injectionResult == null) {
            PhpInjectorBase.$$$reportNull$$$0(16);
        }
        return injectionResult;
    }

    @Nullable
    public static PhpDocComment getDocComment(@NotNull PsiElement context) {
        if (context == null) {
            PhpInjectorBase.$$$reportNull$$$0(17);
        }
        if (!(context instanceof StringLiteralExpression)) {
            return null;
        }
        PhpPsiElement prev = ((PhpPsiElement)context).getPrevPsiSibling();
        if (prev instanceof PhpDocComment) {
            return (PhpDocComment)prev;
        }
        PsiElement parent = context.getParent();
        if (prev == null && (parent instanceof ParameterList || parent instanceof Statement || PhpPsiUtil.isOfType(parent, PhpElementTypes.PARAMETER_DEFAULT_VALUE, PhpElementTypes.ARRAY_VALUE))) {
            context = parent;
        } else if (PhpPsiUtil.isOfType(parent, PhpElementTypes.ARRAY_KEY)) {
            if (PhpPsiUtil.isOfType(parent = parent.getParent(), PhpElementTypes.ARRAY_CREATION_EXPRESSION)) {
                parent = parent.getParent();
            }
            context = parent;
        }
        while (context.getParent() instanceof BinaryExpression) {
            context = context.getParent();
        }
        prev = ((PhpPsiElement)context).getPrevPsiSibling();
        return prev instanceof PhpDocComment ? (PhpDocComment)prev : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/injection/PhpInjectorBase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/injection/PhpInjectorBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetLanguageFieldSubstitutedLanguagesFromUsages";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "patchResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processInjectedResult";
                break;
            }
            case 3: 
            case 7: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedLanguage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedLanguageFromUsages";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageFromFieldUsages";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostValueInjectionCapable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageFromVariableUsages";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutedLanguage";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "registerInjection";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "patchInjectionResult";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "patchResult";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDocComment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 16 -> new IllegalStateException(string);
        };
    }
}

